/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.config.xml.internal;

import com.ibm.websphere.config.ConfigParserException;
import com.ibm.websphere.config.ConfigValidationException;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.config.xml.internal.BaseConfiguration;
import com.ibm.ws.config.xml.internal.ConfigElement;
import com.ibm.ws.config.xml.internal.ConfigParserTolerableException;
import com.ibm.ws.config.xml.internal.ConfigUtil;
import com.ibm.ws.config.xml.internal.ConfigVariable;
import com.ibm.ws.config.xml.internal.ConfigVariableRegistry;
import com.ibm.ws.config.xml.internal.DefaultConfiguration;
import com.ibm.ws.config.xml.internal.DepthAwareXMLStreamReader;
import com.ibm.ws.config.xml.internal.ErrorHandler;
import com.ibm.ws.config.xml.internal.ServerConfiguration;
import com.ibm.ws.config.xml.internal.SimpleElement;
import com.ibm.ws.config.xml.internal.XMLConfigConstants;
import com.ibm.ws.config.xml.internal.validator.XMLConfigValidator;
import com.ibm.ws.config.xml.internal.validator.XMLConfigValidatorFactory;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.kernel.service.util.DesignatedXMLInputFactory;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.kernel.service.location.MalformedLocationException;
import com.ibm.wsspi.kernel.service.location.WsLocationAdmin;
import com.ibm.wsspi.kernel.service.location.WsResource;
import com.ibm.wsspi.kernel.service.utils.PathUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Matcher;
import javax.xml.stream.Location;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.osgi.framework.Bundle;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class XMLConfigParser {
    private static final String VARIABLE = "variable";
    private static final String INCLUDE = "include";
    private static final String VARIABLE_VALUE = "value";
    private static final String VARIABLE_DEFAULT_VALUE = "defaultValue";
    private static final String VARIABLE_NAME = "name";
    private static final TraceComponent tc = Tr.register(XMLConfigParser.class, (String)"config", (String)"com.ibm.ws.config.internal.resources.ConfigMessages");
    private static final String IS_SUPPORTING_LOCATION_COORDINATES_PROPERTY = "javax.xml.stream.isSupportingLocationCoordinates";
    protected static final String BEHAVIOR_ATTRIBUTE = "onConflict";
    public static final String REQUIRE_EXISTING = "requireExisting";
    public static final String REQUIRE_DOES_NOT_EXIST = "addIfMissing";
    private int sequenceCounter;
    private final WsLocationAdmin locationService;
    private final LinkedList<String> docLocationStack = new LinkedList();
    private final LinkedList<MergeBehavior> behaviorStack = new LinkedList();
    private final XMLConfigValidator configValidator = XMLConfigValidatorFactory.getInstance().getXMLConfigValidator();
    private final ConfigVariableRegistry variableRegistry;
    private final BaseConfiguration tempVariables = new BaseConfiguration();
    static final long serialVersionUID = 1694655885609180728L;

    public XMLConfigParser(WsLocationAdmin locationService, ConfigVariableRegistry variableRegistry) {
        this.locationService = locationService;
        this.variableRegistry = variableRegistry;
    }

    private static XMLInputFactory getXMLInputFactory() {
        return XifHolder.INSTANCE;
    }

    @Trivial
    private int getNextSequenceId() {
        return this.sequenceCounter++;
    }

    @Trivial
    public XMLConfigValidator getConfigValidator() {
        return this.configValidator;
    }

    public ServerConfiguration parseServerConfiguration(WsResource resource) throws ConfigParserException, ConfigValidationException {
        return this.parseServerConfiguration(resource, new ServerConfiguration());
    }

    @FFDCIgnore(value={IOException.class})
    public ServerConfiguration parseServerConfiguration(WsResource resource, ServerConfiguration configuration) throws ConfigParserException, ConfigValidationException {
        ServerConfiguration serverConfiguration;
        String location = resource.toExternalURI().toString();
        this.tempVariables.variables.clear();
        InputStream in = null;
        try {
            in = this.configValidator.validateResource(resource.get(), location);
            if (this.parseServerConfiguration(in, location, (BaseConfiguration)configuration, MergeBehavior.MERGE)) {
                configuration.updateLastModified(resource.getLastModified());
            } else {
                configuration = null;
            }
            serverConfiguration = configuration;
        }
        catch (IOException e) {
            try {
                throw new ConfigParserException("Error loading configuration file " + location, e);
            }
            catch (Throwable throwable) {
                ConfigUtil.closeIO(in);
                throw throwable;
            }
        }
        ConfigUtil.closeIO(in);
        return serverConfiguration;
    }

    /*
     * Loose catch block
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @FFDCIgnore(value={IOException.class})
    private void parseIncludeConfiguration(WsResource resource, BaseConfiguration configuration, MergeBehavior mergeBehavior) throws ConfigParserException, ConfigValidationException {
        String location = resource.toExternalURI().toString();
        InputStream in = null;
        try {
            in = this.configValidator.validateResource(resource.get(), location);
            if (this.parseServerConfiguration(in, location, configuration, mergeBehavior)) {
                configuration.updateLastModified(resource.getLastModified());
            } else {
                configuration = null;
            }
        }
        catch (ConfigParserTolerableException configParserTolerableException) {
            try {
                void e;
                FFDCFilter.processException((Throwable)configParserTolerableException, (String)"com.ibm.ws.config.xml.internal.XMLConfigParser", (String)"153", (Object)this, (Object[])new Object[]{resource, configuration, mergeBehavior});
                configuration.updateLastModified(resource.getLastModified());
                throw e;
                catch (IOException e2) {
                    throw new ConfigParserException("Error loading configuration file " + location, e2);
                }
            }
            catch (Throwable throwable) {
                ConfigUtil.closeIO(in);
                throw throwable;
            }
        }
        ConfigUtil.closeIO(in);
    }

    public ServerConfiguration parseServerConfiguration(Reader reader) throws ConfigParserException, ConfigValidationException {
        return this.parseServerConfiguration(reader, new ServerConfiguration());
    }

    @FFDCIgnore(value={XMLStreamException.class})
    public ServerConfiguration parseServerConfiguration(Reader reader, ServerConfiguration config) throws ConfigParserException, ConfigValidationException {
        try {
            XMLStreamReader parser = XMLConfigParser.getXMLInputFactory().createXMLStreamReader(reader);
            if (!this.parseServerConfiguration(new DepthAwareXMLStreamReader(parser), "test", (BaseConfiguration)config, MergeBehavior.MERGE)) {
                config = null;
            }
            parser.close();
            return config;
        }
        catch (XMLStreamException e) {
            throw new ConfigParserException(e);
        }
    }

    @FFDCIgnore(value={XMLStreamException.class})
    public boolean parseServerConfiguration(InputStream in, String docLocation, BaseConfiguration config, MergeBehavior mergeBehavior) throws ConfigParserException, ConfigValidationException {
        XMLStreamReader parser = null;
        try {
            parser = XMLConfigParser.getXMLInputFactory().createXMLStreamReader(docLocation, in);
            boolean bl = this.parseServerConfiguration(new DepthAwareXMLStreamReader(parser), docLocation, config, mergeBehavior);
            return bl;
        }
        catch (XMLStreamException e) {
            throw new ConfigParserException(e);
        }
        finally {
            if (parser != null) {
                try {
                    parser.close();
                }
                catch (XMLStreamException e) {
                    throw new ConfigParserException(e);
                }
            }
        }
    }

    /*
     * Exception decompiling
     */
    @FFDCIgnore(value={XMLStreamException.class})
    private boolean parseServerConfiguration(DepthAwareXMLStreamReader parser, String docLocation, BaseConfiguration config, MergeBehavior mergeBehavior) throws ConfigParserException, ConfigValidationException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [7[WHILELOOP]], but top level block is 3[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - void declaration
     */
    @FFDCIgnore(value={XMLStreamException.class})
    public ConfigElement parseConfigElement(Reader reader) throws ConfigParserException {
        this.behaviorStack.add(MergeBehavior.MERGE);
        this.docLocationStack.add("Test Server");
        DepthAwareXMLStreamReader parser = null;
        try {
            parser = new DepthAwareXMLStreamReader(XMLConfigParser.getXMLInputFactory().createXMLStreamReader(reader));
            SimpleElement configElement = null;
            int depth = parser.getDepth();
            while (parser.hasNext(depth)) {
                int event = parser.next();
                if (event != 1) continue;
                configElement = this.parseConfigElement(parser, parser.getLocalName(), null, null, null, false);
                break;
            }
            parser.close();
            return configElement;
        }
        catch (IllegalArgumentException configElement) {
            void ex;
            FFDCFilter.processException((Throwable)configElement, (String)"com.ibm.ws.config.xml.internal.XMLConfigParser", (String)"272", (Object)this, (Object[])new Object[]{reader});
            throw new ConfigParserException((Throwable)ex);
        }
        catch (XMLStreamException e) {
            throw new ConfigParserException(e);
        }
    }

    @FFDCIgnore(value={XMLStreamException.class, ConfigParserTolerableException.class})
    private void parseServer(DepthAwareXMLStreamReader parser, String docLocation, BaseConfiguration config, String processType) throws ConfigParserException, ConfigValidationException {
        String descriptionAttributeValue = this.getAttributeValue(parser, "description");
        if (descriptionAttributeValue != null) {
            config.setDescription(descriptionAttributeValue);
        }
        List<WsResource> includes = config.getIncludes();
        try {
            ConfigParserTolerableException savedConfigParserException = null;
            int depth = parser.getDepth();
            while (parser.hasNext(depth)) {
                int event = parser.next();
                if (event != 1) continue;
                String name = parser.getLocalName();
                if (INCLUDE.equals(name)) {
                    BaseConfiguration importedConfig;
                    block12: {
                        importedConfig = new BaseConfiguration();
                        try {
                            this.parseInclude(parser, docLocation, includes, importedConfig);
                        }
                        catch (ConfigParserTolerableException e) {
                            if (savedConfigParserException != null) break block12;
                            savedConfigParserException = e;
                        }
                    }
                    if (importedConfig == null) continue;
                    config.append(importedConfig);
                    config.updateLastModified(importedConfig.getLastModified());
                    includes.addAll(importedConfig.getIncludes());
                    continue;
                }
                if (VARIABLE.equals(name)) {
                    try {
                        ConfigVariable variable = this.parseVariable(parser, docLocation);
                        config.addVariable(variable);
                        this.tempVariables.addVariable(variable);
                    }
                    catch (ConfigParserTolerableException e) {
                        if (savedConfigParserException != null) continue;
                        savedConfigParserException = e;
                    }
                    continue;
                }
                if (processType.equals(name)) {
                    if (!tc.isWarningEnabled()) continue;
                    Tr.warning((TraceComponent)tc, (String)"warning.unexpected.server.element", (Object[])new Object[0]);
                    continue;
                }
                SimpleElement configElement = this.parseConfigElement(parser, name, config, docLocation, null, false);
                configElement.setDocumentLocation(docLocation);
                config.addConfigElement(configElement);
            }
            if (savedConfigParserException != null) {
                throw new ConfigParserTolerableException(savedConfigParserException);
            }
        }
        catch (XMLStreamException ex) {
            throw new ConfigParserException(ex);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void parseInclude(DepthAwareXMLStreamReader parser, String docLocation, List<WsResource> includes, BaseConfiguration configuration) throws ConfigParserException, ConfigParserTolerableException, ConfigValidationException {
        String behaviorAttribute = this.getAttributeValue(parser, BEHAVIOR_ATTRIBUTE);
        MergeBehavior mergeBehavior = behaviorAttribute == null ? this.behaviorStack.getLast() : XMLConfigParser.getMergeBehavior(behaviorAttribute);
        String optionalAttributeValue = this.getAttributeValue(parser, "optional");
        boolean optionalImport = optionalAttributeValue != null && "true".equalsIgnoreCase(optionalAttributeValue);
        String includeAttributeValue = this.getAttributeValue(parser, "location");
        if (includeAttributeValue == null) {
            Location l = parser.getLocation();
            this.logError("error.include.location.not.specified", l.getLineNumber(), l.getSystemId());
            throw new ConfigParserTolerableException();
        }
        if (this.locationService == null) throw new ConfigParserException("LocationService is not available");
        String location = includeAttributeValue;
        WsResource includeResource = null;
        try {
            includeResource = this.resolveInclude(location, docLocation, this.locationService);
        }
        catch (MalformedLocationException malformedLocationException) {
            FFDCFilter.processException((Throwable)malformedLocationException, (String)"com.ibm.ws.config.xml.internal.XMLConfigParser", (String)"380", (Object)this, (Object[])new Object[]{parser, docLocation, includes, configuration});
        }
        if (includeResource != null) {
            includes.add(includeResource);
            if (includeResource.exists() && (includeResource.isType(WsResource.Type.FILE) || includeResource.isType(WsResource.Type.REMOTE))) {
                if (includeResource.isType(WsResource.Type.FILE)) {
                    Tr.audit((TraceComponent)tc, (String)"audit.include.being.processed", (Object[])new Object[]{includeResource.asFile()});
                } else {
                    Tr.audit((TraceComponent)tc, (String)"audit.include.being.processed", (Object[])new Object[]{includeResource.toExternalURI()});
                }
                this.parseIncludeConfiguration(includeResource, configuration, mergeBehavior);
                return;
            }
            if (optionalImport) return;
            this.logError("error.cannot.read.location", this.resolvePath(location));
            throw new ConfigParserTolerableException();
        }
        if (optionalImport) {
            Tr.warning((TraceComponent)tc, (String)"warn.cannot.resolve.optional.include", (Object[])new Object[]{this.resolvePath(location)});
            return;
        }
        this.logError("error.cannot.read.location", this.resolvePath(location));
        throw new ConfigParserTolerableException();
    }

    protected static MergeBehavior getMergeBehavior(String behaviorAttribute) {
        if (behaviorAttribute == null || behaviorAttribute.equalsIgnoreCase(MergeBehavior.MERGE.name())) {
            return MergeBehavior.MERGE;
        }
        if (behaviorAttribute.equalsIgnoreCase(MergeBehavior.IGNORE.name())) {
            return MergeBehavior.IGNORE;
        }
        if (behaviorAttribute.equalsIgnoreCase(MergeBehavior.REPLACE.name())) {
            return MergeBehavior.REPLACE;
        }
        if (tc.isWarningEnabled()) {
            Tr.warning((TraceComponent)tc, (String)"warning.unrecognized.merge.behavior", (Object[])new Object[]{behaviorAttribute});
        }
        return MergeBehavior.MERGE;
    }

    private ConfigVariable parseVariable(DepthAwareXMLStreamReader parser, String docLocation) throws ConfigParserTolerableException {
        String variableName = null;
        String variableValue = null;
        String variableDefault = null;
        int attrCount = parser.getAttributeCount();
        for (int i = 0; i < attrCount; ++i) {
            String name = parser.getAttributeLocalName(i);
            String value = parser.getAttributeValue(i);
            if (VARIABLE_NAME.equals(name)) {
                variableName = value;
                continue;
            }
            if (VARIABLE_VALUE.equals(name)) {
                variableValue = value;
                continue;
            }
            if (!VARIABLE_DEFAULT_VALUE.equals(name)) continue;
            variableDefault = value;
        }
        if (variableName == null) {
            Location l = parser.getLocation();
            this.logError("error.variable.name.missing", l.getLineNumber(), l.getSystemId());
            throw new ConfigParserTolerableException();
        }
        if (variableValue == null && variableDefault == null) {
            Location l = parser.getLocation();
            this.logError("error.variable.value.missing", l.getLineNumber(), l.getSystemId());
            throw new ConfigParserTolerableException();
        }
        return new ConfigVariable(variableName, variableValue, variableDefault, this.behaviorStack.getLast(), docLocation);
    }

    @FFDCIgnore(value={XMLStreamException.class})
    private SimpleElement parseConfigElement(DepthAwareXMLStreamReader parser, String entryElementLocalName, BaseConfiguration config, String docLocation, String parentId, boolean isChild) throws ConfigParserException {
        SimpleElement element = new SimpleElement(entryElementLocalName);
        element.setDocumentLocation(docLocation);
        element.setMergeBehavior(this.behaviorStack.getLast());
        element.setDocLocationStack((LinkedList)new LinkedList<String>(this.docLocationStack));
        element.setBehaviorStack((LinkedList)new LinkedList<MergeBehavior>(this.behaviorStack));
        int nextSeqId = this.getNextSequenceId();
        element.setSequenceId(nextSeqId);
        int attrCount = parser.getAttributeCount();
        for (int i = 0; i < attrCount; ++i) {
            String name = parser.getAttributeLocalName(i);
            String value = parser.getAttributeValue(i);
            if ("id".equals(name)) {
                element.setId(value);
            }
            element.addAttribute(name, value);
        }
        try {
            int depth = parser.getDepth();
            while (parser.hasNext(depth)) {
                SimpleElement childElement;
                int event = parser.next();
                if (event == 4) {
                    element.setElementValue(element.getElementValue() + parser.getText());
                    continue;
                }
                if (event != 1) continue;
                if (isChild) {
                    element.setTextOnly(false);
                }
                String name = parser.getLocalName();
                String operationValue = this.getAttributeValue(parser, "merge-op");
                if (operationValue != null) {
                    if ("append".equals(operationValue)) {
                        element.setMergeOperation(name, ConfigElement.MERGE_OP.APPEND);
                    } else if ("set".equals(operationValue)) {
                        element.setMergeOperation(name, ConfigElement.MERGE_OP.SET);
                    }
                }
                if ((childElement = this.parseConfigElement(parser, name, config, docLocation, element.getFullId(), true)).isChildElement() && operationValue == null) {
                    if (childElement.getRefAttr() == null) {
                        childElement.setDocumentLocation(docLocation);
                        element.addChildConfigElement(name, childElement);
                        continue;
                    }
                    element.addReference(childElement.getNodeName(), childElement.getRefAttr());
                    continue;
                }
                element.addCollectionAttribute(name, childElement.getElementValue());
            }
        }
        catch (XMLStreamException ex) {
            throw new ConfigParserException(ex);
        }
        return element;
    }

    private String getAttributeValue(XMLStreamReader reader, String localName) {
        int attrCount = reader.getAttributeCount();
        for (int i = 0; i < attrCount; ++i) {
            if (!localName.equals(reader.getAttributeLocalName(i)) || ("".equals(reader.getAttributeNamespace(i)) ? null : reader.getAttributeNamespace(i)) != null) continue;
            return reader.getAttributeValue(i);
        }
        return null;
    }

    @FFDCIgnore(value={IOException.class})
    public BaseConfiguration parseDefaultConfiguration(DefaultConfiguration.DefaultConfigFile defaultConfigFile) throws ConfigParserException, ConfigValidationException {
        InputStream in = null;
        try {
            in = defaultConfigFile.fileURL.openStream();
            BaseConfiguration config = new BaseConfiguration();
            if (!this.parseServerConfiguration(in, defaultConfigFile.fileURL.toExternalForm(), config, defaultConfigFile.behavior)) {
                config = null;
            }
            BaseConfiguration baseConfiguration = config;
            return baseConfiguration;
        }
        catch (IOException e) {
            throw new ConfigParserException(e);
        }
        finally {
            ConfigUtil.closeIO(in);
        }
    }

    @FFDCIgnore(value={XMLStreamException.class})
    public BaseConfiguration parseDefaultConfiguration(Reader reader, String docLocation) throws ConfigParserException, ConfigValidationException {
        try {
            XMLStreamReader parser = XMLConfigParser.getXMLInputFactory().createXMLStreamReader(reader);
            BaseConfiguration config = new BaseConfiguration();
            if (!this.parseServerConfiguration(new DepthAwareXMLStreamReader(parser), docLocation, config, MergeBehavior.MERGE)) {
                config = null;
            }
            parser.close();
            return config;
        }
        catch (XMLStreamException e) {
            throw new ConfigParserException(e);
        }
    }

    WsResource resolveInclude(String includePath, String basePath, WsLocationAdmin wsLocationAdmin) {
        if (includePath == null) {
            return null;
        }
        if ((includePath = includePath.trim()).length() == 0) {
            return null;
        }
        if (basePath == null) {
            String normalIncludePath = this.resolvePath(includePath);
            return wsLocationAdmin.resolveResource(normalIncludePath);
        }
        String normalIncludePath = this.resolvePath(includePath);
        if (PathUtils.pathIsAbsolute((String)normalIncludePath)) {
            return wsLocationAdmin.resolveResource(normalIncludePath);
        }
        String normalBasePath = wsLocationAdmin.resolveString(basePath);
        String normalParentPath = PathUtils.getParent((String)normalBasePath);
        if (normalParentPath == null) {
            return wsLocationAdmin.resolveResource(normalIncludePath);
        }
        if (normalParentPath.endsWith("/")) {
            return wsLocationAdmin.resolveResource(normalParentPath + normalIncludePath);
        }
        return wsLocationAdmin.resolveResource(normalParentPath + "/" + normalIncludePath);
    }

    private String resolvePath(String path) {
        if (PathUtils.isSymbol((String)path)) {
            this.variableRegistry.updateSystemVariables(this.tempVariables.getVariables());
            Matcher matcher = XMLConfigConstants.VAR_PATTERN.matcher(path);
            while (matcher.find()) {
                String var = matcher.group(1);
                String rep = this.variableRegistry.lookupVariable(var);
                if (rep == null) {
                    rep = this.variableRegistry.lookupVariableFromAdditionalSources(var);
                }
                if (rep == null) {
                    rep = this.variableRegistry.lookupVariableDefaultValue(var);
                }
                if (rep == null) continue;
                path = path.replace(matcher.group(0), rep);
                matcher.reset(path);
            }
        } else {
            return this.locationService.resolveString(path);
        }
        return path;
    }

    public void handleParseError(ConfigParserException e, Bundle bundle) {
        Throwable t = e.getCause();
        if (t instanceof XMLStreamException) {
            XMLStreamException xse = (XMLStreamException)t;
            Location l = xse.getLocation();
            if (l != null) {
                String loc = l.getSystemId();
                if (bundle != null) {
                    loc = loc + "(" + bundle.getLocation() + ")";
                }
                this.logError("error.syntax.parse.server", this.getMessage(xse), loc, l.getLineNumber(), l.getColumnNumber());
            } else {
                this.logError("error.syntax.parse.server", this.getMessage(xse), "[null]", -1, -1);
            }
        } else if (e.getMessage() != null) {
            this.logError("error.parse.server", e.getMessage());
        }
    }

    private String getMessage(XMLStreamException xse) {
        String message = xse.getMessage();
        if (message != null && message.startsWith("ParseError at [row,col]:[")) {
            String MESSAGE_HEADER = "Message: ";
            int index = message.indexOf("Message: ");
            if (index >= 0) {
                return message.substring(index + "Message: ".length());
            }
        }
        return message;
    }

    private void logError(String msgKey, Object ... args) {
        switch (ErrorHandler.INSTANCE.getOnError()) {
            case FAIL: 
            case WARN: {
                Tr.error((TraceComponent)tc, (String)msgKey, (Object[])args);
                break;
            }
        }
    }

    static enum MergeBehavior {
        MERGE,
        REPLACE,
        IGNORE,
        MERGE_WHEN_EXISTS,
        MERGE_WHEN_MISSING;

    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    private static final class XifHolder {
        static final XMLInputFactory INSTANCE;
        static final long serialVersionUID = -2209086165756625580L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        private XifHolder() {
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"com.ibm.ws.config.xml.internal.XMLConfigParser$XifHolder", XifHolder.class, (String)"config", (String)"com.ibm.ws.config.internal.resources.ConfigMessages");
            XMLInputFactory xif = DesignatedXMLInputFactory.newInstance();
            xif.setProperty("javax.xml.stream.isCoalescing", Boolean.TRUE);
            if (xif.isPropertySupported(XMLConfigParser.IS_SUPPORTING_LOCATION_COORDINATES_PROPERTY) || "com.ibm.xml.xlxp.api.stax.XMLInputFactoryImpl".equals(xif.getClass().getName())) {
                xif.setProperty(XMLConfigParser.IS_SUPPORTING_LOCATION_COORDINATES_PROPERTY, Boolean.TRUE);
            }
            INSTANCE = xif;
        }
    }
}

