/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wsat.common.impl;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.wsat.common.impl.DebugUtils;
import com.ibm.ws.wsat.tm.impl.TranManagerImpl;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.security.AccessController;
import java.security.PrivilegedAction;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.transform.Source;
import javax.xml.ws.EndpointReference;
import org.apache.cxf.ws.addressing.ContextUtils;
import org.apache.cxf.ws.addressing.EndpointReferenceType;
import org.apache.cxf.wsdl.EndpointReferenceUtils;

@TraceObjectField(fieldName="TC", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public abstract class WSATEndpoint
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final String CLASS_NAME = WSATEndpoint.class.getName();
    private static final TraceComponent TC = Tr.register(WSATEndpoint.class, (String)"wsat", (String)"com.ibm.ws.wsat.resources.WSAT");
    private static TranManagerImpl tranService = TranManagerImpl.getInstance();
    private transient EndpointReferenceType endpointRef;
    private transient EndpointReference wsEpr;
    private transient boolean isSecure;

    public WSATEndpoint(EndpointReferenceType epr) {
        this.init(epr);
    }

    private void init(EndpointReferenceType epr) {
        this.endpointRef = epr;
        if (epr != null) {
            if (TC.isDebugEnabled()) {
                Tr.debug((TraceComponent)TC, (String)"Endpoint:\n{0}", (Object[])new Object[]{DebugUtils.printEPR(epr)});
            }
            this.isSecure = epr.getAddress().getValue().startsWith("https");
            this.wsEpr = AccessController.doPrivileged(new PrivilegedAction<EndpointReference>(){
                static final long serialVersionUID = -2613426499223720156L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public EndpointReference run() {
                    ClassLoader saveLoader = Thread.currentThread().getContextClassLoader();
                    ClassLoader localLoader = tranService.getThreadClassLoader(WSATEndpoint.class);
                    try {
                        Thread.currentThread().setContextClassLoader(localLoader);
                        EndpointReference endpointReference = EndpointReference.readFrom((Source)EndpointReferenceUtils.convertToXML((EndpointReferenceType)WSATEndpoint.this.endpointRef));
                        return endpointReference;
                    }
                    finally {
                        Thread.currentThread().setContextClassLoader(saveLoader);
                        tranService.destroyThreadClassLoader(localLoader);
                    }
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register((String)"com.ibm.ws.wsat.common.impl.WSATEndpoint$1", 1.class, (String)"wsat", (String)"com.ibm.ws.wsat.resources.WSAT");
                }
            });
        }
    }

    public EndpointReferenceType getEndpointReference() {
        return this.endpointRef;
    }

    public EndpointReference getWsEpr() {
        return this.wsEpr;
    }

    public boolean isSecure() {
        return this.isSecure;
    }

    /*
     * WARNING - void declaration
     */
    private void writeObject(ObjectOutputStream stream) throws IOException {
        stream.defaultWriteObject();
        try {
            String xml = null;
            if (this.endpointRef != null) {
                StringWriter xmlWriter = new StringWriter();
                JAXBContext jbCtx = ContextUtils.getJAXBContext();
                JAXBElement jbEpr = ContextUtils.WSA_OBJECT_FACTORY.createEndpointReference(this.endpointRef);
                jbCtx.createMarshaller().marshal((Object)jbEpr, (Writer)xmlWriter);
                xml = xmlWriter.toString();
            }
            stream.writeObject(xml);
        }
        catch (JAXBException xml) {
            void e;
            FFDCFilter.processException((Throwable)xml, (String)"com.ibm.ws.wsat.common.impl.WSATEndpoint", (String)"119", (Object)this, (Object[])new Object[]{stream});
            throw new IOException((Throwable)e);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        try {
            EndpointReferenceType epr = null;
            String xml = (String)stream.readObject();
            if (xml != null) {
                StringReader xmlReader = new StringReader(xml);
                JAXBContext jbCtx = ContextUtils.getJAXBContext();
                Object jbEpr = jbCtx.createUnmarshaller().unmarshal((Reader)xmlReader);
                epr = (EndpointReferenceType)((JAXBElement)jbEpr).getValue();
            }
            this.init(epr);
        }
        catch (JAXBException epr) {
            void e;
            FFDCFilter.processException((Throwable)epr, (String)"com.ibm.ws.wsat.common.impl.WSATEndpoint", (String)"136", (Object)this, (Object[])new Object[]{stream});
            throw new IOException((Throwable)e);
        }
    }
}

