/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jaxws.metadata.builder;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.javaee.dd.common.ParamValue;
import com.ibm.ws.javaee.dd.common.wsclient.Handler;
import com.ibm.ws.javaee.dd.common.wsclient.HandlerChain;
import com.ibm.ws.jaxws.metadata.HandlerChainAnnotationSer;
import com.ibm.ws.jaxws.metadata.HandlerChainInfo;
import com.ibm.ws.jaxws.metadata.HandlerChainsInfo;
import com.ibm.ws.jaxws.metadata.HandlerInfo;
import com.ibm.ws.jaxws.metadata.ParamValueInfo;
import com.ibm.ws.jaxws.metadata.XsdQNameInfo;
import com.ibm.ws.jaxws.utils.JAXBUtils;
import com.ibm.ws.jaxws.utils.JaxWsUtils;
import com.ibm.ws.jaxws.utils.StringUtils;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.anno.info.AnnotationInfo;
import com.ibm.wsspi.anno.info.ClassInfo;
import com.ibm.wsspi.anno.info.InfoStore;
import java.io.InputStream;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.namespace.QName;
import javax.xml.ws.WebServiceException;
import javax.xml.ws.handler.LogicalHandler;
import org.apache.cxf.helpers.XMLUtils;
import org.apache.cxf.jaxws.javaee.CString;
import org.apache.cxf.jaxws.javaee.ParamValueType;
import org.apache.cxf.jaxws.javaee.PortComponentHandlerType;
import org.apache.cxf.jaxws.javaee.XsdQNameType;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class HandlerChainInfoBuilder {
    private static final TraceComponent tc = Tr.register(HandlerChainInfoBuilder.class, (String)"JaxWsClientContainer", (String)"com.ibm.ws.jaxws.clientcontainer.internal.resources.JaxWsClientContainerMessages");
    private static JAXBContext context;
    private final ClassLoader classLoader;
    static final long serialVersionUID = 5382795970776670638L;

    public HandlerChainInfoBuilder(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public static HandlerChainInfo buildHandlerChainInfoFromXML(HandlerChain hChain) {
        HandlerChainInfo hcInfo = new HandlerChainInfo();
        if (hChain.getServiceNamePattern() != null) {
            hcInfo.setServiceNamePattern(new QName(hChain.getServiceNamePattern().getNamespaceURI(), hChain.getServiceNamePattern().getLocalPart()));
        } else {
            hcInfo.setServiceNamePattern(new QName("*"));
        }
        if (hChain.getPortNamePattern() != null) {
            hcInfo.setPortNamePattern(new QName(hChain.getPortNamePattern().getNamespaceURI(), hChain.getPortNamePattern().getLocalPart()));
        } else {
            hcInfo.setPortNamePattern(new QName("*"));
        }
        hcInfo.addProtocolBindings(hChain.getProtocolBindings());
        for (Handler handler : hChain.getHandlers()) {
            hcInfo.addHandlerInfo(HandlerChainInfoBuilder.buildHandlerInfoFromXML(handler));
        }
        return hcInfo;
    }

    public static HandlerInfo buildHandlerInfoFromXML(Handler handler) {
        HandlerInfo hInfo = new HandlerInfo();
        hInfo.setHandlerClass(handler.getHandlerClassName());
        hInfo.setHandlerName(handler.getHandlerName());
        for (ParamValue pv : handler.getInitParams()) {
            hInfo.addInitParam(new ParamValueInfo(pv.getName(), pv.getValue()));
        }
        for (String soapRole : handler.getSoapRoles()) {
            hInfo.addSoapRole(soapRole);
        }
        for (com.ibm.ws.javaee.dd.common.QName header : handler.getSoapHeaders()) {
            hInfo.addSoapHeader(new XsdQNameInfo(new QName(header.getNamespaceURI(), header.getLocalPart()), ""));
        }
        return hInfo;
    }

    public HandlerChainsInfo buildHandlerChainsInfoFromAnnotation(String serviceClazzName, HandlerChainAnnotationSer hcSer, QName portQName, QName serviceQName, String bindingID) {
        HandlerChainsInfo chainsInfo = new HandlerChainsInfo();
        HandlerChainInfoBuilder.validateAnnotation(hcSer.getFile(), serviceClazzName);
        this.processHandlerChainAnnotation(chainsInfo, serviceClazzName, hcSer.getFile(), portQName, serviceQName, bindingID);
        return chainsInfo;
    }

    public HandlerChainsInfo buildHandlerChainsInfoFromAnnotation(ClassInfo clzInfo, String seiClassName, InfoStore infoStore, QName portQName, QName serviceQName, String bindingID) {
        HandlerChainsInfo chainsInfo = new HandlerChainsInfo();
        HandlerChainAnnotation hcAnn = this.findHandlerChainAnnotation(clzInfo, seiClassName, infoStore, true);
        if (hcAnn != null) {
            hcAnn.validate();
            this.processHandlerChainAnnotation(chainsInfo, hcAnn.getDeclaringClass().getName(), hcAnn.getFileName(), portQName, serviceQName, bindingID);
        }
        return chainsInfo;
    }

    /*
     * WARNING - void declaration
     */
    protected void processHandlerChainAnnotation(HandlerChainsInfo chainsInfo, String serviceClazzName, String fileName, QName portQName, QName serviceQName, String bindingID) {
        try {
            URL handlerFileURL = this.resolveHandlerChainFileName(serviceClazzName, fileName);
            if (handlerFileURL == null) {
                throw new WebServiceException(Tr.formatMessage((TraceComponent)tc, (String)"error.no.handlerChainFile.found", (Object[])new Object[]{fileName}));
            }
            Document doc = XMLUtils.parse((InputStream)handlerFileURL.openStream());
            Element el = doc.getDocumentElement();
            if (!"http://java.sun.com/xml/ns/javaee".equals(el.getNamespaceURI()) || !"handler-chains".equals(el.getLocalName())) {
                String xml = XMLUtils.toString((Node)el);
                throw new WebServiceException(Tr.formatMessage((TraceComponent)tc, (String)"error.invalid.handlerChainFile.content", (Object[])new Object[]{xml}));
            }
            for (Node node = el.getFirstChild(); node != null; node = node.getNextSibling()) {
                if (!(node instanceof Element)) continue;
                el = (Element)node;
                if (!el.getNamespaceURI().equals("http://java.sun.com/xml/ns/javaee") || !el.getLocalName().equals("handler-chain")) {
                    String xml = XMLUtils.toString((Node)el);
                    throw new WebServiceException(Tr.formatMessage((TraceComponent)tc, (String)"error.invalid.handlerChainFile.content", (Object[])new Object[]{xml}));
                }
                chainsInfo.addHandlerChainInfo(this.processHandlerChainElement(el, portQName, serviceQName, bindingID));
            }
        }
        catch (WebServiceException handlerFileURL) {
            void e;
            FFDCFilter.processException((Throwable)handlerFileURL, (String)"com.ibm.ws.jaxws.metadata.builder.HandlerChainInfoBuilder", (String)"220", (Object)this, (Object[])new Object[]{chainsInfo, serviceClazzName, fileName, portQName, serviceQName, bindingID});
            throw e;
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.jaxws.metadata.builder.HandlerChainInfoBuilder", (String)"222", (Object)this, (Object[])new Object[]{chainsInfo, serviceClazzName, fileName, portQName, serviceQName, bindingID});
            throw new WebServiceException(Tr.formatMessage((TraceComponent)tc, (String)"error.unknown.exception", (Object[])new Object[]{e.getMessage()}));
        }
    }

    protected HandlerChainInfo processHandlerChainElement(Element el, QName portQName, QName serviceQName, String bindingID) {
        HandlerChainInfo chainInfo = new HandlerChainInfo();
        Node node = el.getFirstChild();
        while (node != null) {
            HandlerInfo handlerInfo;
            Node cur = node;
            node = node.getNextSibling();
            QName elQName = null;
            if (!(cur instanceof Element)) continue;
            el = (Element)cur;
            if (!el.getNamespaceURI().equals("http://java.sun.com/xml/ns/javaee")) {
                String xml = XMLUtils.toString((Node)el);
                throw new WebServiceException(Tr.formatMessage((TraceComponent)tc, (String)"error.invalid.handlerChainFile.content", (Object[])new Object[]{xml}));
            }
            String name = el.getLocalName();
            if ("port-name-pattern".equals(name)) {
                elQName = this.getQNameFromElement(el);
                if (!JaxWsUtils.matchesQName(elQName, portQName, portQName.getPrefix().isEmpty())) {
                    return chainInfo;
                }
                chainInfo.setPortNamePattern(this.getQNameFromElement(el));
                continue;
            }
            if ("service-name-pattern".equals(name)) {
                elQName = this.getQNameFromElement(el);
                if (!JaxWsUtils.matchesQName(elQName, serviceQName, serviceQName.getPrefix().isEmpty())) {
                    return chainInfo;
                }
                chainInfo.setServiceNamePattern(this.getQNameFromElement(el));
                continue;
            }
            if ("protocol-bindings".equals(name)) {
                String elementText = el.getTextContent().trim();
                String[] bindings = elementText.split("\\s");
                boolean include = false;
                for (String binding : bindings) {
                    if (JaxWsUtils.singleProtocolMatches(binding, bindingID)) {
                        include |= true;
                    }
                    chainInfo.addProtocolBinding(JaxWsUtils.getProtocolByToken(binding));
                }
                if (include || bindings.length == 0) continue;
                return new HandlerChainInfo();
            }
            if (!"handler".equals(name) || (handlerInfo = this.processHandlerElement(el)) == null) continue;
            chainInfo.addHandlerInfo(handlerInfo);
        }
        return chainInfo;
    }

    protected HandlerInfo processHandlerElement(Element el) {
        try {
            PortComponentHandlerType pt = (PortComponentHandlerType)context.createUnmarshaller().unmarshal((Node)el, PortComponentHandlerType.class).getValue();
            return this.adaptToHandlerInfo(pt);
        }
        catch (JAXBException jAXBException) {
            FFDCFilter.processException((Throwable)jAXBException, (String)"com.ibm.ws.jaxws.metadata.builder.HandlerChainInfoBuilder", (String)"285", (Object)this, (Object[])new Object[]{el});
            return null;
        }
    }

    private HandlerInfo adaptToHandlerInfo(PortComponentHandlerType pt) {
        HandlerInfo handler = new HandlerInfo();
        handler.setId(pt.getId());
        handler.setHandlerClass(pt.getHandlerClass().getValue());
        handler.setHandlerName(pt.getHandlerName().getValue());
        for (CString sRole : pt.getSoapRole()) {
            handler.addSoapRole(sRole.getValue());
        }
        for (XsdQNameType sHead : pt.getSoapHeader()) {
            handler.addSoapHeader(new XsdQNameInfo(sHead.getValue(), sHead.getId()));
        }
        for (ParamValueType param : pt.getInitParam()) {
            handler.addInitParam(new ParamValueInfo(param.getParamName().getValue(), param.getParamValue().getValue()));
        }
        return handler;
    }

    protected HandlerChainAnnotation findHandlerChainAnnotation(ClassInfo clzInfo, String seiClassName, InfoStore infoStore, boolean searchSEI) {
        if (clzInfo == null) {
            return null;
        }
        HandlerChainAnnotation hcAnn = null;
        AnnotationInfo ann = clzInfo.getAnnotation("javax.jws.HandlerChain");
        if (ann == null) {
            if (searchSEI) {
                AnnotationInfo ws = clzInfo.getAnnotation("javax.jws.WebService");
                boolean noSEI = false;
                if (seiClassName == null || seiClassName.isEmpty()) {
                    if (ws == null || StringUtils.isEmpty(ws.getValue("endpointInterface").getStringValue())) {
                        noSEI = true;
                    } else {
                        seiClassName = ws.getValue("endpointInterface").getStringValue().trim();
                    }
                }
                if (!noSEI) {
                    ClassInfo seiClass = infoStore.getDelayableClassInfo(seiClassName);
                    hcAnn = this.findHandlerChainAnnotation(seiClass, null, infoStore, false);
                }
            }
            if (hcAnn == null) {
                for (ClassInfo iface : clzInfo.getInterfaces()) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"Checking for HandlerChain annotation on {0}", (Object[])new Object[]{iface.getName()});
                    }
                    if ((ann = iface.getAnnotation("javax.jws.HandlerChain")) == null) continue;
                    hcAnn = new HandlerChainAnnotation(ann, iface);
                    break;
                }
                if (hcAnn == null) {
                    hcAnn = this.findHandlerChainAnnotation(clzInfo.getSuperclass(), null, infoStore, false);
                }
            }
        } else {
            hcAnn = new HandlerChainAnnotation(ann, clzInfo);
        }
        return hcAnn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected URL resolveHandlerChainFileName(String clzName, String fileName) {
        URL baseUrl;
        String handlerChainFileName;
        InputStream in;
        URL handlerFile;
        block13: {
            handlerFile = null;
            in = null;
            handlerChainFileName = fileName;
            baseUrl = this.classLoader.getResource(this.getClassResourceName(clzName));
            if (handlerChainFileName.charAt(0) != '/') break block13;
            URL uRL = this.classLoader.getResource(handlerChainFileName.substring(1));
            if (in == null) return uRL;
            try {
                in.close();
                return uRL;
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.jaxws.metadata.builder.HandlerChainInfoBuilder", (String)"391", (Object)this, (Object[])new Object[]{clzName, fileName});
            }
            return uRL;
        }
        handlerFile = new URL(baseUrl, handlerChainFileName);
        in = handlerFile.openStream();
        if (in == null) return handlerFile;
        try {
            in.close();
            return handlerFile;
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.jaxws.metadata.builder.HandlerChainInfoBuilder", (String)"391", (Object)this, (Object[])new Object[]{clzName, fileName});
        }
        return handlerFile;
        catch (Exception exception) {
            try {
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.jaxws.metadata.builder.HandlerChainInfoBuilder", (String)"385", (Object)this, (Object[])new Object[]{clzName, fileName});
                if (in == null) return handlerFile;
            }
            catch (Throwable throwable) {
                if (in == null) throw throwable;
                try {
                    in.close();
                    throw throwable;
                }
                catch (Exception exception2) {
                    FFDCFilter.processException((Throwable)exception2, (String)"com.ibm.ws.jaxws.metadata.builder.HandlerChainInfoBuilder", (String)"391", (Object)this, (Object[])new Object[]{clzName, fileName});
                }
                throw throwable;
            }
            try {
                in.close();
                return handlerFile;
            }
            catch (Exception exception3) {
                FFDCFilter.processException((Throwable)exception3, (String)"com.ibm.ws.jaxws.metadata.builder.HandlerChainInfoBuilder", (String)"391", (Object)this, (Object[])new Object[]{clzName, fileName});
            }
            return handlerFile;
        }
    }

    private String getClassResourceName(String clzName) {
        int index = clzName.lastIndexOf(46);
        String classResourceName = ".";
        if (index != -1) {
            classResourceName = clzName.replace('.', '/');
            classResourceName = classResourceName + ".class";
        }
        return classResourceName;
    }

    protected QName getQNameFromElement(Element el) {
        if (el == null) {
            return null;
        }
        String elementText = el.getTextContent().trim();
        int colonIndex = elementText.indexOf(58);
        String pfx = "";
        if (colonIndex == -1) {
            return new QName("", elementText, pfx);
        }
        String localPart = elementText.substring(colonIndex + 1);
        pfx = elementText.substring(0, colonIndex);
        String ns = el.lookupNamespaceURI(pfx);
        if (ns == null) {
            ns = el.lookupNamespaceURI(null);
        }
        return new QName(ns, localPart, pfx);
    }

    public static List<javax.xml.ws.handler.Handler> sortHandlers(List<javax.xml.ws.handler.Handler> handlers) {
        ArrayList<LogicalHandler> logicalHandlers = new ArrayList<LogicalHandler>();
        ArrayList<javax.xml.ws.handler.Handler> protocolHandlers = new ArrayList<javax.xml.ws.handler.Handler>();
        for (javax.xml.ws.handler.Handler handler : handlers) {
            if (handler instanceof LogicalHandler) {
                logicalHandlers.add((LogicalHandler)handler);
                continue;
            }
            protocolHandlers.add(handler);
        }
        ArrayList<javax.xml.ws.handler.Handler> sortedHandlers = new ArrayList<javax.xml.ws.handler.Handler>(logicalHandlers.size() + protocolHandlers.size());
        sortedHandlers.addAll(logicalHandlers);
        sortedHandlers.addAll(protocolHandlers);
        return sortedHandlers;
    }

    private static void validateAnnotation(String fileName, String className) {
        if (null == fileName || "".equals(fileName)) {
            throw new WebServiceException(Tr.formatMessage((TraceComponent)tc, (String)"error.handlerChain.annotation.without.file", (Object[])new Object[]{className}));
        }
    }

    /*
     * WARNING - void declaration
     */
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        try {
            try {
                context = AccessController.doPrivileged(new PrivilegedExceptionAction<JAXBContext>(){
                    static final long serialVersionUID = 6421207815671218329L;
                    private static final /* synthetic */ TraceComponent $$$tc$$$;

                    @Override
                    public JAXBContext run() throws Exception {
                        return JAXBUtils.newInstance(PortComponentHandlerType.class);
                    }

                    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                    static {
                        $$$tc$$$ = Tr.register((String)"com.ibm.ws.jaxws.metadata.builder.HandlerChainInfoBuilder$1", 1.class, (String)"JaxWsClientContainer", (String)"com.ibm.ws.jaxws.clientcontainer.internal.resources.JaxWsClientContainerMessages");
                    }
                });
            }
            catch (Exception exception) {
                void e;
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.jaxws.metadata.builder.HandlerChainInfoBuilder", (String)"74", null, (Object[])new Object[0]);
                throw new IllegalStateException((Throwable)e);
            }
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.jaxws.metadata.builder.HandlerChainInfoBuilder", (String)"77", null, (Object[])new Object[0]);
            throw new IllegalStateException(e);
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    static class HandlerChainAnnotation {
        private final ClassInfo declaringClzInfo;
        private final AnnotationInfo ann;
        private final String fileName;
        static final long serialVersionUID = 6193908956448835325L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        HandlerChainAnnotation(AnnotationInfo hc, ClassInfo clzInfo) {
            this.ann = hc;
            this.declaringClzInfo = clzInfo;
            this.fileName = this.ann.getValue("file") == null ? null : this.ann.getValue("file").getStringValue();
        }

        public ClassInfo getDeclaringClass() {
            return this.declaringClzInfo;
        }

        public String getFileName() {
            return this.fileName;
        }

        public void validate() {
            HandlerChainInfoBuilder.validateAnnotation(this.fileName, this.declaringClzInfo.getName());
        }

        public String toString() {
            return "[" + this.declaringClzInfo + "," + this.ann + "]";
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"com.ibm.ws.jaxws.metadata.builder.HandlerChainInfoBuilder$HandlerChainAnnotation", HandlerChainAnnotation.class, (String)"JaxWsClientContainer", (String)"com.ibm.ws.jaxws.clientcontainer.internal.resources.JaxWsClientContainerMessages");
        }
    }
}

