/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.reactive.streams.utils.recovery;

import io.reactivex.FlowableSubscriber;
import io.reactivex.internal.subscriptions.EmptySubscription;
import io.reactivex.internal.subscriptions.SubscriptionArbiter;
import io.reactivex.plugins.RxJavaPlugins;
import java.util.function.Function;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public class OnErrorResumeWithSubscriber<T>
implements FlowableSubscriber<T> {
    private final Subscriber<? super T> actual;
    private final Function<? super Throwable, ? extends Publisher<? extends T>> nextSupplier;
    private final SubscriptionArbiter arbiter;
    private boolean once;
    private boolean done;

    OnErrorResumeWithSubscriber(Subscriber<? super T> actual, Function<? super Throwable, ? extends Publisher<? extends T>> nextSupplier) {
        this.actual = actual;
        this.nextSupplier = nextSupplier;
        this.arbiter = new SubscriptionArbiter(false);
    }

    public void onSubscribe(Subscription s) {
        if (!(s instanceof EmptySubscription)) {
            this.arbiter.setSubscription(s);
        }
    }

    public void onNext(T t) {
        if (this.done) {
            return;
        }
        this.actual.onNext(t);
        if (!this.once) {
            this.arbiter.produced(1L);
        }
    }

    public void onError(Throwable t) {
        Publisher<? extends T> p;
        if (this.once) {
            if (this.done) {
                RxJavaPlugins.onError((Throwable)t);
            } else {
                this.actual.onError(t);
            }
            return;
        }
        this.once = true;
        try {
            p = this.nextSupplier.apply(t);
        }
        catch (Exception e) {
            this.actual.onError((Throwable)e);
            return;
        }
        if (p == null) {
            NullPointerException npe = new NullPointerException("Publisher is null");
            npe.initCause(t);
            this.actual.onError((Throwable)npe);
            return;
        }
        p.subscribe((Subscriber)this);
    }

    public void onComplete() {
        if (this.done) {
            return;
        }
        this.done = true;
        this.once = true;
        this.actual.onComplete();
    }

    Subscription arbiter() {
        return this.arbiter;
    }
}

