/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.cdi.impl.inject;

import com.ibm.ejs.util.Util;
import com.ibm.websphere.csi.J2EEName;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.ManualTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.cdi.CDIException;
import com.ibm.ws.cdi.impl.inject.InjectInjectionObjectFactory;
import com.ibm.ws.cdi.impl.inject.InjectableNull;
import com.ibm.ws.cdi.internal.interfaces.CDIRuntime;
import com.ibm.ws.cdi.internal.interfaces.CDIUtils;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.injectionengine.ComponentNameSpaceConfiguration;
import com.ibm.wsspi.injectionengine.InjectionException;
import com.ibm.wsspi.injectionengine.InjectionSimpleBinding;
import com.ibm.wsspi.injectionengine.InjectionTargetContext;
import com.ibm.wsspi.injectionengine.RecursiveInjectionException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import javax.enterprise.context.spi.CreationalContext;
import javax.inject.Inject;
import org.jboss.weld.construction.api.WeldCreationalContext;
import org.jboss.weld.manager.api.WeldManager;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class InjectInjectionBinding
extends InjectionSimpleBinding<Inject> {
    private static final String CLASS_NAME = InjectInjectionBinding.class.getName();
    private static final TraceComponent tc = Tr.register(InjectInjectionBinding.class, (String)"JCDI", (String)"com.ibm.ws.cdi.internal.resources.CDI");
    private final CDIRuntime cdiRuntime;
    private CreationalContext<Object> methodInvocationContext;
    static final long serialVersionUID = 499766586224408052L;

    public InjectInjectionBinding(Inject annotation, ComponentNameSpaceConfiguration nameSpaceConfig, CDIRuntime cdiRuntime) {
        super((Annotation)annotation, nameSpaceConfig);
        this.cdiRuntime = cdiRuntime;
    }

    public J2EEName getJ2EEName() {
        return this.ivJ2eeName;
    }

    public boolean isResolved() {
        return true;
    }

    @ManualTrace
    public Object getInjectionObjectInstance(Object targetObject, InjectionTargetContext targetContext) throws Exception {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getInjectionObjectInstance", (Object[])new Object[]{Util.identity((Object)targetObject), Util.identity((Object)targetContext)});
        }
        WeldCreationalContext cc = null;
        if (targetContext == null) {
            if (!(targetObject instanceof Class)) {
                throw new CDIException(Tr.formatMessage((TraceComponent)tc, (String)"no.injection.target.context.CWOWB1006E", (Object[])new Object[]{targetObject}));
            }
        } else {
            cc = (WeldCreationalContext)targetContext.getInjectionTargetContextData(WeldCreationalContext.class);
        }
        WeldManager beanManager = (WeldManager)this.cdiRuntime.getCurrentBeanManager();
        if (cc == null && beanManager != null) {
            cc = beanManager.createCreationalContext(null);
        }
        if (beanManager != null) {
            this.methodInvocationContext = beanManager.createCreationalContext(null);
        }
        Object retObj = InjectInjectionObjectFactory.getObjectInstance(this, targetObject, (CreationalContext<Object>)cc, this.methodInvocationContext, this.cdiRuntime);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getInjectionObjectInstance", (Object)Util.identity((Object)retObj));
        }
        return retObj;
    }

    public void setInjectionClassType(Method method) throws InjectionException {
        if (method.getParameterTypes().length == 1) {
            super.setInjectionClassType(method);
        } else if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Initializer method multi parameter Injection. InjectionClassType will be null.", (Object[])new Object[0]);
        }
    }

    public void cleanAfterMethodInvocation() {
        if (this.methodInvocationContext != null) {
            this.methodInvocationContext.release();
        }
    }

    /*
     * WARNING - void declaration
     */
    @ManualTrace
    public Object getInjectionObject(Object targetObject, InjectionTargetContext targetContext) throws InjectionException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getInjectionObject", (Object[])new Object[]{Util.identity((Object)targetObject), Util.identity((Object)targetContext)});
        }
        Object[] retObj = null;
        try {
            retObj = this.getInjectionObjectInstance(targetObject, targetContext);
        }
        catch (RecursiveInjectionException recursiveInjectionException) {
            void ex;
            FFDCFilter.processException((Throwable)recursiveInjectionException, (String)"com.ibm.ws.cdi.impl.inject.InjectInjectionBinding", (String)"158", (Object)((Object)this), (Object[])new Object[]{targetObject, targetContext});
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("getInjectionObject: " + ex), (Object[])new Object[0]);
            }
            throw ex;
        }
        catch (Throwable ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.cdi.impl.inject.InjectInjectionBinding", (String)"162", (Object)((Object)this), (Object[])new Object[]{targetObject, targetContext});
            if (CDIUtils.isInjectionFailureIgnored()) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"com.ibm.ws.cdi.ignoreInjectionFailure = true, ignoring InjectionException and will return null", (Object)ex);
                }
                return null;
            }
            if (targetObject != null) {
                FFDCFilter.processException((Throwable)ex, (String)(CLASS_NAME + ".getInjectionObject"), (String)"408", (Object)((Object)this), (Object[])null);
            }
            String displayName = this.getDisplayName();
            String exMessage = ex.getLocalizedMessage();
            if (exMessage == null) {
                exMessage = ex.toString();
            }
            String message = Tr.formatMessage((TraceComponent)tc, (String)"FAILED_TO_CREATE_OBJECT_INSTANCE_CWNEN0030E", (Object[])new Object[]{displayName, exMessage});
            InjectionException ex2 = new InjectionException(message, ex);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"getInjectionObject", (Object[])new Object[]{ex2});
            }
            throw ex2;
        }
        if (retObj == null) {
            String app;
            String module;
            String component;
            if (this.ivJ2eeName != null) {
                component = this.ivJ2eeName.getComponent();
                module = this.ivJ2eeName.getModule();
                app = this.ivJ2eeName.getApplication();
            } else {
                app = "UNKNOWN";
                module = "UNKNOWN";
                component = "UNKNOWN";
            }
            String classTypeName = this.getInjectionClassType() == null ? "UNKNOWN" : this.getInjectionClassType().getName();
            Tr.error((TraceComponent)tc, (String)"UNABLE_TO_RESOLVE_INJECTION_OBJECT_CWNEN0035E", (Object[])new Object[]{this.getDisplayName(), classTypeName, component, module, app});
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"getInjectionObject : failed", (Object[])new Object[0]);
            }
            InjectionException ex = new InjectionException("The " + this.getDisplayName() + " reference of type " + classTypeName + " for the " + component + " component in the " + module + " module of the " + app + " application cannot be resolved.");
            if (CDIUtils.isInjectionFailureIgnored()) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"com.ibm.ws.cdi.ignoreInjectionFailure = true, ignoring InjectionException and will return null", (Object)ex);
                }
                return null;
            }
            throw ex;
        }
        if (retObj instanceof InjectableNull) {
            retObj = null;
        } else if (retObj instanceof Object[]) {
            Object[] retObjArray = retObj;
            for (int i = 0; i < retObjArray.length; ++i) {
                if (!(retObjArray[i] instanceof InjectableNull)) continue;
                retObjArray[i] = null;
            }
            retObj = retObjArray;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getInjectionObjectInstance", (Object)Util.identity((Object)retObj));
        }
        return retObj;
    }
}

