/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.api.jms.impl;

import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.sib.Reliability;
import com.ibm.websphere.sib.SIDestinationAddress;
import com.ibm.websphere.sib.SIDestinationAddressFactory;
import com.ibm.websphere.sib.api.jms.JmsFactoryFactory;
import com.ibm.ws.sib.api.jms.EncodingLevel;
import com.ibm.ws.sib.api.jms.JmsInternalConstants;
import com.ibm.ws.sib.api.jms.JmsInternalsFactory;
import com.ibm.ws.sib.api.jms.impl.JmsBytesMessageImpl;
import com.ibm.ws.sib.api.jms.impl.JmsDestinationImpl;
import com.ibm.ws.sib.api.jms.impl.JmsErrorUtils;
import com.ibm.ws.sib.api.jms.impl.JmsMapMessageImpl;
import com.ibm.ws.sib.api.jms.impl.JmsObjectMessageImpl;
import com.ibm.ws.sib.api.jms.impl.JmsSessionImpl;
import com.ibm.ws.sib.api.jms.impl.JmsStreamMessageImpl;
import com.ibm.ws.sib.api.jms.impl.JmsTextMessageImpl;
import com.ibm.ws.sib.api.jms.service.JmsServiceFacade;
import com.ibm.ws.sib.mfp.JmsBodyType;
import com.ibm.ws.sib.mfp.JsJmsBytesMessage;
import com.ibm.ws.sib.mfp.JsJmsMapMessage;
import com.ibm.ws.sib.mfp.JsJmsMessage;
import com.ibm.ws.sib.mfp.JsJmsMessageFactory;
import com.ibm.ws.sib.mfp.JsJmsObjectMessage;
import com.ibm.ws.sib.mfp.JsJmsStreamMessage;
import com.ibm.ws.sib.mfp.JsJmsTextMessage;
import com.ibm.ws.sib.mfp.PersistenceType;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.wsspi.sib.core.SICoreConnection;
import java.io.IOException;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.jms.BytesMessage;
import javax.jms.ConnectionMetaData;
import javax.jms.Destination;
import javax.jms.IllegalStateException;
import javax.jms.InvalidDestinationException;
import javax.jms.JMSException;
import javax.jms.MapMessage;
import javax.jms.Message;
import javax.jms.MessageFormatException;
import javax.jms.MessageNotReadableException;
import javax.jms.MessageNotWriteableException;
import javax.jms.ObjectMessage;
import javax.jms.StreamMessage;
import javax.jms.TextMessage;

public class JmsMessageImpl
implements Message,
JmsInternalConstants,
Serializable {
    private static TraceComponent tc = SibTr.register(JmsMessageImpl.class, (String)"SIBJms_External", (String)"com.ibm.websphere.sib.api.jms.CWSIAJMSMessages");
    private static final long serialVersionUID = 7645122120151618834L;
    private transient Destination dest = null;
    private transient Destination replyTo = null;
    private JsJmsMessage msg;
    private transient JmsSessionImpl theSession = null;
    static JsJmsMessageFactory jmfact = null;
    static SIDestinationAddressFactory destAddressFactory = null;
    private boolean bodyReadOnly = false;
    private boolean propertiesReadOnly = false;
    private static Hashtable<String, Class> JMS_IBM_props = null;
    private static Set<String> localStorePropertyNames = null;
    private Hashtable locallyStoredPropertyValues = null;
    private String localJMSMessageID = null;
    private transient String cachedToString = null;
    protected String messageClass = null;
    private transient Object sessionSyncLock = null;
    private boolean rrpBusNameNeedsUpdating = false;
    protected boolean producerWontModifyPayloadAfterSet = false;
    protected boolean consumerWontModifyPayloadAfterGet = false;
    private volatile transient boolean inusebyAsyncSend = false;

    public JmsMessageImpl() throws JMSException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"<init>");
        }
        JsJmsMessage newMsg = null;
        try {
            newMsg = this.instantiateMessage();
        }
        catch (Exception e) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)"Exception creating message", (Object)e);
            }
            throw (JMSException)JmsErrorUtils.newThrowable(JMSException.class, "MSG_CREATE_FAILED_CWSIA0111", null, e, "JmsMessageImpl.<init>#2", this, tc);
        }
        this.setMsgReference(newMsg);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"<init>");
        }
    }

    public JmsMessageImpl(JsJmsMessage jsMsg) throws JMSException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"<init>", (Object)jsMsg);
        }
        this.setMsgReference(jsMsg);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"<init>");
        }
    }

    JmsMessageImpl(JsJmsMessage newMsg, JmsSessionImpl newSess) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"<init>", (Object)new Object[]{newMsg, newSess});
        }
        this.setMsgReference(newMsg);
        this.theSession = newSess;
        if (newSess != null) {
            this.sessionSyncLock = newSess.getSessionSyncLock();
        }
        this.messageClass = "jms_none";
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"<init>");
        }
    }

    JmsMessageImpl(Message message) throws JMSException {
        this();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"<init>", (Object)message);
        }
        this.setJMSCorrelationID(message.getJMSCorrelationID());
        this.setJMSReplyTo(message.getJMSReplyTo());
        this.setJMSType(message.getJMSType());
        Enumeration propertyNames = message.getPropertyNames();
        while (propertyNames.hasMoreElements()) {
            String name = (String)propertyNames.nextElement();
            Object value = message.getObjectProperty(name);
            try {
                this.setObjectProperty(name, value);
            }
            catch (Exception exception) {}
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"<init>");
        }
    }

    public String getJMSMessageID() throws JMSException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getJMSMessageID");
        }
        String id = null;
        id = this.localJMSMessageID == null ? this.msg.getApiMessageId() : this.localJMSMessageID;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getJMSMessageID", (Object)id);
        }
        return id;
    }

    public void setJMSMessageID(String newMsgId) throws JMSException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"setJMSMessageID", (Object)newMsgId);
        }
        this.localJMSMessageID = newMsgId;
        this.cachedToString = null;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"setJMSMessageID");
        }
    }

    public long getJMSTimestamp() throws JMSException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getJMSTimestamp");
        }
        Long ts = this.msg.getTimestamp();
        long val = 0L;
        val = ts != null ? ts : 0L;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getJMSTimestamp", (Object)val);
        }
        return val;
    }

    public void setJMSTimestamp(long time) throws JMSException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"setJMSTimestamp", (Object)time);
        }
        this.msg.setTimestamp(time);
        this.cachedToString = null;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"setJMSTimestamp");
        }
    }

    public byte[] getJMSCorrelationIDAsBytes() throws JMSException {
        byte[] result;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getJMSCorrelationIDAsBytes");
        }
        try {
            result = this.msg.getCorrelationIdAsBytes();
        }
        catch (IllegalArgumentException iae) {
            throw (JMSException)JmsErrorUtils.newThrowable(JMSException.class, "EXCEPTION_RECEIVED_CWSIA0115", new Object[]{iae, "JmsMessageImpl.getCorrelationIdAsBytes"}, iae, "JmsMessageImpl.getJMSCorrelationIDAsBytes#1", this, tc);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getJMSCorrelationIDAsBytes", (Object)result);
        }
        return result;
    }

    public void setJMSCorrelationIDAsBytes(byte[] cidB) throws JMSException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"setJMSCorrelationIDAsBytes", (Object)cidB);
        }
        try {
            this.msg.setCorrelationIdAsBytes(cidB);
            this.cachedToString = null;
        }
        catch (IllegalArgumentException iae) {
            throw (JMSException)JmsErrorUtils.newThrowable(JMSException.class, "INVALID_VALUE_CWSIA0116", new Object[]{"JMSCorrelationID", cidB}, iae, null, this, tc);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"setJMSCorrelationIDAsBytes");
        }
    }

    public void setJMSCorrelationID(String correl) throws JMSException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"setJMSCorrelationID", (Object)correl);
        }
        try {
            this.msg.setCorrelationId(correl);
            this.cachedToString = null;
        }
        catch (IllegalArgumentException iae) {
            throw (JMSException)JmsErrorUtils.newThrowable(JMSException.class, "INVALID_VALUE_CWSIA0116", new Object[]{"JMSCorrelationID", correl}, iae, null, this, tc);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"setJMSCorrelationID");
        }
    }

    public String getJMSCorrelationID() throws JMSException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getJMSCorrelationID");
        }
        String correl = this.msg.getCorrelationId();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"setJMSCorrelationID", (Object)correl);
        }
        return correl;
    }

    public Destination getJMSReplyTo() throws JMSException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getJMSReplyTo");
        }
        if (this.replyTo == null) {
            List rrp = this.msg.getReverseRoutingPath();
            SICoreConnection siConn = null;
            if (this.theSession != null) {
                siConn = this.theSession.getCoreConnection();
            }
            this.replyTo = JmsDestinationImpl.getJMSReplyToInternal(this.msg, rrp, siConn);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getJMSReplyTo", (Object)this.replyTo);
        }
        return this.replyTo;
    }

    public void setJMSReplyTo(Destination destination) throws JMSException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"setJMSReplyTo", (Object)destination);
        }
        if (destination instanceof JmsDestinationImpl) {
            this.replyTo = destination;
            this.setReplyHeader((JmsDestinationImpl)this.replyTo);
            this.msg.setJmsReplyTo(((JmsDestinationImpl)destination).encodeToBytes(EncodingLevel.MINIMAL));
            this.msg.setNonNullProperty("JMS_IBM_MsgType", (Object)1);
        } else if (destination == null) {
            this.replyTo = null;
            this.setReplyHeader(null);
            this.msg.setJmsReplyTo(null);
            this.msg.setNonNullProperty("JMS_IBM_MsgType", (Object)8);
        } else {
            throw (InvalidDestinationException)JmsErrorUtils.newThrowable(InvalidDestinationException.class, "INVALID_VALUE_CWSIA0116", new Object[]{"JMSReplyTo", destination.getClass().toString()}, null, "JmsMessageImpl.setJMSReplyTo#1", this, tc);
        }
        this.cachedToString = null;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"setJMSReplyTo");
        }
    }

    public Destination getJMSDestination() throws JMSException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getJMSDestination");
        }
        if (this.dest == null) {
            byte[] byteForm = this.msg.getJmsDestination();
            if (byteForm != null) {
                this.dest = JmsInternalsFactory.getMessageDestEncodingUtils().getDestinationFromMsgRepresentation(byteForm);
            } else {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)"null was returned by getJmsDestination");
                }
                this.dest = null;
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getJMSDestination", (Object)this.dest);
        }
        return this.dest;
    }

    public void setJMSDestination(Destination destination) throws JMSException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"setJMSDestination", (Object)destination);
        }
        this.setDestReference(destination);
        if (destination instanceof JmsDestinationImpl) {
            this.msg.setJmsDestination(((JmsDestinationImpl)destination).encodeToBytes(EncodingLevel.FULL));
        } else {
            this.msg.uncheckedSetForwardRoutingPath(null);
            this.msg.setJmsDestination(null);
        }
        this.cachedToString = null;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"setJMSDestination(Destination)");
        }
    }

    public int getJMSDeliveryMode() throws JMSException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getJMSDeliveryMode");
        }
        PersistenceType pt = this.msg.getJmsDeliveryMode();
        int tempDM = 0;
        if (pt == PersistenceType.PERSISTENT) {
            tempDM = 2;
        } else if (pt == PersistenceType.NON_PERSISTENT) {
            tempDM = 1;
        } else if (pt == PersistenceType.UNKNOWN) {
            tempDM = 1;
        } else {
            throw (JMSException)JmsErrorUtils.newThrowable(JMSException.class, "INTERNAL_ERROR_CWSIA0499", new Object[]{"JMSDeliveryMode", pt}, null, "JmsMessageImpl.getJMSDeliveryMode#1", this, tc);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getJMSDeliveryMode", (Object)tempDM);
        }
        return tempDM;
    }

    public void setJMSDeliveryMode(int dm) throws JMSException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"setJMSDeliveryMode", (Object)dm);
        }
        switch (dm) {
            case 1: {
                this.msg.setJmsDeliveryMode(PersistenceType.NON_PERSISTENT);
                break;
            }
            case 2: {
                this.msg.setJmsDeliveryMode(PersistenceType.PERSISTENT);
                break;
            }
            default: {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)"Invalid value");
                }
                throw (JMSException)JmsErrorUtils.newThrowable(JMSException.class, "INVALID_VALUE_CWSIA0116", new Object[]{"JMSDeliveryMode", String.valueOf(dm)}, tc);
            }
        }
        this.cachedToString = null;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"setJMSDeliveryMode");
        }
    }

    public boolean getJMSRedelivered() throws JMSException {
        Boolean red;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getJMSRedelivered");
        }
        if ((red = this.msg.getJmsRedelivered()) == null) {
            throw (JMSException)JmsErrorUtils.newThrowable(JMSException.class, "PROPERTY_NOT_SET_CWSIA0101", new Object[]{"JMSRedelivered"}, tc);
        }
        boolean redeliv = red;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getJMSRedelivered");
        }
        return redeliv;
    }

    public void setJMSRedelivered(boolean arg0) throws JMSException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"setJMSRedelivered", (Object)arg0);
        }
        if (!arg0) {
            this.msg.setRedeliveredCount(0);
        } else {
            this.msg.setRedeliveredCount(1);
        }
        this.cachedToString = null;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"setJMSRedelivered");
        }
    }

    public String getJMSType() throws JMSException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getJMSType");
        }
        String type = this.msg.getJmsType();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getJMSType", (Object)type);
        }
        return type;
    }

    public void setJMSType(String arg0) throws JMSException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"setJMSType", (Object)arg0);
        }
        this.msg.setJmsType(arg0);
        this.cachedToString = null;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"setJMSType");
        }
    }

    public long getJMSExpiration() throws JMSException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getJMSExpiration");
        }
        Long ex = this.msg.getJmsExpiration();
        long exl = 0L;
        if (ex == null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)"Property was not set");
            }
            throw (JMSException)JmsErrorUtils.newThrowable(JMSException.class, "PROPERTY_NOT_SET_CWSIA0101", new Object[]{"JMSExpiration"}, tc);
        }
        exl = ex;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getJMSExpiration", (Object)exl);
        }
        return exl;
    }

    public void setJMSExpiration(long exp) throws JMSException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"setJMSExpiration", (Object)exp);
        }
        this.msg.setJmsExpiration(exp);
        this.cachedToString = null;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"setJMSExpiration");
        }
    }

    public int getJMSPriority() throws JMSException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getJMSPriority");
        }
        Integer tempPri = this.msg.getPriority();
        int p = 0;
        if (tempPri != null) {
            p = tempPri;
            if (p == -1) {
                p = 4;
            }
        } else {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)"Property was not set");
            }
            throw (JMSException)JmsErrorUtils.newThrowable(JMSException.class, "PROPERTY_NOT_SET_CWSIA0101", new Object[]{"JMSPriority"}, tc);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getJMSPriority", (Object)p);
        }
        return p;
    }

    public void setJMSPriority(int newPriority) throws JMSException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"setJMSPriority", (Object)newPriority);
        }
        try {
            this.msg.setPriority(newPriority);
            this.cachedToString = null;
        }
        catch (IllegalArgumentException iae) {
            throw (JMSException)JmsErrorUtils.newThrowable(JMSException.class, "INVALID_VALUE_CWSIA0116", new Object[]{"JMSPriority", "" + newPriority}, iae, null, this, tc);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"setJMSPriority");
        }
    }

    public void clearProperties() throws JMSException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"clearProperties");
        }
        this.msg.clearProperties();
        this.propertiesReadOnly = false;
        this.cachedToString = null;
        if (this.locallyStoredPropertyValues != null) {
            this.locallyStoredPropertyValues.clear();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"clearProperties");
        }
    }

    public boolean propertyExists(String name) throws JMSException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"propertyExists", (Object)name);
        }
        boolean ex = this.msg.propertyExists(name);
        if (this.locallyStoredPropertyValues != null) {
            boolean bl = ex = ex || this.locallyStoredPropertyValues.containsKey(name);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"propertyExists", (Object)ex);
        }
        return ex;
    }

    public boolean getBooleanProperty(String name) throws JMSException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getBooleanProperty", (Object)name);
        }
        Object obj = this.getObjByName(name);
        boolean value = JmsMessageImpl.parseBoolean(obj, name);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getBooleanProperty", (Object)value);
        }
        return value;
    }

    public byte getByteProperty(String name) throws JMSException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getByteProperty", (Object)name);
        }
        Object obj = this.getObjByName(name);
        byte value = JmsMessageImpl.parseByte(obj, name);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getByteProperty", (Object)value);
        }
        return value;
    }

    public short getShortProperty(String name) throws JMSException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getShortProperty", (Object)name);
        }
        Object obj = this.getObjByName(name);
        short value = JmsMessageImpl.parseShort(obj, name);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getShortProperty", (Object)value);
        }
        return value;
    }

    public int getIntProperty(String name) throws JMSException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getIntProperty", (Object)name);
        }
        Object obj = this.getObjByName(name);
        int value = JmsMessageImpl.parseInt(obj, name);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getIntProperty", (Object)value);
        }
        return value;
    }

    public long getLongProperty(String name) throws JMSException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getLongProperty", (Object)name);
        }
        Object obj = this.getObjByName(name);
        long value = JmsMessageImpl.parseLong(obj, name);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getLongProperty", (Object)value);
        }
        return value;
    }

    public float getFloatProperty(String name) throws JMSException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getFloatProperty", (Object)name);
        }
        Object obj = this.getObjByName(name);
        float value = JmsMessageImpl.parseFloat(obj, name);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getFloatProperty", (Object)Float.valueOf(value));
        }
        return value;
    }

    public double getDoubleProperty(String name) throws JMSException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getDoubleProperty", (Object)name);
        }
        Object obj = this.getObjByName(name);
        double value = JmsMessageImpl.parseDouble(obj, name);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getDoubleProperty", (Object)value);
        }
        return value;
    }

    public String getStringProperty(String name) throws JMSException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getStringProperty", (Object)name);
        }
        String value = null;
        Object obj = this.getObjByName(name);
        value = obj instanceof String || obj == null ? (String)obj : obj.toString();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getStringProperty", (Object)value);
        }
        return value;
    }

    public Object getObjectProperty(String name) throws JMSException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getObjectProperty", (Object)name);
        }
        Object obj = this.getObjByName(name);
        if (name.equals("JMS_IBM_Character_Set") && obj instanceof Integer) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)"special case for charset, setting as string");
            }
            obj = String.valueOf(obj);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getObjectProperty", (Object)obj);
        }
        return obj;
    }

    public Enumeration getPropertyNames() throws JMSException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getPropertyNames");
        }
        Set pnSet = this.msg.getPropertyNameSet();
        if (this.locallyStoredPropertyValues != null) {
            pnSet.addAll(this.locallyStoredPropertyValues.keySet());
        }
        final Iterator it = pnSet.iterator();
        Enumeration vEnum = new Enumeration(){

            @Override
            public boolean hasMoreElements() {
                return it.hasNext();
            }

            public Object nextElement() {
                return it.next();
            }
        };
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getPropertyNames", (Object)vEnum);
        }
        return vEnum;
    }

    public void setBooleanProperty(String name, boolean val) throws JMSException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"setBooleanProperty", (Object)new Object[]{name, val});
        }
        this.checkPropertiesWriteable("setBooleanProperty");
        JmsMessageImpl.checkPropName(name, "setBooleanProperty");
        JmsMessageImpl.checkSettablePropertyNameAndType(name, Boolean.class);
        this.msg.setNonNullProperty(name, (Object)val);
        this.cachedToString = null;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"setBooleanProperty");
        }
    }

    public void setByteProperty(String name, byte val) throws JMSException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"setByteProperty", (Object)new Object[]{name, val});
        }
        this.checkPropertiesWriteable("setByteProperty");
        JmsMessageImpl.checkPropName(name, "setByteProperty");
        JmsMessageImpl.checkSettablePropertyNameAndType(name, Byte.class);
        this.msg.setNonNullProperty(name, (Object)val);
        this.cachedToString = null;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"setByteProperty");
        }
    }

    public void setShortProperty(String name, short val) throws JMSException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"setShortProperty", (Object)new Object[]{name, val});
        }
        this.checkPropertiesWriteable("setShortProperty");
        JmsMessageImpl.checkPropName(name, "setShortProperty");
        JmsMessageImpl.checkSettablePropertyNameAndType(name, Short.class);
        this.msg.setNonNullProperty(name, (Object)val);
        this.cachedToString = null;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"setShortProperty");
        }
    }

    public void setIntProperty(String name, int val) throws JMSException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"setIntProperty", (Object)new Object[]{name, val});
        }
        this.checkPropertiesWriteable("setIntProperty");
        JmsMessageImpl.checkPropName(name, "setIntProperty");
        if (name.equals("JMS_IBM_Character_Set")) {
            this.setStringProperty(name, String.valueOf(val));
        } else {
            JmsMessageImpl.checkSettablePropertyNameAndType(name, Integer.class);
            if (localStorePropertyNames.contains(name)) {
                if (this.locallyStoredPropertyValues == null) {
                    this.locallyStoredPropertyValues = new Hashtable();
                }
                this.locallyStoredPropertyValues.put(name, val);
            } else {
                this.msg.setNonNullProperty(name, (Object)val);
            }
            this.cachedToString = null;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"setIntProperty");
        }
    }

    public void setLongProperty(String name, long val) throws JMSException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"setLongProperty", (Object)new Object[]{name, val});
        }
        this.checkPropertiesWriteable("setLongProperty");
        JmsMessageImpl.checkPropName(name, "setLongProperty");
        JmsMessageImpl.checkSettablePropertyNameAndType(name, Long.class);
        if (localStorePropertyNames.contains(name)) {
            if (this.locallyStoredPropertyValues == null) {
                this.locallyStoredPropertyValues = new Hashtable();
            }
            this.locallyStoredPropertyValues.put(name, val);
        } else {
            this.msg.setNonNullProperty(name, (Object)val);
        }
        this.cachedToString = null;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"setLongProperty");
        }
    }

    public void setFloatProperty(String name, float val) throws JMSException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"setFloatProperty", (Object)new Object[]{name, Float.valueOf(val)});
        }
        this.checkPropertiesWriteable("setFloatProperty");
        JmsMessageImpl.checkPropName(name, "setFloatProperty");
        JmsMessageImpl.checkSettablePropertyNameAndType(name, Float.class);
        this.msg.setNonNullProperty(name, (Object)Float.valueOf(val));
        this.cachedToString = null;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"setFloatProperty");
        }
    }

    public void setDoubleProperty(String name, double val) throws JMSException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"setDoubleProperty", (Object)new Object[]{name, val});
        }
        this.checkPropertiesWriteable("setDoubleProperty");
        JmsMessageImpl.checkPropName(name, "setDoubleProperty");
        JmsMessageImpl.checkSettablePropertyNameAndType(name, Double.class);
        this.msg.setNonNullProperty(name, (Object)val);
        this.cachedToString = null;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"setDoubleProperty");
        }
    }

    public void setStringProperty(String name, String val) throws JMSException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"setStringProperty", (Object)new Object[]{name, val});
        }
        this.checkPropertiesWriteable("setStringProperty");
        JmsMessageImpl.checkPropName(name, "setStringProperty");
        JmsMessageImpl.checkSettablePropertyNameAndType(name, String.class);
        if ("JMSXAppID".equals(name) || "JMSXUserID".equals(name)) {
            this.msg.setObjectProperty(name, (Object)val);
        } else if (localStorePropertyNames.contains(name)) {
            if (val != null) {
                if (this.locallyStoredPropertyValues == null) {
                    this.locallyStoredPropertyValues = new Hashtable();
                }
                this.locallyStoredPropertyValues.put(name, val);
            } else if (this.locallyStoredPropertyValues != null) {
                this.locallyStoredPropertyValues.remove(name);
            }
        } else {
            this.msg.setObjectProperty(name, (Object)val);
        }
        this.cachedToString = null;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"setStringProperty");
        }
    }

    public void setObjectProperty(String name, Object obj) throws JMSException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"setObjectProperty", (Object)new Object[]{name, obj});
        }
        this.checkPropertiesWriteable("setObjectProperty");
        JmsMessageImpl.checkPropName(name, "setObjectProperty");
        Class<?> type = null;
        if (obj != null) {
            type = obj.getClass();
        }
        JmsMessageImpl.checkSettablePropertyNameAndType(name, type);
        if (obj == null) {
            if (localStorePropertyNames.contains(name)) {
                if (this.locallyStoredPropertyValues != null) {
                    this.locallyStoredPropertyValues.remove(name);
                }
            } else {
                this.msg.setObjectProperty(name, null);
            }
        } else if (obj instanceof Boolean || obj instanceof Number || obj instanceof String || name.startsWith("JMS")) {
            if (localStorePropertyNames.contains(name)) {
                if (this.locallyStoredPropertyValues == null) {
                    this.locallyStoredPropertyValues = new Hashtable();
                }
                this.locallyStoredPropertyValues.put(name, obj);
            } else {
                this.msg.setObjectProperty(name, obj);
            }
        } else {
            String objClassName = null;
            if (obj != null) {
                objClassName = obj.getClass().getName();
            }
            throw (MessageFormatException)JmsErrorUtils.newThrowable(MessageFormatException.class, "INVALID_OBJECT_TYPE_CWSIA0102", new Object[]{objClassName, name}, tc);
        }
        this.cachedToString = null;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"setObjectProperty");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void acknowledge() throws JMSException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"acknowledge");
        }
        if (this.theSession == null) {
            throw (IllegalStateException)JmsErrorUtils.newThrowable(IllegalStateException.class, "INVALID_FOR_UNCONSUMED_MSG_CWSIA0110", new Object[]{"acknowledge"}, tc);
        }
        Object object = this.sessionSyncLock;
        synchronized (object) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)"got lock");
            }
            this.theSession.checkNotClosed();
            this.theSession.checkSynchronousUsage("acknowledge");
            int sessAck = this.theSession.getAcknowledgeMode();
            if (sessAck == 2 || sessAck == 3) {
                this.theSession.commitTransaction();
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"acknowledge");
        }
    }

    public void clearBody() throws JMSException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"clearBody");
        }
        this.msg.clearBody();
        this.bodyReadOnly = false;
        this.cachedToString = null;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"clearBody");
        }
    }

    public String toString() {
        if (this.cachedToString == null) {
            try {
                this.cachedToString = "TO_STRING_IN_PROGRESS";
                StringBuffer sb = new StringBuffer();
                sb.append("\n  JMSMessage class: " + this.messageClass);
                sb.append("\n  JMSType:          " + this.getJMSType());
                sb.append("\n  JMSDeliveryMode:  " + this.getJMSDeliveryMode());
                sb.append("\n  JMSExpiration:    " + this.getJMSExpiration());
                sb.append("\n  JMSPriority:      " + this.getJMSPriority());
                sb.append("\n  JMSMessageID:     " + this.getJMSMessageID());
                sb.append("\n  JMSTimestamp:     " + this.getJMSTimestamp());
                sb.append("\n  JMSCorrelationID: " + this.getJMSCorrelationID());
                sb.append("\n  JMSDestination:   ");
                try {
                    sb.append(this.getJMSDestination());
                }
                catch (Exception e) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        SibTr.exception((Object)this, (TraceComponent)tc, (Exception)e);
                    }
                    sb.append("<ERROR>");
                }
                sb.append("\n  JMSReplyTo:       ");
                try {
                    sb.append(this.getJMSReplyTo());
                }
                catch (Exception e) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        SibTr.exception((Object)this, (TraceComponent)tc, (Exception)e);
                    }
                    sb.append("<ERROR>");
                }
                sb.append("\n  JMSRedelivered:   " + this.getJMSRedelivered());
                sb.append("\n  JMSDeliveryTime:  " + this.getJMSDeliveryTime());
                Enumeration propertyNames = this.getPropertyNames();
                while (propertyNames.hasMoreElements()) {
                    String name = (String)propertyNames.nextElement();
                    sb.append("\n    " + name + ": " + this.getObjectProperty(name));
                }
                this.cachedToString = sb.toString();
            }
            catch (JMSException jMSException) {
                // empty catch block
            }
        }
        return this.cachedToString;
    }

    protected JsJmsMessage instantiateMessage() throws Exception {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"instantiateMessage");
        }
        JsJmsMessage newMsg = jmfact.createJmsMessage();
        this.messageClass = "jms_none";
        newMsg.setNonNullProperty("JMS_IBM_MsgType", (Object)8);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"instantiateMessage", (Object)newMsg);
        }
        return newMsg;
    }

    protected JsJmsMessage getMsgReference() throws JMSException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getMsgReference");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getMsgReference", (Object)this.msg);
        }
        return this.msg;
    }

    protected void setMsgReference(JsJmsMessage newMsg) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"setMsgReference", (Object)newMsg);
        }
        this.msg = newMsg;
        this.cachedToString = null;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"setMsgReference");
        }
    }

    protected void setDestReference(Destination d) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"setDestReference", (Object)d);
        }
        this.dest = d;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"setDestReference");
        }
    }

    protected void checkBodyWriteable(String callingMethodName) throws JMSException {
        if (this.bodyReadOnly) {
            throw (MessageNotWriteableException)JmsErrorUtils.newThrowable(MessageNotWriteableException.class, "READ_ONLY_MESSAGE_BODY_CWSIA0107", new Object[]{callingMethodName}, tc);
        }
    }

    protected void checkBodyReadable(String callingMethodName) throws MessageNotReadableException {
        if (!this.bodyReadOnly) {
            throw (MessageNotReadableException)JmsErrorUtils.newThrowable(MessageNotReadableException.class, "WRITE_ONLY_MESSAGE_BODY_CWSIA0109", new Object[]{callingMethodName}, tc);
        }
    }

    protected void checkPropertiesWriteable(String callingMethodName) throws JMSException {
        if (this.propertiesReadOnly) {
            throw (MessageNotWriteableException)JmsErrorUtils.newThrowable(MessageNotWriteableException.class, "READ_ONLY_MESSAGE_PROPERTY_CWSIA0108", new Object[]{callingMethodName}, tc);
        }
    }

    public Reliability getReliability() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getReliability");
        }
        Reliability r = this.msg.getReliability();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getReliablity", (Object)r);
        }
        return r;
    }

    public Reliability getReplyReliability() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getReplyReliability");
        }
        Reliability r = this.msg.getReplyReliability();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getReplyReliability", (Object)r);
        }
        return r;
    }

    void updateReplyReliability(Reliability nonPerReliability, Reliability perReliability) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"updateReplyReliability", (Object)new Object[]{nonPerReliability, perReliability});
        }
        if (this.replyTo != null && this.replyTo instanceof JmsDestinationImpl) {
            Reliability replyReliability = ((JmsDestinationImpl)this.replyTo).getReplyReliability();
            if (replyReliability != null && replyReliability != Reliability.NONE) {
                this.msg.uncheckedSetReplyReliability(replyReliability);
            } else {
                String dMode = ((JmsDestinationImpl)this.replyTo).getDeliveryMode();
                if ("Persistent".equals(dMode)) {
                    this.msg.uncheckedSetReplyReliability(perReliability);
                } else if ("NonPersistent".equals(dMode)) {
                    this.msg.uncheckedSetReplyReliability(nonPerReliability);
                } else if ("Application".equals(dMode)) {
                    this.msg.uncheckedSetReplyReliability(Reliability.NONE);
                }
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"updateReplyReliability");
        }
    }

    protected boolean isBodyReadOnly() {
        return this.bodyReadOnly;
    }

    protected void setBodyReadOnly() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"setBodyReadOnly");
        }
        this.bodyReadOnly = true;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"setBodyReadOnly");
        }
    }

    void clearLocalProperties() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"clearLocalProperties");
        }
        if (this.locallyStoredPropertyValues != null) {
            this.locallyStoredPropertyValues.clear();
        }
        this.localJMSMessageID = null;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"clearLocalProperties");
        }
    }

    void invalidateToStringCache() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"invalidateToStringCache");
        }
        this.cachedToString = null;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"invalidateToStringCache");
        }
    }

    public boolean isRrpBusNameNeedsUpdating() {
        return this.rrpBusNameNeedsUpdating;
    }

    public void setRrpBusNameNeedsUpdating(boolean rrpBusNameNeedsUpdating) {
        this.rrpBusNameNeedsUpdating = rrpBusNameNeedsUpdating;
    }

    static void checkPropName(String name, String callingMethodName) throws IllegalArgumentException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"checkPropName", (Object)new Object[]{name, callingMethodName});
        }
        if (name == null || "".equals(name)) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)("Invalid field name: " + name + " as parameter to " + callingMethodName));
            }
            throw (IllegalArgumentException)JmsErrorUtils.newThrowable(IllegalArgumentException.class, "INVALID_FIELD_NAME_CWSIA0106", null, tc);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"checkPropName");
        }
    }

    static Message inboundJmsInstance(JsJmsMessage newMsg, JmsSessionImpl newSess, Map passThruProps) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"inboundJmsInstance", (Object)new Object[]{newMsg, newSess, passThruProps});
        }
        JmsMessageImpl jmsMsg = null;
        JmsBodyType bt = newMsg.getBodyType();
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)("body type: " + bt));
        }
        int bodyTypeInt = -2;
        if (bt != null) {
            bodyTypeInt = bt.toInt();
        }
        switch (bodyTypeInt) {
            case 0: {
                jmsMsg = new JmsMessageImpl(newMsg, newSess);
                break;
            }
            case 5: {
                jmsMsg = new JmsTextMessageImpl((JsJmsTextMessage)newMsg, newSess);
                break;
            }
            case 2: {
                jmsMsg = new JmsMapMessageImpl((JsJmsMapMessage)newMsg, newSess);
                break;
            }
            case 3: {
                jmsMsg = new JmsObjectMessageImpl((JsJmsObjectMessage)newMsg, newSess);
                break;
            }
            case 1: {
                jmsMsg = new JmsBytesMessageImpl((JsJmsBytesMessage)newMsg, newSess);
                break;
            }
            case 4: {
                jmsMsg = new JmsStreamMessageImpl((JsJmsStreamMessage)newMsg, newSess);
                break;
            }
            default: {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)tc, (String)("UNKNOWN MESSAGE TYPE FOUND: " + bt));
                }
                jmsMsg = new JmsMessageImpl(newMsg, newSess);
            }
        }
        if (passThruProps != null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)"Pass through properties provided - attempting to assign to new message");
            }
            String producerProp = (String)passThruProps.get("producerDoesNotModifyPayloadAfterSet");
            String consumerProp = (String)passThruProps.get("consumerDoesNotModifyPayloadAfterGet");
            if (producerProp != null) {
                jmsMsg.producerWontModifyPayloadAfterSet = producerProp.equalsIgnoreCase("true");
            }
            if (consumerProp != null) {
                jmsMsg.consumerWontModifyPayloadAfterGet = consumerProp.equalsIgnoreCase("true");
            }
        }
        jmsMsg.bodyReadOnly = true;
        jmsMsg.propertiesReadOnly = true;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"inboundJmsInstance");
        }
        return jmsMsg;
    }

    static JmsMessageImpl messageToJmsMessageImpl(Message message) throws JMSException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"messageToJmsMessageImpl", (Object)message);
        }
        JmsMessageImpl jmsMessage = null;
        if (message instanceof BytesMessage) {
            jmsMessage = new JmsBytesMessageImpl((BytesMessage)message);
        } else if (message instanceof MapMessage) {
            jmsMessage = new JmsMapMessageImpl((MapMessage)message);
        } else if (message instanceof ObjectMessage) {
            jmsMessage = new JmsObjectMessageImpl((ObjectMessage)message);
        } else if (message instanceof StreamMessage) {
            jmsMessage = new JmsStreamMessageImpl((StreamMessage)message);
        } else if (message instanceof TextMessage) {
            jmsMessage = new JmsTextMessageImpl((TextMessage)message);
        } else if (message instanceof Message) {
            jmsMessage = new JmsMessageImpl(message);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"messageToJmsMessageImpl", (Object)jmsMessage);
        }
        return jmsMessage;
    }

    static MessageFormatException newBadConvertException(Object obj, String propName, String dType, TraceComponent xtc) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"newBadConvertException", (Object)new Object[]{obj, propName, dType, xtc});
        }
        String clsName = null;
        if (!(obj instanceof byte[])) {
            clsName = obj.getClass().getName();
            int index = 0;
            index = clsName.lastIndexOf(46);
            if (index != 0) {
                clsName = clsName.substring(index + 1);
            }
        } else {
            clsName = "Byte[]";
        }
        MessageFormatException mfe = (MessageFormatException)JmsErrorUtils.newThrowable(MessageFormatException.class, "INVALID_TYPE_CONVERSION_CWSIA0104", new Object[]{propName, clsName, dType}, xtc);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getBadConvertException");
        }
        return mfe;
    }

    protected static boolean parseBoolean(Object obj, String name) throws JMSException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"parseBoolean", (Object)new Object[]{obj, name});
        }
        boolean value = false;
        if (obj instanceof Boolean) {
            value = (Boolean)obj;
        } else if (obj instanceof String) {
            value = Boolean.valueOf((String)obj);
        } else if (obj == null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)"value null, generating rte");
            }
            value = Boolean.valueOf(null);
        } else {
            MessageFormatException e = JmsMessageImpl.newBadConvertException(obj, name, "Boolean", tc);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)"Invalid convert", (Object)((Object)e));
            }
            throw e;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"parseBoolean", (Object)value);
        }
        return value;
    }

    protected static byte parseByte(Object obj, String name) throws JMSException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"parseByte", (Object)new Object[]{obj, name});
        }
        byte value = 0;
        if (obj instanceof Byte) {
            value = (Byte)obj;
        } else if (obj instanceof String) {
            try {
                value = Byte.parseByte((String)obj);
            }
            catch (RuntimeException e) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)tc, (String)("Error parsing byte: " + obj), (Object)e);
                }
                throw e;
            }
        } else if (obj == null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)"Generating exception for null->byte conversion");
            }
            value = Byte.valueOf(null);
        } else {
            MessageFormatException e = JmsMessageImpl.newBadConvertException(obj, name, "Byte", tc);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)"invalid convert", (Object)((Object)e));
            }
            throw e;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"parseByte", (Object)value);
        }
        return value;
    }

    protected static double parseDouble(Object obj, String name) throws JMSException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"parseDouble", (Object)new Object[]{obj, name});
        }
        double value = 0.0;
        if (obj instanceof Double) {
            value = (Double)obj;
        } else if (obj instanceof Float) {
            value = ((Float)obj).doubleValue();
        } else if (obj instanceof String) {
            try {
                value = Double.parseDouble((String)obj);
            }
            catch (RuntimeException e) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)tc, (String)("Error parsing double: " + obj), (Object)e);
                }
                throw e;
            }
        } else {
            if (obj == null) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)tc, (String)"retrieved object is null, generating rte");
                }
                throw new NullPointerException();
            }
            MessageFormatException e = JmsMessageImpl.newBadConvertException(obj, name, "Double", tc);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)"invalid convert", (Object)((Object)e));
            }
            throw e;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"parseDouble", (Object)value);
        }
        return value;
    }

    protected static float parseFloat(Object obj, String name) throws JMSException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"parseFloat", (Object)new Object[]{obj, name});
        }
        float value = 0.0f;
        if (obj instanceof Float) {
            value = ((Float)obj).floatValue();
        } else if (obj instanceof String) {
            try {
                value = Float.parseFloat((String)obj);
            }
            catch (RuntimeException e) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)tc, (String)("Error parsing float: " + obj), (Object)e);
                }
                throw e;
            }
        } else {
            if (obj == null) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)tc, (String)"retrieved object is null, generating rte");
                }
                throw new NullPointerException();
            }
            MessageFormatException e = JmsMessageImpl.newBadConvertException(obj, name, "Float", tc);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)"invalid convert", (Object)((Object)e));
            }
            throw e;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"parseFloat", (Object)Float.valueOf(value));
        }
        return value;
    }

    protected static int parseInt(Object obj, String name) throws JMSException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"parseInt", (Object)new Object[]{obj, name});
        }
        int value = 0;
        if (obj instanceof Integer) {
            value = (Integer)obj;
        } else if (obj instanceof String) {
            try {
                value = Integer.parseInt((String)obj);
            }
            catch (RuntimeException e) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)tc, (String)("Error parsing int: " + obj), (Object)e);
                }
                throw e;
            }
        } else if (obj instanceof Byte) {
            value = ((Byte)obj).intValue();
        } else if (obj instanceof Short) {
            value = ((Short)obj).intValue();
        } else if (obj == null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)"retrieved object is null, generating rte");
            }
            value = Integer.valueOf(null);
        } else {
            MessageFormatException e = JmsMessageImpl.newBadConvertException(obj, name, "Integer", tc);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)"invalid convert", (Object)((Object)e));
            }
            throw e;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"parseInt", (Object)value);
        }
        return value;
    }

    protected static long parseLong(Object obj, String name) throws JMSException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"parseLong", (Object)new Object[]{obj, name});
        }
        long value = 0L;
        if (obj instanceof Long) {
            value = (Long)obj;
        } else if (obj instanceof String) {
            try {
                value = Long.parseLong((String)obj);
            }
            catch (RuntimeException e) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)tc, (String)("Error parsing long: " + obj), (Object)e);
                }
                throw e;
            }
        } else if (obj instanceof Byte) {
            value = ((Byte)obj).longValue();
        } else if (obj instanceof Short) {
            value = ((Short)obj).longValue();
        } else if (obj instanceof Integer) {
            value = ((Integer)obj).longValue();
        } else if (obj == null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)"retrieved object is null, generating rte");
            }
            value = Long.valueOf(null);
        } else {
            MessageFormatException e = JmsMessageImpl.newBadConvertException(obj, name, "Long", tc);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)"invalid convert", (Object)((Object)e));
            }
            throw e;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"parseLong", (Object)value);
        }
        return value;
    }

    protected static short parseShort(Object obj, String name) throws JMSException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"parseShort", (Object)new Object[]{obj, name});
        }
        short value = 0;
        if (obj instanceof Short) {
            value = (Short)obj;
        } else if (obj instanceof String) {
            try {
                value = Short.parseShort((String)obj);
            }
            catch (RuntimeException e) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)tc, (String)("Error parsing short: " + obj), (Object)e);
                }
                throw e;
            }
        } else if (obj instanceof Byte) {
            value = ((Byte)obj).shortValue();
        } else if (obj == null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)"retrieved object is null, generating rte");
            }
            value = Short.valueOf(null);
        } else {
            MessageFormatException e = JmsMessageImpl.newBadConvertException(obj, name, "Short", tc);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)"invalid convert", (Object)((Object)e));
            }
            throw e;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"parseShort", (Object)value);
        }
        return value;
    }

    private static void obtainMFPFactory() throws JMSException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"obtainMFPFactory");
        }
        if (jmfact == null) {
            try {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)tc, (String)"Retrieving reference to MFP factory.");
                }
                jmfact = JsJmsMessageFactory.getInstance();
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)tc, (String)"Retrieving reference to DestinationAddress factory.");
                }
                destAddressFactory = JmsServiceFacade.getSIDestinationAddressFactory();
            }
            catch (Exception e) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)tc, (String)"Exception getting MFP factory", (Object)e);
                }
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"JmsMessageImpl");
                }
                throw (JMSException)JmsErrorUtils.newThrowable(JMSException.class, "INITIALIZATION_ERROR_CWSIA0002", new Object[]{e}, e, "JmsMessageImpl.obtainMFPFactory#1", JmsMessageImpl.class, tc);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"obtainMFPFactory");
        }
    }

    private void setReplyHeader(JmsDestinationImpl replyTo) throws JMSException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"setReplyHeader", (Object)replyTo);
        }
        if (replyTo != null) {
            SIDestinationAddress siDest = replyTo.getConsumerSIDestinationAddress();
            String busName = siDest.getBusName();
            if (busName == null) {
                this.setRrpBusNameNeedsUpdating(true);
            }
            this.msg.setReplyDiscriminator(replyTo.getDestDiscrim());
            ArrayList<SIDestinationAddress> reverseList = new ArrayList<SIDestinationAddress>(1);
            reverseList.add(siDest);
            this.msg.uncheckedSetReverseRoutingPath(reverseList);
            this.msg.uncheckedSetReplyPriority(replyTo.getPriority());
            this.msg.uncheckedSetReplyTimeToLive(replyTo.getTimeToLive());
        } else {
            this.msg.clearReplyFields();
            this.msg.uncheckedSetReverseRoutingPath(null);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"setReplyHeader");
        }
    }

    private Object getObjByName(String name) {
        Object obj = null;
        if (name == null) {
            throw (IllegalArgumentException)JmsErrorUtils.newThrowable(IllegalArgumentException.class, "INVALID_PROPNAME_CWSIA0112", new Object[]{null}, tc);
        }
        if ("".equals(name)) {
            throw (IllegalArgumentException)JmsErrorUtils.newThrowable(IllegalArgumentException.class, "INVALID_PROPNAME_CWSIA0112", new Object[]{"\"\""}, tc);
        }
        obj = this.locallyStoredPropertyValues != null && this.locallyStoredPropertyValues.containsKey(name) ? this.locallyStoredPropertyValues.get(name) : this.msg.getObjectProperty(name);
        return obj;
    }

    static void checkSettablePropertyNameAndType(String propertyName, Class propType) throws JMSException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"checkSettablePropertyNameAndType", (Object)new Object[]{propertyName, propType});
        }
        if (propertyName == null || !Character.isJavaIdentifierStart(propertyName.charAt(0))) {
            throw (MessageFormatException)JmsErrorUtils.newThrowable(MessageFormatException.class, "INVALID_PROPNAME_CWSIA0112", new Object[]{propertyName}, tc);
        }
        for (int i = 1; i < propertyName.length(); ++i) {
            if (Character.isJavaIdentifierPart(propertyName.charAt(i))) continue;
            throw (MessageFormatException)JmsErrorUtils.newThrowable(MessageFormatException.class, "INVALID_PROPNAME_CWSIA0112", new Object[]{propertyName}, tc);
        }
        if (propertyName.startsWith("JMS_")) {
            if (JMS_IBM_props.containsKey(propertyName)) {
                Class expectedPropType;
                if (propType != null && propType != (expectedPropType = JMS_IBM_props.get(propertyName))) {
                    throw (JMSException)JmsErrorUtils.newThrowable(JMSException.class, "JMS_IBM_INVALID_TYPE_CWSIA0114", new Object[]{propertyName, expectedPropType.getName(), propType.getName()}, tc);
                }
            } else if (propertyName.startsWith("JMSX")) {
                if (!propertyName.equals("JMSXGroupID") && !propertyName.equals("JMSXGroupSeq")) {
                    ConnectionMetaData cmd = JmsFactoryFactory.getInstance().getMetaData();
                    Enumeration supportedJMSX = cmd.getJMSXPropertyNames();
                    boolean found = false;
                    while (supportedJMSX.hasMoreElements()) {
                        String nextProp = (String)supportedJMSX.nextElement();
                        if (!nextProp.equals(propertyName)) continue;
                        found = true;
                        break;
                    }
                    if (!found) {
                        throw (MessageFormatException)JmsErrorUtils.newThrowable(MessageFormatException.class, "RESERVED_PROPNAME_CWSIA0113", new Object[]{propertyName}, tc);
                    }
                }
            } else {
                throw (MessageFormatException)JmsErrorUtils.newThrowable(MessageFormatException.class, "RESERVED_PROPNAME_CWSIA0113", new Object[]{propertyName}, tc);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"checkSettablePropertyNameAndType");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T getBody(Class<T> paramClass) throws JMSException, MessageFormatException {
        Object object;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getBody", (Object)new Object[]{paramClass});
        }
        Object returnObj = null;
        try {
            int bodyType = this.msg.getBodyType().toInt();
            Object _messageObject = null;
            switch (bodyType) {
                case 5: {
                    try {
                        _messageObject = ((JsJmsTextMessage)this.msg).getText();
                        break;
                    }
                    catch (UnsupportedEncodingException exp) {
                        throw this.getJMSException(paramClass, exp);
                    }
                }
                case 3: {
                    try {
                        _messageObject = ((JsJmsObjectMessage)this.msg).getRealObject();
                        if (_messageObject != null && !Serializable.class.isAssignableFrom(paramClass)) {
                            throw this.getMessageFormatException(paramClass);
                        }
                        break;
                    }
                    catch (ClassNotFoundException cnfe) {
                        throw this.getJMSException(paramClass, cnfe);
                    }
                    catch (IOException ioe) {
                        throw this.getJMSException(paramClass, ioe);
                    }
                }
                case 2: {
                    try {
                        _messageObject = this.getMapMessage();
                        if (_messageObject != null && !paramClass.isAssignableFrom(Map.class)) {
                            throw this.getMessageFormatException(paramClass);
                        }
                        break;
                    }
                    catch (UnsupportedEncodingException uee) {
                        throw this.getJMSException(paramClass, uee);
                    }
                }
                case 1: {
                    byte[] byteMsg = ((JsJmsBytesMessage)this.msg).getBytes();
                    _messageObject = byteMsg != null && byteMsg.length > 0 ? byteMsg : null;
                    Object object2 = _messageObject;
                    if (_messageObject == null || paramClass.isAssignableFrom(byte[].class)) break;
                    throw this.getMessageFormatException(paramClass);
                }
                case 4: {
                    throw this.getMessageFormatException(paramClass);
                }
                case 0: {
                    _messageObject = null;
                }
            }
            if (_messageObject != null) {
                if (paramClass.isAssignableFrom(_messageObject.getClass())) {
                    returnObj = _messageObject;
                } else {
                    throw this.getMessageFormatException(paramClass);
                }
            }
            object = returnObj;
        }
        catch (Throwable throwable) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"getBody", returnObj);
            }
            throw throwable;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getBody", (Object)returnObj);
        }
        return (T)object;
    }

    private Map getMapMessage() throws UnsupportedEncodingException {
        HashMap<String, Object> mapBody = null;
        Enumeration mapNames = ((JsJmsMapMessage)this.msg).getMapNames();
        mapBody = new HashMap<String, Object>();
        while (mapNames.hasMoreElements()) {
            String name = (String)mapNames.nextElement();
            mapBody.put(name, ((JsJmsMapMessage)this.msg).getObject(name));
        }
        return mapBody != null && mapBody.isEmpty() ? null : mapBody;
    }

    private <T> MessageFormatException getMessageFormatException(T paramClass) {
        return (MessageFormatException)JmsErrorUtils.newThrowable(MessageFormatException.class, "INVALID_CLASS_TYPE_CWSIA0118", new Object[]{paramClass}, tc);
    }

    private <T> JMSException getJMSException(T paramClass, Exception exp) {
        return (JMSException)JmsErrorUtils.newThrowable(JMSException.class, "GET_MSG_BODY_FAILED_CWSIA0120", null, exp, null, this, tc);
    }

    public long getJMSDeliveryTime() throws JMSException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getJMSDeliveryTime");
        }
        Long ex = this.msg.getJmsDeliveryTime();
        long exl = 0L;
        if (ex == null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)"Property was not set");
            }
            throw (JMSException)JmsErrorUtils.newThrowable(JMSException.class, "PROPERTY_NOT_SET_CWSIA0101", new Object[]{"JMSDeliveryTime"}, tc);
        }
        exl = ex;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getJMSDeliveryTime", (Object)exl);
        }
        return exl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean isBodyAssignableTo(Class paramClass) throws JMSException, MessageFormatException {
        block13: {
            if (TraceComponent.isAnyTracingEnabled() && JmsMessageImpl.tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)JmsMessageImpl.tc, (String)"isBodyAssignableTo", (Object)new Object[]{paramClass});
            }
            decision = false;
            if (paramClass == null) {
                return false;
            }
            bodyType = this.msg.getBodyType().toInt();
            if (bodyType != 5) break block13;
            decision = String.class.isAssignableFrom(paramClass);
            ** GOTO lbl50
        }
        if (bodyType != 3) ** GOTO lbl39
        decision = Serializable.class.isAssignableFrom(paramClass);
        if (!decision) ** GOTO lbl50
        try {
            object = ((JsJmsObjectMessage)this.msg).getRealObject();
            decision = paramClass.isAssignableFrom(object.getClass());
            ** GOTO lbl50
        }
        catch (IOException jmse) {
            var5_7 = false;
            if (TraceComponent.isAnyTracingEnabled() == false) return var5_7;
            if (JmsMessageImpl.tc.isEntryEnabled() == false) return var5_7;
            SibTr.exit((TraceComponent)JmsMessageImpl.tc, (String)"isBodyAssignableTo", (Object)new Object[]{decision});
            return var5_7;
        }
        catch (ClassNotFoundException e) {
            var5_8 = false;
            if (TraceComponent.isAnyTracingEnabled() == false) return var5_8;
            if (JmsMessageImpl.tc.isEntryEnabled() == false) return var5_8;
            SibTr.exit((TraceComponent)JmsMessageImpl.tc, (String)"isBodyAssignableTo", (Object)new Object[]{decision});
            return var5_8;
        }
        {
            block12: {
                catch (Throwable var6_9) {
                    if (TraceComponent.isAnyTracingEnabled() == false) throw var6_9;
                    if (JmsMessageImpl.tc.isEntryEnabled() == false) throw var6_9;
                    SibTr.exit((TraceComponent)JmsMessageImpl.tc, (String)"isBodyAssignableTo", (Object)new Object[]{decision});
                    throw var6_9;
                }
lbl39:
                // 2 sources

                if (bodyType == 2) {
                    decision = Map.class.isAssignableFrom(paramClass);
                    break block12;
                }
                if (bodyType == 1) {
                    decision = byte[].class.isAssignableFrom(paramClass);
                    break block12;
                }
                if (bodyType == 4) {
                    decision = false;
                    break block12;
                }
                if (bodyType != 0) break block12;
                decision = false;
            }
            if (TraceComponent.isAnyTracingEnabled() == false) return decision;
            if (JmsMessageImpl.tc.isEntryEnabled() == false) return decision;
            SibTr.exit((TraceComponent)JmsMessageImpl.tc, (String)"isBodyAssignableTo", (Object)new Object[]{decision});
            return decision;
        }
    }

    public void setJMSDeliveryTime(long value) throws JMSException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"setJMSDeliveryTime", (Object)value);
        }
        this.msg.setJmsDeliveryTime(value);
        this.cachedToString = null;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"setJMSDeliveryTime");
        }
    }

    boolean isAsynSendInProgress() {
        return this.inusebyAsyncSend;
    }

    void setAsyncSendInProgress(boolean inusebyAsyncSend) {
        this.inusebyAsyncSend = inusebyAsyncSend;
    }

    static {
        JMS_IBM_props = new Hashtable(30);
        JMS_IBM_props.put("JMS_IBM_Format", String.class);
        JMS_IBM_props.put("JMS_IBM_MsgType", Integer.class);
        JMS_IBM_props.put("JMS_IBM_Feedback", Integer.class);
        JMS_IBM_props.put("JMS_IBM_PutApplType", Integer.class);
        JMS_IBM_props.put("JMS_IBM_Report_Exception", Integer.class);
        JMS_IBM_props.put("JMS_IBM_Report_Expiration", Integer.class);
        JMS_IBM_props.put("JMS_IBM_Report_COA", Integer.class);
        JMS_IBM_props.put("JMS_IBM_Report_COD", Integer.class);
        JMS_IBM_props.put("JMS_IBM_Report_PAN", Integer.class);
        JMS_IBM_props.put("JMS_IBM_Report_NAN", Integer.class);
        JMS_IBM_props.put("JMS_IBM_Report_Pass_Msg_ID", Integer.class);
        JMS_IBM_props.put("JMS_IBM_Report_Pass_Correl_ID", Integer.class);
        JMS_IBM_props.put("JMS_IBM_Report_Discard_Msg", Integer.class);
        JMS_IBM_props.put("JMS_IBM_Encoding", Integer.class);
        JMS_IBM_props.put("JMS_IBM_Character_Set", String.class);
        JMS_IBM_props.put("JMS_IBM_Last_Msg_In_Group", Boolean.class);
        JMS_IBM_props.put("JMS_IBM_PutDate", String.class);
        JMS_IBM_props.put("JMS_IBM_PutTime", String.class);
        JMS_IBM_props.put("JMS_IBM_ExceptionReason", Integer.class);
        JMS_IBM_props.put("JMS_IBM_ExceptionTimestamp", Long.class);
        JMS_IBM_props.put("JMS_IBM_ExceptionMessage", String.class);
        JMS_IBM_props.put("JMS_IBM_ExceptionProblemDestination", String.class);
        JMS_IBM_props.put("JMS_IBM_ExceptionProblemSubscription", String.class);
        JMS_IBM_props.put("JMS_IBM_System_MessageID", String.class);
        JMS_IBM_props.put("JMS_IBM_ArmCorrelator", String.class);
        JMS_IBM_props.put("JMS_TOG_ARM_Correlator", String.class);
        JMS_IBM_props.put("JMS_IBM_MQMD_MsgId", byte[].class);
        JMS_IBM_props.put("JMS_IBM_MQMD_CorrelId", byte[].class);
        JMS_IBM_props.put("JMS_IBM_MQMD_Persistence", Integer.class);
        JMS_IBM_props.put("JMS_IBM_MQMD_ReplyToQ", String.class);
        JMS_IBM_props.put("JMS_IBM_MQMD_ReplyToQMgr", String.class);
        localStorePropertyNames = new HashSet<String>();
        localStorePropertyNames.add("JMS_IBM_ExceptionReason");
        localStorePropertyNames.add("JMS_IBM_ExceptionTimestamp");
        localStorePropertyNames.add("JMS_IBM_ExceptionMessage");
        localStorePropertyNames.add("JMSXDeliveryCount");
        localStorePropertyNames.add("JMS_IBM_System_MessageID");
        localStorePropertyNames.add("JMS_IBM_ExceptionProblemDestination");
        localStorePropertyNames.add("JMS_IBM_ExceptionProblemSubscription");
        try {
            JmsMessageImpl.obtainMFPFactory();
        }
        catch (JMSException e) {
            throw new RuntimeException(e);
        }
    }
}

