/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.messaging.security;

import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.messaging.security.Authentication;
import com.ibm.ws.messaging.security.Authorization;
import com.ibm.ws.messaging.security.MessagingSecurityException;
import com.ibm.ws.messaging.security.MessagingSecurityService;
import com.ibm.ws.messaging.security.authentication.MessagingAuthenticationException;
import com.ibm.ws.sib.utils.ras.SibTr;
import javax.security.auth.Subject;

public enum RuntimeSecurityService {
    SINGLETON_INSTANCE;

    private static TraceComponent tc;
    private static final String CLASS_NAME = "com.ibm.ws.messaging.security.RuntimeSecurityService.";
    private MessagingSecurityService messagingSecurityService = null;
    private Authentication authentication = null;
    private Authorization authorization = null;
    private Subject unauthenticatedSubject = null;

    public synchronized void modifyMessagingServices(MessagingSecurityService messagingSecurityService) {
        SibTr.entry((TraceComponent)tc, (String)"com.ibm.ws.messaging.security.RuntimeSecurityService.modifyMessagingServices", (Object)messagingSecurityService);
        this.messagingSecurityService = messagingSecurityService;
        if (messagingSecurityService != null) {
            this.getAuthenticationInstance().setMessagingAuthenticationService(messagingSecurityService.getMessagingAuthenticationService());
            this.getAuthorizationInstance().setMessagingAuthorizationService(messagingSecurityService.getMessagingAuthorizationService());
        } else {
            this.getAuthenticationInstance().setMessagingAuthenticationService(null);
            this.getAuthorizationInstance().setMessagingAuthorizationService(null);
        }
        SibTr.exit((TraceComponent)tc, (String)"com.ibm.ws.messaging.security.RuntimeSecurityService.modifyMessagingServices");
    }

    public boolean isMessagingSecure() {
        SibTr.entry((TraceComponent)tc, (String)"com.ibm.ws.messaging.security.RuntimeSecurityService.isMessagingSecure");
        boolean result = false;
        if (this.messagingSecurityService != null) {
            result = true;
        }
        SibTr.exit((TraceComponent)tc, (String)"com.ibm.ws.messaging.security.RuntimeSecurityService.isMessagingSecure", (Object)result);
        return result;
    }

    public Subject createUnauthenticatedSubject() {
        SibTr.entry((TraceComponent)tc, (String)"com.ibm.ws.messaging.security.RuntimeSecurityService.createUnauthenticatedSubject");
        if (this.unauthenticatedSubject == null) {
            this.unauthenticatedSubject = new Subject();
        }
        SibTr.exit((TraceComponent)tc, (String)"com.ibm.ws.messaging.security.RuntimeSecurityService.createUnauthenticatedSubject", (Object)this.unauthenticatedSubject);
        return this.unauthenticatedSubject;
    }

    public Authentication getAuthenticationInstance() {
        if (this.authentication == null) {
            this.authentication = new Authentication();
        }
        return this.authentication;
    }

    public Authorization getAuthorizationInstance() {
        if (this.authorization == null) {
            this.authorization = new Authorization();
        }
        return this.authorization;
    }

    public String getUniqueUserName(Subject subject) throws MessagingSecurityException {
        if (!this.isMessagingSecure()) {
            return "";
        }
        return this.messagingSecurityService.getUniqueUserName(subject);
    }

    public boolean isUnauthenticated(Subject subject) throws MessagingAuthenticationException {
        SibTr.entry((TraceComponent)tc, (String)"com.ibm.ws.messaging.security.RuntimeSecurityService.isUnauthenticated", (Object)subject);
        boolean result = false;
        if (!this.isMessagingSecure()) {
            result = false;
        } else {
            try {
                result = this.messagingSecurityService.isUnauthenticated(subject);
            }
            catch (Exception e) {
                throw new MessagingAuthenticationException(e.getMessage());
            }
        }
        SibTr.exit((TraceComponent)tc, (String)"com.ibm.ws.messaging.security.RuntimeSecurityService.isUnauthenticated", (Object)subject);
        return result;
    }

    static {
        tc = SibTr.register(RuntimeSecurityService.class, (String)"MessagingSecurity", (String)"com.ibm.ws.messaging.security.CWWKMMessages");
    }
}

