/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.microprofile.client.proxy;

import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.jaxrs.model.ProviderInfo;
import org.apache.cxf.message.Message;
import org.apache.cxf.microprofile.client.MicroProfileClientProviderFactory;
import org.apache.cxf.phase.AbstractPhaseInterceptor;
import org.eclipse.microprofile.rest.client.ext.AsyncInvocationInterceptor;
import org.eclipse.microprofile.rest.client.ext.AsyncInvocationInterceptorFactory;

@TraceObjectField(fieldName="LOG", fieldDesc="Ljava/util/logging/Logger;")
@InjectedFFDC
public class MPAsyncInvocationInterceptorImpl
extends AbstractPhaseInterceptor<Message> {
    private static final Logger LOG = LogUtils.getL7dLogger(MPAsyncInvocationInterceptorImpl.class);
    private final List<AsyncInvocationInterceptor> interceptors;
    static final long serialVersionUID = 2034780536292107036L;

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    MPAsyncInvocationInterceptorImpl(Message message) {
        super("post-marshal");
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.microprofile.client.proxy.MPAsyncInvocationInterceptorImpl", "<init>", new Object[]{message});
        }
        this.interceptors = new ArrayList<AsyncInvocationInterceptor>();
        MicroProfileClientProviderFactory factory = MicroProfileClientProviderFactory.getInstance(message);
        List<ProviderInfo<Object>> aiiProviderList = factory.getAsyncInvocationInterceptorFactories();
        for (ProviderInfo<Object> providerInfo : aiiProviderList) {
            AsyncInvocationInterceptor aiInterceptor = ((AsyncInvocationInterceptorFactory)providerInfo.getProvider()).newInterceptor();
            this.interceptors.add(0, aiInterceptor);
        }
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.microprofile.client.proxy.MPAsyncInvocationInterceptorImpl", "<init>", (Object)this);
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    List<AsyncInvocationInterceptor> getInterceptors() {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.microprofile.client.proxy.MPAsyncInvocationInterceptorImpl", "getInterceptors", new Object[0]);
        }
        List<AsyncInvocationInterceptor> list = this.interceptors;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            list = list;
            LOG.exiting("org.apache.cxf.microprofile.client.proxy.MPAsyncInvocationInterceptorImpl", "getInterceptors", list);
        }
        return list;
    }

    /*
     * WARNING - void declaration
     */
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void handleMessage(Message message) throws Fault {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.microprofile.client.proxy.MPAsyncInvocationInterceptorImpl", "handleMessage", new Object[]{message});
        }
        for (int i = this.interceptors.size() - 1; i >= 0; --i) {
            try {
                this.interceptors.get(i).prepareContext();
                continue;
            }
            catch (Throwable throwable) {
                void t;
                FFDCFilter.processException((Throwable)throwable, (String)"org.apache.cxf.microprofile.client.proxy.MPAsyncInvocationInterceptorImpl", (String)"66", (Object)((Object)this), (Object[])new Object[]{message});
                LOG.log(Level.WARNING, "ASYNC_INTERCEPTOR_EXCEPTION_PREPARE_CONTEXT", new Object[]{this.interceptors.get(i).getClass().getName(), t});
            }
        }
        message.getExchange().put(MPAsyncInvocationInterceptorImpl.class, (Object)this);
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.microprofile.client.proxy.MPAsyncInvocationInterceptorImpl", "handleMessage");
        }
    }
}

