/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.microprofile.client.proxy;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.net.URI;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ws.rs.client.InvocationCallback;
import javax.ws.rs.core.Configuration;
import javax.ws.rs.core.MultivaluedHashMap;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.apache.cxf.common.classloader.ClassLoaderUtils;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.common.util.ReflectionUtil;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.interceptor.Interceptor;
import org.apache.cxf.jaxrs.client.ClientProxyImpl;
import org.apache.cxf.jaxrs.client.ClientState;
import org.apache.cxf.jaxrs.client.JaxrsClientCallback;
import org.apache.cxf.jaxrs.client.LocalClientState;
import org.apache.cxf.jaxrs.model.AbstractResourceInfo;
import org.apache.cxf.jaxrs.model.ClassResourceInfo;
import org.apache.cxf.jaxrs.model.OperationResourceInfo;
import org.apache.cxf.jaxrs.model.Parameter;
import org.apache.cxf.jaxrs.model.ParameterType;
import org.apache.cxf.jaxrs.model.ProviderInfo;
import org.apache.cxf.jaxrs.utils.HttpUtils;
import org.apache.cxf.jaxrs.utils.InjectionUtils;
import org.apache.cxf.message.Exchange;
import org.apache.cxf.message.Message;
import org.apache.cxf.microprofile.client.MPRestClientCallback;
import org.apache.cxf.microprofile.client.MicroProfileClientProviderFactory;
import org.apache.cxf.microprofile.client.cdi.CDIFacade;
import org.apache.cxf.microprofile.client.cdi.CDIInterceptorWrapper;
import org.apache.cxf.microprofile.client.proxy.MPAsyncInvocationInterceptorImpl;
import org.apache.cxf.microprofile.client.proxy.MPAsyncInvocationInterceptorPostAsyncImpl;
import org.apache.cxf.microprofile.client.proxy.MPAsyncInvocationInterceptorRemoveContextImpl;
import org.eclipse.microprofile.rest.client.annotation.ClientHeaderParam;
import org.eclipse.microprofile.rest.client.annotation.RegisterClientHeaders;
import org.eclipse.microprofile.rest.client.ext.ClientHeadersFactory;
import org.eclipse.microprofile.rest.client.ext.ResponseExceptionMapper;

@TraceObjectField(fieldName="LOG", fieldDesc="Ljava/util/logging/Logger;")
@InjectedFFDC
public class MicroProfileClientProxyImpl
extends ClientProxyImpl {
    private static final Logger LOG = LogUtils.getL7dLogger(MicroProfileClientProxyImpl.class);
    private static final InvocationCallback<Object> NO_OP_CALLBACK = new InvocationCallback<Object>(){
        static final long serialVersionUID = 9125140467778639374L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        public void failed(Throwable t) {
        }

        public void completed(Object o) {
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"org.apache.cxf.microprofile.client.proxy.MicroProfileClientProxyImpl$1", 1.class, null, null);
        }
    };
    private static final Method JAXRS_UTILS_GET_CURRENT_MESSAGE_METHOD = MicroProfileClientProxyImpl.getJAXRSGetCurrentMessageMethod();
    private final CDIInterceptorWrapper interceptorWrapper;
    private Object objectInstance;
    private Map<Class<ClientHeadersFactory>, ProviderInfo<ClientHeadersFactory>> clientHeaderFactories;
    static final long serialVersionUID = -3126890164395768116L;

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    @FFDCIgnore(value={Throwable.class})
    private static Method getJAXRSGetCurrentMessageMethod() {
        Method m;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.microprofile.client.proxy.MicroProfileClientProxyImpl", "getJAXRSGetCurrentMessageMethod", new Object[0]);
        }
        try {
            Class<?> jaxrsUtilsClass = Class.forName("org.apache.cxf.jaxrs.utils.JAXRSUtils");
            m = ReflectionUtil.getDeclaredMethod(jaxrsUtilsClass, (String)"getCurrentMessage", (Class[])new Class[0]);
        }
        catch (Throwable t) {
            if (LOG.isLoggable(Level.FINEST)) {
                LOG.log(Level.FINEST, "Caught exception getting JAXRUtils class", t);
            }
            m = null;
        }
        Method method = m;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            method = method;
            LOG.exiting("org.apache.cxf.microprofile.client.proxy.MicroProfileClientProxyImpl", "getJAXRSGetCurrentMessageMethod", method);
        }
        return method;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public MicroProfileClientProxyImpl(URI baseURI, ClassLoader loader, ClassResourceInfo cri, boolean isRoot, boolean inheritHeaders, ExecutorService executorService, Configuration configuration, CDIInterceptorWrapper interceptorWrapper, Object ... varValues) {
        super((ClientState)new LocalClientState(baseURI), loader, cri, isRoot, inheritHeaders, varValues);
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.microprofile.client.proxy.MicroProfileClientProxyImpl", "<init>", new Object[]{baseURI, loader, cri, isRoot, inheritHeaders, executorService, configuration, interceptorWrapper, varValues});
        }
        this.clientHeaderFactories = new WeakHashMap<Class<ClientHeadersFactory>, ProviderInfo<ClientHeadersFactory>>();
        this.interceptorWrapper = interceptorWrapper;
        this.init(executorService, configuration);
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.microprofile.client.proxy.MicroProfileClientProxyImpl", "<init>", (Object)this);
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public MicroProfileClientProxyImpl(ClientState initialState, ClassLoader loader, ClassResourceInfo cri, boolean isRoot, boolean inheritHeaders, ExecutorService executorService, Configuration configuration, CDIInterceptorWrapper interceptorWrapper, Object ... varValues) {
        super(initialState, loader, cri, isRoot, inheritHeaders, varValues);
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.microprofile.client.proxy.MicroProfileClientProxyImpl", "<init>", new Object[]{initialState, loader, cri, isRoot, inheritHeaders, executorService, configuration, interceptorWrapper, varValues});
        }
        this.clientHeaderFactories = new WeakHashMap<Class<ClientHeadersFactory>, ProviderInfo<ClientHeadersFactory>>();
        this.interceptorWrapper = interceptorWrapper;
        this.init(executorService, configuration);
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.microprofile.client.proxy.MicroProfileClientProxyImpl", "<init>", (Object)this);
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private void init(ExecutorService executorService, Configuration configuration) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.microprofile.client.proxy.MicroProfileClientProxyImpl", "init", new Object[]{executorService, configuration});
        }
        this.cfg.getRequestContext().put("executorService", executorService);
        this.cfg.getRequestContext().putAll(configuration.getProperties());
        List inboundChain = this.cfg.getInInterceptors();
        inboundChain.add(new MPAsyncInvocationInterceptorPostAsyncImpl());
        inboundChain.add(new MPAsyncInvocationInterceptorRemoveContextImpl());
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.microprofile.client.proxy.MicroProfileClientProxyImpl", "init");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected InvocationCallback<Object> checkAsyncCallback(OperationResourceInfo ori, Map<String, Object> reqContext, Message outMessage) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.microprofile.client.proxy.MicroProfileClientProxyImpl", "checkAsyncCallback", new Object[]{ori, reqContext, outMessage});
        }
        InvocationCallback<Object> callback = (InvocationCallback<Object>)outMessage.getContent(InvocationCallback.class);
        if (callback == null && CompletionStage.class.equals(ori.getMethodToInvoke().getReturnType())) {
            callback = NO_OP_CALLBACK;
            outMessage.setContent(InvocationCallback.class, callback);
        }
        InvocationCallback<Object> invocationCallback = callback;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            invocationCallback = invocationCallback;
            LOG.exiting("org.apache.cxf.microprofile.client.proxy.MicroProfileClientProxyImpl", "checkAsyncCallback", invocationCallback);
        }
        return invocationCallback;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected boolean checkAsyncReturnType(OperationResourceInfo ori, Map<String, Object> reqContext, Message outMessage) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.microprofile.client.proxy.MicroProfileClientProxyImpl", "checkAsyncReturnType", new Object[]{ori, reqContext, outMessage});
        }
        boolean bl = CompletionStage.class.equals(ori.getMethodToInvoke().getReturnType());
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            bl = bl;
            LOG.exiting("org.apache.cxf.microprofile.client.proxy.MicroProfileClientProxyImpl", "checkAsyncReturnType", bl);
        }
        return bl;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected Object doInvokeAsync(OperationResourceInfo ori, Message outMessage, InvocationCallback<Object> asyncCallback) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.microprofile.client.proxy.MicroProfileClientProxyImpl", "doInvokeAsync", new Object[]{ori, outMessage, asyncCallback});
        }
        MPAsyncInvocationInterceptorImpl aiiImpl = new MPAsyncInvocationInterceptorImpl(outMessage);
        outMessage.getInterceptorChain().add((Interceptor)aiiImpl);
        this.setTimeouts(this.cfg.getRequestContext());
        super.doInvokeAsync(ori, outMessage, asyncCallback);
        JaxrsClientCallback cb = (JaxrsClientCallback)outMessage.getExchange().get(JaxrsClientCallback.class);
        Future future = cb.createFuture();
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            future = future;
            LOG.exiting("org.apache.cxf.microprofile.client.proxy.MicroProfileClientProxyImpl", "doInvokeAsync", future);
        }
        return future;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected void doRunInterceptorChain(Message message) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.microprofile.client.proxy.MicroProfileClientProxyImpl", "doRunInterceptorChain", new Object[]{message});
        }
        this.setTimeouts(this.cfg.getRequestContext());
        super.doRunInterceptorChain(message);
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.microprofile.client.proxy.MicroProfileClientProxyImpl", "doRunInterceptorChain");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected JaxrsClientCallback<?> newJaxrsClientCallback(InvocationCallback<Object> asyncCallback, Message outMessage, Class<?> responseClass, Type outGenericType) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.microprofile.client.proxy.MicroProfileClientProxyImpl", "newJaxrsClientCallback", new Object[]{asyncCallback, outMessage, responseClass, outGenericType});
        }
        MPRestClientCallback<Object> mPRestClientCallback = new MPRestClientCallback<Object>(asyncCallback, outMessage, responseClass, outGenericType);
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            mPRestClientCallback = mPRestClientCallback;
            LOG.exiting("org.apache.cxf.microprofile.client.proxy.MicroProfileClientProxyImpl", "newJaxrsClientCallback", mPRestClientCallback);
        }
        return mPRestClientCallback;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected void checkResponse(Method m, Response r, Message inMessage) throws Throwable {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.microprofile.client.proxy.MicroProfileClientProxyImpl", "checkResponse", new Object[]{m, r, inMessage});
        }
        MicroProfileClientProviderFactory factory = MicroProfileClientProviderFactory.getInstance(inMessage);
        List<ResponseExceptionMapper<?>> mappers = factory.createResponseExceptionMapper(inMessage, Throwable.class);
        for (ResponseExceptionMapper<?> mapper : mappers) {
            if (!mapper.handles(r.getStatus(), r.getHeaders())) continue;
            Throwable t = mapper.toThrowable(r);
            if (t instanceof RuntimeException) {
                throw t;
            }
            if (t == null || m.getExceptionTypes() == null) continue;
            for (Class<?> c : m.getExceptionTypes()) {
                if (!t.getClass().isAssignableFrom(c)) continue;
                throw t;
            }
        }
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.microprofile.client.proxy.MicroProfileClientProxyImpl", "checkResponse");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected Class<?> getReturnType(Method method, Message outMessage) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.microprofile.client.proxy.MicroProfileClientProxyImpl", "getReturnType", new Object[]{method, outMessage});
        }
        Class returnType = super.getReturnType(method, outMessage);
        if (CompletionStage.class.isAssignableFrom(returnType)) {
            Type t = method.getGenericReturnType();
            returnType = InjectionUtils.getActualType((Type)t);
        }
        Class clazz = returnType;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            clazz = clazz;
            LOG.exiting("org.apache.cxf.microprofile.client.proxy.MicroProfileClientProxyImpl", "getReturnType", clazz);
        }
        return clazz;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected Message createMessage(Object body, OperationResourceInfo ori, MultivaluedMap<String, String> headers, URI currentURI, Exchange exchange, Map<String, Object> invocationContext, boolean proxy) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.microprofile.client.proxy.MicroProfileClientProxyImpl", "createMessage", new Object[]{body, ori, headers, currentURI, exchange, invocationContext, proxy});
        }
        Method m = ori.getMethodToInvoke();
        Message msg = super.createMessage(body, ori, headers, currentURI, exchange, invocationContext, proxy);
        HashMap<String, Method> filterProps = (HashMap<String, Method>)msg.getExchange().get((Object)"jaxrs.filter.properties");
        if (filterProps == null) {
            filterProps = new HashMap<String, Method>();
            msg.getExchange().put((Object)"jaxrs.filter.properties", filterProps);
        }
        filterProps.put("org.eclipse.microprofile.rest.client.invokedMethod", m);
        Message message = msg;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            message = message;
            LOG.exiting("org.apache.cxf.microprofile.client.proxy.MicroProfileClientProxyImpl", "createMessage", message);
        }
        return message;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    @FFDCIgnore(value={Exception.class})
    protected void setTimeouts(Map<String, Object> props) {
        block6: {
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                LOG.entering("org.apache.cxf.microprofile.client.proxy.MicroProfileClientProxyImpl", "setTimeouts", new Object[]{props});
            }
            try {
                Long connectTimeout = this.getIntFromProps(props, "http.connection.timeout");
                Long readTimeout = this.getIntFromProps(props, "http.receive.timeout");
                if (connectTimeout > -1L) {
                    this.cfg.getHttpConduit().getClient().setConnectionTimeout(connectTimeout.longValue());
                }
                if (readTimeout > -1L) {
                    this.cfg.getHttpConduit().getClient().setReceiveTimeout(readTimeout.longValue());
                }
            }
            catch (Exception ex) {
                if (!LOG.isLoggable(Level.FINEST)) break block6;
                LOG.log(Level.FINEST, "Caught exception setting timeouts", ex);
            }
        }
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.microprofile.client.proxy.MicroProfileClientProxyImpl", "setTimeouts");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    @FFDCIgnore(value={NumberFormatException.class})
    private Long getIntFromProps(Map<String, Object> props, String key) {
        Long l;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.microprofile.client.proxy.MicroProfileClientProxyImpl", "getIntFromProps", new Object[]{props, key});
        }
        Object o = props.get(key);
        if (o == null) {
            Long l2 = -1L;
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                l2 = l2;
                LOG.exiting("org.apache.cxf.microprofile.client.proxy.MicroProfileClientProxyImpl", "getIntFromProps", l2);
            }
            return l2;
        }
        if (o instanceof Long) {
            l = (Long)o;
        } else if (o instanceof String) {
            try {
                l = Long.parseLong((String)o);
            }
            catch (NumberFormatException ex) {
                LOG.log(Level.WARNING, "INVALID_TIMEOUT_PROPERTY", new Object[]{key, o});
                Long l3 = -1L;
                if (LOG != null && LOG.isLoggable(Level.FINER)) {
                    l3 = l3;
                    LOG.exiting("org.apache.cxf.microprofile.client.proxy.MicroProfileClientProxyImpl", "getIntFromProps", l3);
                }
                return l3;
            }
        } else {
            LOG.log(Level.WARNING, "INVALID_TIMEOUT_PROPERTY", new Object[]{key, o});
            Long l4 = -1L;
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                l4 = l4;
                LOG.exiting("org.apache.cxf.microprofile.client.proxy.MicroProfileClientProxyImpl", "getIntFromProps", l4);
            }
            return l4;
        }
        if (l < 0L) {
            LOG.log(Level.WARNING, "INVALID_TIMEOUT_PROPERTY", new Object[]{key, o});
            Long l5 = -1L;
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                l5 = l5;
                LOG.exiting("org.apache.cxf.microprofile.client.proxy.MicroProfileClientProxyImpl", "getIntFromProps", l5);
            }
            return l5;
        }
        Long l6 = l;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            l6 = l6;
            LOG.exiting("org.apache.cxf.microprofile.client.proxy.MicroProfileClientProxyImpl", "getIntFromProps", l6);
        }
        return l6;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    @FFDCIgnore(value={ClassNotFoundException.class, NoSuchMethodException.class, NoSuchMethodException.class, Throwable.class})
    private String invokeBestFitComputeMethod(Class<?> clientIntf, ClientHeaderParam anno) throws Throwable {
        String value;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.microprofile.client.proxy.MicroProfileClientProxyImpl", "invokeBestFitComputeMethod", new Object[]{clientIntf, anno});
        }
        String methodName = anno.value()[0];
        methodName = methodName.substring(1, methodName.length() - 1);
        Class computeClass = clientIntf;
        if (methodName.contains(".")) {
            String className = methodName.substring(0, methodName.lastIndexOf(46));
            methodName = methodName.substring(methodName.lastIndexOf(46) + 1);
            try {
                computeClass = ClassLoaderUtils.loadClass((String)className, clientIntf);
            }
            catch (ClassNotFoundException ex) {
                LOG.warning("Cannot find specified computeValue class, " + className);
                String string = null;
                if (LOG != null && LOG.isLoggable(Level.FINER)) {
                    string = string;
                    LOG.exiting("org.apache.cxf.microprofile.client.proxy.MicroProfileClientProxyImpl", "invokeBestFitComputeMethod", string);
                }
                return string;
            }
        }
        Method m = null;
        boolean includeHeaderName = false;
        try {
            m = computeClass.getMethod(methodName, String.class);
            includeHeaderName = true;
        }
        catch (NoSuchMethodException expected) {
            try {
                m = computeClass.getMethod(methodName, new Class[0]);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
        }
        if (m == null) {
            value = null;
            LOG.warning("Cannot find specified computeValue method, " + methodName + ", on client interface, " + clientIntf.getName());
        } else {
            try {
                Object valueFromComputeMethod = includeHeaderName ? m.invoke(computeClass == clientIntf ? this.objectInstance : null, anno.name()) : m.invoke(computeClass == clientIntf ? this.objectInstance : null, new Object[0]);
                value = valueFromComputeMethod instanceof String[] ? HttpUtils.getHeaderString(Arrays.asList((String[])valueFromComputeMethod)) : (String)valueFromComputeMethod;
            }
            catch (Throwable t) {
                if (LOG.isLoggable(Level.FINEST)) {
                    LOG.log(Level.FINEST, "Caught exception invoking compute method", t);
                }
                if (t instanceof InvocationTargetException) {
                    t = t.getCause();
                }
                throw t;
            }
        }
        String string = value;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            string = string;
            LOG.exiting("org.apache.cxf.microprofile.client.proxy.MicroProfileClientProxyImpl", "invokeBestFitComputeMethod", string);
        }
        return string;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    @FFDCIgnore(value={Throwable.class})
    private Parameter createClientHeaderParameter(ClientHeaderParam anno, Class<?> clientIntf) {
        String headerValue;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.microprofile.client.proxy.MicroProfileClientProxyImpl", "createClientHeaderParameter", new Object[]{anno, clientIntf});
        }
        Parameter p = new Parameter(ParameterType.HEADER, anno.name());
        String[] values = anno.value();
        if (values[0] != null && values[0].length() > 2 && values[0].startsWith("{") && values[0].endsWith("}")) {
            try {
                headerValue = this.invokeBestFitComputeMethod(clientIntf, anno);
            }
            catch (Throwable t) {
                if (anno.required()) {
                    this.throwException(t);
                }
                Parameter parameter = null;
                if (LOG != null && LOG.isLoggable(Level.FINER)) {
                    parameter = parameter;
                    LOG.exiting("org.apache.cxf.microprofile.client.proxy.MicroProfileClientProxyImpl", "createClientHeaderParameter", parameter);
                }
                return parameter;
            }
        } else {
            headerValue = HttpUtils.getHeaderString(Arrays.asList(values));
        }
        p.setDefaultValue(headerValue);
        Parameter parameter = p;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            parameter = parameter;
            LOG.exiting("org.apache.cxf.microprofile.client.proxy.MicroProfileClientProxyImpl", "createClientHeaderParameter", parameter);
        }
        return parameter;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    @FFDCIgnore(value={Throwable.class})
    protected void handleHeaders(Method m, Object[] params, MultivaluedMap<String, String> headers, List<Parameter> beanParams, MultivaluedMap<ParameterType, Parameter> map) {
        RegisterClientHeaders headersFactoryAnno;
        ClientHeaderParam[] clientHeaderAnnosOnMethod;
        ClientHeaderParam[] clientHeaderAnnosOnInterface;
        Class<?> declaringClass;
        block9: {
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                LOG.entering("org.apache.cxf.microprofile.client.proxy.MicroProfileClientProxyImpl", "handleHeaders", new Object[]{m, params, headers, beanParams, map});
            }
            super.handleHeaders(m, params, headers, beanParams, map);
            declaringClass = m.getDeclaringClass();
            clientHeaderAnnosOnInterface = (ClientHeaderParam[])declaringClass.getAnnotationsByType(ClientHeaderParam.class);
            clientHeaderAnnosOnMethod = (ClientHeaderParam[])m.getAnnotationsByType(ClientHeaderParam.class);
            headersFactoryAnno = declaringClass.getAnnotation(RegisterClientHeaders.class);
            if (clientHeaderAnnosOnInterface.length >= 1 || clientHeaderAnnosOnMethod.length >= 1 || headersFactoryAnno != null) break block9;
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                LOG.exiting("org.apache.cxf.microprofile.client.proxy.MicroProfileClientProxyImpl", "handleHeaders");
            }
            return;
        }
        try {
            Parameter p;
            String headerName;
            for (ClientHeaderParam methodAnno : clientHeaderAnnosOnMethod) {
                headerName = methodAnno.name();
                if (headers.containsKey((Object)headerName) || (p = this.createClientHeaderParameter(methodAnno, declaringClass)) == null) continue;
                headers.putSingle((Object)p.getName(), (Object)p.getDefaultValue());
            }
            for (ClientHeaderParam intfAnno : clientHeaderAnnosOnInterface) {
                headerName = intfAnno.name();
                if (headers.containsKey((Object)headerName) || (p = this.createClientHeaderParameter(intfAnno, declaringClass)) == null) continue;
                headers.putSingle((Object)p.getName(), (Object)p.getDefaultValue());
            }
            if (headersFactoryAnno != null) {
                Class headersFactoryClass = headersFactoryAnno.value();
                this.mergeHeaders(headersFactoryClass, headers);
            }
        }
        catch (Throwable t) {
            this.throwException(t);
        }
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.microprofile.client.proxy.MicroProfileClientProxyImpl", "handleHeaders");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    @FFDCIgnore(value={Throwable.class})
    private void mergeHeaders(Class<ClientHeadersFactory> factoryCls, MultivaluedMap<String, String> existingHeaders) {
        block7: {
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                LOG.entering("org.apache.cxf.microprofile.client.proxy.MicroProfileClientProxyImpl", "mergeHeaders", new Object[]{factoryCls, existingHeaders});
            }
            try {
                MultivaluedMap<String, String> jaxrsHeaders;
                ClientHeadersFactory factory = CDIFacade.getInstanceFromCDI(factoryCls).orElse(factoryCls.newInstance());
                if (JAXRS_UTILS_GET_CURRENT_MESSAGE_METHOD != null) {
                    Message m = (Message)JAXRS_UTILS_GET_CURRENT_MESSAGE_METHOD.invoke(null, new Object[0]);
                    if (m != null) {
                        ProviderInfo pi = this.clientHeaderFactories.computeIfAbsent(factoryCls, k -> new ProviderInfo((Object)factory, m.getExchange().getBus(), true));
                        InjectionUtils.injectContexts((Object)factory, (AbstractResourceInfo)pi, (Message)m);
                    }
                    jaxrsHeaders = MicroProfileClientProxyImpl.getJaxrsHeaders(m);
                } else {
                    jaxrsHeaders = new MultivaluedMap<String, String>();
                }
                MultivaluedMap updatedHeaders = factory.update((MultivaluedMap)jaxrsHeaders, existingHeaders);
                existingHeaders.putAll((Map)updatedHeaders);
            }
            catch (Throwable t) {
                if (!LOG.isLoggable(Level.FINEST)) break block7;
                LOG.log(Level.FINEST, "Caught exception getting JAX-RS incoming headers", t);
            }
        }
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.microprofile.client.proxy.MicroProfileClientProxyImpl", "mergeHeaders");
        }
    }

    @Trivial
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public Object invoke(Object o, Method m, Object[] params) throws Throwable {
        this.checkClosed();
        this.objectInstance = o;
        return this.interceptorWrapper.invoke(o, m, params, new Invoker(o, m, params, this));
    }

    @Trivial
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private Object invokeActual(Object o, Method m, Object[] params) throws Throwable {
        return super.invoke(o, m, params);
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private void throwException(Throwable t) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.microprofile.client.proxy.MicroProfileClientProxyImpl", "throwException", new Object[]{t});
        }
        if (t instanceof Error) {
            throw (Error)t;
        }
        if (t instanceof RuntimeException) {
            throw (RuntimeException)t;
        }
        throw new RuntimeException(t);
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private static MultivaluedMap<String, String> getJaxrsHeaders(Message m) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.microprofile.client.proxy.MicroProfileClientProxyImpl", "getJaxrsHeaders", new Object[]{m});
        }
        MultivaluedHashMap headers = new MultivaluedHashMap();
        if (m != null) {
            headers.putAll(CastUtils.cast((Map)((Map)m.get((Object)Message.PROTOCOL_HEADERS))));
        }
        MultivaluedHashMap multivaluedHashMap = headers;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            multivaluedHashMap = multivaluedHashMap;
            LOG.exiting("org.apache.cxf.microprofile.client.proxy.MicroProfileClientProxyImpl", "getJaxrsHeaders", multivaluedHashMap);
        }
        return multivaluedHashMap;
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    private static class Invoker
    implements Callable<Object> {
        private final Object targetObject;
        private final Method method;
        private final Object[] params;
        private final MicroProfileClientProxyImpl proxy;
        static final long serialVersionUID = 2204233936299670173L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        @Trivial
        Invoker(Object o, Method m, Object[] params, MicroProfileClientProxyImpl proxy) {
            this.targetObject = o;
            this.method = m;
            this.params = params;
            this.proxy = proxy;
        }

        @Override
        @Trivial
        @FFDCIgnore(value={Throwable.class})
        public Object call() throws Exception {
            try {
                return this.proxy.invokeActual(this.targetObject, this.method, this.params);
            }
            catch (Throwable t) {
                if (t instanceof Exception) {
                    throw (Exception)t;
                }
                throw new RuntimeException(t);
            }
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"org.apache.cxf.microprofile.client.proxy.MicroProfileClientProxyImpl$Invoker", Invoker.class, null, null);
        }
    }
}

