/*
 * Decompiled with CFR 0.152.
 */
package org.apache.yoko.orb.CosNaming;

import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.omg.CORBA.BAD_PARAM;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.ORB;
import org.omg.CORBA.Object;
import org.omg.CORBA.SystemException;
import org.omg.CosNaming.BindingIteratorHolder;
import org.omg.CosNaming.BindingListHolder;
import org.omg.CosNaming.BindingType;
import org.omg.CosNaming.BindingTypeHolder;
import org.omg.CosNaming.NameComponent;
import org.omg.CosNaming.NamingContext;
import org.omg.CosNaming.NamingContextExtPOA;
import org.omg.CosNaming.NamingContextExtPackage.InvalidAddress;
import org.omg.CosNaming.NamingContextHelper;
import org.omg.CosNaming.NamingContextPackage.AlreadyBound;
import org.omg.CosNaming.NamingContextPackage.CannotProceed;
import org.omg.CosNaming.NamingContextPackage.InvalidName;
import org.omg.CosNaming.NamingContextPackage.NotEmpty;
import org.omg.CosNaming.NamingContextPackage.NotFound;
import org.omg.CosNaming.NamingContextPackage.NotFoundReason;
import org.omg.PortableServer.POA;

public abstract class NamingContextBase
extends NamingContextExtPOA {
    protected static final Logger logger = Logger.getLogger(NamingContext.class.getName());
    protected final String nonEscaped = ";/?:@&=+$;-_.!~* ()";
    protected ORB orb;
    protected POA poa;

    public NamingContextBase(ORB orb, POA poa) throws Exception {
        this.orb = orb;
        this.poa = poa;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void bind(NameComponent[] n, Object obj) throws NotFound, CannotProceed, InvalidName, AlreadyBound {
        this.validateName(n);
        this.logNameComponent("bind() name", n);
        if (n.length > 1) {
            NamingContext context = this.resolveContext(n[0]);
            NameComponent[] subName = this.extractSubName(n);
            context.bind(subName, obj);
        } else {
            NameComponent name = n[0];
            NamingContextBase namingContextBase = this;
            synchronized (namingContextBase) {
                BindingTypeHolder type = new BindingTypeHolder();
                if (this.resolveObject(name, type) != null) {
                    throw new AlreadyBound();
                }
                type.value = BindingType.nobject;
                this.bindObject(name, obj, type);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rebind(NameComponent[] n, Object obj) throws NotFound, CannotProceed, InvalidName {
        this.validateName(n);
        this.logNameComponent("rebind() name", n);
        if (n.length > 1) {
            NamingContext context = this.resolveContext(n[0]);
            NameComponent[] subName = this.extractSubName(n);
            context.rebind(subName, obj);
        } else {
            NameComponent name = n[0];
            NamingContextBase namingContextBase = this;
            synchronized (namingContextBase) {
                BindingTypeHolder type = new BindingTypeHolder();
                if (this.resolveObject(name, type) != null) {
                    if (type.value.value() == 1) {
                        throw new NotFound(NotFoundReason.not_object, n);
                    }
                    this.unbindObject(name);
                }
                type.value = BindingType.nobject;
                this.bindObject(name, obj, type);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void bind_context(NameComponent[] n, NamingContext nc) throws NotFound, CannotProceed, InvalidName, AlreadyBound {
        this.validateName(n);
        this.logNameComponent("bind_context() name", n);
        if (n.length > 1) {
            NamingContext context = this.resolveContext(n[0]);
            NameComponent[] subName = this.extractSubName(n);
            context.bind_context(subName, nc);
        } else {
            NameComponent name = n[0];
            NamingContextBase namingContextBase = this;
            synchronized (namingContextBase) {
                BindingTypeHolder type = new BindingTypeHolder();
                if (this.resolveObject(name, type) != null) {
                    throw new AlreadyBound();
                }
                type.value = BindingType.ncontext;
                this.bindObject(name, (Object)nc, type);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rebind_context(NameComponent[] n, NamingContext nc) throws NotFound, CannotProceed, InvalidName {
        this.validateName(n);
        this.logNameComponent("rebind_context() name", n);
        if (n.length > 1) {
            NamingContext context = this.resolveContext(n[0]);
            NameComponent[] subName = this.extractSubName(n);
            context.rebind_context(subName, nc);
        } else {
            NameComponent name = n[0];
            NamingContextBase namingContextBase = this;
            synchronized (namingContextBase) {
                BindingTypeHolder type = new BindingTypeHolder();
                if (this.resolveObject(name, type) != null) {
                    if (type.value.value() != 1) {
                        throw new NotFound(NotFoundReason.not_context, n);
                    }
                    this.unbindObject(name);
                }
                type.value = BindingType.ncontext;
                this.bindObject(name, (Object)nc, type);
            }
        }
    }

    public Object resolve(NameComponent[] n) throws NotFound, CannotProceed, InvalidName {
        this.validateName(n);
        this.logNameComponent("resolve() name", n);
        if (n.length > 1) {
            NamingContext context = this.resolveContext(n[0]);
            NameComponent[] subName = this.extractSubName(n);
            return context.resolve(subName);
        }
        NameComponent name = n[0];
        BindingTypeHolder type = new BindingTypeHolder();
        Object obj = this.resolveObject(name, type);
        if (obj == null) {
            throw new NotFound(NotFoundReason.missing_node, n);
        }
        return obj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unbind(NameComponent[] n) throws NotFound, CannotProceed, InvalidName {
        this.validateName(n);
        this.logNameComponent("unbind() name", n);
        if (n.length > 1) {
            NamingContext context = this.resolveContext(n[0]);
            NameComponent[] subName = this.extractSubName(n);
            context.unbind(subName);
        } else {
            NameComponent name = n[0];
            NamingContextBase namingContextBase = this;
            synchronized (namingContextBase) {
                BindingTypeHolder type = new BindingTypeHolder();
                Object obj = this.unbindObject(name);
                if (obj == null) {
                    throw new NotFound(NotFoundReason.missing_node, n);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized NamingContext bind_new_context(NameComponent[] n) throws NotFound, AlreadyBound, CannotProceed, InvalidName {
        this.logNameComponent("bind_new_context() name", n);
        NamingContext context = this.new_context();
        try {
            this.bind_context(n, context);
            NamingContext returnContext = context;
            context = null;
            NamingContext namingContext = returnContext;
            return namingContext;
        }
        finally {
            if (context != null) {
                try {
                    context.destroy();
                }
                catch (NotEmpty notEmpty) {}
            }
        }
    }

    public String to_string(NameComponent[] n) throws InvalidName {
        this.validateName(n);
        this.logNameComponent("to_string() name", n);
        StringBuffer value = new StringBuffer();
        this.nameToString(n[0], value);
        for (int i = 1; i < n.length; ++i) {
            value.append('/');
            this.nameToString(n[i], value);
        }
        return value.toString();
    }

    public NameComponent[] to_name(String sn) throws InvalidName {
        if (sn == null || sn.length() == 0) {
            throw new InvalidName();
        }
        ArrayList<NameComponent> components = new ArrayList<NameComponent>();
        StringBuffer component = new StringBuffer();
        int index = 0;
        String id = null;
        String kind = null;
        while (index < sn.length()) {
            char ch;
            if ((ch = sn.charAt(index++)) == '\\') {
                if (index >= sn.length()) {
                    throw new InvalidName();
                }
                ch = sn.charAt(index++);
                component.append(ch);
                continue;
            }
            if (ch == '.') {
                if (id != null) {
                    throw new InvalidName();
                }
                id = component.toString();
                component.setLength(0);
                continue;
            }
            if (ch == '/') {
                if (id == null) {
                    id = component.toString();
                    kind = "";
                } else {
                    kind = component.toString();
                }
                components.add(new NameComponent(id, kind));
                component.setLength(0);
                id = null;
                kind = null;
                continue;
            }
            component.append(ch);
        }
        if (id == null) {
            id = component.toString();
            kind = "";
        } else {
            kind = component.toString();
        }
        components.add(new NameComponent(id, kind));
        return components.toArray(new NameComponent[components.size()]);
    }

    public String to_url(String addr, String sn) throws InvalidAddress, InvalidName {
        if (addr == null || addr.length() == 0) {
            throw new InvalidAddress();
        }
        if (sn == null || sn.length() == 0) {
            throw new InvalidName();
        }
        return "corbaname:" + addr + "#" + this.encodeRFC2396Name(sn);
    }

    public Object resolve_str(String n) throws NotFound, CannotProceed, InvalidName {
        return this.resolve(this.to_name(n));
    }

    public abstract NamingContext new_context() throws SystemException;

    public abstract void destroy() throws NotEmpty;

    public abstract void list(int var1, BindingListHolder var2, BindingIteratorHolder var3) throws SystemException;

    protected abstract Object resolveObject(NameComponent var1, BindingTypeHolder var2) throws SystemException;

    protected abstract void bindObject(NameComponent var1, Object var2, BindingTypeHolder var3) throws SystemException;

    protected abstract Object unbindObject(NameComponent var1) throws SystemException;

    protected synchronized NamingContext resolveContext(NameComponent name) throws NotFound {
        BindingTypeHolder type = new BindingTypeHolder();
        Object resolvedReference = this.resolveObject(name, type);
        if (resolvedReference == null) {
            throw new NotFound(NotFoundReason.missing_node, new NameComponent[]{name});
        }
        if (type.value.value() != 1) {
            throw new NotFound(NotFoundReason.not_context, new NameComponent[]{name});
        }
        try {
            return NamingContextHelper.narrow((Object)resolvedReference);
        }
        catch (BAD_PARAM ex) {
            throw new NotFound(NotFoundReason.not_context, new NameComponent[]{name});
        }
    }

    protected NameComponent[] extractSubName(NameComponent[] name) {
        NameComponent[] subName = new NameComponent[name.length - 1];
        System.arraycopy(name, 1, subName, 0, name.length - 1);
        return subName;
    }

    protected void validateName(NameComponent[] n) throws InvalidName {
        if (n == null) {
            throw new BAD_PARAM(1330446363, CompletionStatus.COMPLETED_NO);
        }
        if (n.length < 1) {
            throw new InvalidName();
        }
        NameComponent name = n[0];
        if (name.id.length() == 0 && name.kind.length() == 0) {
            throw new InvalidName();
        }
    }

    protected void nameToString(NameComponent name, StringBuffer out) {
        if (name.id == null || name.id.length() == 0) {
            out.append(".");
            if (name.kind != null && name.kind.length() != 0) {
                this.escapeName(name.kind, out);
            }
        } else {
            this.escapeName(name.id, out);
            if (name.kind != null && name.kind.length() != 0) {
                out.append(".");
                this.escapeName(name.kind, out);
            }
        }
    }

    protected void escapeName(String name, StringBuffer out) {
        if (name.indexOf(46) == -1 && name.indexOf(47) == -1) {
            out.append(name);
        } else {
            for (int i = 0; i < name.length(); ++i) {
                char ch = name.charAt(i);
                if (ch == '.' || ch == '/') {
                    out.append('/');
                }
                out.append(ch);
            }
        }
    }

    protected String encodeRFC2396Name(String name) {
        StringBuffer value = new StringBuffer();
        for (int i = 0; i < name.length(); ++i) {
            char ch = name.charAt(i);
            if (Character.isLetterOrDigit(ch) || ";/?:@&=+$;-_.!~* ()".indexOf(ch) != -1) {
                value.append(ch);
                continue;
            }
            value.append('%');
            value.append(Integer.toHexString(ch));
        }
        return value.toString();
    }

    protected boolean isDebugEnabled() {
        return logger.isLoggable(Level.FINE);
    }

    protected void debug(String message) {
        logger.fine(message);
    }

    protected void logNameComponent(String message, NameComponent[] n) {
        if (this.isDebugEnabled()) {
            this.debug(message);
            for (int i = 0; i < n.length; ++i) {
                this.debug("   NameComponent " + i + " id=" + n[i].id + " kind=" + n[i].kind);
            }
        }
    }
}

