/*
 * Decompiled with CFR 0.152.
 */
package org.apache.yoko.orb.DynamicAny;

import java.util.HashMap;
import java.util.Map;
import org.apache.yoko.orb.CORBA.InputStream;
import org.apache.yoko.orb.DynamicAny.DynAnyFactory_impl;
import org.apache.yoko.orb.DynamicAny.DynAny_impl;
import org.apache.yoko.orb.OB.Assert;
import org.apache.yoko.orb.OB.MinorCodes;
import org.apache.yoko.orb.OB.ORBInstance;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.MARSHAL;
import org.omg.CORBA.TypeCode;
import org.omg.DynamicAny.DynAny;
import org.omg.DynamicAny.DynAnyFactory;
import org.omg.DynamicAny.DynAnyFactoryPackage.InconsistentTypeCode;

public final class DynValueReader {
    private final DynAnyFactory factory_;
    private final Map<Integer, DynAny> instanceTable_;
    public boolean mustTruncate;

    public DynValueReader(ORBInstance orbInstance, DynAnyFactory factory, boolean truncateOK) {
        this.factory_ = factory;
        this.mustTruncate = false;
        this.instanceTable_ = new HashMap<Integer, DynAny>(131);
    }

    public DynAny readValue(InputStream in, TypeCode tc) throws InconsistentTypeCode {
        DynAny result = this.getValue(in, tc);
        if (result != null) {
            return result;
        }
        int tag = in.read_long();
        int save = in.getPosition() - 4;
        try {
            if (tag == -1) {
                return this.readIndirection(in);
            }
        }
        catch (MARSHAL ex) {
            throw Assert.fail(ex);
        }
        DynAnyFactory_impl factory_impl = (DynAnyFactory_impl)this.factory_;
        result = factory_impl.prepare_dyn_any_from_type_code(tc, this);
        if (tag != 0) {
            this.indexValue(save, result);
        }
        in.setPosition(save);
        DynAny_impl impl = (DynAny_impl)result;
        impl._OB_unmarshal(in);
        return result;
    }

    protected void indexValue(int startPos, DynAny dv) {
        this.instanceTable_.put(startPos, dv);
    }

    private DynAny readIndirection(InputStream in) throws MARSHAL {
        int offs = in.read_long();
        int startPos = in.getPosition() - 4 + offs;
        DynAny result = this.instanceTable_.get(startPos);
        if (result == null) {
            throw new MARSHAL(MinorCodes.describeMarshal(1095974954), 1095974954, CompletionStatus.COMPLETED_NO);
        }
        return result;
    }

    private DynAny getValue(InputStream in, TypeCode tc) {
        int startPos = in.getPosition();
        DynAny orig = this.instanceTable_.get(startPos);
        if (orig == null) {
            return null;
        }
        DynAnyFactory_impl factory_impl = (DynAnyFactory_impl)this.factory_;
        DynAny copy = null;
        try {
            copy = factory_impl.prepare_dyn_any_from_type_code(tc, this);
        }
        catch (InconsistentTypeCode ex) {
            throw Assert.fail(ex);
        }
        DynAny_impl impl = (DynAny_impl)copy;
        impl._OB_unmarshal(in);
        return orig;
    }
}

