/*
 * Decompiled with CFR 0.152.
 */
package org.apache.yoko.orb.OB;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Map;
import java.util.Properties;
import org.apache.yoko.orb.CORBA.InputStream;
import org.apache.yoko.orb.CORBA.ORB;
import org.apache.yoko.orb.OB.Assert;
import org.apache.yoko.orb.OB.IORUtil;
import org.apache.yoko.orb.OB.Version;
import org.apache.yoko.orb.OCI.ConFactory;
import org.apache.yoko.orb.OCI.ConFactoryRegistry;
import org.apache.yoko.orb.OCI.ConFactoryRegistryHelper;
import org.apache.yoko.util.HexConverter;
import org.omg.CORBA.BAD_PARAM;
import org.omg.CORBA.ORBPackage.InvalidName;
import org.omg.CORBA.Object;
import org.omg.CORBA.UserException;
import org.omg.IOP.IOR;
import org.omg.IOP.IORHelper;
import org.omg.IOP.TaggedComponent;
import org.omg.IOP.TaggedComponentHelper;

public class IORDump {
    public static String PrintObjref(org.omg.CORBA.ORB orb, IOR ior) {
        StringBuilder sb = new StringBuilder();
        IORDump.PrintObjref(orb, sb, ior);
        return sb.toString();
    }

    public static void PrintObjref(org.omg.CORBA.ORB orb, StringBuilder sb, IOR ior) {
        sb.append("type_id: ").append(ior.type_id).append('\n');
        ConFactoryRegistry conFactoryRegistry = null;
        try {
            Object obj = orb.resolve_initial_references("OCIConFactoryRegistry");
            conFactoryRegistry = ConFactoryRegistryHelper.narrow(obj);
        }
        catch (InvalidName ex) {
            throw Assert.fail(ex);
        }
        ConFactory[] factories = conFactoryRegistry.get_factories();
        for (int i = 0; i < ior.profiles.length; ++i) {
            int j;
            sb.append("Profile #" + (i + 1) + ": ");
            if (ior.profiles[i].tag == 1) {
                sb.append("multiple components");
                InputStream in = new InputStream(ior.profiles[i].profile_data);
                in._OB_readEndian();
                int cnt = in.read_ulong();
                if (cnt == 0) {
                    sb.append('\n');
                    continue;
                }
                for (int j2 = 0; j2 < cnt; ++j2) {
                    TaggedComponent comp = TaggedComponentHelper.read((org.omg.CORBA.portable.InputStream)in);
                    IORUtil.describe_component(comp, sb);
                }
                continue;
            }
            for (j = 0; j < factories.length; ++j) {
                if (factories[j].tag() != ior.profiles[i].tag) continue;
                sb.append(factories[j].id()).append('\n');
                String desc = factories[j].describe_profile(ior.profiles[i]);
                sb.append(desc);
                break;
            }
            if (j < factories.length) continue;
            sb.append("unknown profile tag ").append(ior.profiles[i].tag).append('\n');
            sb.append("profile_data: (").append(ior.profiles[i].profile_data.length).append(")\n");
            IORUtil.dump_octets(ior.profiles[i].profile_data, sb);
        }
    }

    public static void DumpIOR(org.omg.CORBA.ORB orb, String ref, boolean hasEndian) {
        StringBuilder sb = new StringBuilder();
        IORDump.DumpIOR(orb, ref, hasEndian, sb);
        PrintWriter pw = new PrintWriter(System.out);
        pw.write(sb.toString());
        pw.flush();
    }

    public static String DumpIORToString(org.omg.CORBA.ORB orb, String ref, boolean hasEndian) {
        StringBuilder sb = new StringBuilder();
        IORDump.DumpIOR(orb, ref, hasEndian, sb);
        return sb.toString();
    }

    public static void DumpIOR(org.omg.CORBA.ORB orb, String ref, boolean hasEndian, StringBuilder sb) {
        if (!ref.startsWith("IOR:")) {
            sb.append("IOR is invalid\n");
            return;
        }
        byte[] data = HexConverter.asciiToOctets((String)ref, (int)4);
        InputStream in = new InputStream(data);
        boolean endian = in.read_boolean();
        in._OB_swap(endian);
        IOR ior = IORHelper.read((org.omg.CORBA.portable.InputStream)in);
        sb.append("byteorder: ");
        if (hasEndian) {
            sb.append((endian ? "little" : "big") + " endian\n");
        } else {
            sb.append("n/a\n");
        }
        IORDump.PrintObjref(orb, sb, ior);
    }

    static void usage() {
        System.err.println("Usage:");
        System.err.println("org.apache.yoko.orb.OB.IORDump [options] [-f FILE ... | IOR ...]\n\nOptions:\n-h, --help          Show this message.\n-v, --version       Show Yoko version.\n-f                  Read IORs from files instead of from the\n                    command line.");
    }

    public static int run(org.omg.CORBA.ORB orb, String[] args) throws UserException {
        int i;
        boolean files = false;
        for (i = 0; i < args.length && args[i].charAt(0) == '-'; ++i) {
            if (args[i].equals("--help") || args[i].equals("-h")) {
                IORDump.usage();
                return 0;
            }
            if (args[i].equals("--version") || args[i].equals("-v")) {
                System.out.println("Yoko " + Version.getVersion());
                return 0;
            }
            if (!args[i].equals("-f")) {
                System.err.println("IORDump: unknown option `" + args[i] + "'");
                IORDump.usage();
                return 1;
            }
            files = true;
        }
        if (i == args.length) {
            System.err.println("IORDump: no IORs");
            System.err.println();
            IORDump.usage();
            return 1;
        }
        if (!(files || args[i].startsWith("IOR:") || args[i].startsWith("corbaloc:") || args[i].startsWith("corbaname:") || args[i].startsWith("file:") || args[i].startsWith("relfile:"))) {
            System.err.println("[No valid IOR found on the command line, assuming -f]");
            files = true;
        }
        if (!files) {
            int count = 0;
            while (i < args.length) {
                if (count > 0) {
                    System.out.println();
                }
                System.out.println("IOR #" + ++count + ':');
                try {
                    if (args[i].startsWith("IOR:")) {
                        IORDump.DumpIOR(orb, args[i], true);
                    } else {
                        Object obj = orb.string_to_object(args[i]);
                        String s = orb.object_to_string(obj);
                        IORDump.DumpIOR(orb, s, false);
                    }
                }
                catch (BAD_PARAM ex) {
                    System.err.println("IOR is invalid");
                }
                ++i;
            }
        } else {
            int count = 0;
            while (i < args.length) {
                try {
                    String line;
                    FileReader fin = new FileReader(args[i]);
                    BufferedReader in = new BufferedReader(fin);
                    while ((line = in.readLine()) != null) {
                        if (line.length() <= 0) continue;
                        if (count > 0) {
                            System.out.println();
                        }
                        System.out.println("IOR #" + ++count + ':');
                        if (line.startsWith("IOR:")) {
                            IORDump.DumpIOR(orb, line, true);
                            continue;
                        }
                        Object obj = orb.string_to_object(line);
                        String s = orb.object_to_string(obj);
                        IORDump.DumpIOR(orb, s, false);
                    }
                }
                catch (FileNotFoundException ex) {
                    System.err.println("IORDump: can't open `" + args[i] + "': " + ex);
                    return 1;
                }
                catch (IOException ex) {
                    System.err.println("IORDump: can't read `" + args[i] + "': " + ex);
                    return 1;
                }
                ++i;
            }
        }
        return 0;
    }

    public static void main(String[] args) {
        int status;
        Properties props = new Properties();
        props.putAll((Map<?, ?>)System.getProperties());
        props.put("org.omg.CORBA.ORBClass", "org.apache.yoko.orb.CORBA.ORB");
        props.put("org.omg.CORBA.ORBSingletonClass", "org.apache.yoko.orb.CORBA.ORBSingleton");
        org.omg.CORBA.ORB orb = null;
        try {
            args = ORB.ParseArgs(args, props, null);
            orb = org.omg.CORBA.ORB.init((String[])args, (Properties)props);
            status = IORDump.run(orb, args);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            status = 1;
        }
        if (orb != null) {
            try {
                orb.destroy();
            }
            catch (Exception ex) {
                ex.printStackTrace();
                status = 1;
            }
        }
        System.exit(status);
    }
}

