/*
 * Decompiled with CFR 0.152.
 */
package org.apache.yoko.orb.OBPortableServer;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import org.apache.yoko.orb.IMR.ActiveState;
import org.apache.yoko.orb.IMR.Domain;
import org.apache.yoko.orb.IMR.DomainHelper;
import org.apache.yoko.orb.IMR.NoSuchOAD;
import org.apache.yoko.orb.IMR.NoSuchServer;
import org.apache.yoko.orb.IMR.OADNotRunning;
import org.apache.yoko.orb.IMR.ServerStatus;
import org.apache.yoko.orb.OAD.AlreadyLinked;
import org.apache.yoko.orb.OAD.ProcessEndpoint;
import org.apache.yoko.orb.OAD.ProcessEndpointManagerHolder;
import org.apache.yoko.orb.OAD.ProcessEndpoint_impl;
import org.apache.yoko.orb.OB.Assert;
import org.apache.yoko.orb.OB.InitialServiceManager;
import org.apache.yoko.orb.OB.LocationForward;
import org.apache.yoko.orb.OB.Logger;
import org.apache.yoko.orb.OB.ORBControl;
import org.apache.yoko.orb.OB.ORBInstance;
import org.apache.yoko.orb.OB.PIManager;
import org.apache.yoko.orb.OB.ParseParams;
import org.apache.yoko.orb.OB.RefCountPolicyList;
import org.apache.yoko.orb.OBPortableServer.AcceptorConfig;
import org.apache.yoko.orb.OBPortableServer.CommunicationsConcurrencyPolicy;
import org.apache.yoko.orb.OBPortableServer.CommunicationsConcurrencyPolicy_impl;
import org.apache.yoko.orb.OBPortableServer.DirectServant;
import org.apache.yoko.orb.OBPortableServer.EndpointConfigurationPolicy;
import org.apache.yoko.orb.OBPortableServer.EndpointConfigurationPolicyHelper;
import org.apache.yoko.orb.OBPortableServer.EndpointConfigurationPolicyOperations;
import org.apache.yoko.orb.OBPortableServer.EndpointConfigurationPolicy_impl;
import org.apache.yoko.orb.OBPortableServer.GIOPVersionPolicy;
import org.apache.yoko.orb.OBPortableServer.GIOPVersionPolicy_impl;
import org.apache.yoko.orb.OBPortableServer.POALocator;
import org.apache.yoko.orb.OBPortableServer.POAManager;
import org.apache.yoko.orb.OBPortableServer.POAManagerFactory;
import org.apache.yoko.orb.OBPortableServer.POAManager_impl;
import org.apache.yoko.orb.OBPortableServer.POA_impl;
import org.apache.yoko.orb.OCI.AccFactory;
import org.apache.yoko.orb.OCI.AccFactoryRegistry;
import org.apache.yoko.orb.OCI.Acceptor;
import org.apache.yoko.orb.OCI.InvalidParam;
import org.apache.yoko.orb.OCI.NoSuchFactory;
import org.apache.yoko.orb.OCI.ProfileInfo;
import org.apache.yoko.orb.PortableInterceptor.IMRIORInterceptor_impl;
import org.omg.CORBA.BAD_PARAM;
import org.omg.CORBA.INITIALIZE;
import org.omg.CORBA.LocalObject;
import org.omg.CORBA.OBJECT_NOT_EXIST;
import org.omg.CORBA.ORBPackage.InvalidName;
import org.omg.CORBA.Object;
import org.omg.CORBA.Policy;
import org.omg.CORBA.PolicyError;
import org.omg.CORBA.SystemException;
import org.omg.IOP.IOR;
import org.omg.PortableInterceptor.IORInterceptor;
import org.omg.PortableInterceptor.ORBInitInfoPackage.DuplicateName;
import org.omg.PortableInterceptor.ObjectReferenceTemplate;
import org.omg.PortableServer.POAManagerFactoryPackage.ManagerAlreadyExists;
import org.omg.PortableServer.POAManagerPackage.AdapterInactive;
import org.omg.PortableServer.POAManagerPackage.State;

public final class POAManagerFactory_impl
extends LocalObject
implements POAManagerFactory {
    private ORBInstance orbInstance_;
    private Hashtable managers_ = new Hashtable(7);
    private int count_ = 0;
    private ActiveState activeState_;
    private POALocator poaLocator_ = new POALocator();
    private ProcessEndpoint_impl processEndpoint_;
    private Object endpointManager_;

    private String getUniqueName() {
        long now = System.currentTimeMillis();
        String name = "POAManager-" + now;
        Assert.ensure(!this.managers_.containsKey(name = name + this.count_++));
        return name;
    }

    private void validateName(String name) throws ManagerAlreadyExists {
        POAManager manager = (POAManager)this.managers_.get(name);
        if (manager != null) {
            if (manager.get_state() == State.INACTIVE) {
                this.managers_.remove(name);
            } else {
                throw new ManagerAlreadyExists();
            }
        }
    }

    private AcceptorConfig[] parseEndpointString(String endpoint) {
        Logger logger = this.orbInstance_.getLogger();
        Vector<AcceptorConfig> configVec = new Vector<AcceptorConfig>();
        AccFactoryRegistry registry = this.orbInstance_.getAccFactoryRegistry();
        AccFactory[] factories = registry.get_factories();
        int pos = 0;
        while (pos != -1) {
            Vector params = new Vector();
            pos = ParseParams.parse(endpoint, pos, params);
            if (params.isEmpty()) continue;
            String prot = (String)params.firstElement();
            params.removeElementAt(0);
            boolean found = false;
            for (int i = 0; i < factories.length; ++i) {
                if (!prot.equals(factories[i].id())) continue;
                java.lang.Object[] paramSeq = new String[params.size()];
                params.copyInto(paramSeq);
                AcceptorConfig config = new AcceptorConfig(prot, (String[])paramSeq);
                configVec.addElement(config);
                found = true;
                break;
            }
            if (found) continue;
            String err = "unknown endpoint protocol `" + prot + "'";
            logger.error(err);
            throw new INITIALIZE(err);
        }
        if (configVec.size() == 0) {
            String err = "no endpoints defined";
            logger.error(err);
            throw new INITIALIZE(err);
        }
        java.lang.Object[] configArr = new AcceptorConfig[configVec.size()];
        configVec.copyInto(configArr);
        return configArr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public org.omg.PortableServer.POAManager create_POAManager(String id, Policy[] policies) throws ManagerAlreadyExists, PolicyError {
        Hashtable hashtable = this.managers_;
        synchronized (hashtable) {
            AcceptorConfig[] config;
            if (id.length() == 0) {
                id = this.getUniqueName();
            } else {
                this.validateName(id);
                ++this.count_;
            }
            Properties props = this.orbInstance_.getProperties();
            Logger logger = this.orbInstance_.getLogger();
            EndpointConfigurationPolicyOperations endpointPolicy = null;
            Vector<Policy> tmpPolicyVector = new Vector<Policy>();
            int nTmpPolicies = 0;
            int nPolicies = policies.length;
            if (nPolicies != 0) {
                for (int i = 0; i < nPolicies; ++i) {
                    int policyType = policies[i].policy_type();
                    if (policyType == 1330577669) {
                        endpointPolicy = EndpointConfigurationPolicyHelper.narrow((Object)policies[i]);
                        continue;
                    }
                    ++nTmpPolicies;
                    tmpPolicyVector.addElement(policies[i]);
                }
            }
            java.lang.Object[] tmpPolicies = new Policy[tmpPolicyVector.size()];
            tmpPolicyVector.copyInto(tmpPolicies);
            if (endpointPolicy == null) {
                String propName;
                String rootStr = null;
                String paramStr = null;
                if (id.equals("RootPOAManager")) {
                    rootStr = props.getProperty("yoko.orb.oa.endpoint");
                }
                if ((paramStr = props.getProperty(propName = "yoko.orb.poamanager." + id + ".endpoint")) == null && rootStr == null) {
                    paramStr = "iiop";
                } else if (paramStr == null) {
                    paramStr = rootStr;
                }
                config = this.parseEndpointString(paramStr);
            } else {
                config = endpointPolicy.value();
            }
            AccFactoryRegistry registry = this.orbInstance_.getAccFactoryRegistry();
            Vector<Acceptor> acceptors = new Vector<Acceptor>();
            int nConfig = config.length;
            for (int i = 0; i < nConfig; ++i) {
                try {
                    AccFactory factory = registry.get_factory(config[i].id);
                    acceptors.addElement(factory.create_acceptor(config[i].params));
                    continue;
                }
                catch (NoSuchFactory ex) {
                    String err = "cannot find factory: " + (java.lang.Object)((java.lang.Object)ex);
                    logger.error(err, (Throwable)((java.lang.Object)ex));
                    throw (INITIALIZE)new INITIALIZE(err).initCause((Throwable)((java.lang.Object)ex));
                }
                catch (InvalidParam ex) {
                    String err = "unable to create acceptor: " + ex.reason;
                    logger.error(err, (Throwable)((java.lang.Object)ex));
                    throw (INITIALIZE)new INITIALIZE(err).initCause((Throwable)((java.lang.Object)ex));
                }
            }
            java.lang.Object[] arr = new Acceptor[acceptors.size()];
            acceptors.copyInto(arr);
            POAManager_impl manager = new POAManager_impl(this.orbInstance_, this.poaLocator_, id, Integer.toString(this.count_), (Acceptor[])arr, (Policy[])tmpPolicies);
            this.managers_.put(id, manager);
            return manager;
        }
    }

    public org.omg.PortableServer.POAManager[] list() {
        Enumeration e = this.managers_.keys();
        Vector<POAManager> result = new Vector<POAManager>();
        while (e.hasMoreElements()) {
            String name = (String)e.nextElement();
            POAManager manager = (POAManager)this.managers_.get(name);
            if (manager == null) continue;
            result.addElement(manager);
        }
        java.lang.Object[] r = new POAManager[result.size()];
        result.copyInto(r);
        return r;
    }

    public org.omg.PortableServer.POAManager find(String id) {
        return (org.omg.PortableServer.POAManager)this.managers_.get(id);
    }

    @Override
    public void destroy() {
        this.orbInstance_ = null;
        if (!this.managers_.isEmpty()) {
            this._OB_deactivate();
        }
    }

    @Override
    public EndpointConfigurationPolicy create_endpoint_configuration_policy(String value) throws PolicyError {
        AcceptorConfig[] configArray = this.parseEndpointString(value);
        return new EndpointConfigurationPolicy_impl(configArray);
    }

    @Override
    public CommunicationsConcurrencyPolicy create_communications_concurrency_policy(short value) throws PolicyError {
        return new CommunicationsConcurrencyPolicy_impl(value);
    }

    @Override
    public GIOPVersionPolicy create_giop_version_policy(short value) throws PolicyError {
        return new GIOPVersionPolicy_impl(value);
    }

    public void _OB_deactivate() {
        Enumeration e = this.managers_.keys();
        while (e.hasMoreElements()) {
            String name = (String)e.nextElement();
            POAManager manager = (POAManager)this.managers_.get(name);
            if (manager == null) continue;
            try {
                manager.deactivate(true, true);
            }
            catch (AdapterInactive adapterInactive) {}
        }
        this.managers_.clear();
        if (this.activeState_ != null) {
            Logger logger = this.orbInstance_.getLogger();
            String serverInstance = this.orbInstance_.getServerInstance();
            try {
                this.activeState_.set_status(serverInstance, ServerStatus.STOPPING);
            }
            catch (SystemException ex) {
                String msg = this.orbInstance_.getServerId() + ": Cannot contact IMR on shutdown";
                logger.warning(msg, ex);
            }
            this.activeState_ = null;
        }
    }

    public DirectServant _OB_getDirectServant(IOR ior, RefCountPolicyList policies) throws LocationForward {
        if (this.managers_.isEmpty()) {
            return null;
        }
        Enumeration e = this.managers_.keys();
        while (e.hasMoreElements()) {
            try {
                String name = (String)e.nextElement();
                POAManager_impl manager = (POAManager_impl)this.managers_.get(name);
                if (manager == null) continue;
                Acceptor[] acceptors = manager.get_acceptors();
                for (int i = 0; i < acceptors.length; ++i) {
                    ProfileInfo[] profileInfos = acceptors[i].get_local_profiles(ior);
                    if (profileInfos.length <= 0) continue;
                    return manager._OB_getDirectServant(profileInfos[0].key, policies);
                }
            }
            catch (AdapterInactive adapterInactive) {
            }
            catch (OBJECT_NOT_EXIST oBJECT_NOT_EXIST) {
            }
        }
        return null;
    }

    public void _OB_setORBInstance(ORBInstance instance) {
        this.orbInstance_ = instance;
    }

    public void _OB_initializeIMR(POA_impl root, ORBControl orbControl) {
        String serverId = this.orbInstance_.getServerId();
        String serverInstance = this.orbInstance_.getServerInstance();
        Properties properties = this.orbInstance_.getProperties();
        String noIMR = properties.getProperty("yoko.orb.noIMR");
        if (serverId.length() == 0 || noIMR != null) {
            return;
        }
        this.processEndpoint_ = new ProcessEndpoint_impl(serverId, serverInstance, root, orbControl);
        Domain imrDomain = null;
        try {
            InitialServiceManager initServiceManager = this.orbInstance_.getInitialServiceManager();
            Object imrObj = initServiceManager.resolveInitialReferences("IMR");
            imrDomain = DomainHelper.narrow(imrObj);
        }
        catch (InvalidName initServiceManager) {
        }
        catch (BAD_PARAM initServiceManager) {
            // empty catch block
        }
        Logger logger = this.orbInstance_.getLogger();
        if (imrDomain == null) {
            String msg = serverId + ": IMRDomain not reachable";
            logger.error(msg);
            throw new INITIALIZE(msg);
        }
        String exec = properties.getProperty("yoko.orb.imr.register");
        if (exec != null) {
            String msg = serverId + ": Self registration not implemented for java servers";
            logger.error(msg);
            throw new INITIALIZE(msg);
        }
        try {
            ProcessEndpointManagerHolder endpoint = new ProcessEndpointManagerHolder();
            ObjectReferenceTemplate primary = root.adapter_template();
            this.activeState_ = imrDomain.startup(serverId, serverInstance, primary, endpoint);
            ProcessEndpoint ref = this.processEndpoint_._this(this.orbInstance_.getORB());
            endpoint.value.establish_link(serverId, serverInstance, -1, ref);
            this.endpointManager_ = endpoint.value;
            IMRIORInterceptor_impl i = new IMRIORInterceptor_impl(logger, this.activeState_, serverInstance);
            PIManager piManager = this.orbInstance_.getPIManager();
            try {
                piManager.addIORInterceptor((IORInterceptor)i, true);
            }
            catch (DuplicateName ex) {
                throw Assert.fail(ex);
            }
        }
        catch (BAD_PARAM ex) {
            String msg = serverId + ": (IMR) Server already running";
            logger.error(msg, ex);
            throw (INITIALIZE)new INITIALIZE(msg).initCause((Throwable)ex);
        }
        catch (NoSuchServer ex) {
            String msg = serverId + ": (IMR) Not registered with IMR";
            logger.error(msg, (Throwable)((java.lang.Object)ex));
            throw (INITIALIZE)new INITIALIZE(msg).initCause((Throwable)((java.lang.Object)ex));
        }
        catch (NoSuchOAD ex) {
            String msg = serverId + ": (IMR) No OAD for host";
            logger.error(msg, (Throwable)((java.lang.Object)ex));
            throw (INITIALIZE)new INITIALIZE(msg).initCause((Throwable)((java.lang.Object)ex));
        }
        catch (OADNotRunning ex) {
            String msg = serverId + ": (IMR) OAD not running";
            logger.error(msg, (Throwable)((java.lang.Object)ex));
            throw (INITIALIZE)new INITIALIZE(msg).initCause((Throwable)((java.lang.Object)ex));
        }
        catch (AlreadyLinked ex) {
            String msg = serverId + ": (IMR) Process registered with OAD";
            logger.error(msg, (Throwable)((java.lang.Object)ex));
            throw (INITIALIZE)new INITIALIZE(msg).initCause((Throwable)((java.lang.Object)ex));
        }
    }
}

