/*
 * Decompiled with CFR 0.152.
 */
package org.apache.yoko.orb.cmsf;

import org.apache.yoko.orb.CORBA.InputStream;
import org.apache.yoko.orb.CORBA.OutputStream;
import org.omg.CORBA.Any;
import org.omg.CORBA.MARSHAL;
import org.omg.CORBA.ORB;
import org.omg.IOP.ServiceContext;
import org.omg.IOP.TaggedComponent;

public enum CmsfVersion {
    CMSFv1(1),
    CMSFv2(2);

    public static final boolean ENABLED = true;
    private final byte value;
    private final TaggedComponent tc;
    private final ServiceContext sc;
    private final Any any;

    private CmsfVersion(int value) {
        this((byte)(value & 0xFF));
    }

    private CmsfVersion(byte value) {
        this.value = value;
        byte[] data = CmsfVersion.genData(value);
        this.tc = new TaggedComponent(38, (byte[])data.clone());
        this.sc = new ServiceContext(17, data);
        this.any = ORB.init().create_any();
        this.any.insert_octet(value);
    }

    byte getValue() {
        return this.value;
    }

    TaggedComponent getTc() {
        return this.tc;
    }

    ServiceContext getSc() {
        return this.sc;
    }

    Any getAny() {
        return this.any;
    }

    static CmsfVersion readAny(Any any) {
        if (any == null) {
            return CMSFv1;
        }
        return any.extract_octet() >= 2 ? CMSFv2 : CMSFv1;
    }

    static CmsfVersion readData(byte[] data) {
        if (data == null) {
            return CMSFv1;
        }
        byte cmsf = 1;
        try (InputStream in = new InputStream(data);){
            in._OB_readEndian();
            cmsf = in.read_octet();
        }
        catch (Exception e) {
            throw (MARSHAL)new MARSHAL(e.getMessage()).initCause((Throwable)e);
        }
        return cmsf >= 2 ? CMSFv2 : CMSFv1;
    }

    private static byte[] genData(byte value) {
        try (OutputStream out = new OutputStream(2);){
            out._OB_writeEndian();
            out.write_octet(value);
            byte[] byArray = out.copyWrittenBytes();
            return byArray;
        }
    }
}

