/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.saml.sso20.binding;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.saml.sso20.internal.utils.SamlUtil;
import javax.xml.namespace.QName;
import org.joda.time.DateTime;
import org.opensaml.common.SAMLObject;
import org.opensaml.common.binding.SAMLMessageContext;
import org.opensaml.saml2.metadata.Endpoint;
import org.opensaml.saml2.metadata.EntityDescriptor;
import org.opensaml.saml2.metadata.RoleDescriptor;
import org.opensaml.saml2.metadata.provider.MetadataProvider;
import org.opensaml.ws.message.handler.HandlerChainResolver;
import org.opensaml.ws.security.SecurityPolicyResolver;
import org.opensaml.ws.transport.InTransport;
import org.opensaml.ws.transport.OutTransport;
import org.opensaml.xml.XMLObject;
import org.opensaml.xml.security.credential.Credential;
import org.opensaml.xml.util.DatatypeHelper;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public abstract class DebugMessageContext<InboundMessageType extends SAMLObject, OutboundMessageType extends SAMLObject, NameIdentifierType extends SAMLObject>
implements SAMLMessageContext<InboundMessageType, OutboundMessageType, NameIdentifierType> {
    public static final TraceComponent tc = Tr.register(DebugMessageContext.class, (String)"SAML20", (String)"com.ibm.ws.security.saml.sso20.internal.resources.SamlSso20Messages");
    private byte[] artifactType;
    private NameIdentifierType subjectNameIdentifier;
    private String localEntityId;
    private EntityDescriptor localEntityMetadata;
    private QName localEntityRole;
    private RoleDescriptor localEntityRoleMetadata;
    private InboundMessageType inboundSAMLMessage;
    private boolean inboundSAMLMessageAuthenticated;
    private String inboundSAMLMessageId;
    private DateTime inboundSAMLMessageIssueInstant;
    private String inboundSAMLProtocol;
    private MetadataProvider metadataProvider;
    private OutboundMessageType outboundSAMLMessage;
    private String outboundSAMLMessageId;
    private DateTime outboundSAMLMessageIssueInstant;
    private Credential outboundSAMLMessageSigningCredential;
    private String outboundSAMLProtocol;
    private String relayState;
    private Endpoint peerEntityEndpoint;
    private String peerEntityId;
    private EntityDescriptor peerEntityMetadata;
    private QName peerEntityRole;
    private RoleDescriptor peerEntityRoleMetadata;
    private String communicationProfile;
    private XMLObject inboundMessage;
    private String inboundMessageIssuer;
    private InTransport inboundTransport;
    private XMLObject outboundMessage;
    private String outboundMessageIssuer;
    private OutTransport outboundTransport;
    private SecurityPolicyResolver securityPolicyResolver;
    private HandlerChainResolver preSecurityInboundHandlerChainResolver;
    private HandlerChainResolver postSecurityInboundHandlerChainResolver;
    private HandlerChainResolver outboundHandlerChainResolver;
    static final long serialVersionUID = 1623838169163840420L;

    public InboundMessageType getInboundSAMLMessage() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("BasicMessageContext:getInboundSAMLMessage:" + this.inboundSAMLMessage), (Object[])new Object[0]);
        }
        this.checkNullObject(this.inboundSAMLMessage);
        return this.inboundSAMLMessage;
    }

    public String getInboundSAMLMessageId() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("BasicMessageContext:getInboundSAMLMessageId:" + this.inboundSAMLMessageId), (Object[])new Object[0]);
        }
        this.checkNullObject(this.inboundSAMLMessageId);
        return this.inboundSAMLMessageId;
    }

    public DateTime getInboundSAMLMessageIssueInstant() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("BasicMessageContext:getInboundSAMLMessageIssueInstant:" + this.inboundSAMLMessageIssueInstant), (Object[])new Object[0]);
        }
        this.checkNullObject(this.inboundSAMLMessageIssueInstant);
        return this.inboundSAMLMessageIssueInstant;
    }

    public String getLocalEntityId() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("BasicMessageContext:getLocalEntityId:" + this.localEntityId), (Object[])new Object[0]);
        }
        this.checkNullObject(this.localEntityId);
        return this.localEntityId;
    }

    public EntityDescriptor getLocalEntityMetadata() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("BasicMessageContext:getLocalEntityMetadata:" + this.localEntityMetadata), (Object[])new Object[0]);
        }
        this.checkNullObject(this.localEntityMetadata);
        return this.localEntityMetadata;
    }

    public QName getLocalEntityRole() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("BasicMessageContext:getLocalEntityRole:" + this.localEntityRole), (Object[])new Object[0]);
        }
        this.checkNullObject(this.localEntityRole);
        return this.localEntityRole;
    }

    public RoleDescriptor getLocalEntityRoleMetadata() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("BasicMessageContext:getLocalEntityRoleMetada:" + this.localEntityRoleMetadata), (Object[])new Object[0]);
        }
        this.checkNullObject(this.localEntityRoleMetadata);
        return this.localEntityRoleMetadata;
    }

    public MetadataProvider getMetadataProvider() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("BasicMessageContext:getMetadaProvider:" + this.metadataProvider), (Object[])new Object[0]);
        }
        this.checkNullObject(this.metadataProvider);
        return this.metadataProvider;
    }

    public Credential getOuboundSAMLMessageSigningCredential() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("BasicMessageContext:getOuboundSAMLMessageSigningCredential:" + this.outboundSAMLMessageSigningCredential), (Object[])new Object[0]);
        }
        this.checkNullObject(this.outboundSAMLMessageSigningCredential);
        return this.outboundSAMLMessageSigningCredential;
    }

    public OutboundMessageType getOutboundSAMLMessage() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("BasicMessageContext:getOutboundSAMLMessage:" + this.outboundSAMLMessage), (Object[])new Object[0]);
        }
        this.checkNullObject(this.outboundSAMLMessage);
        return this.outboundSAMLMessage;
    }

    public String getOutboundSAMLMessageId() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("BasicMessageContext:getOutboundSAMLMessageId:" + this.outboundSAMLMessageId), (Object[])new Object[0]);
        }
        this.checkNullObject(this.outboundSAMLMessageId);
        return this.outboundSAMLMessageId;
    }

    public DateTime getOutboundSAMLMessageIssueInstant() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("BasicMessageContext:getOutboundSAMLMessageIssueInstant:" + this.outboundSAMLMessageIssueInstant), (Object[])new Object[0]);
        }
        this.checkNullObject(this.outboundSAMLMessageIssueInstant);
        return this.outboundSAMLMessageIssueInstant;
    }

    public String getOutboundSAMLProtocol() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("BasicMessageContext:getOutboundSAMLProtocol:" + this.outboundSAMLProtocol), (Object[])new Object[0]);
        }
        this.checkNullObject(this.outboundSAMLProtocol);
        return this.outboundSAMLProtocol;
    }

    public Endpoint getPeerEntityEndpoint() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("BasicMessageContext:getPeerEntityEndpoint:" + this.peerEntityEndpoint), (Object[])new Object[0]);
        }
        this.checkNullObject(this.peerEntityEndpoint);
        return this.peerEntityEndpoint;
    }

    public String getPeerEntityId() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("BasicMessageContext:getPeerEntityId:" + this.peerEntityId), (Object[])new Object[0]);
        }
        this.checkNullObject(this.peerEntityId);
        return this.peerEntityId;
    }

    public EntityDescriptor getPeerEntityMetadata() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("BasicMessageContext:getPeerEntityMetadata:" + this.peerEntityMetadata), (Object[])new Object[0]);
        }
        return this.peerEntityMetadata;
    }

    public QName getPeerEntityRole() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("BasicMessageContext:getPeerEntityRole:" + this.peerEntityRole), (Object[])new Object[0]);
        }
        return this.peerEntityRole;
    }

    public RoleDescriptor getPeerEntityRoleMetadata() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("BasicMessageContext:getPeerEntityRoleMetadata:" + this.peerEntityRoleMetadata), (Object[])new Object[0]);
        }
        this.checkNullObject(this.peerEntityRoleMetadata);
        return this.peerEntityRoleMetadata;
    }

    public String getRelayState() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("BasicMessageContext:getRelayState:" + this.relayState), (Object[])new Object[0]);
        }
        this.checkNullObject(this.relayState);
        return this.relayState;
    }

    public NameIdentifierType getSubjectNameIdentifier() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("BasicMessageContext:getSubjectNameIdentifier:" + this.subjectNameIdentifier), (Object[])new Object[0]);
        }
        this.checkNullObject(this.subjectNameIdentifier);
        return this.subjectNameIdentifier;
    }

    public boolean isInboundSAMLMessageAuthenticated() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("BasicMessageContext:isInboundSAMLMessageAuthenticatedr:" + this.inboundSAMLMessageAuthenticated), (Object[])new Object[0]);
        }
        this.checkNullObject(this.inboundSAMLMessageAuthenticated);
        return this.inboundSAMLMessageAuthenticated;
    }

    public void setInboundSAMLMessage(InboundMessageType message) {
        this.inboundSAMLMessage = message;
    }

    public void setInboundSAMLMessageAuthenticated(boolean isAuthenticated) {
        this.inboundSAMLMessageAuthenticated = isAuthenticated;
    }

    public void setInboundSAMLMessageId(String id) {
        this.inboundSAMLMessageId = DatatypeHelper.safeTrimOrNullString((String)id);
    }

    public void setInboundSAMLMessageIssueInstant(DateTime instant) {
        this.inboundSAMLMessageIssueInstant = instant;
    }

    public void setLocalEntityId(String id) {
        this.localEntityId = DatatypeHelper.safeTrimOrNullString((String)id);
    }

    public void setLocalEntityMetadata(EntityDescriptor metadata) {
        this.localEntityMetadata = metadata;
    }

    public void setLocalEntityRole(QName role) {
        this.localEntityRole = role;
    }

    public void setLocalEntityRoleMetadata(RoleDescriptor role) {
        this.localEntityRoleMetadata = role;
    }

    public void setMetadataProvider(MetadataProvider provider) {
        this.metadataProvider = provider;
    }

    public void setOutboundSAMLMessage(OutboundMessageType message) {
        this.outboundSAMLMessage = message;
    }

    public void setOutboundSAMLMessageId(String id) {
        this.outboundSAMLMessageId = DatatypeHelper.safeTrimOrNullString((String)id);
    }

    public void setOutboundSAMLMessageIssueInstant(DateTime instant) {
        this.outboundSAMLMessageIssueInstant = instant;
    }

    public void setOutboundSAMLMessageSigningCredential(Credential credential) {
        this.outboundSAMLMessageSigningCredential = credential;
    }

    public void setOutboundSAMLProtocol(String protocol) {
        this.outboundSAMLProtocol = DatatypeHelper.safeTrimOrNullString((String)protocol);
    }

    public void setPeerEntityEndpoint(Endpoint endpoint) {
        this.peerEntityEndpoint = endpoint;
    }

    public void setPeerEntityId(String id) {
        this.peerEntityId = DatatypeHelper.safeTrimOrNullString((String)id);
    }

    public void setPeerEntityMetadata(EntityDescriptor metadata) {
        this.peerEntityMetadata = metadata;
    }

    public void setPeerEntityRoleMetadata(RoleDescriptor role) {
        this.peerEntityRoleMetadata = role;
    }

    public void setRelayState(String state) {
        this.relayState = DatatypeHelper.safeTrimOrNullString((String)state);
    }

    public void setSubjectNameIdentifier(NameIdentifierType identifier) {
        this.subjectNameIdentifier = identifier;
    }

    public byte[] getOutboundMessageArtifactType() {
        if (this.artifactType != null) {
            this.checkNullObject(this.artifactType.clone());
            return (byte[])this.artifactType.clone();
        }
        return null;
    }

    public void setOutboundMessageArtifactType(byte[] type) {
        this.artifactType = type == null ? null : (byte[])type.clone();
    }

    public boolean isIssuerAuthenticated() {
        this.checkNullObject(this.isInboundSAMLMessageAuthenticated());
        return this.isInboundSAMLMessageAuthenticated();
    }

    public String getCommunicationProfileId() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("BasicMessageContext:getCommunicationProfileId(mc):" + this.communicationProfile), (Object[])new Object[0]);
        }
        this.checkNullObject(this.communicationProfile);
        return this.communicationProfile;
    }

    public XMLObject getInboundMessage() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("BasicMessageContext:getInboundMessage(mc):" + this.inboundMessage), (Object[])new Object[0]);
        }
        this.checkNullObject(this.inboundMessage);
        return this.inboundMessage;
    }

    public String getInboundMessageIssuer() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("BasicMessageContext:getInboundMessageIssuer(mc):" + this.inboundMessageIssuer), (Object[])new Object[0]);
        }
        this.checkNullObject(this.inboundMessageIssuer);
        return this.inboundMessageIssuer;
    }

    public InTransport getInboundMessageTransport() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("BasicMessageContext:getInboundMessageTransport(mc):" + this.inboundTransport), (Object[])new Object[0]);
        }
        this.checkNullObject(this.inboundTransport);
        return this.inboundTransport;
    }

    public XMLObject getOutboundMessage() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("BasicMessageContext:getOutboundMessage(mc):" + this.outboundMessage), (Object[])new Object[0]);
        }
        this.checkNullObject(this.outboundMessage);
        return this.outboundMessage;
    }

    public String getOutboundMessageIssuer() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("BasicMessageContext:getOutboundMessageIssuer(mc):" + this.outboundMessageIssuer), (Object[])new Object[0]);
        }
        this.checkNullObject(this.outboundMessageIssuer);
        return this.outboundMessageIssuer;
    }

    public OutTransport getOutboundMessageTransport() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("BasicMessageContext:getOutboundMessageTraneport(mc):" + this.outboundTransport), (Object[])new Object[0]);
        }
        this.checkNullObject(this.outboundTransport);
        return this.outboundTransport;
    }

    public SecurityPolicyResolver getSecurityPolicyResolver() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("BasicMessageContext:getSecurityPolicyResolver(mc):" + this.securityPolicyResolver), (Object[])new Object[0]);
        }
        return this.securityPolicyResolver;
    }

    public void setCommunicationProfileId(String id) {
        this.communicationProfile = DatatypeHelper.safeTrimOrNullString((String)id);
    }

    public void setInboundMessage(XMLObject message) {
        this.inboundMessage = message;
    }

    public void setInboundMessageIssuer(String issuer) {
        this.inboundMessageIssuer = issuer;
    }

    public void setInboundMessageTransport(InTransport transport) {
        this.inboundTransport = transport;
    }

    public void setOutboundMessage(XMLObject message) {
        this.outboundMessage = message;
    }

    public void setOutboundMessageIssuer(String issuer) {
        this.outboundMessageIssuer = issuer;
    }

    public void setOutboundMessageTransport(OutTransport transport) {
        this.outboundTransport = transport;
    }

    public void setSecurityPolicyResolver(SecurityPolicyResolver resolver) {
        this.securityPolicyResolver = resolver;
    }

    public HandlerChainResolver getPreSecurityInboundHandlerChainResolver() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("BasicMessageContext:getPreSecurityInboundHandlerChainResolver(mc):" + this.preSecurityInboundHandlerChainResolver), (Object[])new Object[0]);
        }
        this.checkNullObject(this.preSecurityInboundHandlerChainResolver);
        return this.preSecurityInboundHandlerChainResolver;
    }

    public HandlerChainResolver getPostSecurityInboundHandlerChainResolver() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("BasicMessageContext:getPostSecurityInboundHandlerChainResolver(mc):" + this.postSecurityInboundHandlerChainResolver), (Object[])new Object[0]);
        }
        this.checkNullObject(this.postSecurityInboundHandlerChainResolver);
        return this.postSecurityInboundHandlerChainResolver;
    }

    public HandlerChainResolver getOutboundHandlerChainResolver() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("BasicMessageContext:getOutboundHandlerChainResolver(mc):" + this.outboundHandlerChainResolver), (Object[])new Object[0]);
        }
        this.checkNullObject(this.outboundHandlerChainResolver);
        return this.outboundHandlerChainResolver;
    }

    public void setPreSecurityInboundHandlerChainResolver(HandlerChainResolver newHandlerChainResolver) {
        this.preSecurityInboundHandlerChainResolver = newHandlerChainResolver;
    }

    public void setPostSecurityInboundHandlerChainResolver(HandlerChainResolver newHandlerChainResolver) {
        this.postSecurityInboundHandlerChainResolver = newHandlerChainResolver;
    }

    public void setOutboundHandlerChainResolver(HandlerChainResolver newHandlerChainResolver) {
        this.outboundHandlerChainResolver = newHandlerChainResolver;
    }

    @Trivial
    private void checkNullObject(Object object) {
        if (object == null && TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Exception e = new Exception("Debugging Only");
            StringBuffer sb = SamlUtil.dumpStackTrace(e, -1);
            Tr.debug((TraceComponent)tc, (String)sb.toString(), (Object[])new Object[0]);
        }
    }
}

