/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.saml.sso20.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.Sensitive;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.authentication.cache.AuthCacheService;
import com.ibm.ws.security.saml.SsoRequest;
import com.ibm.ws.security.saml.sso20.internal.AssertionToSubject;
import com.ibm.ws.security.saml.sso20.internal.utils.RequestUtil;
import com.ibm.wsspi.webcontainer.servlet.IExtendedRequest;
import javax.security.auth.Subject;
import javax.servlet.http.HttpServletRequest;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class SpCookieRetriver {
    public static final TraceComponent tc = Tr.register(SpCookieRetriver.class, (String)"SAML20", (String)"com.ibm.ws.security.saml.sso20.internal.resources.SamlSso20Messages");
    IExtendedRequest req = null;
    SsoRequest samlRequest = null;
    AuthCacheService authCacheService = null;
    String providerId = null;
    @Sensitive
    String customCacheKey = null;
    boolean cacheKeyInitialized = false;
    static final long serialVersionUID = -6207566808464145993L;

    public SpCookieRetriver(AuthCacheService authCacheService, HttpServletRequest req, SsoRequest samlRequest) {
        this.req = (IExtendedRequest)req;
        this.samlRequest = samlRequest;
        this.authCacheService = authCacheService;
        this.providerId = samlRequest.getProviderName();
    }

    public Subject getSubjectFromSpCookie() {
        Subject result = null;
        if (this.authCacheService == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"ERROR: No activated authCacheService. Of course no cached subject", (Object[])new Object[0]);
            }
            return null;
        }
        String cacheKey = this.getCustomCacheKey();
        if (cacheKey != null) {
            result = this.authCacheService.getSubject((Object)this.customCacheKey);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Get Subject:" + result), (Object[])new Object[0]);
        }
        return result;
    }

    public void removeSubject() {
        String cacheKey;
        if (this.authCacheService != null && (cacheKey = this.getCustomCacheKey()) != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"remove Subject", (Object[])new Object[0]);
            }
            this.authCacheService.remove((Object)cacheKey);
            return;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Does not remove Subject. It's probably OK.", (Object[])new Object[0]);
        }
    }

    @Sensitive
    @Trivial
    public String getCustomCacheKey() {
        if (!this.cacheKeyInitialized) {
            String spCookieName = this.samlRequest.getSpCookieName();
            byte[] cookieValueBytes = this.req.getCookieValueAsBytes(spCookieName);
            if (cookieValueBytes != null) {
                String preKey = RequestUtil.convertBytesToString(cookieValueBytes);
                this.customCacheKey = AssertionToSubject.getAfterDigestValue(this.providerId, preKey);
            }
            this.cacheKeyInitialized = true;
        }
        return this.customCacheKey;
    }
}

