/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.microprofile.reactive.messaging.kafka.adapter;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.microprofile.reactive.messaging.kafka.adapter.ConsumerRecord;
import com.ibm.ws.microprofile.reactive.messaging.kafka.adapter.KafkaAdapterException;
import com.ibm.ws.microprofile.reactive.messaging.kafka.adapter.KafkaConsumer;
import com.ibm.ws.microprofile.reactive.messaging.kafka.adapter.KafkaProducer;
import com.ibm.ws.microprofile.reactive.messaging.kafka.adapter.OffsetAndMetadata;
import com.ibm.ws.microprofile.reactive.messaging.kafka.adapter.ProducerRecord;
import com.ibm.ws.microprofile.reactive.messaging.kafka.adapter.TopicPartition;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletionStage;
import java.util.function.Supplier;
import org.eclipse.microprofile.reactive.messaging.Message;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public abstract class KafkaAdapterFactory {
    private static final TraceComponent tc = Tr.register(KafkaAdapterFactory.class, (String)"REACTIVEMESSAGE", (String)"com.ibm.ws.microprofile.reactive.messaging.kafka.resources.ReactiveMessaging");
    private static final String KAFKA_CONSUMER_IMPL = "com.ibm.ws.microprofile.reactive.messaging.kafka.adapter.impl.KafkaConsumerImpl";
    private static final Class<?>[] KAFKA_CONSUMER_ARG_TYPES = new Class[]{Map.class};
    private static final String KAFKA_PRODUCER_IMPL = "com.ibm.ws.microprofile.reactive.messaging.kafka.adapter.impl.KafkaProducerImpl";
    private static final Class<?>[] KAFKA_PRODUCER_ARG_TYPES = new Class[]{Map.class};
    private static final String TOPIC_PARTITION_IMPL = "com.ibm.ws.microprofile.reactive.messaging.kafka.adapter.impl.TopicPartitionImpl";
    private static final Class<?>[] TOPIC_PARTITION_ARG_TYPES = new Class[]{String.class, Integer.TYPE};
    private static final String OFFSET_AND_METADATA_IMPL = "com.ibm.ws.microprofile.reactive.messaging.kafka.adapter.impl.OffsetAndMetadataImpl";
    private static final Class<?>[] OFFSET_AND_METADATA_ARG_TYPES = new Class[]{Long.TYPE, Optional.class, String.class};
    private static final String COMMIT_FAILED_EXCEPTION = "org.apache.kafka.clients.consumer.CommitFailedException";
    private static final Class<?>[] COMMIT_FAILED_EXCEPTION_ARG_TYPES = new Class[0];
    private static final String INCOMING_KAFKA_MESSAGE_IMPL = "com.ibm.ws.microprofile.reactive.messaging.kafka.adapter.impl.IncomingKafkaMessage";
    private static final Class<?>[] INCOMING_KAFKA_MESSAGE_ARG_TYPES = new Class[]{ConsumerRecord.class, Supplier.class};
    private static final String PRODUCER_RECORD_IMPL = "com.ibm.ws.microprofile.reactive.messaging.kafka.adapter.impl.ProducerRecordImpl";
    private static final Class<?>[] PRODUCER_RECORD_ARG_TYPES = new Class[]{String.class, String.class, Object.class};
    private static final String KAFKA_TEST_CLASS = "org.apache.kafka.clients.producer.KafkaProducer";
    static final long serialVersionUID = 4192857018051357212L;

    protected abstract ClassLoader getClassLoader();

    public <K, V> ProducerRecord<K, V> newProducerRecord(String configuredTopic, String channelName, V value) {
        ProducerRecord producerRecord = KafkaAdapterFactory.getInstance(this.getClassLoader(), ProducerRecord.class, PRODUCER_RECORD_IMPL, PRODUCER_RECORD_ARG_TYPES, configuredTopic, channelName, value);
        return producerRecord;
    }

    public <K, V> Message<V> newIncomingKafkaMessage(ConsumerRecord<K, V> consumerRecord, Supplier<CompletionStage<Void>> ack) {
        Message incomingMessage = KafkaAdapterFactory.getInstance(this.getClassLoader(), Message.class, INCOMING_KAFKA_MESSAGE_IMPL, INCOMING_KAFKA_MESSAGE_ARG_TYPES, consumerRecord, ack);
        return incomingMessage;
    }

    public <K, V> KafkaConsumer<K, V> newKafkaConsumer(Map<String, Object> consumerConfig) {
        KafkaConsumer kafkaConsumer = KafkaAdapterFactory.getInstance(this.getClassLoader(), KafkaConsumer.class, KAFKA_CONSUMER_IMPL, KAFKA_CONSUMER_ARG_TYPES, consumerConfig);
        return kafkaConsumer;
    }

    public <K, V> KafkaProducer<K, V> newKafkaProducer(Map<String, Object> producerConfig) {
        KafkaProducer kafkaProducer = KafkaAdapterFactory.getInstance(this.getClassLoader(), KafkaProducer.class, KAFKA_PRODUCER_IMPL, KAFKA_PRODUCER_ARG_TYPES, producerConfig);
        return kafkaProducer;
    }

    public TopicPartition newTopicPartition(String topic, int partition) {
        TopicPartition topicPartition = KafkaAdapterFactory.getInstance(this.getClassLoader(), TopicPartition.class, TOPIC_PARTITION_IMPL, TOPIC_PARTITION_ARG_TYPES, topic, partition);
        return topicPartition;
    }

    public OffsetAndMetadata newOffsetAndMetadata(long commitOffset, Optional<Integer> leaderEpoch, String metadata) {
        OffsetAndMetadata offsetAndMetadata = KafkaAdapterFactory.getInstance(this.getClassLoader(), OffsetAndMetadata.class, OFFSET_AND_METADATA_IMPL, OFFSET_AND_METADATA_ARG_TYPES, commitOffset, leaderEpoch, metadata);
        return offsetAndMetadata;
    }

    public Exception newCommitFailedException() {
        Exception e = KafkaAdapterFactory.getInstance(this.getClassLoader(), Exception.class, COMMIT_FAILED_EXCEPTION, COMMIT_FAILED_EXCEPTION_ARG_TYPES, new Object[0]);
        return e;
    }

    protected void validate() throws KafkaAdapterException {
        try {
            this.getClassLoader().loadClass(KAFKA_TEST_CLASS);
        }
        catch (ClassNotFoundException classNotFoundException) {
            FFDCFilter.processException((Throwable)classNotFoundException, (String)"com.ibm.ws.microprofile.reactive.messaging.kafka.adapter.KafkaAdapterFactory", (String)"148", (Object)this, (Object[])new Object[0]);
            throw new KafkaAdapterException(Tr.formatMessage((TraceComponent)tc, (String)"kafka.library.not.present.CWMRX1006E", (Object[])new Object[0]));
        }
    }

    protected static final <T> T getInstance(ClassLoader classloader, Class<T> interfaceClass, String implClassName, Class<?>[] parameterTypes, Object ... parameters) {
        Class<T> implClass = KafkaAdapterFactory.getImplClass(classloader, interfaceClass, implClassName);
        T instance = KafkaAdapterFactory.getInstance(implClass, parameterTypes, parameters);
        return instance;
    }

    /*
     * WARNING - void declaration
     */
    protected static final <T> T getInstance(Class<T> implClass, Class<?>[] parameterTypes, Object[] parameters) {
        Constructor<T> xtor = KafkaAdapterFactory.getConstructor(implClass, parameterTypes);
        T instance = null;
        try {
            instance = xtor.newInstance(parameters);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | InvocationTargetException exception) {
            void e;
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.microprofile.reactive.messaging.kafka.adapter.KafkaAdapterFactory", (String)"166", null, (Object[])new Object[]{implClass, parameterTypes, parameters});
            throw new KafkaAdapterException((Exception)e);
        }
        return instance;
    }

    /*
     * WARNING - void declaration
     */
    protected static final <T> Constructor<T> getConstructor(Class<T> implClass, Class<?> ... parameterTypes) {
        Constructor<T> xtor = null;
        try {
            xtor = implClass.getConstructor(parameterTypes);
        }
        catch (NoSuchMethodException | SecurityException exception) {
            void e;
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.microprofile.reactive.messaging.kafka.adapter.KafkaAdapterFactory", (String)"176", null, (Object[])new Object[]{implClass, parameterTypes});
            throw new KafkaAdapterException((Exception)e);
        }
        return xtor;
    }

    /*
     * WARNING - void declaration
     */
    protected static final <T> Class<? extends T> getImplClass(ClassLoader classloader, Class<T> interfaceClass, String implClassName) {
        Class<?> implClass = null;
        try {
            implClass = classloader.loadClass(implClassName);
        }
        catch (ClassNotFoundException classNotFoundException) {
            void e;
            FFDCFilter.processException((Throwable)classNotFoundException, (String)"com.ibm.ws.microprofile.reactive.messaging.kafka.adapter.KafkaAdapterFactory", (String)"187", null, (Object[])new Object[]{classloader, interfaceClass, implClassName});
            throw new KafkaAdapterException((Exception)e);
        }
        return implClass;
    }
}

