/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.provider;

import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.FileDataSource;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.MessageBodyReader;
import javax.ws.rs.ext.MessageBodyWriter;
import javax.ws.rs.ext.Provider;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.helpers.IOUtils;
import org.apache.cxf.jaxrs.ext.multipart.InputStreamDataSource;
import org.apache.cxf.jaxrs.provider.BinaryDataProvider;
import org.apache.cxf.jaxrs.utils.ExceptionUtils;
import org.apache.cxf.jaxrs.utils.JAXRSUtils;

@Provider
@TraceObjectField(fieldName="LOG", fieldDesc="Ljava/util/logging/Logger;")
@InjectedFFDC
public class DataSourceProvider<T>
implements MessageBodyReader<T>,
MessageBodyWriter<T> {
    protected static final Logger LOG = LogUtils.getL7dLogger(DataSourceProvider.class);
    private boolean useDataSourceContentType;
    static final long serialVersionUID = 2984310210573845348L;

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public DataSourceProvider() {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.provider.DataSourceProvider", "<init>", new Object[0]);
        }
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.jaxrs.provider.DataSourceProvider", "<init>", this);
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public boolean isReadable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mt) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.provider.DataSourceProvider", "isReadable", new Object[]{type, genericType, annotations, mt});
        }
        boolean bl = this.isSupported(type, mt);
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            bl = bl;
            LOG.exiting("org.apache.cxf.jaxrs.provider.DataSourceProvider", "isReadable", bl);
        }
        return bl;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public T readFrom(Class<T> cls, Type genericType, Annotation[] annotations, MediaType type, MultivaluedMap<String, String> headers, InputStream is) throws IOException {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.provider.DataSourceProvider", "readFrom", new Object[]{cls, genericType, annotations, type, headers, is});
        }
        Object ds = null;
        if (cls == FileDataSource.class) {
            File file = new BinaryDataProvider<File>().readFrom(File.class, (Type)((Object)File.class), annotations, type, headers, is);
            ds = new FileDataSource(file);
        } else if (cls == DataSource.class || cls == DataHandler.class) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            IOUtils.copy((InputStream)is, (OutputStream)baos);
            ByteArrayInputStream copiedStream = new ByteArrayInputStream(baos.toByteArray());
            ds = new InputStreamDataSource(copiedStream, type.toString());
        } else {
            LOG.warning("Unsupported DataSource class: " + cls.getName());
            throw ExceptionUtils.toWebApplicationException(null, null);
        }
        T t = cls.cast(DataSource.class.isAssignableFrom(cls) ? ds : new DataHandler((DataSource)ds));
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            t = t;
            LOG.exiting("org.apache.cxf.jaxrs.provider.DataSourceProvider", "readFrom", t);
        }
        return t;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public long getSize(T t, Class<?> type, Type genericType, Annotation[] annotations, MediaType mt) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.provider.DataSourceProvider", "getSize", new Object[]{t, type, genericType, annotations, mt});
        }
        long l = -1L;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            l = l;
            LOG.exiting("org.apache.cxf.jaxrs.provider.DataSourceProvider", "getSize", l);
        }
        return l;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public boolean isWriteable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mt) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.provider.DataSourceProvider", "isWriteable", new Object[]{type, genericType, annotations, mt});
        }
        boolean bl = this.isSupported(type, mt);
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            bl = bl;
            LOG.exiting("org.apache.cxf.jaxrs.provider.DataSourceProvider", "isWriteable", bl);
        }
        return bl;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private boolean isSupported(Class<?> type, MediaType mt) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.provider.DataSourceProvider", "isSupported", new Object[]{type, mt});
        }
        boolean bl = DataSource.class.isAssignableFrom(type) || DataHandler.class.isAssignableFrom(type);
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            bl = bl;
            LOG.exiting("org.apache.cxf.jaxrs.provider.DataSourceProvider", "isSupported", bl);
        }
        return bl;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void writeTo(T src, Class<?> cls, Type genericType, Annotation[] annotations, MediaType type, MultivaluedMap<String, Object> headers, OutputStream os) throws IOException {
        DataSource ds;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.provider.DataSourceProvider", "writeTo", new Object[]{src, cls, genericType, annotations, type, headers, os});
        }
        DataSource dataSource = ds = DataSource.class.isAssignableFrom(cls) ? (DataSource)src : ((DataHandler)src).getDataSource();
        if (this.useDataSourceContentType) {
            this.setContentTypeIfNeeded(type, headers, ds.getContentType());
        }
        IOUtils.copyAndCloseInput((InputStream)ds.getInputStream(), (OutputStream)os);
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.jaxrs.provider.DataSourceProvider", "writeTo");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private void setContentTypeIfNeeded(MediaType type, MultivaluedMap<String, Object> headers, String ct) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.provider.DataSourceProvider", "setContentTypeIfNeeded", new Object[]{type, headers, ct});
        }
        if (!StringUtils.isEmpty((String)ct) && !type.equals((Object)JAXRSUtils.toMediaType(ct))) {
            headers.putSingle((Object)"Content-Type", (Object)ct);
        }
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.jaxrs.provider.DataSourceProvider", "setContentTypeIfNeeded");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void setUseDataSourceContentType(boolean useDataSourceContentType) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.provider.DataSourceProvider", "setUseDataSourceContentType", new Object[]{useDataSourceContentType});
        }
        this.useDataSourceContentType = useDataSourceContentType;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.jaxrs.provider.DataSourceProvider", "setUseDataSourceContentType");
        }
    }
}

