/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jbatch.joblog.internal.impl;

import com.ibm.jbatch.container.instance.WorkUnitDescriptor;
import com.ibm.jbatch.container.ws.BatchJobNotLocalException;
import com.ibm.jbatch.container.ws.BatchLocationService;
import com.ibm.jbatch.container.ws.JoblogUtil;
import com.ibm.jbatch.container.ws.WSJobExecution;
import com.ibm.jbatch.container.ws.WSJobInstance;
import com.ibm.jbatch.container.ws.WSJobRepository;
import com.ibm.jbatch.container.ws.events.BatchEventsPublisher;
import com.ibm.jbatch.spi.services.IBatchConfig;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TrConfigurator;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.jbatch.joblog.JobExecutionLog;
import com.ibm.ws.jbatch.joblog.JobInstanceLog;
import com.ibm.ws.jbatch.joblog.internal.impl.BatchLogPartNotCreatedException;
import com.ibm.ws.jbatch.joblog.internal.impl.FileUtils;
import com.ibm.ws.jbatch.joblog.internal.impl.JobLogHandler;
import com.ibm.ws.jbatch.joblog.internal.impl.StringUtils;
import com.ibm.ws.jbatch.joblog.internal.impl.TraceSpecElement;
import com.ibm.ws.jbatch.joblog.services.IJobLogManagerService;
import com.ibm.ws.kernel.security.thread.ThreadIdentityManager;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.kernel.service.location.WsLocationAdmin;
import java.io.File;
import java.io.FileFilter;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.batch.runtime.JobExecution;
import javax.batch.runtime.JobInstance;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
@Component(configurationPid={"com.ibm.ws.jbatch.joblog"}, configurationPolicy=ConfigurationPolicy.REQUIRE)
public class JobLogManagerImpl
implements IJobLogManagerService {
    private static final String CLASSNAME;
    private final Logger logger = Logger.getLogger(CLASSNAME, "com.ibm.ws.jbatch.joblog.internal.resources.JBatchJobLogMessages");
    private static final int MAX_SUBDIRECTORIES = 32000;
    private static final String ENV_LOG_DIR = "LOG_DIR";
    private static final String SERVER_OUTPUT_DIR = "server.output.dir";
    private WsLocationAdmin locationService;
    private WSJobRepository jobRepository;
    private BatchEventsPublisher eventsPublisher;
    private final JobLogHandler joblogHandler = new JobLogHandler();
    private BatchLocationService batchLocationService;
    protected static final FileFilter JobLogFileFilter;
    static final long serialVersionUID = -1868654757587527100L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    @Activate
    protected synchronized void activate(ComponentContext componentContext, Map<String, Object> config) {
        this.configureJobLogHandler(config);
    }

    @Deactivate
    protected void deactivate() {
        JoblogUtil.setIncludeServerLogging((boolean)true);
        this.joblogHandler.removeFromLoggers();
        this.joblogHandler.close();
    }

    @Modified
    protected void modified(Map<String, Object> config) {
        this.configureJobLogHandler(config);
    }

    public void init(IBatchConfig batchConfig) {
    }

    public void shutdown() {
    }

    @Reference
    protected synchronized void setLocationService(WsLocationAdmin locSvc) {
        this.locationService = locSvc;
    }

    @Reference
    protected void setWSJobRepository(WSJobRepository ref) {
        this.jobRepository = ref;
    }

    @Reference
    protected void setBatchLocationService(BatchLocationService batchLocationService) {
        this.batchLocationService = batchLocationService;
    }

    @Reference(cardinality=ReferenceCardinality.OPTIONAL, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY)
    protected void setEventsPublisher(BatchEventsPublisher publisher) {
        this.eventsPublisher = publisher;
    }

    protected void unsetEventsPublisher(BatchEventsPublisher publisher) {
        if (this.eventsPublisher == publisher) {
            this.eventsPublisher = null;
        }
    }

    protected BatchEventsPublisher getEventsPublisher() {
        return this.eventsPublisher;
    }

    private synchronized boolean isJobLoggingEnabled() {
        return this.joblogHandler.hasLoggers();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void workUnitStarted(WorkUnitDescriptor ctx) {
        if (this.isJobLoggingEnabled() && !ctx.isRemotePartitionDispatch() && this.isJobLoggingEnabled()) {
            try {
                String logDirPath = this.joblogHandler.setExecutionContext(ctx);
                ctx.updateExecutionJobLogDir(logDirPath);
            }
            catch (BatchLogPartNotCreatedException logDirPath) {
                void e;
                FFDCFilter.processException((Throwable)logDirPath, (String)"com.ibm.ws.jbatch.joblog.internal.impl.JobLogManagerImpl", (String)"201", (Object)this, (Object[])new Object[]{ctx});
                this.logger.log(Level.SEVERE, "job.logging.create.new", new Object[]{ctx.getTopLevelJobName(), ctx.getTopLevelInstanceId(), ctx.getTopLevelExecutionId(), e.toString()});
            }
        }
    }

    @Override
    public void workUnitEnded(WorkUnitDescriptor ctx) {
        this.joblogHandler.clearExecutionContext();
    }

    @Override
    public JobInstanceLog getJobInstanceLog(long jobInstanceId) throws BatchJobNotLocalException {
        ArrayList<JobExecutionLog> execLogs = new ArrayList<JobExecutionLog>();
        HashSet<File> instanceDirs = new HashSet<File>();
        WSJobInstance jobInstance = this.jobRepository.getJobInstance(jobInstanceId);
        for (JobExecution jobExecution : this.jobRepository.getJobExecutionsFromInstance(jobInstanceId)) {
            JobExecutionLog execLog = this.getJobExecutionLog((JobInstance)jobInstance, jobExecution.getExecutionId());
            execLogs.add(execLog);
            instanceDirs.add(execLog.getExecLogRootDir().getParentFile());
        }
        JobInstanceLog retMe = new JobInstanceLog((JobInstance)jobInstance, new ArrayList<File>(instanceDirs));
        for (JobExecutionLog log : execLogs) {
            retMe.addJobExecutionLog(log);
        }
        return retMe;
    }

    @Override
    public JobInstanceLog getLocalJobInstanceLog(long jobInstanceId) {
        ArrayList<JobExecutionLog> execLogs = new ArrayList<JobExecutionLog>();
        HashSet<File> instanceDirs = new HashSet<File>();
        WSJobInstance jobInstance = this.jobRepository.getJobInstance(jobInstanceId);
        for (JobExecution jobExecution : this.jobRepository.getJobExecutionsFromInstance(jobInstanceId)) {
            if (!this.batchLocationService.isLocalJobExecution(jobExecution.getExecutionId())) continue;
            JobExecutionLog execLog = this.getJobExecutionLog((JobInstance)jobInstance, jobExecution);
            execLogs.add(execLog);
            instanceDirs.add(execLog.getExecLogRootDir().getParentFile());
        }
        JobInstanceLog retMe = new JobInstanceLog((JobInstance)jobInstance, new ArrayList<File>(instanceDirs));
        for (JobExecutionLog log : execLogs) {
            retMe.addJobExecutionLog(log);
        }
        return retMe;
    }

    @Override
    public JobInstanceLog getJobInstanceLogAllExecutions(long jobInstanceId) {
        ArrayList<JobExecutionLog> execLogs = new ArrayList<JobExecutionLog>();
        HashSet<File> instanceDirs = new HashSet<File>();
        WSJobInstance jobInstance = this.jobRepository.getJobInstance(jobInstanceId);
        for (JobExecution jobExecution : this.jobRepository.getJobExecutionsFromInstance(jobInstanceId)) {
            JobExecutionLog execLog = this.getJobExecutionLog((JobInstance)jobInstance, jobExecution);
            execLogs.add(execLog);
            instanceDirs.add(execLog.getExecLogRootDir().getParentFile());
        }
        JobInstanceLog retMe = new JobInstanceLog((JobInstance)jobInstance, new ArrayList<File>(instanceDirs));
        for (JobExecutionLog log : execLogs) {
            retMe.addJobExecutionLog(log);
        }
        return retMe;
    }

    private JobExecutionLog getJobExecutionLog(JobInstance jobInstance, JobExecution jobExecution) {
        String jobLogDirName = ((WSJobExecution)jobExecution).getLogpath();
        File jobLogDir = StringUtils.isEmpty(jobLogDirName) ? this.getServerOutputDir(this.getJobExecutionLogDirName(jobInstance, jobExecution.getExecutionId())) : new File(jobLogDirName);
        List<File> jobLogFiles = StringUtils.isEmpty(jobLogDirName) ? Collections.EMPTY_LIST : FileUtils.findFiles(new File(jobLogDirName), JobLogFileFilter);
        return new JobExecutionLog(jobExecution, jobLogFiles, jobLogDir);
    }

    @Override
    public JobExecutionLog getJobExecutionLog(long jobExecutionId) throws BatchJobNotLocalException {
        WSJobInstance jobInstance = this.jobRepository.getJobInstanceFromExecution(jobExecutionId);
        return this.getJobExecutionLog((JobInstance)jobInstance, jobExecutionId);
    }

    private JobExecutionLog getJobExecutionLog(JobInstance jobInstance, long jobExecutionId) throws BatchJobNotLocalException {
        JobExecution jobExecution = this.batchLocationService.assertIsLocalJobExecution(jobExecutionId);
        String jobLogDirName = ((WSJobExecution)jobExecution).getLogpath();
        File jobLogDir = StringUtils.isEmpty(jobLogDirName) ? this.getServerOutputDir(this.getJobExecutionLogDirName(jobInstance, jobExecutionId)) : new File(jobLogDirName);
        List<File> jobLogFiles = StringUtils.isEmpty(jobLogDirName) ? Collections.EMPTY_LIST : FileUtils.findFiles(new File(jobLogDirName), JobLogFileFilter);
        return new JobExecutionLog(jobExecution, jobLogFiles, jobLogDir);
    }

    protected File getServerOutputDir(String dirname) {
        return this.getServerOutputFile(dirname + File.separator);
    }

    protected File getServerOutputFile(String filename) {
        return this.locationService.resolveResource(filename).asFile();
    }

    protected String getAbsoluteJobLogsRootDirName() {
        String logLocation = TrConfigurator.getLogLocation();
        logLocation = logLocation == null ? ((logLocation = System.getenv(ENV_LOG_DIR)) == null ? System.getProperty(SERVER_OUTPUT_DIR) + File.separator + "logs" + File.separator + "joblogs" : logLocation + File.separator + "joblogs") : logLocation + File.separator + "joblogs";
        return logLocation;
    }

    protected String getJobInstanceLogDirName(JobInstance jobInstance) {
        return this.getJobInstanceLogDirName(jobInstance.getJobName(), jobInstance.getInstanceId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getJobInstanceLogDirName(String jobName, long instanceId) {
        Object token = null;
        File dateDir = null;
        try {
            token = ThreadIdentityManager.runAsServer();
            String dateDirBase = String.format(this.getAbsoluteJobLogsRootDirName() + File.separator + "%s" + File.separator + new SimpleDateFormat("yyyy-MM-dd").format(new Date()), jobName);
            dateDir = new File(dateDirBase);
            int extraDir = 2;
            while (dateDir.exists() && dateDir.isDirectory() && dateDir.list().length >= 32000) {
                dateDir = new File(dateDirBase + "_" + extraDir);
                ++extraDir;
            }
        }
        finally {
            if (token != null) {
                ThreadIdentityManager.reset((Object)token);
            }
        }
        return String.format(dateDir.getPath() + File.separator + "instance.%d", instanceId);
    }

    protected String getJobExecutionLogDirName(JobInstance jobInstance, long executionId) {
        return this.getJobExecutionLogDirName(jobInstance.getJobName(), jobInstance.getInstanceId(), executionId);
    }

    protected String getJobExecutionLogDirName(String jobName, long instanceId, long executionId) {
        return String.format(this.getJobInstanceLogDirName(jobName, instanceId) + File.separator + "execution.%d", executionId);
    }

    protected boolean shouldUseParentHandlers(Map<String, Object> config) {
        return Boolean.parseBoolean((String)config.get("writeToServerLog"));
    }

    protected boolean shouldRegisterWithRootLogger(Map<String, Object> config) {
        String bool = (String)config.get("includeServerLogging");
        return StringUtils.isEmpty(bool) ? true : Boolean.parseBoolean(bool);
    }

    protected void registerWithBatchJobLogger(Map<String, Object> config) {
        Logger jobLogger = Logger.getLogger("com.ibm.ws.batch.JobLogger");
        this.joblogHandler.addToLogger(jobLogger);
        Level level = jobLogger.getLevel();
        if (level == null || level.intValue() > Level.FINE.intValue() && !level.equals(Level.OFF)) {
            jobLogger.setLevel(Level.FINE);
        }
        jobLogger.setUseParentHandlers(this.shouldUseParentHandlers(config));
    }

    protected JobLogHandler configureJobLogHandler(Map<String, Object> config) {
        if (this.isJobLoggingEnabled() && !((Boolean)config.get("enabled")).booleanValue()) {
            this.joblogHandler.setFinalNotification(true);
        }
        this.joblogHandler.removeFromLoggers();
        this.joblogHandler.setMaxRecords((Integer)config.get("maxRecords"));
        this.joblogHandler.setMaxTime((Integer)config.get("maxTime"));
        this.joblogHandler.setPurgeOnPublish((Boolean)config.get("purgeOnPublish"));
        this.joblogHandler.setJobLogManagerImpl(this);
        this.joblogHandler.setLevel(Level.ALL);
        if (((Boolean)config.get("enabled")).booleanValue()) {
            this.registerWithBatchJobLogger(config);
            List<TraceSpecElement> traceSpecElements = this.parseTraceSpecElements((String)config.get("jobLoggers"));
            for (TraceSpecElement traceSpecElement : traceSpecElements) {
                Logger logger = traceSpecElement.getLogger();
                this.joblogHandler.addToLogger(logger);
                logger.setUseParentHandlers(this.shouldUseParentHandlers(config));
            }
            if (this.shouldRegisterWithRootLogger(config)) {
                this.joblogHandler.addToLogger(Logger.getLogger(""));
            } else {
                JoblogUtil.setIncludeServerLogging((boolean)false);
            }
            this.joblogHandler.setFinalNotification(false);
        }
        return this.joblogHandler;
    }

    protected List<TraceSpecElement> parseTraceSpecElements(String traceSpec) {
        ArrayList<TraceSpecElement> traceSpecElements = new ArrayList<TraceSpecElement>();
        for (String spec : StringUtils.split(traceSpec, ":")) {
            if (StringUtils.isEmpty(spec)) continue;
            traceSpecElements.add(new TraceSpecElement(spec));
        }
        return traceSpecElements;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"com.ibm.ws.jbatch.joblog.internal.impl.JobLogManagerImpl", JobLogManagerImpl.class, null, null);
        CLASSNAME = JobLogManagerImpl.class.getName();
        JobLogFileFilter = new FileFilter(){
            static final long serialVersionUID = -4930099094517266032L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            @Override
            public boolean accept(File pathname) {
                return pathname.isFile() && pathname.getName().endsWith(".log");
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register((String)"com.ibm.ws.jbatch.joblog.internal.impl.JobLogManagerImpl$1", 1.class, null, null);
            }
        };
    }
}

