/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jaxws.metadata;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.jaxws.metadata.HandlerChainAnnotationSer;
import com.ibm.ws.jaxws.metadata.HandlerChainInfo;
import com.ibm.ws.jaxws.metadata.JaxWsClientMetaData;
import com.ibm.ws.jaxws.metadata.PortComponentRefInfo;
import com.ibm.ws.jaxws.metadata.Utils;
import com.ibm.ws.jaxws.metadata.WebServiceFeatureInfo;
import com.ibm.ws.jaxws.metadata.WebServiceRefPartialInfo;
import com.ibm.ws.jaxws.utils.StringUtils;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.jws.HandlerChain;
import javax.xml.namespace.QName;
import javax.xml.ws.WebServiceFeature;
import javax.xml.ws.WebServiceRef;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class WebServiceRefInfo
implements Serializable {
    private static final TraceComponent tc = Tr.register(WebServiceRefInfo.class, (String)"JaxWsCommon", (String)"com.ibm.ws.jaxws.internal.resources.JaxWsCommonMessages");
    private static final long serialVersionUID = -6008015521793819719L;
    private String jndiName;
    private String mappedName;
    private String lookupName;
    private String serviceInterfaceClassName;
    private String serviceRefTypeClassName;
    private String wsdlLocation;
    private QName serviceQName;
    private QName portQName;
    private String defaultPortAddress;
    private Map<String, String> properties;
    private String handlerChainDeclaringClassName;
    private HandlerChainAnnotationSer handlerChainAnnotation;
    private boolean handlersFromXML;
    private String componenetName;
    private final List<HandlerChainInfo> handlerChains = new ArrayList<HandlerChainInfo>(2);
    private final Map<String, PortComponentRefInfo> seiNamePortComponentRefInfoMap = new HashMap<String, PortComponentRefInfo>();
    private final Map<QName, PortComponentRefInfo> bindingPortComponentRefInfoMap = new HashMap<QName, PortComponentRefInfo>();
    private final transient WebServiceRef webServiceRefAnnotation;
    private WebServiceRefPartialInfo partialInfo;
    private transient JaxWsClientMetaData clientMetaData;

    public String getComponenetName() {
        return this.componenetName;
    }

    public void setComponenetName(String componenetName) {
        this.componenetName = componenetName;
    }

    public WebServiceRefInfo(WebServiceRef wsrAnnot) {
        this.jndiName = wsrAnnot.name();
        this.mappedName = wsrAnnot.mappedName();
        this.lookupName = wsrAnnot.lookup();
        this.wsdlLocation = wsrAnnot.wsdlLocation();
        this.setServiceInterfaceClassName(wsrAnnot.value() != null ? wsrAnnot.value().getName() : null);
        this.setServiceRefTypeClassName(wsrAnnot.type() != null ? wsrAnnot.type().getName() : null);
        this.webServiceRefAnnotation = wsrAnnot;
    }

    public WebServiceRef getAnnotationValue() {
        return this.webServiceRefAnnotation;
    }

    public Map<String, PortComponentRefInfo> getPortComponentRefInfoMap() {
        return this.seiNamePortComponentRefInfoMap;
    }

    public PortComponentRefInfo getPortComponentRefInfo(String seiClassName) {
        return this.seiNamePortComponentRefInfoMap.get(seiClassName);
    }

    public PortComponentRefInfo getPortComponentRefInfo(QName portQName) {
        if (null == portQName) {
            return null;
        }
        PortComponentRefInfo portInfo = this.bindingPortComponentRefInfoMap.get(portQName);
        if (null == portInfo) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("No PortComponentRefInfo object was found with the given qname '" + portQName + "', try again with its local part."), (Object[])new Object[0]);
            }
            portInfo = this.bindingPortComponentRefInfoMap.get(new QName(portQName.getLocalPart()));
        }
        return portInfo;
    }

    public void addPortComponentRefInfo(PortComponentRefInfo portComponentRefInfo) {
        String seiClassName = portComponentRefInfo.getServiceEndpointInterface();
        QName portQname = portComponentRefInfo.getPortQName();
        if (null != seiClassName) {
            this.seiNamePortComponentRefInfoMap.put(seiClassName, portComponentRefInfo);
        } else if (null != portQname) {
            this.bindingPortComponentRefInfoMap.put(portQname, portComponentRefInfo);
        }
    }

    public List<WebServiceFeature> getWSFeatureForSEIClass(String seiClassName) {
        PortComponentRefInfo portComponentRefInfo = this.seiNamePortComponentRefInfoMap.get(seiClassName);
        if (portComponentRefInfo == null) {
            return Collections.emptyList();
        }
        List<WebServiceFeatureInfo> featureInfos = portComponentRefInfo.getWebServiceFeatureInfos();
        if (featureInfos.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<WebServiceFeature> wsFeatures = new ArrayList<WebServiceFeature>(featureInfos.size());
        for (WebServiceFeatureInfo featureInfo : featureInfos) {
            wsFeatures.add(featureInfo.getWebServiceFeature());
        }
        return wsFeatures;
    }

    public boolean isWebServiceFeaturePresent(String seiClassName, Class<? extends WebServiceFeatureInfo> featureClass) {
        PortComponentRefInfo portComponentRefInfo = this.seiNamePortComponentRefInfoMap.get(seiClassName);
        if (portComponentRefInfo == null) {
            return false;
        }
        List<WebServiceFeatureInfo> seiList = portComponentRefInfo.getWebServiceFeatureInfos();
        if (seiList.isEmpty()) {
            return false;
        }
        for (WebServiceFeatureInfo wsFeatureInfo : seiList) {
            if (wsFeatureInfo.getClass() != featureClass) continue;
            return true;
        }
        return false;
    }

    public void addWebServiceFeatureInfo(String seiName, WebServiceFeatureInfo featureInfo) {
        PortComponentRefInfo portComponentRefInfo = this.seiNamePortComponentRefInfoMap.get(seiName);
        if (portComponentRefInfo == null) {
            portComponentRefInfo = new PortComponentRefInfo(seiName);
            this.seiNamePortComponentRefInfoMap.put(seiName, portComponentRefInfo);
        }
        portComponentRefInfo.addWebServiceFeatureInfo(featureInfo);
    }

    public void setJndiName(String jndiName) {
        this.jndiName = jndiName;
    }

    public String getJndiName() {
        return this.jndiName;
    }

    public void setMappedName(String mappedName) {
        this.mappedName = mappedName;
    }

    public String getMappedName() {
        return this.mappedName;
    }

    public void setLookupName(String lookupName) {
        this.lookupName = lookupName;
    }

    public String getLookupName() {
        return this.lookupName;
    }

    public void setWsdlLocation(String wsdlLocation) {
        this.wsdlLocation = wsdlLocation;
    }

    public String getWsdlLocation() {
        if (!StringUtils.isEmpty(this.wsdlLocation)) {
            return this.wsdlLocation;
        }
        return this.partialInfo == null ? null : this.partialInfo.getWsdlLocation();
    }

    public String getDefaultPortAddress() {
        return this.defaultPortAddress;
    }

    public void setDefaultPortAddress(String address) {
        this.defaultPortAddress = address;
    }

    public void setServiceQName(QName serviceQName) {
        this.serviceQName = serviceQName;
    }

    public QName getServiceQName() {
        if (this.serviceQName != null) {
            return this.serviceQName;
        }
        return this.partialInfo == null ? null : this.partialInfo.getServiceQName();
    }

    public void setPortQName(QName portQName) {
        this.portQName = portQName;
    }

    public QName getPortQName() {
        if (this.portQName != null) {
            return this.portQName;
        }
        return this.partialInfo == null ? null : this.partialInfo.getPortQName();
    }

    public void setServiceInterfaceClassName(String serviceInterfaceClassName) {
        this.serviceInterfaceClassName = serviceInterfaceClassName;
    }

    public String getServiceInterfaceClassName() {
        return this.serviceInterfaceClassName;
    }

    public void setServiceRefTypeClassName(String serviceRefTypeClassName) {
        this.serviceRefTypeClassName = serviceRefTypeClassName;
    }

    public String getServiceRefTypeClassName() {
        return this.serviceRefTypeClassName;
    }

    public void addHandlerChain(HandlerChainInfo handlerChain) {
        this.handlerChains.add(handlerChain);
    }

    public boolean removeHandlerChain(HandlerChainInfo handlerChain) {
        return this.handlerChains.remove(handlerChain);
    }

    public void clearHandlerChain(HandlerChainInfo handlerChain) {
        this.handlerChains.clear();
    }

    public boolean getHandlersFromXML() {
        return this.handlersFromXML;
    }

    public void setHandlersFromXML(boolean handlersFromXML) {
        this.handlersFromXML = handlersFromXML;
    }

    public String getHandlerChainDeclaringClassName() {
        return this.handlerChainDeclaringClassName;
    }

    public void setHandlerChainDeclaringClassName(String handlerChainDeclaringClassName) {
        this.handlerChainDeclaringClassName = handlerChainDeclaringClassName;
    }

    public List<HandlerChainInfo> getHandlerChains() {
        return Collections.unmodifiableList(this.handlerChains);
    }

    public HandlerChainAnnotationSer getHandlerChainAnnotation() {
        return this.handlerChainAnnotation;
    }

    public void setHandlerChainAnnotation(HandlerChain handlerChainAnnotation) {
        this.handlerChainAnnotation = new HandlerChainAnnotationSer(handlerChainAnnotation);
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public void setProperties(Map<String, String> properties) {
        this.properties = properties;
    }

    public WebServiceRefPartialInfo getPartialInfo() {
        return this.partialInfo;
    }

    public void setPartialInfo(WebServiceRefPartialInfo partialInfo) {
        this.partialInfo = partialInfo;
        if (partialInfo != null) {
            if (this.handlerChainAnnotation == null) {
                this.handlerChainAnnotation = partialInfo.getHandlerChainAnnotation();
            }
            if (this.handlerChainDeclaringClassName == null) {
                this.handlerChainDeclaringClassName = partialInfo.getHandlerChainDeclaringClassName();
            }
        }
    }

    public JaxWsClientMetaData getClientMetaData() {
        return this.clientMetaData;
    }

    public void setClientMetaData(JaxWsClientMetaData clientMetaData) {
        this.clientMetaData = clientMetaData;
    }

    public final boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof WebServiceRefInfo)) {
            return false;
        }
        WebServiceRefInfo wsrObj = (WebServiceRefInfo)obj;
        if (this.handlersFromXML != wsrObj.handlersFromXML) {
            return false;
        }
        if (!Utils.compareInstance(this.handlerChainAnnotation, wsrObj.handlerChainAnnotation)) {
            return false;
        }
        if (!Utils.compareStrings(this.jndiName, wsrObj.jndiName)) {
            return false;
        }
        if (!Utils.compareStrings(this.mappedName, wsrObj.mappedName)) {
            return false;
        }
        if (!Utils.compareStrings(this.lookupName, wsrObj.lookupName)) {
            return false;
        }
        if (!Utils.compareStrings(this.wsdlLocation, wsrObj.wsdlLocation)) {
            return false;
        }
        if (!Utils.compareStrings(this.serviceInterfaceClassName, wsrObj.serviceInterfaceClassName)) {
            return false;
        }
        if (!Utils.compareStrings(this.serviceRefTypeClassName, wsrObj.serviceRefTypeClassName)) {
            return false;
        }
        if (!Utils.compareStrings(this.handlerChainDeclaringClassName, wsrObj.handlerChainDeclaringClassName)) {
            return false;
        }
        if (!Utils.compareQNames(this.serviceQName, wsrObj.serviceQName)) {
            return false;
        }
        if (!Utils.compareQNames(this.portQName, wsrObj.portQName)) {
            return false;
        }
        if (!Utils.compareLists(this.handlerChains, wsrObj.handlerChains)) {
            return false;
        }
        return Utils.compareInstance(this.partialInfo, wsrObj.partialInfo);
    }

    public int hashCode() {
        int result = this.jndiName == null ? 0 : this.jndiName.hashCode();
        result += this.mappedName == null ? 0 : this.mappedName.hashCode();
        result += this.lookupName == null ? 0 : this.lookupName.hashCode();
        result += this.wsdlLocation == null ? 0 : this.wsdlLocation.hashCode();
        result += this.serviceInterfaceClassName == null ? 0 : this.serviceInterfaceClassName.hashCode();
        result += this.serviceRefTypeClassName == null ? 0 : this.serviceRefTypeClassName.hashCode();
        result += this.serviceQName == null ? 0 : this.serviceQName.hashCode();
        result += this.portQName == null ? 0 : this.portQName.hashCode();
        result += !this.handlersFromXML ? 0 : 1;
        result += this.handlerChainDeclaringClassName == null ? 0 : this.handlerChainDeclaringClassName.hashCode();
        result += this.handlerChains == null ? 0 : this.handlerChains.hashCode();
        result += this.handlerChainAnnotation == null ? 0 : this.handlerChainAnnotation.hashCode();
        return result += this.partialInfo == null ? 0 : this.partialInfo.hashCode();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("*** Begin WebServiceRefInfo: " + this.getClass().getName() + "@" + Integer.toHexString(System.identityHashCode(this)) + " ***\n");
        sb.append("JNDI name                       : " + this.getJndiName() + "\n");
        sb.append("Mapped name                     : " + this.getMappedName() + "\n");
        sb.append("Lookup name                     : " + this.getLookupName() + "\n");
        sb.append("WSDL location                   : " + this.getWsdlLocation() + "\n");
        sb.append("WSDL service                    : " + (this.getServiceQName() != null ? this.getServiceQName().toString() : "<null>") + "\n");
        sb.append("Service-Interface classname     : " + this.getServiceInterfaceClassName() + "\n");
        sb.append("Service-Ref-Type classname      : " + this.getServiceRefTypeClassName() + "\n");
        sb.append("Port QName                      : " + (this.getPortQName() != null ? this.getPortQName().toString() : "<null>") + "\n");
        sb.append("handlerChain file location: " + (this.handlerChainAnnotation != null ? this.handlerChainAnnotation.getFile() : "<null>") + "\n");
        sb.append("handlers is From XML: " + this.handlersFromXML + "\n");
        sb.append("HandlerChain declaring classname: " + this.getHandlerChainDeclaringClassName() + "\n");
        sb.append("HandlerChains: " + (this.handlerChains != null ? this.handlerChains.toString() : "<null>") + "\n");
        sb.append("PartialInfo: " + (this.partialInfo != null ? this.partialInfo.toString() : "<null>") + "\n");
        sb.append("*** End WebServiceRefInfo ***\n");
        return sb.toString();
    }
}

