/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wsspi.webcontainer;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.util.WSThreadLocal;
import com.ibm.wsspi.webcontainer.servlet.AsyncContext;
import com.ibm.wsspi.webcontainer.servlet.IExtendedRequest;
import com.ibm.wsspi.webcontainer.servlet.IExtendedResponse;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class WebContainerRequestState {
    protected static Logger logger = Logger.getLogger("com.ibm.wsspi.webcontainer");
    private static final String CLASS_NAME = "com.ibm.wsspi.webcontainer.WebContainerRequestState";
    private Map _attributes = null;
    private boolean _invokedFilters;
    private boolean completed;
    private boolean ardRequest;
    private boolean startAsync;
    private IExtendedRequest currentThreadsIExtendedRequest;
    private IExtendedResponse currentThreadsIExtendedResponse;
    private Map<String, String> cookieAttributesMap = null;
    private AsyncContext asyncContext;
    private static WSThreadLocal instance = new WSThreadLocal();

    public IExtendedResponse getCurrentThreadsIExtendedResponse() {
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "getCurrentThreadsIExtendedResponse", " currentThreadsIExtendedResponse --> " + this.currentThreadsIExtendedResponse);
        }
        return this.currentThreadsIExtendedResponse;
    }

    public void setCurrentThreadsIExtendedRequest(IExtendedRequest currentThreadsIExtendedRequest) {
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "setCurrentThreadsIExtendedRequest", " new currentThreadsIExtendedRequest --> " + currentThreadsIExtendedRequest);
        }
        this.currentThreadsIExtendedRequest = currentThreadsIExtendedRequest;
    }

    public boolean isAsyncMode() {
        return this.startAsync;
    }

    public static WebContainerRequestState getInstance(boolean create) {
        WebContainerRequestState tempState = null;
        tempState = (WebContainerRequestState)instance.get();
        if (tempState == null && create) {
            tempState = WebContainerRequestState.createInstance();
        }
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINEST)) {
            logger.logp(Level.FINEST, CLASS_NAME, "getInstance", "created->" + create + ", request state->" + tempState);
        }
        return tempState;
    }

    public static WebContainerRequestState createInstance() {
        WebContainerRequestState newState = new WebContainerRequestState();
        instance.set((Object)newState);
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINEST)) {
            logger.logp(Level.FINEST, CLASS_NAME, "createInstance", "created requestState -->" + newState.toString());
        }
        return newState;
    }

    public void init() {
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINEST)) {
            logger.logp(Level.FINEST, CLASS_NAME, "init", "init for request State");
        }
        if (this._attributes != null) {
            this._attributes.clear();
        }
        if (this.cookieAttributesMap != null) {
            this.cookieAttributesMap.clear();
        }
        this._invokedFilters = false;
        this.completed = false;
        this.ardRequest = false;
        this.currentThreadsIExtendedRequest = null;
        this.startAsync = false;
        this.asyncContext = null;
    }

    public void setAttribute(String string, Object obj) {
        if (this._attributes == null) {
            this._attributes = new HashMap();
        }
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "setAttribute", " name --> " + string);
        }
        this._attributes.put(string, obj);
    }

    public Object getAttribute(String arg0) {
        if (this._attributes == null) {
            return null;
        }
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "getAttribute", " name --> " + arg0);
        }
        return this._attributes.get(arg0);
    }

    public void removeAttribute(String arg0) {
        if (this._attributes == null) {
            return;
        }
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "removeAttribute", " name --> " + arg0);
        }
        this._attributes.remove(arg0);
    }

    public boolean isInvokedFilters() {
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "isInvokedFilters", " _invokedFilters --> " + this._invokedFilters);
        }
        return this._invokedFilters;
    }

    public void setInvokedFilters(boolean filters) {
        this._invokedFilters = filters;
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "setInvokedFilters", " invokedFilters --> " + this._invokedFilters);
        }
    }

    public boolean isCompleted() {
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "isCompleted", " completed --> " + this.completed);
        }
        return this.completed;
    }

    public void setCompleted(boolean completed) {
        this.completed = completed;
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "setCompleted", " completed --> " + completed);
        }
    }

    public boolean isArdRequest() {
        return this.ardRequest;
    }

    public void setArdRequest(boolean ardRequest) {
        this.ardRequest = ardRequest;
    }

    public void setAsyncMode(boolean b) {
        this.startAsync = b;
    }

    public IExtendedRequest getCurrentThreadsIExtendedRequest() {
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "getCurrentThreadsIExtendedRequest", " currentThreadsIExtendedRequest --> " + this.currentThreadsIExtendedRequest);
        }
        return this.currentThreadsIExtendedRequest;
    }

    public AsyncContext getAsyncContext() {
        return this.asyncContext;
    }

    public void setAsyncContext(AsyncContext asyncContext2) {
        this.asyncContext = asyncContext2;
    }

    public void setCurrentThreadsIExtendedResponse(IExtendedResponse hres) {
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "setCurrentThreadsIExtendedResponse", " new currentThreadsIExtendedResponse --> " + hres);
        }
        this.currentThreadsIExtendedResponse = hres;
    }

    public void setCookieAttributes(String cookieName, String cookieAttributes) {
        String[] attribute;
        String methodName = "setCookieAttributes";
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, methodName, " cookieName --> " + cookieName + " cookieAttribute --> " + cookieAttributes);
        }
        if (!(attribute = cookieAttributes.split("="))[0].equals("SameSite")) {
            logger.logp(Level.FINE, CLASS_NAME, methodName, " Only SameSite attribute is supported at this time.");
            return;
        }
        if (this.cookieAttributesMap == null) {
            this.cookieAttributesMap = new HashMap<String, String>();
        }
        this.cookieAttributesMap.put(cookieName, cookieAttributes);
    }

    public String getCookieAttributes(String cookieName) {
        String methodName = "getCookieAttributes";
        if (this.cookieAttributesMap == null) {
            return null;
        }
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, methodName, " cookieName --> " + cookieName);
        }
        String cookieAttributes = this.cookieAttributesMap.get(cookieName);
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, methodName, " cookieAttribute --> " + cookieAttributes);
        }
        return cookieAttributes;
    }

    public void removeCookieAttributes(String cookieName) {
        String methodName = "removeCookieAttributes";
        if (this.cookieAttributesMap == null) {
            return;
        }
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, methodName, " cookieName --> " + cookieName);
        }
        String removedAttributes = this.cookieAttributesMap.remove(cookieName);
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, methodName, "removedAttribute --> " + removedAttributes);
        }
    }
}

