/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.tools.common.plugins.util;

import com.sun.nio.file.SensitivityWatchEventModifier;
import io.openliberty.tools.ant.ServerTask;
import io.openliberty.tools.common.plugins.util.PluginExecutionException;
import io.openliberty.tools.common.plugins.util.PluginScenarioException;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileFilter;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.ServerSocket;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.nio.file.Watchable;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import java.util.Set;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileObject;
import javax.tools.StandardJavaFileManager;
import javax.tools.StandardLocation;
import javax.tools.ToolProvider;
import org.apache.commons.io.FileUtils;

public abstract class DevUtil {
    private static final String START_SERVER_MESSAGE_PREFIX = "CWWKF0011I:";
    private static final String START_APP_MESSAGE_REGEXP = "CWWKZ0001I.*";
    private static final String UPDATED_APP_MESSAGE_REGEXP = "CWWKZ0003I.*";
    private static final String PORT_IN_USE_MESSAGE_PREFIX = "CWWKO0221E:";
    private static final String WEB_APP_AVAILABLE_MESSAGE_PREFIX = "CWWKT0016I:";
    private static final String LISTENING_ON_PORT_MESSAGE_PREFIX = "CWWKO0219I:";
    private static final String HTTP_PREFIX = "http://";
    private static final String GENERATED_HEADER_REGEX = "# Generated by liberty-.*-plugin";
    private static final String[] IGNORE_DIRECTORY_PREFIXES = new String[]{"."};
    private static final String[] IGNORE_FILE_PREFIXES = new String[]{"."};
    private static final String[] IGNORE_FILE_POSTFIXES = new String[]{".dmp", "~", "___jb_tmp___", "___jb_old___"};
    private File serverDirectory;
    private File sourceDirectory;
    private File testSourceDirectory;
    private File configDirectory;
    private List<File> resourceDirs;
    private boolean hotTests;
    private Path tempConfigPath;
    private boolean skipTests;
    private boolean skipUTs;
    private boolean skipITs;
    private String applicationId;
    private int appStartupTimeout;
    private int appUpdateTimeout;
    private Thread serverThread;
    private AtomicBoolean devStop;
    private String hostName;
    private String httpPort;
    private String httpsPort;
    private final long compileWaitMillis;
    private AtomicBoolean inputUnavailable;
    private int alternativeDebugPort = -1;
    private boolean libertyDebug;
    private int libertyDebugPort;
    private AtomicBoolean detectedAppStarted;
    private HotkeyReader hotkeyReader = null;

    public abstract void debug(String var1);

    public abstract void debug(String var1, Throwable var2);

    public abstract void debug(Throwable var1);

    public abstract void warn(String var1);

    public abstract void info(String var1);

    public abstract void error(String var1);

    public abstract void error(String var1, Throwable var2);

    public abstract boolean isDebugEnabled();

    public abstract List<String> getArtifacts();

    public abstract boolean recompileBuildFile(File var1, List<String> var2, ThreadPoolExecutor var3);

    public abstract void runUnitTests() throws PluginScenarioException, PluginExecutionException;

    public abstract void runIntegrationTests() throws PluginScenarioException, PluginExecutionException;

    public abstract void checkConfigFile(File var1, File var2);

    public abstract boolean compile(File var1);

    public abstract void stopServer();

    public abstract ServerTask getServerTask() throws Exception;

    public DevUtil(File serverDirectory, File sourceDirectory, File testSourceDirectory, File configDirectory, List<File> resourceDirs, boolean hotTests, boolean skipTests, boolean skipUTs, boolean skipITs, String applicationId, int appStartupTimeout, int appUpdateTimeout, long compileWaitMillis, boolean libertyDebug) {
        this.serverDirectory = serverDirectory;
        this.sourceDirectory = sourceDirectory;
        this.testSourceDirectory = testSourceDirectory;
        this.configDirectory = configDirectory;
        this.resourceDirs = resourceDirs;
        this.hotTests = hotTests;
        this.skipTests = skipTests;
        this.skipUTs = skipUTs;
        this.skipITs = skipITs;
        this.applicationId = applicationId;
        this.appStartupTimeout = appStartupTimeout;
        this.appUpdateTimeout = appUpdateTimeout;
        this.devStop = new AtomicBoolean(false);
        this.compileWaitMillis = compileWaitMillis;
        this.inputUnavailable = new AtomicBoolean(false);
        this.libertyDebug = libertyDebug;
        this.detectedAppStarted = new AtomicBoolean(false);
    }

    public void runTests(boolean waitForApplicationUpdate, int messageOccurrences, ThreadPoolExecutor executor, boolean forceSkipUTs) {
        if (!this.skipTests) {
            ServerTask serverTask = null;
            try {
                serverTask = this.getServerTask();
            }
            catch (Exception e) {
                this.error("Could not get the server task for running tests.", e);
            }
            File logFile = serverTask.getLogFile();
            String regexp = UPDATED_APP_MESSAGE_REGEXP + this.applicationId;
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException e) {
                this.debug("Thread interrupted while waiting to start unit tests.", e);
            }
            if (executor.getQueue().size() >= 1) {
                Runnable head = (Runnable)executor.getQueue().peek();
                boolean manualInvocation = ((TestJob)head).isManualInvocation();
                if (manualInvocation) {
                    this.debug("Tests were re-invoked before previous tests began. Cancelling previous tests and resubmitting them.");
                } else {
                    this.debug("Changes were detected before tests began. Cancelling tests and resubmitting them.");
                }
                return;
            }
            if (!this.skipUTs && !forceSkipUTs) {
                this.info("Running unit tests...");
                try {
                    this.runUnitTests();
                    this.info("Unit tests finished.");
                }
                catch (PluginScenarioException e) {
                    this.debug(e);
                    this.error(e.getMessage());
                    return;
                }
                catch (PluginExecutionException e) {
                    this.error(e.getMessage());
                }
            }
            if (executor.getQueue().size() >= 1) {
                Runnable head = (Runnable)executor.getQueue().peek();
                boolean manualInvocation = ((TestJob)head).isManualInvocation();
                if (manualInvocation) {
                    this.info("Tests were invoked while previous tests were running. Restarting tests.");
                } else {
                    this.info("Changes were detected while tests were running. Restarting tests.");
                }
                return;
            }
            if (!this.skipITs) {
                if (!this.detectedAppStarted.get()) {
                    if (this.appStartupTimeout < 0) {
                        this.appStartupTimeout = 30;
                    }
                    long timeout = this.appStartupTimeout * 1000;
                    String logsDirectory = serverTask.getOutputDir() + "/" + serverTask.getServerName() + "/logs";
                    File messagesLogFile = new File(logsDirectory + "/messages.log");
                    this.info("Waiting up to " + this.appStartupTimeout + " seconds for the application to start up...");
                    String startMessage = serverTask.waitForStringInLog(START_APP_MESSAGE_REGEXP, timeout, messagesLogFile);
                    if (startMessage == null) {
                        this.error("Unable to verify if the application was started after " + this.appStartupTimeout + " seconds.  Consider increasing the verifyTimeout value if this continues to occur.");
                    } else {
                        this.detectedAppStarted.set(true);
                    }
                }
                if (waitForApplicationUpdate) {
                    if (this.appUpdateTimeout < 0) {
                        this.appUpdateTimeout = 5;
                    }
                    long timeout = this.appUpdateTimeout * 1000;
                    serverTask.waitForUpdatedStringInLog(regexp, timeout, logFile, messageOccurrences);
                }
                this.info("Running integration tests...");
                try {
                    this.runIntegrationTests();
                    this.info("Integration tests finished.");
                }
                catch (PluginScenarioException e) {
                    this.debug(e);
                    this.error(e.getMessage());
                    return;
                }
                catch (PluginExecutionException e) {
                    this.error(e.getMessage());
                }
            }
        }
    }

    public int countApplicationUpdatedMessages() {
        int messageOccurrences = -1;
        if (!this.skipTests && !this.skipITs) {
            try {
                ServerTask serverTask = this.getServerTask();
                File logFile = serverTask.getLogFile();
                String regexp = UPDATED_APP_MESSAGE_REGEXP + this.applicationId;
                messageOccurrences = serverTask.countStringOccurrencesInFile(regexp, logFile);
                this.debug("Message occurrences before compile: " + messageOccurrences);
            }
            catch (Exception e) {
                this.debug("Failed to get message occurrences before compile", e);
            }
        }
        return messageOccurrences;
    }

    public void startServer(long serverStartTimeout) throws PluginExecutionException {
        try {
            long serverStartTimeoutMillis;
            String startMessage;
            ServerTask serverTask;
            try {
                serverTask = this.getServerTask();
            }
            catch (Exception e) {
                throw new PluginExecutionException("An error occurred while starting the server: " + e.getMessage(), e);
            }
            String logsDirectory = serverTask.getOutputDir() + "/" + serverTask.getServerName() + "/logs";
            File messagesLogFile = new File(logsDirectory + "/messages.log");
            WatchService watchService = FileSystems.getDefault().newWatchService();
            boolean logsExist = new File(logsDirectory).isDirectory();
            if (logsExist) {
                Paths.get(logsDirectory, new String[0]).register(watchService, StandardWatchEventKinds.ENTRY_CREATE, StandardWatchEventKinds.ENTRY_MODIFY);
            }
            this.serverThread = new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        serverTask.execute();
                    }
                    catch (RuntimeException e) {
                        DevUtil.this.error("An error occurred while starting the server: " + e.getMessage(), e);
                        throw e;
                    }
                }
            });
            this.serverThread.start();
            if (logsExist) {
                WatchKey key;
                boolean messagesModified = false;
                while (!messagesModified && (key = watchService.take()) != null) {
                    for (WatchEvent<?> event : key.pollEvents()) {
                        if (!event.context().toString().equals("messages.log")) continue;
                        messagesModified = true;
                        this.debug("messages.log has been changed");
                    }
                    if (key.reset()) continue;
                }
            }
            if (serverStartTimeout < 0L) {
                serverStartTimeout = 30L;
            }
            if ((startMessage = serverTask.waitForStringInLog(START_SERVER_MESSAGE_PREFIX, serverStartTimeoutMillis = serverStartTimeout * 1000L, messagesLogFile)) == null) {
                this.setDevStop(true);
                this.stopServer();
                throw new PluginExecutionException("Unable to verify if the server was started after " + serverStartTimeoutMillis + " seconds.  Consider increasing the serverStartTimeout value if this continues to occur.");
            }
            String portError = serverTask.findStringInFile(PORT_IN_USE_MESSAGE_PREFIX, messagesLogFile);
            if (portError != null) {
                this.error(portError.split(PORT_IN_USE_MESSAGE_PREFIX)[1]);
            }
            this.parseHostNameAndPorts(serverTask, messagesLogFile);
        }
        catch (IOException | InterruptedException e) {
            throw new PluginExecutionException("An error occurred while starting the server: " + e.getMessage(), e);
        }
    }

    private void parseHostNameAndPorts(ServerTask serverTask, File messagesLogFile) throws PluginExecutionException {
        List listeningOnPortMessages;
        String webAppMessage = serverTask.findStringInFile(WEB_APP_AVAILABLE_MESSAGE_PREFIX, messagesLogFile);
        this.debug("Web app available message: " + webAppMessage);
        if (webAppMessage != null) {
            int portPrefixIndex = this.parseHostName(webAppMessage);
            this.parseHttpPort(webAppMessage, portPrefixIndex);
        }
        if ((listeningOnPortMessages = serverTask.findStringsInFile(LISTENING_ON_PORT_MESSAGE_PREFIX, messagesLogFile)) != null) {
            this.parseHttpsPort(listeningOnPortMessages);
        }
    }

    protected int parseHostName(String webAppMessage) throws PluginExecutionException {
        int httpPrefixIndex = webAppMessage.indexOf(HTTP_PREFIX);
        if (httpPrefixIndex < 0) {
            throw new PluginExecutionException("Could not parse the host name from the log message: " + webAppMessage);
        }
        int hostNameIndex = httpPrefixIndex + HTTP_PREFIX.length();
        int portPrefixIndex = webAppMessage.indexOf(":", hostNameIndex);
        if (portPrefixIndex < 0) {
            throw new PluginExecutionException("Could not parse the http port number from the log message: " + webAppMessage);
        }
        this.hostName = webAppMessage.substring(hostNameIndex, portPrefixIndex);
        this.debug("Parsed host name: " + this.hostName);
        return portPrefixIndex;
    }

    protected void parseHttpPort(String webAppMessage, int portPrefixIndex) {
        int portIndex = portPrefixIndex + 1;
        int portEndIndex = webAppMessage.indexOf("/", portIndex);
        if (portEndIndex < 0) {
            portEndIndex = webAppMessage.length();
        }
        this.httpPort = webAppMessage.substring(portIndex, portEndIndex);
        this.debug("Parsed http port: " + this.httpPort);
    }

    protected void parseHttpsPort(List<String> messages) throws PluginExecutionException {
        for (String message : messages) {
            String[] messageTokens;
            this.debug("Looking for https port in message: " + message);
            String httpsMessageContents = message.split(LISTENING_ON_PORT_MESSAGE_PREFIX)[1];
            for (String token : messageTokens = httpsMessageContents.split(" ")) {
                if (!token.contains("-ssl")) continue;
                String parsedHttpsPort = this.getPortFromMessageTokens(messageTokens);
                if (parsedHttpsPort != null) {
                    this.debug("Parsed https port: " + parsedHttpsPort);
                    this.httpsPort = parsedHttpsPort;
                    return;
                }
                throw new PluginExecutionException("Could not parse the https port number from the log message: " + message);
            }
        }
        this.debug("Could not find https port. The server might not be configured for https.");
    }

    private String getPortFromMessageTokens(String[] messageTokens) throws PluginExecutionException {
        for (int i = messageTokens.length - 1; i >= 0; --i) {
            String numericToken = messageTokens[i].replaceAll("[^\\d]", "");
            if (numericToken.length() <= 0) continue;
            try {
                int parsedPort = Integer.parseInt(numericToken);
                if (parsedPort > 65535) continue;
                return numericToken;
            }
            catch (NumberFormatException e) {
                this.debug("Could not parse integer from numeric token " + numericToken + " from message token " + messageTokens[i], e);
            }
        }
        return null;
    }

    public void cleanUpServerEnv() {
        block5: {
            try {
                File serverEnvBackup = new File(this.serverDirectory.getCanonicalPath() + "/server.env.bak");
                File serverEnvFile = new File(this.serverDirectory.getCanonicalPath() + "/server.env");
                if (serverEnvBackup.exists()) {
                    try {
                        Files.copy(serverEnvBackup.toPath(), serverEnvFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
                    }
                    catch (IOException e) {
                        this.error("Could not restore server.env: " + e.getMessage());
                    }
                    serverEnvBackup.delete();
                    break block5;
                }
                serverEnvFile.delete();
            }
            catch (IOException e) {
                this.error("Could not retrieve server.env: " + e.getMessage());
            }
        }
    }

    public void cleanUpTempConfig() {
        File tempConfig;
        if (this.tempConfigPath != null && (tempConfig = this.tempConfigPath.toFile()).exists()) {
            try {
                FileUtils.deleteDirectory((File)tempConfig);
                this.debug("Sucessfully deleted liberty:dev temporary configuration folder");
            }
            catch (IOException e) {
                this.error("Could not delete liberty:dev temporary configuration folder");
            }
        }
    }

    public void setDevStop(boolean devStop) {
        this.devStop.set(devStop);
    }

    public void addShutdownHook(final ThreadPoolExecutor executor) {
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                DevUtil.this.debug("Inside Shutdown Hook, shutting down server");
                DevUtil.this.cleanUpTempConfig();
                DevUtil.this.cleanUpServerEnv();
                DevUtil.this.setDevStop(true);
                if (DevUtil.this.hotkeyReader != null) {
                    DevUtil.this.hotkeyReader.shutdown();
                }
                executor.shutdown();
                DevUtil.this.stopServer();
            }
        });
    }

    public Map<String, String> getDebugEnvironmentVariables() throws IOException {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("WLP_DEBUG_SUSPEND", "n");
        map.put("WLP_DEBUG_ADDRESS", String.valueOf(this.findAvailablePort(this.libertyDebugPort)));
        return map;
    }

    public void enableServerDebug() throws IOException {
        this.enableServerDebug(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void enableServerDebug(boolean findAvailablePort) throws IOException {
        if (!this.libertyDebug) {
            return;
        }
        String serverEnvPath = this.serverDirectory.getCanonicalPath() + "/server.env";
        File serverEnvFile = new File(serverEnvPath);
        StringBuilder sb = new StringBuilder();
        File serverEnvBackup = new File(serverEnvPath + ".bak");
        if (serverEnvFile.exists()) {
            this.debug("server.env already exists");
            Files.copy(serverEnvFile.toPath(), serverEnvBackup.toPath(), StandardCopyOption.REPLACE_EXISTING);
            boolean deleted = serverEnvFile.delete();
            if (!deleted) {
                this.error("Could not move existing server.env file");
            }
            try (BufferedReader reader = new BufferedReader(new FileReader(serverEnvBackup));){
                String line;
                while ((line = reader.readLine()) != null) {
                    sb.append(line);
                    sb.append("\n");
                }
            }
        } else {
            serverEnvBackup.delete();
        }
        this.debug("Creating server.env file: " + serverEnvFile.getCanonicalPath());
        sb.append("WLP_DEBUG_SUSPEND=n\n");
        sb.append("WLP_DEBUG_ADDRESS=");
        if (findAvailablePort) {
            sb.append(this.findAvailablePort(this.libertyDebugPort));
        } else {
            sb.append(this.alternativeDebugPort == -1 ? this.libertyDebugPort : this.alternativeDebugPort);
        }
        sb.append("\n");
        try (BufferedWriter writer = new BufferedWriter(new FileWriter(serverEnvFile));){
            writer.write(sb.toString());
        }
        if (serverEnvFile.exists()) {
            this.debug("Successfully created liberty:dev server.env file");
        }
    }

    public int findAvailablePort(int preferredPort) throws IOException {
        int portToTry = preferredPort;
        if (this.alternativeDebugPort != -1) {
            portToTry = this.alternativeDebugPort;
        }
        try (ServerSocket serverSocket = null;){
            serverSocket = new ServerSocket();
            serverSocket.setReuseAddress(false);
            serverSocket.bind(new InetSocketAddress(InetAddress.getByName(null), portToTry), 1);
            int n = serverSocket.getLocalPort();
            return n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runHotkeyReaderThread(ThreadPoolExecutor executor) {
        if (this.inputUnavailable.get()) {
            return;
        }
        boolean startedNewHotkeyReader = false;
        if (this.hotkeyReader == null) {
            this.hotkeyReader = new HotkeyReader(executor);
            new Thread(this.hotkeyReader).start();
            this.debug("Started hotkey reader.");
            startedNewHotkeyReader = true;
        }
        if (!this.skipTests) {
            AtomicBoolean atomicBoolean = this.inputUnavailable;
            synchronized (atomicBoolean) {
                try {
                    if (startedNewHotkeyReader) {
                        this.inputUnavailable.wait(500L);
                    }
                    if (!this.inputUnavailable.get()) {
                        if (this.hotTests) {
                            this.info("Tests will run automatically when changes are detected. You can also press the Enter key to run tests on demand.");
                        } else {
                            this.info("Press the Enter key to run tests on demand.");
                        }
                    } else {
                        this.debug("Cannot read user input, setting hotTests to true.");
                        this.info("Tests will run automatically when changes are detected.");
                        this.hotTests = true;
                    }
                }
                catch (InterruptedException e) {
                    this.debug("Interrupted while waiting to determine whether input can be read", e);
                }
            }
        }
    }

    public void watchFiles(File buildFile, File outputDirectory, File testOutputDirectory, ThreadPoolExecutor executor, List<String> artifactPaths, File serverXmlFile) throws Exception {
        WatchService watcher = FileSystems.getDefault().newWatchService();
        Throwable throwable = null;
        try {
            try {
                File serverXmlFileParent = null;
                if (serverXmlFile != null && serverXmlFile.exists()) {
                    serverXmlFileParent = serverXmlFile.getParentFile();
                }
                Path srcPath = this.sourceDirectory.getCanonicalFile().toPath();
                Path testSrcPath = this.testSourceDirectory.getCanonicalFile().toPath();
                Path configPath = this.configDirectory.getCanonicalFile().toPath();
                boolean sourceDirRegistered = false;
                boolean testSourceDirRegistered = false;
                boolean configDirRegistered = false;
                boolean serverXmlFileRegistered = false;
                if (this.sourceDirectory.exists()) {
                    this.registerAll(srcPath, watcher);
                    sourceDirRegistered = true;
                }
                if (this.testSourceDirectory.exists()) {
                    this.registerAll(testSrcPath, watcher);
                    testSourceDirRegistered = true;
                }
                if (this.configDirectory.exists()) {
                    this.registerAll(configPath, watcher);
                    configDirRegistered = true;
                }
                if (serverXmlFile != null && serverXmlFile.exists() && serverXmlFileParent.exists()) {
                    Path serverXmlFilePath = serverXmlFileParent.getCanonicalFile().toPath();
                    this.registerAll(serverXmlFilePath, watcher);
                    serverXmlFileRegistered = true;
                }
                HashMap<File, Boolean> resourceMap = new HashMap<File, Boolean>();
                for (File resourceDir : this.resourceDirs) {
                    resourceMap.put(resourceDir, false);
                    if (!resourceDir.exists()) continue;
                    this.registerAll(resourceDir.getCanonicalFile().toPath(), watcher);
                    resourceMap.put(resourceDir, true);
                }
                buildFile.getParentFile().toPath().register(watcher, new WatchEvent.Kind[]{StandardWatchEventKinds.ENTRY_MODIFY, StandardWatchEventKinds.ENTRY_DELETE, StandardWatchEventKinds.ENTRY_CREATE}, SensitivityWatchEventModifier.HIGH);
                this.debug("Watching build file directory: " + buildFile.getParentFile().toPath());
                HashSet<File> recompileJavaSources = new HashSet<File>();
                HashSet<File> recompileJavaTests = new HashSet<File>();
                HashSet<File> deleteJavaSources = new HashSet<File>();
                HashSet<File> deleteJavaTests = new HashSet<File>();
                long lastJavaSourceChange = System.currentTimeMillis();
                long lastJavaTestChange = System.currentTimeMillis();
                while (true) {
                    boolean processTests;
                    if (this.serverThread.getState().equals((Object)Thread.State.TERMINATED) && !this.devStop.get()) {
                        throw new PluginScenarioException("The server has stopped. Exiting dev mode.");
                    }
                    boolean processSources = System.currentTimeMillis() > lastJavaSourceChange + this.compileWaitMillis;
                    boolean bl = processTests = System.currentTimeMillis() > lastJavaTestChange + this.compileWaitMillis;
                    if (processSources) {
                        if (!deleteJavaSources.isEmpty()) {
                            this.debug("Deleting Java source files: " + deleteJavaSources);
                            for (File file : deleteJavaSources) {
                                this.deleteJavaFile(file, outputDirectory, this.sourceDirectory);
                            }
                        }
                        if (!recompileJavaSources.isEmpty()) {
                            this.debug("Recompiling Java source files: " + recompileJavaSources);
                            this.recompileJavaSource(recompileJavaSources, artifactPaths, executor, outputDirectory, testOutputDirectory);
                        }
                        if (processTests) {
                            if (!deleteJavaTests.isEmpty()) {
                                this.debug("Deleting Java test files: " + deleteJavaTests);
                                for (File file : deleteJavaTests) {
                                    this.deleteJavaFile(file, testOutputDirectory, this.testSourceDirectory);
                                }
                            }
                            if (!recompileJavaTests.isEmpty()) {
                                this.debug("Recompiling Java test files: " + recompileJavaTests);
                                this.recompileJavaTest(recompileJavaTests, artifactPaths, executor, outputDirectory, testOutputDirectory);
                            }
                        }
                        if (!deleteJavaSources.isEmpty() && recompileJavaSources.isEmpty()) {
                            int numApplicationUpdatedMessages = this.countApplicationUpdatedMessages();
                            this.runTestThread(true, executor, numApplicationUpdatedMessages, false, false);
                        } else if (processTests && !deleteJavaTests.isEmpty() && recompileJavaTests.isEmpty()) {
                            this.runTestThread(false, executor, -1, false, false);
                        }
                        deleteJavaSources.clear();
                        recompileJavaSources.clear();
                        if (processTests) {
                            deleteJavaTests.clear();
                            recompileJavaTests.clear();
                        }
                    }
                    if (!sourceDirRegistered && this.sourceDirectory.exists() && this.sourceDirectory.listFiles().length > 0) {
                        this.compile(this.sourceDirectory);
                        this.registerAll(srcPath, watcher);
                        this.debug("Registering Java source directory: " + this.sourceDirectory);
                        sourceDirRegistered = true;
                    } else if (sourceDirRegistered && !this.sourceDirectory.exists()) {
                        this.cleanTargetDir(outputDirectory);
                        sourceDirRegistered = false;
                    }
                    if (!testSourceDirRegistered && this.testSourceDirectory.exists() && this.testSourceDirectory.listFiles().length > 0) {
                        this.compile(this.testSourceDirectory);
                        this.registerAll(testSrcPath, watcher);
                        this.debug("Registering Java test directory: " + this.testSourceDirectory);
                        this.runTestThread(false, executor, -1, false, false);
                        testSourceDirRegistered = true;
                    } else if (testSourceDirRegistered && !this.testSourceDirectory.exists()) {
                        this.cleanTargetDir(testOutputDirectory);
                        testSourceDirRegistered = false;
                    }
                    if (!configDirRegistered && this.configDirectory.exists()) {
                        configDirRegistered = true;
                        if (serverXmlFile != null && !serverXmlFile.exists()) {
                            this.registerAll(configPath, watcher);
                            this.debug("Registering configuration directory: " + this.configDirectory);
                        } else {
                            this.info("The server configuration directory " + this.configDirectory + " has been added. Restart liberty:dev mode for it to take effect.");
                        }
                    }
                    if (!serverXmlFileRegistered && serverXmlFile != null && serverXmlFile.exists()) {
                        serverXmlFileRegistered = true;
                        this.debug("Server configuration file has been added: " + serverXmlFile);
                        this.info("The server configuration file " + serverXmlFile + " has been added. Restart liberty:dev mode for it to take effect.");
                    }
                    for (File resourceDir : this.resourceDirs) {
                        if (((Boolean)resourceMap.get(resourceDir)).booleanValue() || !resourceDir.exists()) continue;
                        this.registerAll(resourceDir.getCanonicalFile().toPath(), watcher);
                        resourceMap.put(resourceDir, true);
                    }
                    try {
                        boolean valid;
                        WatchKey wk = watcher.poll(100L, TimeUnit.MILLISECONDS);
                        Watchable watchable = wk.watchable();
                        Path directory = (Path)watchable;
                        List<WatchEvent<?>> events = wk.pollEvents();
                        for (WatchEvent<?> event : events) {
                            boolean recompiledBuild;
                            ArrayList<File> javaFilesChanged;
                            Path changed = (Path)event.context();
                            this.debug("Processing events for watched directory: " + directory);
                            File fileChanged = new File(directory.toString(), changed.toString());
                            if (this.ignoreFileOrDir(fileChanged)) continue;
                            this.debug("Changed: " + changed + "; " + event.kind());
                            File resourceParent = null;
                            for (File resourceDir : this.resourceDirs) {
                                if (!directory.startsWith(resourceDir.getCanonicalFile().toPath())) continue;
                                resourceParent = resourceDir;
                                break;
                            }
                            if (fileChanged.isDirectory()) {
                                if (event.kind() != StandardWatchEventKinds.ENTRY_CREATE) break;
                                this.registerAll(fileChanged.toPath(), watcher);
                                break;
                            }
                            int numApplicationUpdatedMessages = this.countApplicationUpdatedMessages();
                            if (directory.startsWith(srcPath)) {
                                javaFilesChanged = new ArrayList<File>();
                                javaFilesChanged.add(fileChanged);
                                if (fileChanged.exists() && fileChanged.getName().endsWith(".java") && (event.kind() == StandardWatchEventKinds.ENTRY_MODIFY || event.kind() == StandardWatchEventKinds.ENTRY_CREATE)) {
                                    this.debug("Java source file modified: " + fileChanged.getName() + ". Adding to list for processing.");
                                    lastJavaSourceChange = System.currentTimeMillis();
                                    recompileJavaSources.add(fileChanged);
                                    continue;
                                }
                                if (event.kind() != StandardWatchEventKinds.ENTRY_DELETE) continue;
                                this.debug("Java file deleted: " + fileChanged.getName() + ". Adding to list for processing.");
                                lastJavaSourceChange = System.currentTimeMillis();
                                deleteJavaSources.add(fileChanged);
                                continue;
                            }
                            if (directory.startsWith(testSrcPath)) {
                                javaFilesChanged = new ArrayList();
                                javaFilesChanged.add(fileChanged);
                                if (fileChanged.exists() && fileChanged.getName().endsWith(".java") && (event.kind() == StandardWatchEventKinds.ENTRY_MODIFY || event.kind() == StandardWatchEventKinds.ENTRY_CREATE)) {
                                    this.debug("Java test file modified: " + fileChanged.getName() + ". Adding to list for processing.");
                                    lastJavaTestChange = System.currentTimeMillis();
                                    recompileJavaTests.add(fileChanged);
                                    continue;
                                }
                                if (event.kind() != StandardWatchEventKinds.ENTRY_DELETE) continue;
                                this.debug("Java test file deleted: " + fileChanged.getName() + ". Adding to list for processing.");
                                lastJavaTestChange = System.currentTimeMillis();
                                deleteJavaTests.add(fileChanged);
                                continue;
                            }
                            if (directory.startsWith(configPath) && !this.isGeneratedConfigFile(fileChanged, this.configDirectory, this.serverDirectory)) {
                                if (fileChanged.exists() && (event.kind() == StandardWatchEventKinds.ENTRY_MODIFY || event.kind() == StandardWatchEventKinds.ENTRY_CREATE)) {
                                    this.copyConfigFolder(fileChanged, this.configDirectory, null);
                                    this.copyFile(fileChanged, this.configDirectory, this.serverDirectory, null);
                                    if (fileChanged.getName().equals("server.env")) {
                                        this.enableServerDebug(false);
                                    }
                                    this.runTestThread(true, executor, numApplicationUpdatedMessages, true, false);
                                    continue;
                                }
                                if (event.kind() != StandardWatchEventKinds.ENTRY_DELETE) continue;
                                this.info("Config file deleted: " + fileChanged.getName());
                                this.deleteFile(fileChanged, this.configDirectory, this.serverDirectory, null);
                                if (fileChanged.getName().equals("server.env")) {
                                    this.enableServerDebug(false);
                                }
                                this.runTestThread(true, executor, numApplicationUpdatedMessages, true, false);
                                continue;
                            }
                            if (serverXmlFileParent != null && directory.startsWith(serverXmlFileParent.getCanonicalFile().toPath())) {
                                if (fileChanged.exists() && fileChanged.getCanonicalPath().endsWith(serverXmlFile.getName()) && (event.kind() == StandardWatchEventKinds.ENTRY_MODIFY || event.kind() == StandardWatchEventKinds.ENTRY_CREATE)) {
                                    this.copyConfigFolder(fileChanged, serverXmlFileParent, "server.xml");
                                    this.copyFile(fileChanged, serverXmlFileParent, this.serverDirectory, "server.xml");
                                    this.runTestThread(true, executor, numApplicationUpdatedMessages, true, false);
                                    continue;
                                }
                                if (event.kind() != StandardWatchEventKinds.ENTRY_DELETE || !fileChanged.getCanonicalPath().endsWith(serverXmlFile.getName())) continue;
                                this.info("Config file deleted: " + fileChanged.getName());
                                this.deleteFile(fileChanged, this.configDirectory, this.serverDirectory, "server.xml");
                                this.runTestThread(true, executor, numApplicationUpdatedMessages, true, false);
                                continue;
                            }
                            if (resourceParent != null && directory.startsWith(resourceParent.getCanonicalFile().toPath())) {
                                this.debug("Resource dir: " + resourceParent.toString());
                                this.debug("File within resource directory");
                                if (fileChanged.exists() && (event.kind() == StandardWatchEventKinds.ENTRY_MODIFY || event.kind() == StandardWatchEventKinds.ENTRY_CREATE)) {
                                    this.copyFile(fileChanged, resourceParent, outputDirectory, null);
                                    this.runTestThread(true, executor, numApplicationUpdatedMessages, false, false);
                                    continue;
                                }
                                if (event.kind() != StandardWatchEventKinds.ENTRY_DELETE) continue;
                                this.debug("Resource file deleted: " + fileChanged.getName());
                                this.deleteFile(fileChanged, resourceParent, outputDirectory, null);
                                this.runTestThread(true, executor, numApplicationUpdatedMessages, false, false);
                                continue;
                            }
                            if (!fileChanged.equals(buildFile) || !directory.startsWith(buildFile.getParentFile().getCanonicalFile().toPath()) || event.kind() != StandardWatchEventKinds.ENTRY_MODIFY || !(recompiledBuild = this.recompileBuildFile(buildFile, artifactPaths, executor))) continue;
                            this.runTestThread(true, executor, numApplicationUpdatedMessages, false, false);
                        }
                        if (valid = wk.reset()) continue;
                        this.debug("WatchService key has been unregistered");
                    }
                    catch (InterruptedException | NullPointerException exception) {}
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
        catch (Throwable throwable3) {
            if (watcher != null) {
                if (throwable != null) {
                    try {
                        watcher.close();
                    }
                    catch (Throwable throwable4) {
                        throwable.addSuppressed(throwable4);
                    }
                } else {
                    watcher.close();
                }
            }
            throw throwable3;
        }
    }

    protected boolean isGeneratedConfigFile(File fileChanged, File srcDir, File targetDir) throws IOException {
        return (fileChanged.getName().equals("bootstrap.properties") || fileChanged.getName().equals("jvm.options")) && this.isGeneratedTargetFile(fileChanged, srcDir, targetDir);
    }

    /*
     * Exception decompiling
     */
    private boolean isGeneratedTargetFile(File fileChanged, File srcDir, File targetDir) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public String readFile(File file) throws IOException {
        return FileUtils.readFileToString((File)file, (Charset)StandardCharsets.UTF_8);
    }

    public void copyConfigFolder(File fileChanged, File srcDir, String targetFileName) throws IOException {
        this.tempConfigPath = Files.createTempDirectory("tempConfig", new FileAttribute[0]);
        File tempConfig = this.tempConfigPath.toFile();
        this.debug("Temporary configuration folder created: " + tempConfig);
        FileUtils.copyDirectory((File)this.serverDirectory, (File)tempConfig, (FileFilter)new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                String name = pathname.getName();
                boolean skip = DevUtil.this.ignoreFileOrDir(pathname) || pathname.isDirectory() && (name.equals("workarea") || name.equals("logs"));
                return !skip;
            }
        }, (boolean)true);
        this.copyFile(fileChanged, srcDir, tempConfig, targetFileName);
        this.checkConfigFile(fileChanged, tempConfig);
        this.cleanUpTempConfig();
    }

    private boolean ignoreFileOrDir(File file) {
        String name = file.getName();
        if (file.isDirectory()) {
            for (String prefix : IGNORE_DIRECTORY_PREFIXES) {
                if (!name.startsWith(prefix)) continue;
                this.debug("Ignoring " + name);
                return true;
            }
        } else {
            for (String prefix : IGNORE_FILE_PREFIXES) {
                if (!name.startsWith(prefix)) continue;
                this.debug("Ignoring " + name);
                return true;
            }
            for (String postfix : IGNORE_FILE_POSTFIXES) {
                if (!name.endsWith(postfix)) continue;
                this.debug("Ignoring " + name);
                return true;
            }
        }
        return false;
    }

    public void copyFile(File fileChanged, File srcDir, File targetDir, String targetFileName) throws IOException {
        File targetResource = this.getTargetFile(fileChanged, srcDir, targetDir, targetFileName);
        try {
            FileUtils.copyFile((File)fileChanged, (File)targetResource);
            this.info("Copied file: " + fileChanged.getCanonicalPath() + " to: " + targetResource.getCanonicalPath());
        }
        catch (FileNotFoundException ex) {
            this.debug("Failed to copy file: " + fileChanged.getCanonicalPath());
        }
        catch (Exception ex) {
            this.debug(ex);
        }
    }

    private File getTargetFile(File fileChanged, File srcDir, File targetDir, String targetFileName) throws IOException {
        String relPath = fileChanged.getCanonicalPath().substring(fileChanged.getCanonicalPath().indexOf(srcDir.getCanonicalPath()) + srcDir.getCanonicalPath().length());
        if (targetFileName != null) {
            relPath = relPath.substring(0, relPath.indexOf(fileChanged.getName())) + targetFileName;
        }
        File targetResource = new File(targetDir.getCanonicalPath() + relPath);
        return targetResource;
    }

    protected void deleteFile(File deletedFile, File dir, File targetDir, String targetFileName) throws IOException {
        this.debug("File that was deleted: " + deletedFile.getCanonicalPath());
        File targetFile = this.getTargetFile(deletedFile, dir, targetDir, targetFileName);
        this.debug("Target file exists: " + targetFile.exists());
        if (targetFile.exists()) {
            if (targetFile.delete()) {
                this.info("Deleted file" + targetFile.getCanonicalPath());
            } else {
                this.error("Error deleting file " + targetFile.getCanonicalPath());
            }
        }
    }

    protected void cleanTargetDir(File outputDirectory) {
        File[] fList = outputDirectory.listFiles();
        if (fList != null) {
            for (File file : fList) {
                if (file.isFile() && file.getName().toLowerCase().endsWith(".class")) {
                    file.delete();
                    this.info("Deleted Java class file: " + file);
                    continue;
                }
                if (!file.isDirectory()) continue;
                this.cleanTargetDir(file);
            }
        }
        if (outputDirectory.listFiles().length == 0) {
            outputDirectory.delete();
        }
    }

    protected void registerAll(Path start, final WatchService watcher) throws IOException {
        Files.walkFileTree(start, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                DevUtil.this.debug("Watching directory: " + dir.toString());
                dir.register(watcher, new WatchEvent.Kind[]{StandardWatchEventKinds.ENTRY_MODIFY, StandardWatchEventKinds.ENTRY_DELETE, StandardWatchEventKinds.ENTRY_CREATE}, SensitivityWatchEventModifier.HIGH);
                return FileVisitResult.CONTINUE;
            }
        });
    }

    protected File getFileFromConfigDirectory(String file) {
        File f = new File(this.configDirectory, file);
        if (this.configDirectory != null && f.exists()) {
            return f;
        }
        return null;
    }

    protected void deleteJavaFile(File fileChanged, File classesDir, File compileSourceRoot) throws IOException {
        if (fileChanged.getName().endsWith(".java")) {
            String fileName = fileChanged.getName().substring(0, fileChanged.getName().indexOf(".java"));
            File parentFile = fileChanged.getParentFile();
            String relPath = parentFile.getCanonicalPath().substring(parentFile.getCanonicalPath().indexOf(compileSourceRoot.getCanonicalPath()) + compileSourceRoot.getCanonicalPath().length()) + "/" + fileName + ".class";
            File targetFile = new File(classesDir.getCanonicalPath() + relPath);
            if (targetFile.exists()) {
                targetFile.delete();
                this.info("Java class deleted: " + targetFile.getCanonicalPath());
            }
        } else {
            this.debug("File deleted but was not a java file: " + fileChanged.getName());
        }
    }

    protected void recompileJavaSource(Collection<File> javaFilesChanged, List<String> artifactPaths, ThreadPoolExecutor executor, File outputDirectory, File testOutputDirectory) throws PluginExecutionException {
        this.recompileJava(javaFilesChanged, artifactPaths, executor, false, outputDirectory, testOutputDirectory);
    }

    protected void recompileJavaTest(Collection<File> javaFilesChanged, List<String> artifactPaths, ThreadPoolExecutor executor, File outputDirectory, File testOutputDirectory) throws PluginExecutionException {
        this.recompileJava(javaFilesChanged, artifactPaths, executor, true, outputDirectory, testOutputDirectory);
    }

    protected void recompileJava(Collection<File> javaFilesChanged, List<String> artifactPaths, ThreadPoolExecutor executor, boolean tests, File outputDirectory, File testOutputDirectory) throws PluginExecutionException {
        try {
            File classesDir;
            int messageOccurrences = this.countApplicationUpdatedMessages();
            File file = classesDir = tests ? testOutputDirectory : outputDirectory;
            if (!classesDir.exists() && !classesDir.mkdirs()) {
                throw new PluginExecutionException("The classes output directory " + classesDir.getAbsolutePath() + " does not exist and cannot be created.");
            }
            ArrayList<String> optionList = new ArrayList<String>();
            ArrayList<File> outputDirs = new ArrayList<File>();
            if (tests) {
                outputDirs.add(outputDirectory);
                outputDirs.add(testOutputDirectory);
            } else {
                outputDirs.add(outputDirectory);
            }
            Set<File> classPathElems = this.getClassPath(artifactPaths, outputDirs);
            JavaCompiler compiler = ToolProvider.getSystemJavaCompiler();
            StandardJavaFileManager fileManager = compiler.getStandardFileManager(null, null, null);
            fileManager.setLocation(StandardLocation.CLASS_PATH, classPathElems);
            fileManager.setLocation(StandardLocation.CLASS_OUTPUT, Collections.singleton(classesDir));
            HashSet<JavaFileObject> compilationUnits = new HashSet<JavaFileObject>();
            for (File file2 : javaFilesChanged) {
                if (file2.exists() && file2.isFile()) {
                    for (JavaFileObject javaFileObject : fileManager.getJavaFileObjects(file2)) {
                        compilationUnits.add(javaFileObject);
                    }
                    continue;
                }
                this.debug("The Java file " + file2 + " does not exist and will not be compiled.");
            }
            JavaCompiler.CompilationTask task = compiler.getTask(null, fileManager, null, optionList, null, compilationUnits);
            boolean didCompile = task.call();
            if (didCompile) {
                if (tests) {
                    this.info("Tests compilation was successful.");
                } else {
                    this.info("Source compilation was successful.");
                }
                if (tests) {
                    this.runTestThread(false, executor, -1, false, false);
                } else {
                    this.runTestThread(true, executor, messageOccurrences, false, false);
                }
            } else if (tests) {
                this.info("Tests compilation had errors.");
            } else {
                this.info("Source compilation had errors.");
            }
        }
        catch (Exception e) {
            this.debug("Error compiling java files", e);
        }
    }

    protected Set<File> getClassPath(List<String> artifactPaths, List<File> outputDirs) throws IOException {
        ArrayList<URL> urls = new ArrayList<URL>();
        for (ClassLoader c = Thread.currentThread().getContextClassLoader(); c != null; c = c.getParent()) {
            if (!(c instanceof URLClassLoader)) continue;
            urls.addAll(Arrays.asList(((URLClassLoader)c).getURLs()));
        }
        HashSet<String> parsedFiles = new HashSet<String>();
        ArrayDeque<String> toParse = new ArrayDeque<String>();
        for (URL url : urls) {
            toParse.add(new File(url.getPath()).getCanonicalPath());
        }
        for (String artifactPath : artifactPaths) {
            toParse.add(new File(artifactPath).getCanonicalPath());
        }
        HashSet<File> classPathElements = new HashSet<File>();
        classPathElements.addAll(outputDirs);
        while (!toParse.isEmpty()) {
            String s = (String)toParse.poll();
            if (parsedFiles.contains(s)) continue;
            parsedFiles.add(s);
            File file = new File(s);
            if (!file.exists() || !file.getName().endsWith(".jar")) continue;
            classPathElements.add(file);
            if (file.isDirectory()) continue;
            try {
                JarFile jar = new JarFile(file);
                Throwable throwable = null;
                try {
                    Object classPath;
                    Manifest mf = jar.getManifest();
                    if (mf == null || mf.getMainAttributes() == null || (classPath = mf.getMainAttributes().get(Attributes.Name.CLASS_PATH)) == null) continue;
                    for (String i : classPath.toString().split(" ")) {
                        File f;
                        try {
                            URL u = new URL(i);
                            f = new File(u.getPath());
                        }
                        catch (MalformedURLException e) {
                            f = new File(file.getParentFile(), i);
                        }
                        if (!f.exists()) continue;
                        toParse.add(f.getCanonicalPath());
                    }
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (jar == null) continue;
                    if (throwable != null) {
                        try {
                            jar.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    jar.close();
                }
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to open class path file " + file, e);
            }
        }
        return classPathElements;
    }

    public void runTestThread(boolean waitForApplicationUpdate, ThreadPoolExecutor executor, int messageOccurrences, boolean forceSkipUTs, boolean manualInvocation) {
        try {
            if (manualInvocation || this.hotTests) {
                executor.execute(new TestJob(waitForApplicationUpdate, messageOccurrences, executor, forceSkipUTs, manualInvocation));
            }
        }
        catch (RejectedExecutionException e) {
            this.debug("Cannot add thread since max threads reached", e);
        }
    }

    public String getHostName() {
        return this.hostName;
    }

    public String getHttpPort() {
        return this.httpPort;
    }

    public String getHttpsPort() {
        return this.httpsPort;
    }

    public void setLibertyDebugPort(int libertyDebugPort) {
        this.libertyDebugPort = libertyDebugPort;
    }

    public class TestJob
    implements Runnable {
        private boolean waitForApplicationUpdate;
        private int messageOccurrences;
        private ThreadPoolExecutor executor;
        private boolean forceSkipUTs;
        private boolean manualInvocation;

        public TestJob(boolean waitForApplicationUpdate, int messageOccurrences, ThreadPoolExecutor executor, boolean forceSkipUTs, boolean manualInvocation) {
            this.waitForApplicationUpdate = waitForApplicationUpdate;
            this.messageOccurrences = messageOccurrences;
            this.executor = executor;
            this.forceSkipUTs = forceSkipUTs;
            this.manualInvocation = manualInvocation;
        }

        @Override
        public void run() {
            try {
                DevUtil.this.runTests(this.waitForApplicationUpdate, this.messageOccurrences, this.executor, this.forceSkipUTs);
            }
            finally {
                DevUtil.this.runHotkeyReaderThread(this.executor);
            }
        }

        public boolean isManualInvocation() {
            return this.manualInvocation;
        }
    }

    private class HotkeyReader
    implements Runnable {
        private Scanner scanner;
        private ThreadPoolExecutor executor;
        private boolean shutdown = false;

        public HotkeyReader(ThreadPoolExecutor executor) {
            this.executor = executor;
        }

        @Override
        public void run() {
            DevUtil.this.debug("Running hotkey reader thread");
            this.scanner = new Scanner(System.in);
            try {
                this.readInput();
            }
            finally {
                this.scanner.close();
            }
        }

        public void shutdown() {
            this.shutdown = true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void readInput() {
            if (this.scanner.hasNextLine()) {
                AtomicBoolean atomicBoolean = DevUtil.this.inputUnavailable;
                synchronized (atomicBoolean) {
                    DevUtil.this.inputUnavailable.notify();
                }
                while (!this.shutdown) {
                    DevUtil.this.debug("Waiting for Enter key to run tests");
                    if (this.scanner.hasNextLine()) {
                        String line = this.scanner.nextLine();
                        if (line != null && (line.trim().equalsIgnoreCase("q") || line.trim().equalsIgnoreCase("quit") || line.trim().equalsIgnoreCase("exit"))) {
                            DevUtil.this.debug("Detected exit command");
                            System.exit(0);
                            continue;
                        }
                        DevUtil.this.debug("Detected Enter key. Running tests...");
                        DevUtil.this.runTestThread(false, this.executor, -1, false, true);
                        continue;
                    }
                    break;
                }
            } else {
                AtomicBoolean atomicBoolean = DevUtil.this.inputUnavailable;
                synchronized (atomicBoolean) {
                    DevUtil.this.inputUnavailable.set(true);
                    DevUtil.this.inputUnavailable.notify();
                }
            }
            DevUtil.this.debug("Hotkey reader thread was shut down");
        }
    }
}

