/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.tools.ant;

import io.openliberty.tools.ant.FeatureManagerTask;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.apache.tools.ant.BuildException;

public class InstallFeatureTask
extends FeatureManagerTask {
    private boolean acceptLicense = false;
    private String to;
    private String whenFileExists;
    private String from;

    public void execute() {
        this.initTask();
        File f = new File(this.cmd);
        if (f.exists()) {
            try {
                this.doInstall();
            }
            catch (BuildException e) {
                throw e;
            }
            catch (Exception e) {
                throw new BuildException((Throwable)e);
            }
        } else {
            this.log("The installUtility is not available on this Liberty runtime. Any features specified in the build will not be installed.", 1);
        }
    }

    private void doInstall() throws Exception {
        List<String> command = this.initCommand();
        if (this.name != null && !this.name.isEmpty()) {
            String[] names;
            for (String featureName : names = this.name.trim().split("\\s*,\\s*")) {
                if (this.name.isEmpty()) continue;
                command.add(featureName);
            }
        }
        if (!this.features.isEmpty()) {
            for (FeatureManagerTask.Feature feature : this.features) {
                command.add(feature.getFeature());
            }
        }
        if (this.features.isEmpty() && (this.name == null || this.name.isEmpty())) {
            command.add(this.serverName);
        }
        this.processCommand(command);
    }

    private List<String> initCommand() {
        ArrayList<String> command = new ArrayList<String>();
        command.add(this.cmd);
        command.add("install");
        if (this.acceptLicense) {
            command.add("--acceptLicense");
        } else {
            command.add("--viewLicenseAgreement");
        }
        if (this.to != null) {
            command.add("--to=" + this.to);
        }
        if (this.from != null) {
            command.add("--from=" + this.from);
        }
        return command;
    }

    private void processCommand(List<String> command) throws Exception {
        this.processBuilder.command(command);
        Process p = this.processBuilder.start();
        this.checkReturnCode(p, this.processBuilder.command().toString(), FeatureManagerTask.ReturnCode.OK.getValue(), FeatureManagerTask.ReturnCode.ALREADY_EXISTS.getValue());
        if (!this.acceptLicense) {
            throw new BuildException("To install a feature, you must accept the feature's license terms and conditions.");
        }
    }

    public boolean isAcceptLicense() {
        return this.acceptLicense;
    }

    public void setAcceptLicense(boolean acceptLicense) {
        this.acceptLicense = acceptLicense;
    }

    public String getTo() {
        return this.to;
    }

    public void setTo(String to) {
        this.to = to;
    }

    @Deprecated
    public String getWhenFileExists() {
        return this.whenFileExists;
    }

    @Deprecated
    public void setWhenFileExists(String whenFileExists) {
        this.whenFileExists = whenFileExists;
    }

    public String getFrom() {
        return this.from;
    }

    public void setFrom(String from) {
        this.from = from;
    }
}

