/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.tools.ant.install;

import io.openliberty.tools.ant.install.InstallUtils;
import io.openliberty.tools.ant.install.UnixPermissions;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import org.apache.tools.zip.ZipEntry;
import org.apache.tools.zip.ZipFile;

public class Unzip {
    public static void unzipToDirectory(File file, File destDir) throws IOException {
        ZipFile zipFile = new ZipFile(file);
        try {
            Unzip.unzipToDirectory(zipFile, destDir);
        }
        finally {
            ZipFile.closeQuietly((ZipFile)zipFile);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void unzipToDirectory(ZipFile zipFile, File destDir) throws IOException {
        byte[] buffer = new byte[4096];
        Enumeration entries = zipFile.getEntries();
        while (entries.hasMoreElements()) {
            ZipEntry entry = (ZipEntry)entries.nextElement();
            if (entry.isDirectory()) {
                File dir = new File(destDir, entry.getName());
                InstallUtils.createDirectory(dir);
                continue;
            }
            File file = new File(destDir, entry.getName());
            InstallUtils.createDirectory(file.getParentFile());
            BufferedOutputStream out = null;
            InputStream in = null;
            try {
                out = new BufferedOutputStream(new FileOutputStream(file));
                in = zipFile.getInputStream(entry);
                Unzip.copy(in, out, buffer);
            }
            catch (Throwable throwable) {
                InstallUtils.close(in);
                InstallUtils.close(out);
                throw throwable;
            }
            InstallUtils.close(in);
            InstallUtils.close(out);
            Unzip.setFilePermissions(file, entry);
        }
    }

    private static void copy(InputStream in, OutputStream out, byte[] buffer) throws IOException {
        int count;
        while ((count = in.read(buffer)) > 0) {
            out.write(buffer, 0, count);
        }
        out.flush();
    }

    private static void setFilePermissions(File file, ZipEntry entry) {
        UnixPermissions perm;
        int permissions = entry.getUnixMode();
        if (permissions != 0 && ((perm = new UnixPermissions(permissions)).isOwnerExecute() || perm.isGroupExecute() || perm.isOwnerExecute())) {
            file.setExecutable(true);
        }
    }
}

