/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.tools.maven.server;

import io.openliberty.tools.ant.FeatureManagerTask;
import io.openliberty.tools.ant.UninstallFeatureTask;
import io.openliberty.tools.maven.BasicSupport;
import io.openliberty.tools.maven.server.types.Features;
import java.text.MessageFormat;
import java.util.ArrayList;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name="uninstall-feature")
public class UninstallFeatureMojo
extends BasicSupport {
    @Parameter
    private Features features;

    protected void doExecute() throws Exception {
        if (this.skip) {
            this.getLog().info((CharSequence)"\nSkipping uninstall-feature goal.\n");
            return;
        }
        if (this.features == null) {
            return;
        }
        if (this.features.getFeatures().size() <= 0) {
            throw new MojoExecutionException(messages.getString("error.install.feature.set.validate"));
        }
        UninstallFeatureTask uninstallFeatureTask = (UninstallFeatureTask)this.ant.createTask("antlib:io/openliberty/tools/ant:uninstall-feature");
        if (uninstallFeatureTask == null) {
            throw new IllegalStateException(MessageFormat.format(messages.getString("error.dependencies.not.found"), "uninstall-feature"));
        }
        uninstallFeatureTask.setInstallDir(this.installDirectory);
        uninstallFeatureTask.setServerName(this.serverName);
        uninstallFeatureTask.setUserDir(this.userDirectory);
        uninstallFeatureTask.setOutputDir(this.outputDirectory);
        StringBuilder featureFailures = new StringBuilder();
        for (FeatureManagerTask.Feature f : this.features.getFeatures()) {
            try {
                this.uninstallFeature(uninstallFeatureTask, f);
            }
            catch (Exception e) {
                featureFailures.append(f.getFeature());
                featureFailures.append(", ");
            }
        }
        if (featureFailures.length() > 0) {
            featureFailures.setLength(featureFailures.length() - 2);
            throw new MojoExecutionException(MessageFormat.format(messages.getString("error.uninstall.feature.fail"), featureFailures.toString()));
        }
    }

    protected void uninstallFeature(UninstallFeatureTask task, FeatureManagerTask.Feature f) throws Exception {
        ArrayList<FeatureManagerTask.Feature> featuresToUninstall = new ArrayList<FeatureManagerTask.Feature>();
        featuresToUninstall.add(f);
        task.setFeatures(featuresToUninstall);
        task.execute();
    }
}

