/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.tools.maven;

import io.openliberty.tools.common.plugins.util.ServerFeatureUtil;
import io.openliberty.tools.maven.BasicSupport;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import org.apache.maven.execution.ProjectDependencyGraph;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;

public class ServerFeatureSupport
extends BasicSupport {
    private ServerFeatureUtil servUtil;

    private void createNewServerFeatureUtil() {
        this.servUtil = new ServerFeatureMojoUtil();
    }

    protected ServerFeatureUtil getServerFeatureUtil(boolean suppressLogs) {
        if (this.servUtil == null) {
            this.createNewServerFeatureUtil();
        }
        if (suppressLogs) {
            this.servUtil.setSuppressLogs(true);
        } else {
            this.servUtil.setSuppressLogs(false);
        }
        return this.servUtil;
    }

    protected void checkMultiModuleConflicts(ProjectDependencyGraph graph) throws MojoExecutionException {
        boolean bl;
        List sortedReactorProjects = graph.getSortedProjects();
        LinkedHashSet<MavenProject> conflicts = new LinkedHashSet<MavenProject>();
        ArrayList<MavenProject> leaves = new ArrayList<MavenProject>();
        for (MavenProject mavenProject : sortedReactorProjects) {
            if (!graph.getDownstreamProjects(mavenProject, true).isEmpty()) continue;
            leaves.add(mavenProject);
        }
        for (MavenProject mavenProject : leaves) {
            for (MavenProject leaf2 : leaves) {
                if (mavenProject == leaf2 || ServerFeatureSupport.isSubModule(leaf2, mavenProject) || ServerFeatureSupport.isSubModule(mavenProject, leaf2)) continue;
                conflicts.add(mavenProject);
                conflicts.add(leaf2);
            }
        }
        ArrayList<String> conflictModuleRelativeDirs = new ArrayList<String>();
        for (MavenProject mavenProject : conflicts) {
            conflictModuleRelativeDirs.add(this.getModuleRelativePath(mavenProject));
        }
        boolean bl2 = bl = !conflicts.isEmpty();
        if (bl) {
            throw new MojoExecutionException("Found multiple independent modules in the Reactor build order: " + conflictModuleRelativeDirs + ". Specify the module containing the Liberty configuration that you want to use for the server by including the following parameters in the Maven command: -pl <module-with-liberty-config> -am");
        }
    }

    private static boolean isSubModule(MavenProject potentialTopModule, MavenProject potentialSubModule) {
        List multiModules = potentialTopModule.getModules();
        if (multiModules != null) {
            for (String module : multiModules) {
                File subModuleDir = new File(potentialTopModule.getBasedir(), module);
                try {
                    if (!subModuleDir.getCanonicalFile().equals(potentialSubModule.getBasedir().getCanonicalFile())) continue;
                    return true;
                }
                catch (IOException e) {
                    if (!subModuleDir.getAbsoluteFile().equals(potentialSubModule.getBasedir().getAbsoluteFile())) continue;
                    return true;
                }
            }
        }
        return false;
    }

    protected boolean containsPreviousLibertyModule(ProjectDependencyGraph graph) {
        MavenProject reactorProject;
        List sortedReactorProjects = graph.getSortedProjects();
        MavenProject mostDownstreamModule = null;
        Iterator iterator = sortedReactorProjects.iterator();
        while (iterator.hasNext() && !(reactorProject = (MavenProject)iterator.next()).equals((Object)this.project)) {
            if (!graph.getDownstreamProjects(reactorProject, true).isEmpty()) continue;
            mostDownstreamModule = reactorProject;
            break;
        }
        if (mostDownstreamModule != null && !mostDownstreamModule.equals((Object)this.project)) {
            this.log.debug((CharSequence)("Found a previous module in the Reactor build order that does not have downstream dependencies: " + mostDownstreamModule));
            if (ServerFeatureSupport.isSubModule(this.project, mostDownstreamModule)) {
                this.log.debug((CharSequence)"Detected that this multi module pom contains another module that does not have downstream dependencies. Skipping goal on this module.");
                return true;
            }
        }
        return false;
    }

    protected String getModuleRelativePath(MavenProject module) {
        return this.multiModuleProjectDirectory.toPath().relativize(module.getBasedir().toPath()).toString();
    }

    protected class ServerFeatureMojoUtil
    extends ServerFeatureUtil {
        protected ServerFeatureMojoUtil() {
        }

        public void debug(String msg) {
            ServerFeatureSupport.this.log.debug((CharSequence)msg);
        }

        public void debug(String msg, Throwable e) {
            ServerFeatureSupport.this.log.debug((CharSequence)msg, e);
        }

        public void debug(Throwable e) {
            ServerFeatureSupport.this.log.debug(e);
        }

        public void warn(String msg) {
            if (!this.suppressLogs) {
                ServerFeatureSupport.this.log.warn((CharSequence)msg);
            } else {
                ServerFeatureSupport.this.log.debug((CharSequence)msg);
            }
        }

        public void info(String msg) {
            if (!this.suppressLogs) {
                ServerFeatureSupport.this.log.info((CharSequence)msg);
            } else {
                ServerFeatureSupport.this.log.debug((CharSequence)msg);
            }
        }

        public void error(String msg, Throwable e) {
            ServerFeatureSupport.this.log.error((CharSequence)msg, e);
        }
    }
}

