/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.jdbc.internal;

import com.google.auto.value.AutoValue;
import io.opentelemetry.instrumentation.jdbc.internal.AutoValue_DbRequest;
import io.opentelemetry.instrumentation.jdbc.internal.JdbcData;
import io.opentelemetry.instrumentation.jdbc.internal.JdbcUtils;
import io.opentelemetry.instrumentation.jdbc.internal.dbinfo.DbInfo;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.Statement;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import javax.annotation.Nullable;

@AutoValue
public abstract class DbRequest {
    @Nullable
    public static DbRequest create(PreparedStatement statement, Map<String, String> preparedStatementParameters) {
        return DbRequest.create((Statement)statement, (String)JdbcData.preparedStatement.get((Object)statement), preparedStatementParameters);
    }

    @Nullable
    public static DbRequest create(Statement statement, String dbStatementString) {
        return DbRequest.create(statement, dbStatementString, null, Collections.emptyMap());
    }

    @Nullable
    private static DbRequest create(Statement statement, String dbStatementString, Map<String, String> preparedStatementParameters) {
        return DbRequest.create(statement, dbStatementString, null, preparedStatementParameters);
    }

    @Nullable
    public static DbRequest create(Statement statement, String dbStatementString, Long batchSize, Map<String, String> preparedStatementParameters) {
        Connection connection = JdbcUtils.connectionFromStatement(statement);
        if (connection == null) {
            return null;
        }
        return DbRequest.create(JdbcUtils.extractDbInfo(connection), dbStatementString, batchSize, preparedStatementParameters);
    }

    public static DbRequest create(Statement statement, Collection<String> queryTexts, Long batchSize) {
        Connection connection = JdbcUtils.connectionFromStatement(statement);
        if (connection == null) {
            return null;
        }
        return DbRequest.create(JdbcUtils.extractDbInfo(connection), queryTexts, batchSize, Collections.emptyMap());
    }

    public static DbRequest create(DbInfo dbInfo, String queryText) {
        return DbRequest.create(dbInfo, queryText, null, Collections.emptyMap());
    }

    public static DbRequest create(DbInfo dbInfo, String queryText, Long batchSize, Map<String, String> preparedStatementParameters) {
        return DbRequest.create(dbInfo, Collections.singletonList(queryText), batchSize, preparedStatementParameters);
    }

    public static DbRequest create(DbInfo dbInfo, Collection<String> queryTexts, Long batchSize, Map<String, String> preparedStatementParameters) {
        return DbRequest.create(dbInfo, queryTexts, batchSize, null, preparedStatementParameters);
    }

    private static DbRequest create(DbInfo dbInfo, Collection<String> queryTexts, Long batchSize, String operation, Map<String, String> preparedStatementParameters) {
        return new AutoValue_DbRequest(dbInfo, queryTexts, batchSize, operation, preparedStatementParameters);
    }

    @Nullable
    public static DbRequest createTransaction(Connection connection, String operation) {
        Connection realConnection = JdbcUtils.unwrapConnection(connection);
        if (realConnection == null) {
            return null;
        }
        return DbRequest.createTransaction(JdbcUtils.extractDbInfo(realConnection), operation);
    }

    public static DbRequest createTransaction(DbInfo dbInfo, String operation) {
        return DbRequest.create(dbInfo, Collections.emptyList(), null, operation, Collections.emptyMap());
    }

    public abstract DbInfo getDbInfo();

    public abstract Collection<String> getQueryTexts();

    @Nullable
    public abstract Long getBatchSize();

    @Nullable
    public abstract String getOperation();

    public abstract Map<String, String> getPreparedStatementParameters();
}

