/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.jdbc.internal;

import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.api.common.AttributesBuilder;
import io.opentelemetry.context.Context;
import io.opentelemetry.instrumentation.api.instrumenter.AttributesExtractor;
import io.opentelemetry.instrumentation.api.internal.AttributesExtractorUtil;
import io.opentelemetry.instrumentation.api.internal.SemconvStability;
import io.opentelemetry.instrumentation.jdbc.internal.DbRequest;
import io.opentelemetry.semconv.DbAttributes;
import javax.annotation.Nullable;

enum TransactionAttributeExtractor implements AttributesExtractor<DbRequest, Void>
{
    INSTANCE;

    private static final AttributeKey<String> DB_OPERATION;

    public void onStart(AttributesBuilder attributes, Context parentContext, DbRequest request) {
        if (SemconvStability.emitOldDatabaseSemconv()) {
            AttributesExtractorUtil.internalSet((AttributesBuilder)attributes, DB_OPERATION, (Object)request.getOperation());
        }
        if (SemconvStability.emitStableDatabaseSemconv()) {
            AttributesExtractorUtil.internalSet((AttributesBuilder)attributes, (AttributeKey)DbAttributes.DB_OPERATION_NAME, (Object)request.getOperation());
        }
    }

    public void onEnd(AttributesBuilder attributes, Context context, DbRequest request, @Nullable Void unused, @Nullable Throwable error) {
    }

    static {
        DB_OPERATION = AttributeKey.stringKey((String)"db.operation");
    }
}

