/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.servlet;

import io.opentelemetry.api.trace.Span;
import io.opentelemetry.context.Context;
import io.opentelemetry.context.propagation.TextMapPropagator;
import io.opentelemetry.instrumentation.api.servlet.AppServerBridge;
import io.opentelemetry.instrumentation.api.servlet.ServletContextPath;
import io.opentelemetry.instrumentation.api.tracer.HttpServerTracer;
import io.opentelemetry.instrumentation.servlet.HttpServletRequestGetter;
import io.opentelemetry.semconv.trace.attributes.SemanticAttributes;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.Principal;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ServletHttpServerTracer<RESPONSE>
extends HttpServerTracer<HttpServletRequest, RESPONSE, HttpServletRequest, HttpServletRequest> {
    private static final Logger log = LoggerFactory.getLogger(ServletHttpServerTracer.class);

    public Context startSpan(HttpServletRequest request) {
        Context context = this.startSpan(request, request, request, ServletHttpServerTracer.getSpanName(request));
        String contextPath = request.getContextPath();
        if (contextPath != null && !contextPath.isEmpty() && !contextPath.equals("/")) {
            context = context.with(ServletContextPath.CONTEXT_KEY, (Object)contextPath);
        }
        return context;
    }

    public void endExceptionally(Context context, Throwable throwable, RESPONSE response, long timestamp) {
        if (this.isResponseCommitted(response)) {
            super.endExceptionally(context, throwable, response, timestamp);
        } else {
            super.endExceptionally(context, throwable, null, timestamp);
        }
    }

    protected abstract boolean isResponseCommitted(RESPONSE var1);

    protected String url(HttpServletRequest httpServletRequest) {
        try {
            return new URI(httpServletRequest.getScheme(), null, httpServletRequest.getServerName(), httpServletRequest.getServerPort(), httpServletRequest.getRequestURI(), httpServletRequest.getQueryString(), null).toString();
        }
        catch (URISyntaxException e) {
            log.debug("Failed to construct request URI", (Throwable)e);
            return null;
        }
    }

    public Context getServerContext(HttpServletRequest request) {
        Object context = request.getAttribute(CONTEXT_ATTRIBUTE);
        return context instanceof Context ? (Context)context : null;
    }

    protected void attachServerContext(Context context, HttpServletRequest request) {
        request.setAttribute(CONTEXT_ATTRIBUTE, (Object)context);
    }

    protected Integer peerPort(HttpServletRequest connection) {
        return null;
    }

    protected String peerHostIP(HttpServletRequest connection) {
        return connection.getRemoteAddr();
    }

    protected String method(HttpServletRequest request) {
        return request.getMethod();
    }

    public void onRequest(Span span, HttpServletRequest request) {
        request.setAttribute("traceId", (Object)span.getSpanContext().getTraceId());
        request.setAttribute("spanId", (Object)span.getSpanContext().getSpanId());
        super.onRequest(span, (Object)request);
    }

    protected TextMapPropagator.Getter<HttpServletRequest> getGetter() {
        return HttpServletRequestGetter.GETTER;
    }

    public void addUnwrappedThrowable(Context context, Throwable throwable) {
        if (AppServerBridge.shouldRecordException((Context)context)) {
            this.addThrowable(Span.fromContext((Context)context), this.unwrapThrowable(throwable));
        }
    }

    protected Throwable unwrapThrowable(Throwable throwable) {
        Throwable result = throwable;
        if (throwable instanceof ServletException && throwable.getCause() != null) {
            result = throwable.getCause();
        }
        return super.unwrapThrowable(result);
    }

    public void setPrincipal(Context context, HttpServletRequest request) {
        Principal principal = request.getUserPrincipal();
        if (principal != null) {
            Span.fromContext((Context)context).setAttribute(SemanticAttributes.ENDUSER_ID, (Object)principal.getName());
        }
    }

    protected String flavor(HttpServletRequest connection, HttpServletRequest request) {
        return connection.getProtocol();
    }

    protected String requestHeader(HttpServletRequest httpServletRequest, String name) {
        return httpServletRequest.getHeader(name);
    }

    public static String getSpanName(HttpServletRequest request) {
        String servletPath = request.getServletPath();
        if (servletPath.isEmpty()) {
            return "HTTP " + request.getMethod();
        }
        String contextPath = request.getContextPath();
        if (contextPath == null || contextPath.isEmpty() || contextPath.equals("/")) {
            return servletPath;
        }
        return contextPath + servletPath;
    }

    public void updateServerSpanNameOnce(Context attachedContext, HttpServletRequest request) {
        if (AppServerBridge.shouldUpdateServerSpanName((Context)attachedContext)) {
            ServletHttpServerTracer.updateSpanName(Span.fromContext((Context)attachedContext), request);
            AppServerBridge.setServletUpdatedServerSpanName((Context)attachedContext, (boolean)true);
        }
    }

    public void updateSpanName(HttpServletRequest request) {
        ServletHttpServerTracer.updateSpanName(this.getServerSpan(request), request);
    }

    private static void updateSpanName(Span span, HttpServletRequest request) {
        span.updateName(ServletHttpServerTracer.getSpanName(request));
    }
}

