/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.trace;

import io.opentelemetry.internal.Utils;
import io.opentelemetry.trace.BigendianEncoding;
import java.util.Arrays;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class TraceFlags {
    private static final byte DEFAULT_OPTIONS = 0;
    private static final byte IS_SAMPLED = 1;
    private static final int SIZE = 1;
    private static final int BASE16_SIZE = 2;
    private static final TraceFlags DEFAULT = TraceFlags.fromByte((byte)0);
    private final byte options;

    private TraceFlags(byte options) {
        this.options = options;
    }

    public static int getSize() {
        return 1;
    }

    public static TraceFlags getDefault() {
        return DEFAULT;
    }

    public static TraceFlags fromByte(byte src) {
        return new TraceFlags(src);
    }

    public static TraceFlags fromLowerBase16(CharSequence src, int srcOffset) {
        return new TraceFlags(BigendianEncoding.byteFromBase16String(src, srcOffset));
    }

    public byte getByte() {
        return this.options;
    }

    public void copyBytesTo(byte[] dest, int destOffset) {
        Utils.checkIndex(destOffset, dest.length);
        dest[destOffset] = this.options;
    }

    public void copyLowerBase16To(char[] dest, int destOffset) {
        BigendianEncoding.byteToBase16String(this.options, dest, destOffset);
    }

    public String toLowerBase16() {
        char[] chars = new char[2];
        this.copyLowerBase16To(chars, 0);
        return new String(chars);
    }

    public static Builder builder() {
        return new Builder(0);
    }

    public static Builder builder(TraceFlags traceFlags) {
        return new Builder(traceFlags.options);
    }

    public boolean isSampled() {
        return this.hasOption(1);
    }

    public boolean equals(@Nullable Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof TraceFlags)) {
            return false;
        }
        TraceFlags that = (TraceFlags)obj;
        return this.options == that.options;
    }

    public int hashCode() {
        return Arrays.hashCode(new byte[]{this.options});
    }

    public String toString() {
        return "TraceFlags{sampled=" + this.isSampled() + "}";
    }

    private boolean hasOption(int mask) {
        return (this.options & mask) != 0;
    }

    public static final class Builder {
        private byte options;

        private Builder(byte options) {
            this.options = options;
        }

        public Builder setIsSampled(boolean isSampled) {
            this.options = isSampled ? (byte)(this.options | 1) : (byte)(this.options & 0xFFFFFFFE);
            return this;
        }

        public TraceFlags build() {
            return TraceFlags.fromByte(this.options);
        }
    }
}

