/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.exporter.otlp.http.trace;

import io.opentelemetry.api.internal.Utils;
import io.opentelemetry.api.metrics.MeterProvider;
import io.opentelemetry.exporter.internal.okhttp.OkHttpExporter;
import io.opentelemetry.exporter.internal.okhttp.OkHttpExporterBuilder;
import io.opentelemetry.exporter.internal.otlp.OtlpUserAgent;
import io.opentelemetry.exporter.internal.otlp.traces.TraceRequestMarshaler;
import io.opentelemetry.exporter.otlp.http.trace.OtlpHttpSpanExporter;
import java.time.Duration;
import java.util.Objects;
import java.util.concurrent.TimeUnit;

public final class OtlpHttpSpanExporterBuilder {
    private static final String DEFAULT_ENDPOINT = "http://localhost:4318/v1/traces";
    private final OkHttpExporterBuilder<TraceRequestMarshaler> delegate = new OkHttpExporterBuilder("otlp", "span", "http://localhost:4318/v1/traces");

    OtlpHttpSpanExporterBuilder() {
        OtlpUserAgent.addUserAgentHeader((arg_0, arg_1) -> this.delegate.addHeader(arg_0, arg_1));
    }

    public OtlpHttpSpanExporterBuilder setTimeout(long timeout, TimeUnit unit) {
        Objects.requireNonNull(unit, "unit");
        Utils.checkArgument((timeout >= 0L ? 1 : 0) != 0, (String)"timeout must be non-negative");
        this.delegate.setTimeout(timeout, unit);
        return this;
    }

    public OtlpHttpSpanExporterBuilder setTimeout(Duration timeout) {
        Objects.requireNonNull(timeout, "timeout");
        return this.setTimeout(timeout.toNanos(), TimeUnit.NANOSECONDS);
    }

    public OtlpHttpSpanExporterBuilder setEndpoint(String endpoint) {
        Objects.requireNonNull(endpoint, "endpoint");
        this.delegate.setEndpoint(endpoint);
        return this;
    }

    public OtlpHttpSpanExporterBuilder setCompression(String compressionMethod) {
        Objects.requireNonNull(compressionMethod, "compressionMethod");
        Utils.checkArgument((compressionMethod.equals("gzip") || compressionMethod.equals("none") ? 1 : 0) != 0, (String)"Unsupported compression method. Supported compression methods include: gzip, none.");
        this.delegate.setCompression(compressionMethod);
        return this;
    }

    public OtlpHttpSpanExporterBuilder addHeader(String key, String value) {
        this.delegate.addHeader(key, value);
        return this;
    }

    public OtlpHttpSpanExporterBuilder setTrustedCertificates(byte[] trustedCertificatesPem) {
        this.delegate.configureTrustManager(trustedCertificatesPem);
        return this;
    }

    public OtlpHttpSpanExporterBuilder setClientTls(byte[] privateKeyPem, byte[] certificatePem) {
        this.delegate.configureKeyManager(privateKeyPem, certificatePem);
        return this;
    }

    public OtlpHttpSpanExporterBuilder setMeterProvider(MeterProvider meterProvider) {
        Objects.requireNonNull(meterProvider, "meterProvider");
        this.delegate.setMeterProvider(meterProvider);
        return this;
    }

    public OtlpHttpSpanExporter build() {
        return new OtlpHttpSpanExporter((OkHttpExporter<TraceRequestMarshaler>)this.delegate.build());
    }
}

