/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.metrics.internal.exemplar;

import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.context.Context;
import io.opentelemetry.sdk.common.Clock;
import io.opentelemetry.sdk.metrics.internal.concurrent.AdderUtil;
import io.opentelemetry.sdk.metrics.internal.concurrent.LongAdder;
import io.opentelemetry.sdk.metrics.internal.exemplar.AbstractFixedSizeExemplarReservoir;
import java.util.Random;
import java.util.function.Supplier;

final class FixedSizeExemplarReservoir
extends AbstractFixedSizeExemplarReservoir {
    private final Supplier<Random> randomSupplier;
    private final LongAdder numMeasurements = AdderUtil.createLongAdder();

    FixedSizeExemplarReservoir(Clock clock, int size, Supplier<Random> randomSupplier) {
        super(clock, size);
        this.randomSupplier = randomSupplier;
    }

    @Override
    protected int reservoirIndexFor(double value, Attributes attributes, Context context) {
        int count;
        int index = this.randomSupplier.get().nextInt((count = this.numMeasurements.intValue() + 1) > 0 ? count : 1);
        this.numMeasurements.increment();
        if (index < this.maxSize()) {
            return index;
        }
        return -1;
    }

    @Override
    protected void reset() {
        this.numMeasurements.reset();
    }
}

