/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.metrics.internal.state;

import io.opentelemetry.api.metrics.ObservableDoubleMeasurement;
import io.opentelemetry.api.metrics.ObservableLongMeasurement;
import io.opentelemetry.sdk.common.InstrumentationScopeInfo;
import io.opentelemetry.sdk.metrics.data.MetricData;
import io.opentelemetry.sdk.metrics.internal.descriptor.InstrumentDescriptor;
import io.opentelemetry.sdk.metrics.internal.export.CollectionInfo;
import io.opentelemetry.sdk.metrics.internal.state.AsynchronousMetricStorage;
import io.opentelemetry.sdk.metrics.internal.state.CallbackRegistration;
import io.opentelemetry.sdk.metrics.internal.state.MeterProviderSharedState;
import io.opentelemetry.sdk.metrics.internal.state.MetricStorage;
import io.opentelemetry.sdk.metrics.internal.state.MetricStorageRegistry;
import io.opentelemetry.sdk.metrics.internal.state.MultiWritableMetricStorage;
import io.opentelemetry.sdk.metrics.internal.state.SynchronousMetricStorage;
import io.opentelemetry.sdk.metrics.internal.state.WriteableMetricStorage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;

public class MeterSharedState {
    private final Object collectLock = new Object();
    private final Object callbackLock = new Object();
    private final List<CallbackRegistration<?>> callbackRegistrations = new ArrayList();
    private final InstrumentationScopeInfo instrumentationScopeInfo;
    private final MetricStorageRegistry metricStorageRegistry;

    private MeterSharedState(InstrumentationScopeInfo instrumentationScopeInfo, MetricStorageRegistry metricStorageRegistry) {
        this.instrumentationScopeInfo = instrumentationScopeInfo;
        this.metricStorageRegistry = metricStorageRegistry;
    }

    public static MeterSharedState create(InstrumentationScopeInfo instrumentationScopeInfo) {
        return new MeterSharedState(instrumentationScopeInfo, new MetricStorageRegistry());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeCallback(CallbackRegistration<?> callbackRegistration) {
        Object object = this.callbackLock;
        synchronized (object) {
            this.callbackRegistrations.remove(callbackRegistration);
        }
    }

    public InstrumentationScopeInfo getInstrumentationScopeInfo() {
        return this.instrumentationScopeInfo;
    }

    MetricStorageRegistry getMetricStorageRegistry() {
        return this.metricStorageRegistry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<MetricData> collectAll(CollectionInfo collectionInfo, MeterProviderSharedState meterProviderSharedState, long epochNanos, boolean suppressSynchronousCollection) {
        ArrayList currentRegisteredCallbacks;
        Object object = this.callbackLock;
        synchronized (object) {
            currentRegisteredCallbacks = new ArrayList(this.callbackRegistrations);
        }
        object = this.collectLock;
        synchronized (object) {
            for (CallbackRegistration callbackRegistration : currentRegisteredCallbacks) {
                callbackRegistration.invokeCallback();
            }
            Collection<MetricStorage> metrics = this.getMetricStorageRegistry().getMetrics();
            ArrayList<MetricData> arrayList = new ArrayList<MetricData>(metrics.size());
            for (MetricStorage metric : metrics) {
                MetricData current = metric.collectAndReset(collectionInfo, meterProviderSharedState.getResource(), this.getInstrumentationScopeInfo(), meterProviderSharedState.getStartEpochNanos(), epochNanos, suppressSynchronousCollection);
                if (current.isEmpty()) continue;
                arrayList.add(current);
            }
            return arrayList;
        }
    }

    public final WriteableMetricStorage registerSynchronousMetricStorage(InstrumentDescriptor instrument, MeterProviderSharedState meterProviderSharedState) {
        List storages = meterProviderSharedState.getViewRegistry().findViews(instrument, this.getInstrumentationScopeInfo()).stream().map(view -> SynchronousMetricStorage.create(view, instrument, meterProviderSharedState.getExemplarFilter())).filter(m -> !m.isEmpty()).collect(Collectors.toList());
        ArrayList<SynchronousMetricStorage> registeredStorages = new ArrayList<SynchronousMetricStorage>(storages.size());
        for (SynchronousMetricStorage storage : storages) {
            registeredStorages.add(this.getMetricStorageRegistry().register(storage));
        }
        if (registeredStorages.size() == 1) {
            return (WriteableMetricStorage)registeredStorages.get(0);
        }
        return new MultiWritableMetricStorage(registeredStorages);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final CallbackRegistration<ObservableLongMeasurement> registerLongAsynchronousInstrument(InstrumentDescriptor instrument, MeterProviderSharedState meterProviderSharedState, Consumer<ObservableLongMeasurement> callback) {
        List<AsynchronousMetricStorage<?>> registeredStorages = this.registerAsynchronousInstrument(instrument, meterProviderSharedState);
        CallbackRegistration<ObservableLongMeasurement> registration = CallbackRegistration.createLong(instrument, callback, registeredStorages);
        Object object = this.callbackLock;
        synchronized (object) {
            this.callbackRegistrations.add(registration);
        }
        return registration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final CallbackRegistration<ObservableDoubleMeasurement> registerDoubleAsynchronousInstrument(InstrumentDescriptor instrument, MeterProviderSharedState meterProviderSharedState, Consumer<ObservableDoubleMeasurement> callback) {
        List<AsynchronousMetricStorage<?>> registeredStorages = this.registerAsynchronousInstrument(instrument, meterProviderSharedState);
        CallbackRegistration<ObservableDoubleMeasurement> registration = CallbackRegistration.createDouble(instrument, callback, registeredStorages);
        Object object = this.callbackLock;
        synchronized (object) {
            this.callbackRegistrations.add(registration);
        }
        return registration;
    }

    private List<AsynchronousMetricStorage<?>> registerAsynchronousInstrument(InstrumentDescriptor instrumentDescriptor, MeterProviderSharedState meterProviderSharedState) {
        List storages = meterProviderSharedState.getViewRegistry().findViews(instrumentDescriptor, this.getInstrumentationScopeInfo()).stream().map(view -> AsynchronousMetricStorage.create(view, instrumentDescriptor)).filter(storage -> !storage.isEmpty()).collect(Collectors.toList());
        ArrayList registeredStorages = new ArrayList(storages.size());
        for (AsynchronousMetricStorage storage2 : storages) {
            registeredStorages.add(this.getMetricStorageRegistry().register(storage2));
        }
        return registeredStorages;
    }
}

