/*
 * Decompiled with CFR 0.152.
 */
package io.jaegertracing.internal.baggage;

import io.jaegertracing.internal.baggage.Restriction;
import io.jaegertracing.internal.baggage.http.BaggageRestrictionResponse;
import io.jaegertracing.internal.exceptions.BaggageRestrictionManagerException;
import io.jaegertracing.internal.metrics.Metrics;
import io.jaegertracing.spi.BaggageRestrictionManager;
import io.jaegertracing.spi.BaggageRestrictionManagerProxy;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;

public class RemoteBaggageRestrictionManager
implements BaggageRestrictionManager {
    private static final int DEFAULT_REFRESH_INTERVAL_MS = 60000;
    private static final int DEFAULT_INITIAL_DELAY_MS = 0;
    private final String serviceName;
    private final BaggageRestrictionManagerProxy proxy;
    private final Timer pollTimer;
    private final Metrics metrics;
    private final boolean denyBaggageOnInitializationFailure;
    private volatile boolean initialized;
    private volatile Map<String, Restriction> restrictions = new HashMap<String, Restriction>();
    private final Restriction invalidRestriction;
    private final Restriction validRestriction;

    protected RemoteBaggageRestrictionManager(String serviceName, BaggageRestrictionManagerProxy proxy, Metrics metrics, boolean denyBaggageOnInitializationFailure, int refreshIntervalMs, int initialDelayMs) {
        this.serviceName = serviceName;
        this.proxy = proxy;
        this.metrics = metrics;
        this.denyBaggageOnInitializationFailure = denyBaggageOnInitializationFailure;
        this.initialized = false;
        this.invalidRestriction = Restriction.of(false, 0);
        this.validRestriction = Restriction.of(true, 2048);
        this.pollTimer = new Timer(true);
        this.pollTimer.schedule(new TimerTask(){

            @Override
            public void run() {
                RemoteBaggageRestrictionManager.this.updateBaggageRestrictions();
            }
        }, initialDelayMs, (long)refreshIntervalMs);
    }

    public boolean isReady() {
        return this.initialized;
    }

    void updateBaggageRestrictions() {
        List<BaggageRestrictionResponse> response;
        try {
            response = this.proxy.getBaggageRestrictions(this.serviceName);
        }
        catch (BaggageRestrictionManagerException e) {
            this.metrics.baggageRestrictionsUpdateFailure.inc(1L);
            return;
        }
        this.updateBaggageRestrictions(response);
        this.metrics.baggageRestrictionsUpdateSuccess.inc(1L);
    }

    private void updateBaggageRestrictions(List<BaggageRestrictionResponse> restrictions) {
        HashMap<String, Restriction> baggageRestrictions = new HashMap<String, Restriction>();
        for (BaggageRestrictionResponse restriction : restrictions) {
            baggageRestrictions.put(restriction.getBaggageKey(), Restriction.of(true, restriction.getMaxValueLength()));
        }
        this.restrictions = baggageRestrictions;
        this.initialized = true;
    }

    public void close() {
        this.pollTimer.cancel();
    }

    @Override
    public Restriction getRestriction(String service, String key) {
        if (!this.initialized) {
            if (this.denyBaggageOnInitializationFailure) {
                return this.invalidRestriction;
            }
            return this.validRestriction;
        }
        Restriction restriction = this.restrictions.get(key);
        if (restriction != null) {
            return restriction;
        }
        return this.invalidRestriction;
    }

    public static class Builder {
        private String serviceName;
        private BaggageRestrictionManagerProxy proxy;
        private Metrics metrics;
        private boolean denyBaggageOnInitializationFailure;
        private int refreshIntervalMs = 60000;
        private int initialDelayMs = 0;

        public Builder(String serviceName) {
            this.serviceName = serviceName;
        }

        public Builder withProxy(BaggageRestrictionManagerProxy proxy) {
            this.proxy = proxy;
            return this;
        }

        public Builder withMetrics(Metrics metrics) {
            this.metrics = metrics;
            return this;
        }

        public Builder withDenyBaggageInitializationFailure(boolean denyBaggageOnInitializationFailure) {
            this.denyBaggageOnInitializationFailure = denyBaggageOnInitializationFailure;
            return this;
        }

        public Builder withRefreshIntervalMs(int refreshIntervalMs) {
            this.refreshIntervalMs = refreshIntervalMs;
            return this;
        }

        public Builder withInitialDelayMs(int initialDelayMs) {
            this.initialDelayMs = initialDelayMs;
            return this;
        }

        public RemoteBaggageRestrictionManager build() {
            return new RemoteBaggageRestrictionManager(this.serviceName, this.proxy, this.metrics, this.denyBaggageOnInitializationFailure, this.refreshIntervalMs, this.initialDelayMs);
        }
    }
}

