/*
 * Decompiled with CFR 0.152.
 */
package io.opentracing.contrib.grizzly.ahc;

import com.ning.http.client.AsyncHttpClient;
import com.ning.http.client.AsyncHttpClientConfig;
import com.ning.http.client.Response;
import com.ning.http.client.filter.RequestFilter;
import io.opentracing.Scope;
import io.opentracing.ScopeManager;
import io.opentracing.Tracer;
import io.opentracing.contrib.grizzly.ahc.AbstractAhcTest;
import io.opentracing.contrib.grizzly.ahc.TracingRequestFilter;
import io.opentracing.mock.MockTracer;
import io.opentracing.util.GlobalTracer;
import io.opentracing.util.ThreadLocalScopeManager;
import org.glassfish.grizzly.http.server.HttpServer;
import org.junit.After;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class TracingRequestFilterTest
extends AbstractAhcTest {
    protected static final MockTracer tracer = new MockTracer((ScopeManager)new ThreadLocalScopeManager());

    @BeforeClass
    public static void beforeClass() throws Exception {
        GlobalTracer.registerIfAbsent((Tracer)tracer);
    }

    @Before
    public void before() throws Exception {
        tracer.reset();
        this.httpServer = HttpServer.createSimpleServer();
        this.httpServer.start();
        this.setupServer(this.httpServer);
    }

    @After
    public void after() throws Exception {
        if (this.httpServer != null) {
            this.httpServer.shutdownNow();
        }
    }

    @Test
    public void testBasicRequest() throws Throwable {
        Response response;
        AsyncHttpClientConfig config = new AsyncHttpClientConfig.Builder().addRequestFilter((RequestFilter)new TracingRequestFilter()).build();
        try (AsyncHttpClient client = new AsyncHttpClient(config);
             Scope scope = tracer.buildSpan("parent").startActive(true);){
            response = (Response)client.prepareGet("http://localhost:8080/root").execute().get();
        }
        this.doTest(response, tracer);
    }
}

