/*
 * Decompiled with CFR 0.152.
 */
package io.opentracing.contrib.grizzly.ahc;

import com.ning.http.client.AsyncHandler;
import com.ning.http.client.HttpResponseBodyPart;
import com.ning.http.client.HttpResponseHeaders;
import com.ning.http.client.HttpResponseStatus;
import com.ning.http.client.Request;
import com.ning.http.client.RequestBuilder;
import com.ning.http.client.RequestBuilderBase;
import com.ning.http.client.filter.FilterContext;
import com.ning.http.client.filter.FilterException;
import com.ning.http.client.filter.RequestFilter;
import io.opentracing.Span;
import io.opentracing.Tracer;
import io.opentracing.contrib.grizzly.ahc.RequestBuilderInjectAdapter;
import io.opentracing.propagation.Format;
import io.opentracing.tag.Tags;
import io.opentracing.util.GlobalTracer;

public class TracingRequestFilter
implements RequestFilter {
    private final Tracer tracer;

    public TracingRequestFilter(Tracer tracer) {
        this.tracer = tracer;
    }

    public TracingRequestFilter() {
        this.tracer = GlobalTracer.get();
    }

    public <T> FilterContext<T> filter(FilterContext<T> ctx) throws FilterException {
        Request request = ctx.getRequest();
        Span span = this.tracer.buildSpan("HTTP::" + request.getMethod()).withTag(Tags.SPAN_KIND.getKey(), "client").start();
        Tags.COMPONENT.set(span, "java-grizzly-ahc");
        Tags.HTTP_METHOD.set(span, request.getMethod());
        Tags.HTTP_URL.set(span, request.getUrl());
        RequestBuilder requestBuilder = new RequestBuilder(ctx.getRequest());
        RequestBuilderInjectAdapter injectAdapter = new RequestBuilderInjectAdapter((RequestBuilderBase<?>)requestBuilder);
        this.tracer.inject(span.context(), Format.Builtin.HTTP_HEADERS, (Object)injectAdapter);
        FilterContext.FilterContextBuilder injectedContextBuilder = new FilterContext.FilterContextBuilder(ctx);
        FilterContext injectedContext = injectedContextBuilder.build();
        injectedContextBuilder.request(injectAdapter.injectedRequest());
        return new FilterContext.FilterContextBuilder(injectedContext).asyncHandler(new AsyncHandlerWrapper(injectedContext.getAsyncHandler(), span)).build();
    }

    private class AsyncHandlerWrapper<T>
    implements AsyncHandler<T> {
        private final AsyncHandler<T> asyncHandler;
        private final Span span;

        public AsyncHandlerWrapper(AsyncHandler<T> asyncHandler, Span span) {
            this.asyncHandler = asyncHandler;
            this.span = span;
        }

        public AsyncHandler.STATE onStatusReceived(HttpResponseStatus httpResponseStatus) throws Exception {
            Tags.HTTP_STATUS.set(this.span, Integer.valueOf(httpResponseStatus.getStatusCode()));
            return this.asyncHandler.onStatusReceived(httpResponseStatus);
        }

        public T onCompleted() throws Exception {
            this.span.finish();
            return (T)this.asyncHandler.onCompleted();
        }

        public void onThrowable(Throwable t) {
            this.asyncHandler.onThrowable(t);
        }

        public AsyncHandler.STATE onBodyPartReceived(HttpResponseBodyPart bodyPart) throws Exception {
            return this.asyncHandler.onBodyPartReceived(bodyPart);
        }

        public AsyncHandler.STATE onHeadersReceived(HttpResponseHeaders headers) throws Exception {
            return this.asyncHandler.onHeadersReceived(headers);
        }
    }
}

