/*
 * Decompiled with CFR 0.152.
 */
package io.opentracing.contrib.jaxrs2.serialization;

import io.opentracing.ActiveSpan;
import io.opentracing.BaseSpan;
import io.opentracing.NoopActiveSpanSource;
import io.opentracing.Tracer;
import io.opentracing.contrib.jaxrs2.internal.SpanWrapper;
import io.opentracing.contrib.jaxrs2.serialization.InterceptorSpanDecorator;
import io.opentracing.tag.Tags;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.ext.InterceptorContext;
import javax.ws.rs.ext.ReaderInterceptor;
import javax.ws.rs.ext.ReaderInterceptorContext;
import javax.ws.rs.ext.WriterInterceptor;
import javax.ws.rs.ext.WriterInterceptorContext;

public abstract class TracingInterceptor
implements WriterInterceptor,
ReaderInterceptor {
    private final Tracer tracer;
    private final Collection<InterceptorSpanDecorator> spanDecorators;

    public TracingInterceptor(Tracer tracer, List<InterceptorSpanDecorator> spanDecorators) {
        Objects.requireNonNull(tracer);
        Objects.requireNonNull(spanDecorators);
        this.tracer = tracer;
        this.spanDecorators = new ArrayList<InterceptorSpanDecorator>(spanDecorators);
    }

    public Object aroundReadFrom(ReaderInterceptorContext context) throws IOException, WebApplicationException {
        Throwable throwable = null;
        try (ActiveSpan activeSpan = this.decorateRead((InterceptorContext)context, this.buildSpan((InterceptorContext)context, "deserialize"));){
            Object object = context.proceed();
            return object;
        }
        catch (Exception e) {
            try {
                Tags.ERROR.set((BaseSpan)activeSpan, Boolean.valueOf(true));
                throw e;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
    }

    public void aroundWriteTo(WriterInterceptorContext context) throws IOException, WebApplicationException {
        try (ActiveSpan activeSpan = this.decorateWrite((InterceptorContext)context, this.buildSpan((InterceptorContext)context, "serialize"));){
            try {
                context.proceed();
            }
            catch (Exception e) {
                Tags.ERROR.set((BaseSpan)activeSpan, Boolean.valueOf(true));
                throw e;
            }
        }
    }

    private ActiveSpan buildSpan(InterceptorContext context, String operationName) {
        SpanWrapper spanWrapper = this.findSpan(context);
        if (spanWrapper == null) {
            return NoopActiveSpanSource.NoopActiveSpan.INSTANCE;
        }
        Tracer.SpanBuilder spanBuilder = this.tracer.buildSpan(operationName);
        if (spanWrapper.isFinished()) {
            spanBuilder.addReference("follows_from", spanWrapper.get().context());
        } else {
            spanBuilder.asChildOf((BaseSpan)spanWrapper.get());
        }
        return spanBuilder.startActive();
    }

    protected abstract SpanWrapper findSpan(InterceptorContext var1);

    private ActiveSpan decorateRead(InterceptorContext context, ActiveSpan span) {
        for (InterceptorSpanDecorator decorator : this.spanDecorators) {
            decorator.decorateRead(context, (BaseSpan<?>)span);
        }
        return span;
    }

    private ActiveSpan decorateWrite(InterceptorContext context, ActiveSpan span) {
        for (InterceptorSpanDecorator decorator : this.spanDecorators) {
            decorator.decorateWrite(context, (BaseSpan<?>)span);
        }
        return span;
    }
}

