/*
 * Decompiled with CFR 0.152.
 */
package io.opentracing.contrib.jaxrs2.server;

import io.opentracing.BaseSpan;
import io.opentracing.contrib.jaxrs2.internal.URIUtils;
import io.opentracing.tag.Tags;
import java.util.List;
import java.util.Map;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerResponseContext;
import javax.ws.rs.core.MultivaluedMap;

public interface ServerSpanDecorator {
    public static final ServerSpanDecorator STANDARD_TAGS = new ServerSpanDecorator(){

        @Override
        public void decorateRequest(ContainerRequestContext requestContext, BaseSpan<?> span) {
            Tags.HTTP_METHOD.set(span, requestContext.getMethod());
            String url = URIUtils.url(requestContext.getUriInfo().getAbsolutePath());
            if (url != null) {
                Tags.HTTP_URL.set(span, url);
            }
        }

        @Override
        public void decorateResponse(ContainerResponseContext responseContext, BaseSpan<?> span) {
            Tags.HTTP_STATUS.set(span, Integer.valueOf(responseContext.getStatus()));
        }
    };
    public static final ServerSpanDecorator HTTP_WILDCARD_PATH_OPERATION_NAME = new ServerSpanDecorator(){

        @Override
        public void decorateRequest(ContainerRequestContext requestContext, BaseSpan<?> span) {
            MultivaluedMap pathParameters = requestContext.getUriInfo().getPathParameters();
            String path = URIUtils.path(requestContext.getUriInfo().getRequestUri());
            for (Map.Entry entry : pathParameters.entrySet()) {
                String originalPathFragment = String.format("{%s}", entry.getKey());
                for (String currentPathFragment : (List)entry.getValue()) {
                    path = path.replace(currentPathFragment, originalPathFragment);
                }
            }
            span.setOperationName(path);
        }

        @Override
        public void decorateResponse(ContainerResponseContext responseContext, BaseSpan<?> span) {
        }
    };

    public void decorateRequest(ContainerRequestContext var1, BaseSpan<?> var2);

    public void decorateResponse(ContainerResponseContext var1, BaseSpan<?> var2);
}

