/*
 * Decompiled with CFR 0.152.
 */
package io.opentracing.contrib.jaxrs2.server;

import io.opentracing.ActiveSpan;
import io.opentracing.BaseSpan;
import io.opentracing.Span;
import io.opentracing.SpanContext;
import io.opentracing.Tracer;
import io.opentracing.contrib.jaxrs2.internal.CastUtils;
import io.opentracing.contrib.jaxrs2.internal.SpanWrapper;
import io.opentracing.contrib.jaxrs2.server.ServerHeadersExtractTextMap;
import io.opentracing.contrib.jaxrs2.server.ServerSpanDecorator;
import io.opentracing.propagation.Format;
import io.opentracing.tag.Tags;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Priority;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.container.ContainerResponseContext;
import javax.ws.rs.container.ContainerResponseFilter;
import javax.ws.rs.core.MultivaluedMap;

@Priority(value=3000)
public class ServerTracingFilter
implements ContainerRequestFilter,
ContainerResponseFilter {
    private static final Logger log = Logger.getLogger(ServerTracingFilter.class.getName());
    private Tracer tracer;
    private String operationName;
    private List<ServerSpanDecorator> spanDecorators;
    private boolean isSyncRequest;

    protected ServerTracingFilter(Tracer tracer, String operationName, List<ServerSpanDecorator> spanDecorators, boolean isSyncRequest) {
        this.tracer = tracer;
        this.operationName = operationName;
        this.spanDecorators = new ArrayList<ServerSpanDecorator>(spanDecorators);
        this.isSyncRequest = isSyncRequest;
    }

    public void filter(ContainerRequestContext requestContext) throws IOException {
        if (requestContext.getProperty(SpanWrapper.PROPERTY_NAME) != null) {
            return;
        }
        if (this.tracer != null) {
            SpanContext extractedSpanContext = this.tracer.extract(Format.Builtin.HTTP_HEADERS, (Object)new ServerHeadersExtractTextMap((MultivaluedMap<String, String>)requestContext.getHeaders()));
            Tracer.SpanBuilder spanBuilder = this.tracer.buildSpan(requestContext.getMethod()).withTag(Tags.SPAN_KIND.getKey(), "server");
            if (extractedSpanContext != null) {
                spanBuilder.asChildOf(extractedSpanContext);
            }
            Span span = spanBuilder.startManual();
            if (this.isSyncRequest) {
                this.tracer.makeActive(span);
            }
            if (this.spanDecorators != null) {
                for (ServerSpanDecorator decorator : this.spanDecorators) {
                    decorator.decorateRequest(requestContext, (BaseSpan<?>)span);
                }
            }
            if (this.operationName != null) {
                span.setOperationName(this.operationName);
            }
            if (log.isLoggable(Level.FINEST)) {
                log.finest("Creating server span: " + this.operationName);
            }
            requestContext.setProperty(SpanWrapper.PROPERTY_NAME, (Object)new SpanWrapper(span));
        }
    }

    public void filter(ContainerRequestContext requestContext, ContainerResponseContext responseContext) throws IOException {
        ActiveSpan activeSpan;
        SpanWrapper spanWrapper = CastUtils.cast(requestContext.getProperty(SpanWrapper.PROPERTY_NAME), SpanWrapper.class);
        if (spanWrapper == null) {
            return;
        }
        if (this.spanDecorators != null) {
            for (ServerSpanDecorator decorator : this.spanDecorators) {
                decorator.decorateResponse(responseContext, (BaseSpan<?>)spanWrapper.get());
            }
        }
        if ((activeSpan = this.tracer.activeSpan()) != null) {
            activeSpan.capture();
            activeSpan.close();
        }
        spanWrapper.finish();
    }
}

