/*
 * Decompiled with CFR 0.152.
 */
package io.opentracing.contrib.jdbc;

public class ConnectionInfo {
    public static ConnectionInfo UNKNOWN_CONNECTION_INFO = new Builder("unknown_peer").dbType("unknown_type").dbInstance("unknown_instance").build();
    private final String dbType;
    private final String dbUser;
    private final String dbInstance;
    private final String dbPeer;
    private final String dbPeerService;

    private ConnectionInfo(String dbType, String dbUser, String dbInstance, String dbHost, Integer dbPort) {
        this.dbType = dbType;
        this.dbUser = dbUser;
        this.dbInstance = dbInstance;
        this.dbPeer = dbHost != null && dbPort != null ? dbHost + ":" + dbPort : "";
        this.dbPeerService = this.makePeerService();
    }

    private ConnectionInfo(String dbType, String dbUser, String dbInstance, String dbPeer) {
        this.dbType = dbType;
        this.dbUser = dbUser;
        this.dbInstance = dbInstance;
        this.dbPeer = dbPeer;
        this.dbPeerService = this.makePeerService();
    }

    private String makePeerService() {
        if (null != this.dbInstance && !this.dbInstance.isEmpty()) {
            return this.dbInstance + "[" + this.dbType + "(" + this.dbPeer + ")]";
        }
        return this.dbType + "(" + this.dbPeer + ")";
    }

    public String getDbType() {
        return this.dbType;
    }

    public String getDbUser() {
        return this.dbUser;
    }

    public String getDbInstance() {
        return this.dbInstance;
    }

    public String getDbPeer() {
        return this.dbPeer;
    }

    public String getPeerService() {
        return this.dbPeerService;
    }

    public static class Builder {
        private String dbType;
        private String dbUser;
        private String dbInstance;
        private String dbHost;
        private Integer dbPort;
        private String dbPeer;

        public Builder(String dbPeer) {
            this.dbPeer = dbPeer;
        }

        public Builder(String dbHost, Integer dbPort) {
            this.dbHost = dbHost;
            this.dbPort = dbPort;
        }

        public Builder dbType(String dbType) {
            this.dbType = dbType;
            return this;
        }

        public Builder dbUser(String dbUser) {
            this.dbUser = dbUser;
            return this;
        }

        public Builder dbInstance(String dbInstance) {
            this.dbInstance = dbInstance;
            return this;
        }

        public ConnectionInfo build() {
            if (this.dbPeer != null && !this.dbPeer.isEmpty()) {
                return new ConnectionInfo(this.dbType, this.dbUser, this.dbInstance, this.dbPeer);
            }
            return new ConnectionInfo(this.dbType, this.dbUser, this.dbInstance, this.dbHost, this.dbPort);
        }
    }
}

