/*
 * Decompiled with CFR 0.152.
 */
package io.opentracing.contrib.jms;

import io.opentracing.Span;
import io.opentracing.Tracer;
import io.opentracing.contrib.jms.common.SpanJmsDecorator;
import io.opentracing.contrib.jms.common.TracingMessageUtils;
import io.opentracing.util.GlobalTracer;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageProducer;

public class TracingMessageProducer
implements MessageProducer {
    private final MessageProducer messageProducer;
    private final Tracer tracer;

    public TracingMessageProducer(MessageProducer messageProducer) {
        this(messageProducer, GlobalTracer.get());
    }

    public TracingMessageProducer(MessageProducer messageProducer, Tracer tracer) {
        this.messageProducer = messageProducer;
        this.tracer = tracer;
    }

    public boolean getDisableMessageID() throws JMSException {
        return this.messageProducer.getDisableMessageID();
    }

    public void setDisableMessageID(boolean value) throws JMSException {
        this.messageProducer.setDisableMessageID(value);
    }

    public boolean getDisableMessageTimestamp() throws JMSException {
        return this.messageProducer.getDisableMessageTimestamp();
    }

    public void setDisableMessageTimestamp(boolean value) throws JMSException {
        this.messageProducer.setDisableMessageTimestamp(value);
    }

    public int getDeliveryMode() throws JMSException {
        return this.messageProducer.getDeliveryMode();
    }

    public void setDeliveryMode(int deliveryMode) throws JMSException {
        this.messageProducer.setDeliveryMode(deliveryMode);
    }

    public int getPriority() throws JMSException {
        return this.messageProducer.getPriority();
    }

    public void setPriority(int defaultPriority) throws JMSException {
        this.messageProducer.setPriority(defaultPriority);
    }

    public long getTimeToLive() throws JMSException {
        return this.messageProducer.getTimeToLive();
    }

    public void setTimeToLive(long timeToLive) throws JMSException {
        this.messageProducer.setTimeToLive(timeToLive);
    }

    public Destination getDestination() throws JMSException {
        return this.messageProducer.getDestination();
    }

    public void close() throws JMSException {
        this.messageProducer.close();
    }

    public void send(Message message) throws JMSException {
        Span span = TracingMessageUtils.buildAndInjectSpan((Destination)this.getDestination(), (Message)message, (Tracer)this.tracer);
        try {
            this.messageProducer.send(message);
        }
        catch (Throwable e) {
            SpanJmsDecorator.onError((Throwable)e, (Span)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public void send(Message message, int deliveryMode, int priority, long timeToLive) throws JMSException {
        Span span = TracingMessageUtils.buildAndInjectSpan((Destination)this.getDestination(), (Message)message, (Tracer)this.tracer);
        try {
            this.messageProducer.send(message, deliveryMode, priority, timeToLive);
        }
        catch (Throwable e) {
            SpanJmsDecorator.onError((Throwable)e, (Span)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public void send(Destination destination, Message message) throws JMSException {
        Span span = TracingMessageUtils.buildAndInjectSpan((Destination)destination, (Message)message, (Tracer)this.tracer);
        try {
            this.messageProducer.send(destination, message);
        }
        catch (Throwable e) {
            SpanJmsDecorator.onError((Throwable)e, (Span)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public void send(Destination destination, Message message, int deliveryMode, int priority, long timeToLive) throws JMSException {
        Span span = TracingMessageUtils.buildAndInjectSpan((Destination)destination, (Message)message, (Tracer)this.tracer);
        try {
            this.messageProducer.send(destination, message, deliveryMode, priority, timeToLive);
        }
        catch (Throwable e) {
            SpanJmsDecorator.onError((Throwable)e, (Span)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }
}

