/*
 * Decompiled with CFR 0.152.
 */
package io.opentracing.contrib.jms2;

import io.opentracing.Tracer;
import io.opentracing.contrib.jms2.TracingSession;
import javax.jms.Connection;
import javax.jms.ConnectionConsumer;
import javax.jms.ConnectionMetaData;
import javax.jms.Destination;
import javax.jms.ExceptionListener;
import javax.jms.JMSException;
import javax.jms.ServerSessionPool;
import javax.jms.Session;
import javax.jms.Topic;

public class TracingConnection
implements Connection {
    private final Connection connection;
    private final Tracer tracer;
    private final boolean traceInLog;

    public TracingConnection(Connection connection, Tracer tracer) {
        this(connection, tracer, false);
    }

    public TracingConnection(Connection connection, Tracer tracer, boolean traceInLog) {
        this.connection = connection;
        this.tracer = tracer;
        this.traceInLog = traceInLog;
    }

    public Session createSession(boolean transacted, int acknowledgeMode) throws JMSException {
        return new TracingSession(this.connection.createSession(transacted, acknowledgeMode), this.tracer, this.traceInLog);
    }

    public Session createSession(int sessionMode) throws JMSException {
        return new TracingSession(this.connection.createSession(sessionMode), this.tracer, this.traceInLog);
    }

    public Session createSession() throws JMSException {
        return new TracingSession(this.connection.createSession(), this.tracer, this.traceInLog);
    }

    public String getClientID() throws JMSException {
        return this.connection.getClientID();
    }

    public void setClientID(String clientID) throws JMSException {
        this.connection.setClientID(clientID);
    }

    public ConnectionMetaData getMetaData() throws JMSException {
        return this.connection.getMetaData();
    }

    public ExceptionListener getExceptionListener() throws JMSException {
        return this.connection.getExceptionListener();
    }

    public void setExceptionListener(ExceptionListener listener) throws JMSException {
        this.connection.setExceptionListener(listener);
    }

    public void start() throws JMSException {
        this.connection.start();
    }

    public void stop() throws JMSException {
        this.connection.stop();
    }

    public void close() throws JMSException {
        this.connection.close();
    }

    public ConnectionConsumer createConnectionConsumer(Destination destination, String messageSelector, ServerSessionPool sessionPool, int maxMessages) throws JMSException {
        return this.connection.createConnectionConsumer(destination, messageSelector, sessionPool, maxMessages);
    }

    public ConnectionConsumer createSharedConnectionConsumer(Topic topic, String subscriptionName, String messageSelector, ServerSessionPool sessionPool, int maxMessages) throws JMSException {
        return this.connection.createSharedConnectionConsumer(topic, subscriptionName, messageSelector, sessionPool, maxMessages);
    }

    public ConnectionConsumer createDurableConnectionConsumer(Topic topic, String subscriptionName, String messageSelector, ServerSessionPool sessionPool, int maxMessages) throws JMSException {
        return this.connection.createDurableConnectionConsumer(topic, subscriptionName, messageSelector, sessionPool, maxMessages);
    }

    public ConnectionConsumer createSharedDurableConnectionConsumer(Topic topic, String subscriptionName, String messageSelector, ServerSessionPool sessionPool, int maxMessages) throws JMSException {
        return this.connection.createSharedDurableConnectionConsumer(topic, subscriptionName, messageSelector, sessionPool, maxMessages);
    }
}

