/*
 * Decompiled with CFR 0.152.
 */
package io.opentracing.contrib.jms2;

import io.opentracing.Tracer;
import io.opentracing.contrib.jms.common.TracingMessageConsumer;
import io.opentracing.contrib.jms2.TracingMessageProducer;
import java.io.Serializable;
import javax.jms.BytesMessage;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.MapMessage;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import javax.jms.MessageProducer;
import javax.jms.ObjectMessage;
import javax.jms.Queue;
import javax.jms.QueueBrowser;
import javax.jms.Session;
import javax.jms.StreamMessage;
import javax.jms.TemporaryQueue;
import javax.jms.TemporaryTopic;
import javax.jms.TextMessage;
import javax.jms.Topic;
import javax.jms.TopicSubscriber;

public class TracingSession
implements Session {
    private final Session session;
    private final Tracer tracer;
    private final boolean traceInLog;

    public TracingSession(Session session, Tracer tracer) {
        this(session, tracer, false);
    }

    public TracingSession(Session session, Tracer tracer, boolean traceInLog) {
        this.session = session;
        this.tracer = tracer;
        this.traceInLog = traceInLog;
    }

    public BytesMessage createBytesMessage() throws JMSException {
        return this.session.createBytesMessage();
    }

    public MapMessage createMapMessage() throws JMSException {
        return this.session.createMapMessage();
    }

    public Message createMessage() throws JMSException {
        return this.session.createMessage();
    }

    public ObjectMessage createObjectMessage() throws JMSException {
        return this.session.createObjectMessage();
    }

    public ObjectMessage createObjectMessage(Serializable object) throws JMSException {
        return this.session.createObjectMessage(object);
    }

    public StreamMessage createStreamMessage() throws JMSException {
        return this.session.createStreamMessage();
    }

    public TextMessage createTextMessage() throws JMSException {
        return this.session.createTextMessage();
    }

    public TextMessage createTextMessage(String text) throws JMSException {
        return this.session.createTextMessage(text);
    }

    public boolean getTransacted() throws JMSException {
        return this.session.getTransacted();
    }

    public int getAcknowledgeMode() throws JMSException {
        return this.session.getAcknowledgeMode();
    }

    public void commit() throws JMSException {
        this.session.commit();
    }

    public void rollback() throws JMSException {
        this.session.rollback();
    }

    public void close() throws JMSException {
        this.session.close();
    }

    public void recover() throws JMSException {
        this.session.recover();
    }

    public MessageListener getMessageListener() throws JMSException {
        return this.session.getMessageListener();
    }

    public void setMessageListener(MessageListener listener) throws JMSException {
        this.session.setMessageListener(listener);
    }

    public void run() {
        this.session.run();
    }

    public MessageProducer createProducer(Destination destination) throws JMSException {
        return new TracingMessageProducer(this.session.createProducer(destination), this.tracer);
    }

    public MessageConsumer createConsumer(Destination destination) throws JMSException {
        return new TracingMessageConsumer(this.session.createConsumer(destination), this.tracer, this.traceInLog);
    }

    public MessageConsumer createConsumer(Destination destination, String messageSelector) throws JMSException {
        return new TracingMessageConsumer(this.session.createConsumer(destination, messageSelector), this.tracer, this.traceInLog);
    }

    public MessageConsumer createConsumer(Destination destination, String messageSelector, boolean noLocal) throws JMSException {
        return new TracingMessageConsumer(this.session.createConsumer(destination, messageSelector, noLocal), this.tracer, this.traceInLog);
    }

    public MessageConsumer createSharedConsumer(Topic topic, String sharedSubscriptionName) throws JMSException {
        return new TracingMessageConsumer(this.session.createSharedConsumer(topic, sharedSubscriptionName), this.tracer, this.traceInLog);
    }

    public MessageConsumer createSharedConsumer(Topic topic, String sharedSubscriptionName, String messageSelector) throws JMSException {
        return new TracingMessageConsumer(this.session.createSharedConsumer(topic, sharedSubscriptionName, messageSelector), this.tracer, this.traceInLog);
    }

    public Queue createQueue(String queueName) throws JMSException {
        return this.session.createQueue(queueName);
    }

    public Topic createTopic(String topicName) throws JMSException {
        return this.session.createTopic(topicName);
    }

    public TopicSubscriber createDurableSubscriber(Topic topic, String name) throws JMSException {
        return this.session.createDurableSubscriber(topic, name);
    }

    public TopicSubscriber createDurableSubscriber(Topic topic, String name, String messageSelector, boolean noLocal) throws JMSException {
        return this.session.createDurableSubscriber(topic, name, messageSelector, noLocal);
    }

    public MessageConsumer createDurableConsumer(Topic topic, String name) throws JMSException {
        return this.session.createDurableConsumer(topic, name);
    }

    public MessageConsumer createDurableConsumer(Topic topic, String name, String messageSelector, boolean noLocal) throws JMSException {
        return new TracingMessageConsumer(this.session.createDurableConsumer(topic, name, messageSelector, noLocal), this.tracer, this.traceInLog);
    }

    public MessageConsumer createSharedDurableConsumer(Topic topic, String name) throws JMSException {
        return new TracingMessageConsumer(this.session.createSharedDurableConsumer(topic, name), this.tracer, this.traceInLog);
    }

    public MessageConsumer createSharedDurableConsumer(Topic topic, String name, String messageSelector) throws JMSException {
        return new TracingMessageConsumer(this.session.createSharedDurableConsumer(topic, name, messageSelector), this.tracer, this.traceInLog);
    }

    public QueueBrowser createBrowser(Queue queue) throws JMSException {
        return this.session.createBrowser(queue);
    }

    public QueueBrowser createBrowser(Queue queue, String messageSelector) throws JMSException {
        return this.session.createBrowser(queue, messageSelector);
    }

    public TemporaryQueue createTemporaryQueue() throws JMSException {
        return this.session.createTemporaryQueue();
    }

    public TemporaryTopic createTemporaryTopic() throws JMSException {
        return this.session.createTemporaryTopic();
    }

    public void unsubscribe(String name) throws JMSException {
        this.session.unsubscribe(name);
    }
}

