/*
 * Decompiled with CFR 0.152.
 */
package io.opentracing.contrib.mongo.common;

import com.mongodb.event.CommandFailedEvent;
import com.mongodb.event.CommandListener;
import com.mongodb.event.CommandStartedEvent;
import com.mongodb.event.CommandSucceededEvent;
import io.opentracing.Span;
import io.opentracing.Tracer;
import io.opentracing.contrib.mongo.common.ExcludedCommand;
import io.opentracing.contrib.mongo.common.providers.MongoSpanNameProvider;
import io.opentracing.contrib.mongo.common.providers.NoopSpanNameProvider;
import io.opentracing.tag.Tags;
import io.opentracing.util.GlobalTracer;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.bson.BsonNull;
import org.bson.BsonValue;

public class TracingCommandListener
implements CommandListener {
    public static final String COMPONENT_NAME = "java-mongo";
    private final Tracer tracer;
    private final List<ExcludedCommand> excludedCommands;
    private final MongoSpanNameProvider mongoSpanNameProvider;
    private final Map<Integer, Span> cache = new ConcurrentHashMap<Integer, Span>();

    public TracingCommandListener(Tracer tracer, MongoSpanNameProvider customNameProvider, List<ExcludedCommand> excludedCommands) {
        this.tracer = tracer;
        this.mongoSpanNameProvider = customNameProvider;
        this.excludedCommands = new ArrayList<ExcludedCommand>(excludedCommands);
    }

    public void commandStarted(CommandStartedEvent event) {
        Span span = this.buildSpan(event);
        if (span != null) {
            this.cache.put(event.getRequestId(), span);
        }
    }

    public void commandSucceeded(CommandSucceededEvent event) {
        Span span = this.cache.remove(event.getRequestId());
        if (span != null) {
            span.finish();
        }
    }

    public void commandFailed(CommandFailedEvent event) {
        Span span = this.cache.remove(event.getRequestId());
        if (span != null) {
            TracingCommandListener.onError(span, event.getThrowable());
            span.finish();
        }
    }

    Span buildSpan(CommandStartedEvent event) {
        for (ExcludedCommand excludedCommand : this.excludedCommands) {
            boolean skip = true;
            for (Map.Entry entry : excludedCommand.entrySet()) {
                if (!event.getCommand().containsKey(entry.getKey())) {
                    skip = false;
                    break;
                }
                if (entry.getValue() == BsonNull.VALUE || ((BsonValue)entry.getValue()).equals(event.getCommand().get(entry.getKey()))) continue;
                skip = false;
                break;
            }
            if (!skip) continue;
            return null;
        }
        Tracer.SpanBuilder spanBuilder = this.tracer.buildSpan(this.mongoSpanNameProvider.generateName(event.getCommandName())).withTag(Tags.SPAN_KIND.getKey(), "client");
        Span span = spanBuilder.start();
        TracingCommandListener.decorate(span, event);
        return span;
    }

    private static void decorate(Span span, CommandStartedEvent event) {
        Tags.COMPONENT.set(span, COMPONENT_NAME);
        Tags.DB_STATEMENT.set(span, event.getCommand().toString());
        Tags.DB_INSTANCE.set(span, event.getDatabaseName());
        Tags.PEER_HOSTNAME.set(span, event.getConnectionDescription().getServerAddress().getHost());
        InetAddress inetAddress = event.getConnectionDescription().getServerAddress().getSocketAddress().getAddress();
        if (inetAddress instanceof Inet4Address) {
            byte[] address = inetAddress.getAddress();
            Tags.PEER_HOST_IPV4.set(span, Integer.valueOf(ByteBuffer.wrap(address).getInt()));
        } else {
            Tags.PEER_HOST_IPV6.set(span, inetAddress.getHostAddress());
        }
        Tags.PEER_PORT.set(span, Integer.valueOf(event.getConnectionDescription().getServerAddress().getPort()));
        Tags.DB_TYPE.set(span, "mongo");
    }

    private static void onError(Span span, Throwable throwable) {
        Tags.ERROR.set(span, Boolean.TRUE);
        span.log(TracingCommandListener.errorLogs(throwable));
    }

    private static Map<String, Object> errorLogs(Throwable throwable) {
        HashMap<String, Object> errorLogs = new HashMap<String, Object>(4);
        errorLogs.put("event", Tags.ERROR.getKey());
        errorLogs.put("error.kind", throwable.getClass().getName());
        errorLogs.put("error.object", throwable);
        errorLogs.put("message", throwable.getMessage());
        StringWriter sw = new StringWriter();
        throwable.printStackTrace(new PrintWriter(sw));
        errorLogs.put("stack", sw.toString());
        return errorLogs;
    }

    public static class Builder {
        private Tracer tracer;
        private List<ExcludedCommand> excludedCommands;
        private MongoSpanNameProvider spanNameProvider;

        public Builder() {
        }

        public Builder(Tracer tracer) {
            this.tracer = tracer;
        }

        public Builder withTracer(Tracer tracer) {
            this.tracer = tracer;
            return this;
        }

        public Builder withExcludedCommands(List<ExcludedCommand> excludedCommands) {
            this.excludedCommands = excludedCommands;
            return this;
        }

        public Builder withSpanNameProvider(MongoSpanNameProvider spanNameProvider) {
            this.spanNameProvider = spanNameProvider;
            return this;
        }

        public TracingCommandListener build() {
            if (this.tracer == null) {
                this.tracer = GlobalTracer.get();
            }
            if (this.spanNameProvider == null) {
                this.spanNameProvider = new NoopSpanNameProvider();
            }
            if (this.excludedCommands == null) {
                this.excludedCommands = Collections.emptyList();
            }
            return new TracingCommandListener(this.tracer, this.spanNameProvider, this.excludedCommands);
        }
    }
}

