/*
 * Decompiled with CFR 0.152.
 */
package io.opentracing.contrib.mongo.common;

import com.mongodb.event.CommandFailedEvent;
import com.mongodb.event.CommandListener;
import com.mongodb.event.CommandStartedEvent;
import com.mongodb.event.CommandSucceededEvent;
import io.opentracing.Span;
import io.opentracing.Tracer;
import io.opentracing.contrib.mongo.common.ExcludedCommand;
import io.opentracing.contrib.mongo.common.SpanDecorator;
import io.opentracing.contrib.mongo.common.providers.MongoSpanNameProvider;
import io.opentracing.contrib.mongo.common.providers.NoopSpanNameProvider;
import io.opentracing.tag.Tags;
import io.opentracing.util.GlobalTracer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.bson.BsonNull;
import org.bson.BsonValue;

public class TracingCommandListener
implements CommandListener {
    public static final String COMPONENT_NAME = "java-mongo";
    private final Tracer tracer;
    private final List<ExcludedCommand> excludedCommands;
    private final List<SpanDecorator> decorators;
    private final MongoSpanNameProvider mongoSpanNameProvider;
    private final Map<Integer, Span> cache = new ConcurrentHashMap<Integer, Span>();

    public TracingCommandListener(Tracer tracer, MongoSpanNameProvider customNameProvider, List<ExcludedCommand> excludedCommands) {
        this(tracer, customNameProvider, excludedCommands, Collections.singletonList(SpanDecorator.DEFAULT));
    }

    public TracingCommandListener(Tracer tracer, MongoSpanNameProvider customNameProvider, List<ExcludedCommand> excludedCommands, List<SpanDecorator> decorators) {
        this.tracer = tracer;
        this.mongoSpanNameProvider = customNameProvider;
        this.excludedCommands = new ArrayList<ExcludedCommand>(excludedCommands);
        this.decorators = decorators;
    }

    public void commandStarted(CommandStartedEvent event) {
        Span span = this.buildSpan(event);
        if (span != null) {
            this.cache.put(event.getRequestId(), span);
        }
    }

    public void commandSucceeded(CommandSucceededEvent event) {
        Span span = this.cache.remove(event.getRequestId());
        if (span != null) {
            for (SpanDecorator decorator : this.decorators) {
                decorator.commandSucceeded(event, span);
            }
            span.finish();
        }
    }

    public void commandFailed(CommandFailedEvent event) {
        Span span = this.cache.remove(event.getRequestId());
        if (span != null) {
            for (SpanDecorator decorator : this.decorators) {
                decorator.commandFailed(event, span);
            }
            span.finish();
        }
    }

    Span buildSpan(CommandStartedEvent event) {
        for (ExcludedCommand excludedCommand : this.excludedCommands) {
            boolean skip = true;
            for (Map.Entry entry : excludedCommand.entrySet()) {
                if (!event.getCommand().containsKey(entry.getKey())) {
                    skip = false;
                    break;
                }
                if (entry.getValue() == BsonNull.VALUE || ((BsonValue)entry.getValue()).equals(event.getCommand().get(entry.getKey()))) continue;
                skip = false;
                break;
            }
            if (!skip) continue;
            return null;
        }
        Tracer.SpanBuilder spanBuilder = this.tracer.buildSpan(this.mongoSpanNameProvider.generateName(event)).withTag(Tags.SPAN_KIND.getKey(), "client");
        Span span = spanBuilder.start();
        for (SpanDecorator decorator : this.decorators) {
            decorator.commandStarted(event, span);
        }
        return span;
    }

    public static class Builder {
        private Tracer tracer;
        private List<ExcludedCommand> excludedCommands;
        private List<SpanDecorator> decorators;
        private MongoSpanNameProvider spanNameProvider;

        public Builder() {
        }

        public Builder(Tracer tracer) {
            this.tracer = tracer;
        }

        public Builder withTracer(Tracer tracer) {
            this.tracer = tracer;
            return this;
        }

        public Builder withExcludedCommands(List<ExcludedCommand> excludedCommands) {
            this.excludedCommands = excludedCommands;
            return this;
        }

        public Builder withSpanDecorators(List<SpanDecorator> decorators) {
            this.decorators = new ArrayList<SpanDecorator>(decorators);
            return this;
        }

        public Builder withSpanNameProvider(MongoSpanNameProvider spanNameProvider) {
            this.spanNameProvider = spanNameProvider;
            return this;
        }

        public TracingCommandListener build() {
            if (this.tracer == null) {
                this.tracer = GlobalTracer.get();
            }
            if (this.spanNameProvider == null) {
                this.spanNameProvider = new NoopSpanNameProvider();
            }
            if (this.excludedCommands == null) {
                this.excludedCommands = Collections.emptyList();
            }
            if (this.decorators == null) {
                this.decorators = Collections.singletonList(SpanDecorator.DEFAULT);
            }
            return new TracingCommandListener(this.tracer, this.spanNameProvider, this.excludedCommands, this.decorators);
        }
    }
}

