/*
 * Decompiled with CFR 0.152.
 */
package io.opentracing.contrib.redis.redisson;

import io.opentracing.Span;
import io.opentracing.contrib.redis.common.TracingHelper;
import io.opentracing.contrib.redis.redisson.TracingRDeque;
import io.opentracing.contrib.redis.redisson.TracingRedissonHelper;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.concurrent.TimeUnit;
import org.redisson.api.RBlockingDeque;
import org.redisson.api.RFuture;
import org.redisson.api.RObject;

public class TracingRBlockingDeque<V>
extends TracingRDeque<V>
implements RBlockingDeque<V> {
    private final RBlockingDeque<V> deque;
    private final TracingRedissonHelper tracingRedissonHelper;

    public TracingRBlockingDeque(RBlockingDeque<V> deque, TracingRedissonHelper tracingRedissonHelper) {
        super(deque, tracingRedissonHelper);
        this.deque = deque;
        this.tracingRedissonHelper = tracingRedissonHelper;
    }

    public V pollFirstFromAny(long timeout, TimeUnit unit, String ... queueNames) throws InterruptedException {
        Span span = this.tracingRedissonHelper.buildSpan("pollFirstFromAny", (RObject)this.deque);
        span.setTag("timeout", (Number)timeout);
        span.setTag("unit", TracingHelper.nullable((Object)((Object)unit)));
        span.setTag("queueNames", Arrays.toString(queueNames));
        return (V)this.tracingRedissonHelper.decorateThrowing(span, () -> this.deque.pollFirstFromAny(timeout, unit, queueNames));
    }

    public V pollLastFromAny(long timeout, TimeUnit unit, String ... queueNames) throws InterruptedException {
        Span span = this.tracingRedissonHelper.buildSpan("pollLastFromAny", (RObject)this.deque);
        span.setTag("timeout", (Number)timeout);
        span.setTag("unit", TracingHelper.nullable((Object)((Object)unit)));
        span.setTag("queueNames", Arrays.toString(queueNames));
        return (V)this.tracingRedissonHelper.decorateThrowing(span, () -> this.deque.pollLastFromAny(timeout, unit, queueNames));
    }

    @Override
    public void addFirst(V v) {
        Span span = this.tracingRedissonHelper.buildSpan("addFirst", (RObject)this.deque);
        span.setTag("element", TracingHelper.nullable(v));
        this.tracingRedissonHelper.decorate(span, () -> this.deque.addFirst(v));
    }

    @Override
    public void addLast(V v) {
        Span span = this.tracingRedissonHelper.buildSpan("addLast", (RObject)this.deque);
        span.setTag("element", TracingHelper.nullable(v));
        this.tracingRedissonHelper.decorate(span, () -> this.deque.addLast(v));
    }

    @Override
    public boolean offerFirst(V v) {
        Span span = this.tracingRedissonHelper.buildSpan("offerFirst", (RObject)this.deque);
        span.setTag("element", TracingHelper.nullable(v));
        return (Boolean)this.tracingRedissonHelper.decorate(span, () -> this.deque.offerFirst(v));
    }

    @Override
    public boolean offerLast(V v) {
        Span span = this.tracingRedissonHelper.buildSpan("offerLast", (RObject)this.deque);
        span.setTag("element", TracingHelper.nullable(v));
        return (Boolean)this.tracingRedissonHelper.decorate(span, () -> this.deque.offerLast(v));
    }

    public void putFirst(V v) throws InterruptedException {
        Span span = this.tracingRedissonHelper.buildSpan("putFirst", (RObject)this.deque);
        span.setTag("element", TracingHelper.nullable(v));
        this.tracingRedissonHelper.decorateThrowing(span, () -> this.deque.putFirst(v));
    }

    public void putLast(V v) throws InterruptedException {
        Span span = this.tracingRedissonHelper.buildSpan("putLast", (RObject)this.deque);
        span.setTag("element", TracingHelper.nullable(v));
        this.tracingRedissonHelper.decorateThrowing(span, () -> this.deque.putLast(v));
    }

    public boolean offerFirst(V v, long timeout, TimeUnit unit) throws InterruptedException {
        Span span = this.tracingRedissonHelper.buildSpan("offerFirst", (RObject)this.deque);
        span.setTag("element", TracingHelper.nullable(v));
        span.setTag("timeout", (Number)timeout);
        span.setTag("unit", TracingHelper.nullable((Object)((Object)unit)));
        return (Boolean)this.tracingRedissonHelper.decorateThrowing(span, () -> this.deque.offerFirst(v, timeout, unit));
    }

    public boolean offerLast(V v, long timeout, TimeUnit unit) throws InterruptedException {
        Span span = this.tracingRedissonHelper.buildSpan("offerLast", (RObject)this.deque);
        span.setTag("element", TracingHelper.nullable(v));
        span.setTag("timeout", (Number)timeout);
        span.setTag("unit", TracingHelper.nullable((Object)((Object)unit)));
        return (Boolean)this.tracingRedissonHelper.decorateThrowing(span, () -> this.deque.offerLast(v, timeout, unit));
    }

    public V takeFirst() throws InterruptedException {
        Span span = this.tracingRedissonHelper.buildSpan("takeFirst", (RObject)this.deque);
        return (V)this.tracingRedissonHelper.decorateThrowing(span, () -> this.deque.takeFirst());
    }

    public V takeLast() throws InterruptedException {
        Span span = this.tracingRedissonHelper.buildSpan("takeLast", (RObject)this.deque);
        return (V)this.tracingRedissonHelper.decorateThrowing(span, () -> this.deque.takeLast());
    }

    public V pollFirst(long timeout, TimeUnit unit) throws InterruptedException {
        Span span = this.tracingRedissonHelper.buildSpan("pollFirst", (RObject)this.deque);
        span.setTag("timeout", (Number)timeout);
        span.setTag("unit", TracingHelper.nullable((Object)((Object)unit)));
        return (V)this.tracingRedissonHelper.decorateThrowing(span, () -> this.deque.pollFirst(timeout, unit));
    }

    public V pollLast(long timeout, TimeUnit unit) throws InterruptedException {
        Span span = this.tracingRedissonHelper.buildSpan("pollLast", (RObject)this.deque);
        span.setTag("timeout", (Number)timeout);
        span.setTag("unit", TracingHelper.nullable((Object)((Object)unit)));
        return (V)this.tracingRedissonHelper.decorateThrowing(span, () -> this.deque.pollLast(timeout, unit));
    }

    @Override
    public boolean removeFirstOccurrence(Object o) {
        Span span = this.tracingRedissonHelper.buildSpan("removeFirstOccurrence", (RObject)this.deque);
        span.setTag("object", TracingHelper.nullable((Object)o));
        return (Boolean)this.tracingRedissonHelper.decorate(span, () -> this.deque.removeFirstOccurrence(o));
    }

    @Override
    public boolean removeLastOccurrence(Object o) {
        Span span = this.tracingRedissonHelper.buildSpan("removeLastOccurrence", (RObject)this.deque);
        span.setTag("object", TracingHelper.nullable((Object)o));
        return (Boolean)this.tracingRedissonHelper.decorate(span, () -> this.deque.removeLastOccurrence(o));
    }

    @Override
    public boolean add(V v) {
        Span span = this.tracingRedissonHelper.buildSpan("add", (RObject)this.deque);
        span.setTag("element", TracingHelper.nullable(v));
        return (Boolean)this.tracingRedissonHelper.decorate(span, () -> this.deque.add(v));
    }

    @Override
    public boolean offer(V v) {
        Span span = this.tracingRedissonHelper.buildSpan("offer", (RObject)this.deque);
        span.setTag("element", TracingHelper.nullable(v));
        return (Boolean)this.tracingRedissonHelper.decorate(span, () -> this.deque.offer(v));
    }

    public void put(V v) throws InterruptedException {
        Span span = this.tracingRedissonHelper.buildSpan("put", (RObject)this.deque);
        span.setTag("element", TracingHelper.nullable(v));
        this.tracingRedissonHelper.decorateThrowing(span, () -> this.deque.put(v));
    }

    public boolean offer(V v, long timeout, TimeUnit unit) throws InterruptedException {
        Span span = this.tracingRedissonHelper.buildSpan("offer", (RObject)this.deque);
        span.setTag("element", TracingHelper.nullable(v));
        span.setTag("timeout", (Number)timeout);
        span.setTag("unit", TracingHelper.nullable((Object)((Object)unit)));
        return (Boolean)this.tracingRedissonHelper.decorateThrowing(span, () -> this.deque.offer(v, timeout, unit));
    }

    @Override
    public V remove() {
        Span span = this.tracingRedissonHelper.buildSpan("remove", (RObject)this.deque);
        return (V)this.tracingRedissonHelper.decorate(span, () -> this.deque.remove());
    }

    @Override
    public V poll() {
        Span span = this.tracingRedissonHelper.buildSpan("poll", (RObject)this.deque);
        return (V)this.tracingRedissonHelper.decorate(span, () -> this.deque.poll());
    }

    public V take() throws InterruptedException {
        Span span = this.tracingRedissonHelper.buildSpan("take", (RObject)this.deque);
        return (V)this.tracingRedissonHelper.decorateThrowing(span, () -> this.deque.take());
    }

    public V poll(long timeout, TimeUnit unit) throws InterruptedException {
        Span span = this.tracingRedissonHelper.buildSpan("poll", (RObject)this.deque);
        span.setTag("timeout", (Number)timeout);
        span.setTag("unit", TracingHelper.nullable((Object)((Object)unit)));
        return (V)this.tracingRedissonHelper.decorateThrowing(span, () -> this.deque.poll(timeout, unit));
    }

    @Override
    public V element() {
        Span span = this.tracingRedissonHelper.buildSpan("element", (RObject)this.deque);
        return (V)this.tracingRedissonHelper.decorate(span, () -> this.deque.element());
    }

    @Override
    public V peek() {
        Span span = this.tracingRedissonHelper.buildSpan("peek", (RObject)this.deque);
        return (V)this.tracingRedissonHelper.decorate(span, () -> this.deque.peek());
    }

    @Override
    public boolean remove(Object o) {
        Span span = this.tracingRedissonHelper.buildSpan("remove", (RObject)this.deque);
        span.setTag("object", TracingHelper.nullable((Object)o));
        return (Boolean)this.tracingRedissonHelper.decorate(span, () -> this.deque.remove(o));
    }

    @Override
    public boolean contains(Object o) {
        Span span = this.tracingRedissonHelper.buildSpan("contains", (RObject)this.deque);
        span.setTag("object", TracingHelper.nullable((Object)o));
        return (Boolean)this.tracingRedissonHelper.decorate(span, () -> this.deque.contains(o));
    }

    @Override
    public int size() {
        Span span = this.tracingRedissonHelper.buildSpan("size", (RObject)this.deque);
        return (Integer)this.tracingRedissonHelper.decorate(span, () -> this.deque.size());
    }

    @Override
    public Iterator<V> iterator() {
        return this.deque.iterator();
    }

    @Override
    public void push(V v) {
        Span span = this.tracingRedissonHelper.buildSpan("push", (RObject)this.deque);
        span.setTag("element", TracingHelper.nullable(v));
        this.tracingRedissonHelper.decorate(span, () -> this.deque.push(v));
    }

    public int remainingCapacity() {
        Span span = this.tracingRedissonHelper.buildSpan("remainingCapacity", (RObject)this.deque);
        return (Integer)this.tracingRedissonHelper.decorate(span, () -> this.deque.remainingCapacity());
    }

    public int drainTo(Collection<? super V> c) {
        Span span = this.tracingRedissonHelper.buildSpan("drainTo", (RObject)this.deque);
        return (Integer)this.tracingRedissonHelper.decorate(span, () -> this.deque.drainTo(c));
    }

    public int drainTo(Collection<? super V> c, int maxElements) {
        Span span = this.tracingRedissonHelper.buildSpan("drainTo", (RObject)this.deque);
        span.setTag("maxElements", (Number)maxElements);
        return (Integer)this.tracingRedissonHelper.decorate(span, () -> this.deque.drainTo(c, maxElements));
    }

    public V pollFromAny(long timeout, TimeUnit unit, String ... queueNames) throws InterruptedException {
        Span span = this.tracingRedissonHelper.buildSpan("pollFromAny", (RObject)this.deque);
        span.setTag("timeout", (Number)timeout);
        span.setTag("unit", TracingHelper.nullable((Object)((Object)unit)));
        span.setTag("queueNames", Arrays.toString(queueNames));
        return (V)this.tracingRedissonHelper.decorateThrowing(span, () -> this.deque.pollFromAny(timeout, unit, queueNames));
    }

    public V pollLastAndOfferFirstTo(String queueName, long timeout, TimeUnit unit) throws InterruptedException {
        Span span = this.tracingRedissonHelper.buildSpan("pollLastAndOfferFirstTo", (RObject)this.deque);
        span.setTag("queueName", TracingHelper.nullable((Object)queueName));
        span.setTag("timeout", (Number)timeout);
        span.setTag("unit", TracingHelper.nullable((Object)((Object)unit)));
        return (V)this.tracingRedissonHelper.decorateThrowing(span, () -> this.deque.pollLastAndOfferFirstTo(queueName, timeout, unit));
    }

    public V takeLastAndOfferFirstTo(String queueName) throws InterruptedException {
        Span span = this.tracingRedissonHelper.buildSpan("takeLastAndOfferFirstTo", (RObject)this.deque);
        span.setTag("queueName", TracingHelper.nullable((Object)queueName));
        return (V)this.tracingRedissonHelper.decorateThrowing(span, () -> this.deque.takeLastAndOfferFirstTo(queueName));
    }

    public RFuture<V> pollFromAnyAsync(long timeout, TimeUnit unit, String ... queueNames) {
        Span span = this.tracingRedissonHelper.buildSpan("pollFromAnyAsync", (RObject)this.deque);
        span.setTag("timeout", (Number)timeout);
        span.setTag("unit", TracingHelper.nullable((Object)((Object)unit)));
        span.setTag("queueNames", Arrays.toString(queueNames));
        return this.tracingRedissonHelper.prepareRFuture(span, () -> this.deque.pollFromAnyAsync(timeout, unit, queueNames));
    }

    public RFuture<Integer> drainToAsync(Collection<? super V> c, int maxElements) {
        Span span = this.tracingRedissonHelper.buildSpan("drainToAsync", (RObject)this.deque);
        span.setTag("maxElements", (Number)maxElements);
        return this.tracingRedissonHelper.prepareRFuture(span, () -> this.deque.drainToAsync(c, maxElements));
    }

    public RFuture<Integer> drainToAsync(Collection<? super V> c) {
        Span span = this.tracingRedissonHelper.buildSpan("drainToAsync", (RObject)this.deque);
        return this.tracingRedissonHelper.prepareRFuture(span, () -> this.deque.drainToAsync(c));
    }

    public RFuture<V> pollLastAndOfferFirstToAsync(String queueName, long timeout, TimeUnit unit) {
        Span span = this.tracingRedissonHelper.buildSpan("pollLastAndOfferFirstToAsync", (RObject)this.deque);
        span.setTag("queueName", TracingHelper.nullable((Object)queueName));
        span.setTag("timeout", (Number)timeout);
        span.setTag("unit", TracingHelper.nullable((Object)((Object)unit)));
        return this.tracingRedissonHelper.prepareRFuture(span, () -> this.deque.pollLastAndOfferFirstToAsync(queueName, timeout, unit));
    }

    public RFuture<V> takeLastAndOfferFirstToAsync(String queueName) {
        Span span = this.tracingRedissonHelper.buildSpan("takeLastAndOfferFirstToAsync", (RObject)this.deque);
        span.setTag("queueName", TracingHelper.nullable((Object)queueName));
        return this.tracingRedissonHelper.prepareRFuture(span, () -> this.deque.takeLastAndOfferFirstToAsync(queueName));
    }

    public RFuture<V> pollAsync(long timeout, TimeUnit unit) {
        Span span = this.tracingRedissonHelper.buildSpan("pollAsync", (RObject)this.deque);
        span.setTag("timeout", (Number)timeout);
        span.setTag("unit", TracingHelper.nullable((Object)((Object)unit)));
        return this.tracingRedissonHelper.prepareRFuture(span, () -> this.deque.pollAsync(timeout, unit));
    }

    public RFuture<V> takeAsync() {
        Span span = this.tracingRedissonHelper.buildSpan("takeAsync", (RObject)this.deque);
        return this.tracingRedissonHelper.prepareRFuture(span, () -> this.deque.takeAsync());
    }

    public RFuture<Void> putAsync(V e) {
        Span span = this.tracingRedissonHelper.buildSpan("putAsync", (RObject)this.deque);
        span.setTag("element", TracingHelper.nullable(e));
        return this.tracingRedissonHelper.prepareRFuture(span, () -> this.deque.putAsync(e));
    }

    public RFuture<V> pollFirstFromAnyAsync(long timeout, TimeUnit unit, String ... queueNames) {
        Span span = this.tracingRedissonHelper.buildSpan("pollFirstFromAnyAsync", (RObject)this.deque);
        span.setTag("timeout", (Number)timeout);
        span.setTag("unit", TracingHelper.nullable((Object)((Object)unit)));
        span.setTag("queueNames", Arrays.toString(queueNames));
        return this.tracingRedissonHelper.prepareRFuture(span, () -> this.deque.pollFirstFromAnyAsync(timeout, unit, queueNames));
    }

    public RFuture<V> pollLastFromAnyAsync(long timeout, TimeUnit unit, String ... queueNames) {
        Span span = this.tracingRedissonHelper.buildSpan("pollLastFromAnyAsync", (RObject)this.deque);
        span.setTag("timeout", (Number)timeout);
        span.setTag("unit", TracingHelper.nullable((Object)((Object)unit)));
        span.setTag("queueNames", Arrays.toString(queueNames));
        return this.tracingRedissonHelper.prepareRFuture(span, () -> this.deque.pollLastFromAnyAsync(timeout, unit, queueNames));
    }

    public RFuture<Void> putFirstAsync(V e) {
        Span span = this.tracingRedissonHelper.buildSpan("putFirstAsync", (RObject)this.deque);
        span.setTag("element", TracingHelper.nullable(e));
        return this.tracingRedissonHelper.prepareRFuture(span, () -> this.deque.putFirstAsync(e));
    }

    public RFuture<Void> putLastAsync(V e) {
        Span span = this.tracingRedissonHelper.buildSpan("putLastAsync", (RObject)this.deque);
        span.setTag("element", TracingHelper.nullable(e));
        return this.tracingRedissonHelper.prepareRFuture(span, () -> this.deque.putLastAsync(e));
    }

    public RFuture<V> pollLastAsync(long timeout, TimeUnit unit) {
        Span span = this.tracingRedissonHelper.buildSpan("pollLastAsync", (RObject)this.deque);
        span.setTag("timeout", (Number)timeout);
        span.setTag("unit", TracingHelper.nullable((Object)((Object)unit)));
        return this.tracingRedissonHelper.prepareRFuture(span, () -> this.deque.pollLastAsync(timeout, unit));
    }

    public RFuture<V> takeLastAsync() {
        Span span = this.tracingRedissonHelper.buildSpan("takeLastAsync", (RObject)this.deque);
        return this.tracingRedissonHelper.prepareRFuture(span, () -> this.deque.takeLastAsync());
    }

    public RFuture<V> pollFirstAsync(long timeout, TimeUnit unit) {
        Span span = this.tracingRedissonHelper.buildSpan("pollFirstAsync", (RObject)this.deque);
        span.setTag("timeout", (Number)timeout);
        span.setTag("unit", TracingHelper.nullable((Object)((Object)unit)));
        return this.tracingRedissonHelper.prepareRFuture(span, () -> this.deque.pollFirstAsync(timeout, unit));
    }

    public RFuture<V> takeFirstAsync() {
        Span span = this.tracingRedissonHelper.buildSpan("takeFirstAsync", (RObject)this.deque);
        return this.tracingRedissonHelper.prepareRFuture(span, () -> this.deque.takeFirstAsync());
    }
}

