/*
 * Decompiled with CFR 0.152.
 */
package io.opentracing.contrib.redis.redisson;

import io.opentracing.Span;
import io.opentracing.contrib.redis.common.TracingHelper;
import io.opentracing.contrib.redis.redisson.TracingRQueue;
import io.opentracing.contrib.redis.redisson.TracingRedissonHelper;
import java.util.Arrays;
import java.util.Collection;
import java.util.concurrent.TimeUnit;
import org.redisson.api.RBlockingQueue;
import org.redisson.api.RFuture;
import org.redisson.api.RObject;

public class TracingRBlockingQueue<V>
extends TracingRQueue<V>
implements RBlockingQueue<V> {
    private final RBlockingQueue<V> queue;
    private final TracingRedissonHelper tracingRedissonHelper;

    public TracingRBlockingQueue(RBlockingQueue<V> queue, TracingRedissonHelper tracingRedissonHelper) {
        super(queue, tracingRedissonHelper);
        this.queue = queue;
        this.tracingRedissonHelper = tracingRedissonHelper;
    }

    public V pollFromAny(long timeout, TimeUnit unit, String ... queueNames) throws InterruptedException {
        Span span = this.tracingRedissonHelper.buildSpan("pollFromAny", (RObject)this.queue);
        span.setTag("timeout", (Number)timeout);
        span.setTag("unit", TracingHelper.nullable((Object)((Object)unit)));
        span.setTag("queueNames", Arrays.toString(queueNames));
        return (V)this.tracingRedissonHelper.decorateThrowing(span, () -> this.queue.pollFromAny(timeout, unit, queueNames));
    }

    public V pollLastAndOfferFirstTo(String queueName, long timeout, TimeUnit unit) throws InterruptedException {
        Span span = this.tracingRedissonHelper.buildSpan("pollLastAndOfferFirstTo", (RObject)this.queue);
        span.setTag("queueName", TracingHelper.nullable((Object)queueName));
        span.setTag("timeout", (Number)timeout);
        span.setTag("unit", TracingHelper.nullable((Object)((Object)unit)));
        return (V)this.tracingRedissonHelper.decorateThrowing(span, () -> this.queue.pollLastAndOfferFirstTo(queueName, timeout, unit));
    }

    public V takeLastAndOfferFirstTo(String queueName) throws InterruptedException {
        Span span = this.tracingRedissonHelper.buildSpan("takeLastAndOfferFirstTo", (RObject)this.queue);
        span.setTag("queueName", TracingHelper.nullable((Object)queueName));
        return (V)this.tracingRedissonHelper.decorateThrowing(span, () -> this.queue.takeLastAndOfferFirstTo(queueName));
    }

    @Override
    public boolean add(V v) {
        Span span = this.tracingRedissonHelper.buildSpan("add", (RObject)this.queue);
        span.setTag("element", TracingHelper.nullable(v));
        return (Boolean)this.tracingRedissonHelper.decorate(span, () -> this.queue.add(v));
    }

    @Override
    public boolean offer(V v) {
        Span span = this.tracingRedissonHelper.buildSpan("offer", (RObject)this.queue);
        span.setTag("element", TracingHelper.nullable(v));
        return (Boolean)this.tracingRedissonHelper.decorate(span, () -> this.queue.offer(v));
    }

    public void put(V v) throws InterruptedException {
        Span span = this.tracingRedissonHelper.buildSpan("put", (RObject)this.queue);
        span.setTag("element", TracingHelper.nullable(v));
        this.tracingRedissonHelper.decorateThrowing(span, () -> this.queue.put(v));
    }

    public boolean offer(V v, long timeout, TimeUnit unit) throws InterruptedException {
        Span span = this.tracingRedissonHelper.buildSpan("offer", (RObject)this.queue);
        span.setTag("element", TracingHelper.nullable(v));
        span.setTag("timeout", (Number)timeout);
        span.setTag("unit", TracingHelper.nullable((Object)((Object)unit)));
        return (Boolean)this.tracingRedissonHelper.decorateThrowing(span, () -> this.queue.offer(v, timeout, unit));
    }

    public V take() throws InterruptedException {
        Span span = this.tracingRedissonHelper.buildSpan("take", (RObject)this.queue);
        return (V)this.tracingRedissonHelper.decorateThrowing(span, () -> this.queue.take());
    }

    public V poll(long timeout, TimeUnit unit) throws InterruptedException {
        Span span = this.tracingRedissonHelper.buildSpan("poll", (RObject)this.queue);
        span.setTag("timeout", (Number)timeout);
        span.setTag("unit", TracingHelper.nullable((Object)((Object)unit)));
        return (V)this.tracingRedissonHelper.decorateThrowing(span, () -> this.queue.poll(timeout, unit));
    }

    public int remainingCapacity() {
        Span span = this.tracingRedissonHelper.buildSpan("remainingCapacity", (RObject)this.queue);
        return (Integer)this.tracingRedissonHelper.decorate(span, () -> this.queue.remainingCapacity());
    }

    @Override
    public boolean remove(Object o) {
        Span span = this.tracingRedissonHelper.buildSpan("remove", (RObject)this.queue);
        span.setTag("object", TracingHelper.nullable((Object)o));
        return (Boolean)this.tracingRedissonHelper.decorate(span, () -> this.queue.remove(o));
    }

    @Override
    public boolean contains(Object o) {
        Span span = this.tracingRedissonHelper.buildSpan("contains", (RObject)this.queue);
        span.setTag("object", TracingHelper.nullable((Object)o));
        return (Boolean)this.tracingRedissonHelper.decorate(span, () -> this.queue.contains(o));
    }

    public int drainTo(Collection<? super V> c) {
        Span span = this.tracingRedissonHelper.buildSpan("drainTo", (RObject)this.queue);
        return (Integer)this.tracingRedissonHelper.decorate(span, () -> this.queue.drainTo(c));
    }

    public int drainTo(Collection<? super V> c, int maxElements) {
        Span span = this.tracingRedissonHelper.buildSpan("drainTo", (RObject)this.queue);
        span.setTag("maxElements", (Number)maxElements);
        return (Integer)this.tracingRedissonHelper.decorate(span, () -> this.queue.drainTo(c, maxElements));
    }

    public RFuture<V> pollFromAnyAsync(long timeout, TimeUnit unit, String ... queueNames) {
        Span span = this.tracingRedissonHelper.buildSpan("pollFromAnyAsync", (RObject)this.queue);
        span.setTag("timeout", (Number)timeout);
        span.setTag("unit", TracingHelper.nullable((Object)((Object)unit)));
        span.setTag("queueNames", Arrays.toString(queueNames));
        return this.tracingRedissonHelper.prepareRFuture(span, () -> this.queue.pollFromAnyAsync(timeout, unit, queueNames));
    }

    public RFuture<Integer> drainToAsync(Collection<? super V> c, int maxElements) {
        Span span = this.tracingRedissonHelper.buildSpan("drainToAsync", (RObject)this.queue);
        span.setTag("maxElements", (Number)maxElements);
        return this.tracingRedissonHelper.prepareRFuture(span, () -> this.queue.drainToAsync(c, maxElements));
    }

    public RFuture<Integer> drainToAsync(Collection<? super V> c) {
        Span span = this.tracingRedissonHelper.buildSpan("drainToAsync", (RObject)this.queue);
        return this.tracingRedissonHelper.prepareRFuture(span, () -> this.queue.drainToAsync(c));
    }

    public RFuture<V> pollLastAndOfferFirstToAsync(String queueName, long timeout, TimeUnit unit) {
        Span span = this.tracingRedissonHelper.buildSpan("pollLastAndOfferFirstToAsync", (RObject)this.queue);
        span.setTag("queueName", TracingHelper.nullable((Object)queueName));
        span.setTag("timeout", (Number)timeout);
        span.setTag("unit", TracingHelper.nullable((Object)((Object)unit)));
        return this.tracingRedissonHelper.prepareRFuture(span, () -> this.queue.pollLastAndOfferFirstToAsync(queueName, timeout, unit));
    }

    public RFuture<V> takeLastAndOfferFirstToAsync(String queueName) {
        Span span = this.tracingRedissonHelper.buildSpan("takeLastAndOfferFirstToAsync", (RObject)this.queue);
        span.setTag("queueName", TracingHelper.nullable((Object)queueName));
        return this.tracingRedissonHelper.prepareRFuture(span, () -> this.queue.takeLastAndOfferFirstToAsync(queueName));
    }

    public RFuture<V> pollAsync(long timeout, TimeUnit unit) {
        Span span = this.tracingRedissonHelper.buildSpan("pollAsync", (RObject)this.queue);
        span.setTag("timeout", (Number)timeout);
        span.setTag("unit", TracingHelper.nullable((Object)((Object)unit)));
        return this.tracingRedissonHelper.prepareRFuture(span, () -> this.queue.pollAsync(timeout, unit));
    }

    public RFuture<V> takeAsync() {
        Span span = this.tracingRedissonHelper.buildSpan("takeAsync", (RObject)this.queue);
        return this.tracingRedissonHelper.prepareRFuture(span, () -> this.queue.takeAsync());
    }

    public RFuture<Void> putAsync(V e) {
        Span span = this.tracingRedissonHelper.buildSpan("putAsync", (RObject)this.queue);
        span.setTag("element", TracingHelper.nullable(e));
        return this.tracingRedissonHelper.prepareRFuture(span, () -> this.queue.putAsync(e));
    }
}

