/*
 * Decompiled with CFR 0.152.
 */
package io.opentracing.contrib.redis.redisson;

import io.opentracing.Span;
import io.opentracing.contrib.redis.common.TracingHelper;
import io.opentracing.contrib.redis.redisson.TracingRBlockingQueue;
import io.opentracing.contrib.redis.redisson.TracingRedissonHelper;
import java.util.concurrent.TimeUnit;
import org.redisson.api.RBoundedBlockingQueue;
import org.redisson.api.RFuture;
import org.redisson.api.RObject;

public class TracingRBoundedBlockingQueue<V>
extends TracingRBlockingQueue<V>
implements RBoundedBlockingQueue<V> {
    private final RBoundedBlockingQueue<V> queue;
    private final TracingRedissonHelper tracingRedissonHelper;

    public TracingRBoundedBlockingQueue(RBoundedBlockingQueue<V> queue, TracingRedissonHelper tracingRedissonHelper) {
        super(queue, tracingRedissonHelper);
        this.queue = queue;
        this.tracingRedissonHelper = tracingRedissonHelper;
    }

    public boolean trySetCapacity(int capacity) {
        Span span = this.tracingRedissonHelper.buildSpan("trySetCapacity", (RObject)this.queue);
        span.setTag("capacity", (Number)capacity);
        return (Boolean)this.tracingRedissonHelper.decorate(span, () -> this.queue.trySetCapacity(capacity));
    }

    public RFuture<Boolean> trySetCapacityAsync(int capacity) {
        Span span = this.tracingRedissonHelper.buildSpan("trySetCapacityAsync", (RObject)this.queue);
        span.setTag("capacity", (Number)capacity);
        return this.tracingRedissonHelper.prepareRFuture(span, () -> this.queue.trySetCapacityAsync(capacity));
    }

    public RFuture<Boolean> offerAsync(V e, long timeout, TimeUnit unit) {
        Span span = this.tracingRedissonHelper.buildSpan("offerAsync", (RObject)this.queue);
        span.setTag("element", TracingHelper.nullable(e));
        span.setTag("timeout", (Number)timeout);
        span.setTag("unit", TracingHelper.nullable((Object)((Object)unit)));
        return this.tracingRedissonHelper.prepareRFuture(span, () -> this.queue.offerAsync(e, timeout, unit));
    }
}

