/*
 * Decompiled with CFR 0.152.
 */
package io.opentracing.contrib.redis.redisson;

import io.opentracing.Span;
import io.opentracing.contrib.redis.common.TracingHelper;
import io.opentracing.contrib.redis.redisson.TracingRExpirable;
import io.opentracing.contrib.redis.redisson.TracingRedissonHelper;
import java.util.concurrent.TimeUnit;
import org.redisson.api.RBucket;
import org.redisson.api.RExpirable;
import org.redisson.api.RFuture;
import org.redisson.api.RObject;

public class TracingRBucket<V>
extends TracingRExpirable
implements RBucket<V> {
    private final RBucket<V> bucket;
    private final TracingRedissonHelper tracingRedissonHelper;

    public TracingRBucket(RBucket<V> bucket, TracingRedissonHelper tracingRedissonHelper) {
        super((RExpirable)bucket, tracingRedissonHelper);
        this.bucket = bucket;
        this.tracingRedissonHelper = tracingRedissonHelper;
    }

    public long size() {
        Span span = this.tracingRedissonHelper.buildSpan("size", (RObject)this.bucket);
        return (Long)this.tracingRedissonHelper.decorate(span, () -> this.bucket.size());
    }

    public V get() {
        Span span = this.tracingRedissonHelper.buildSpan("get", (RObject)this.bucket);
        return (V)this.tracingRedissonHelper.decorate(span, () -> this.bucket.get());
    }

    public V getAndDelete() {
        Span span = this.tracingRedissonHelper.buildSpan("getAndDelete", (RObject)this.bucket);
        return (V)this.tracingRedissonHelper.decorate(span, () -> this.bucket.getAndDelete());
    }

    public boolean trySet(V value) {
        Span span = this.tracingRedissonHelper.buildSpan("trySet", (RObject)this.bucket);
        span.setTag("value", TracingHelper.nullable(value));
        return (Boolean)this.tracingRedissonHelper.decorate(span, () -> this.bucket.trySet(value));
    }

    public boolean trySet(V value, long timeToLive, TimeUnit timeUnit) {
        Span span = this.tracingRedissonHelper.buildSpan("trySet", (RObject)this.bucket);
        span.setTag("value", TracingHelper.nullable(value));
        span.setTag("timeToLive", (Number)timeToLive);
        span.setTag("timeUnit", TracingHelper.nullable((Object)((Object)timeUnit)));
        return (Boolean)this.tracingRedissonHelper.decorate(span, () -> this.bucket.trySet(value, timeToLive, timeUnit));
    }

    public boolean compareAndSet(V expect, V update) {
        Span span = this.tracingRedissonHelper.buildSpan("compareAndSet", (RObject)this.bucket);
        span.setTag("expect", TracingHelper.nullable(expect));
        span.setTag("update", TracingHelper.nullable(update));
        return (Boolean)this.tracingRedissonHelper.decorate(span, () -> this.bucket.compareAndSet(expect, update));
    }

    public V getAndSet(V newValue) {
        Span span = this.tracingRedissonHelper.buildSpan("getAndSet", (RObject)this.bucket);
        span.setTag("newValue", TracingHelper.nullable(newValue));
        return (V)this.tracingRedissonHelper.decorate(span, () -> this.bucket.getAndSet(newValue));
    }

    public V getAndSet(V value, long timeToLive, TimeUnit timeUnit) {
        Span span = this.tracingRedissonHelper.buildSpan("getAndSet", (RObject)this.bucket);
        span.setTag("value", TracingHelper.nullable(value));
        span.setTag("timeToLive", (Number)timeToLive);
        span.setTag("timeUnit", TracingHelper.nullable((Object)((Object)timeUnit)));
        return (V)this.tracingRedissonHelper.decorate(span, () -> this.bucket.getAndSet(value, timeToLive, timeUnit));
    }

    public void set(V value) {
        Span span = this.tracingRedissonHelper.buildSpan("set", (RObject)this.bucket);
        span.setTag("value", TracingHelper.nullable(value));
        this.tracingRedissonHelper.decorate(span, () -> this.bucket.set(value));
    }

    public void set(V value, long timeToLive, TimeUnit timeUnit) {
        Span span = this.tracingRedissonHelper.buildSpan("set", (RObject)this.bucket);
        span.setTag("value", TracingHelper.nullable(value));
        span.setTag("timeToLive", (Number)timeToLive);
        span.setTag("timeUnit", TracingHelper.nullable((Object)((Object)timeUnit)));
        this.tracingRedissonHelper.decorate(span, () -> this.bucket.set(value, timeToLive, timeUnit));
    }

    public RFuture<Long> sizeAsync() {
        Span span = this.tracingRedissonHelper.buildSpan("sizeAsync", (RObject)this.bucket);
        return this.tracingRedissonHelper.prepareRFuture(span, () -> this.bucket.sizeAsync());
    }

    public RFuture<V> getAsync() {
        Span span = this.tracingRedissonHelper.buildSpan("getAsync", (RObject)this.bucket);
        return this.tracingRedissonHelper.prepareRFuture(span, () -> this.bucket.getAsync());
    }

    public RFuture<V> getAndDeleteAsync() {
        Span span = this.tracingRedissonHelper.buildSpan("getAndDeleteAsync", (RObject)this.bucket);
        return this.tracingRedissonHelper.prepareRFuture(span, () -> this.bucket.getAndDeleteAsync());
    }

    public RFuture<Boolean> trySetAsync(V value) {
        Span span = this.tracingRedissonHelper.buildSpan("trySetAsync", (RObject)this.bucket);
        span.setTag("value", TracingHelper.nullable(value));
        return this.tracingRedissonHelper.prepareRFuture(span, () -> this.bucket.trySetAsync(value));
    }

    public RFuture<Boolean> trySetAsync(V value, long timeToLive, TimeUnit timeUnit) {
        Span span = this.tracingRedissonHelper.buildSpan("trySetAsync", (RObject)this.bucket);
        span.setTag("value", TracingHelper.nullable(value));
        span.setTag("timeToLive", (Number)timeToLive);
        span.setTag("timeUnit", TracingHelper.nullable((Object)((Object)timeUnit)));
        return this.tracingRedissonHelper.prepareRFuture(span, () -> this.bucket.trySetAsync(value, timeToLive, timeUnit));
    }

    public RFuture<Boolean> compareAndSetAsync(V expect, V update) {
        Span span = this.tracingRedissonHelper.buildSpan("compareAndSetAsync", (RObject)this.bucket);
        span.setTag("expect", TracingHelper.nullable(expect));
        span.setTag("update", TracingHelper.nullable(update));
        return this.tracingRedissonHelper.prepareRFuture(span, () -> this.bucket.compareAndSetAsync(expect, update));
    }

    public RFuture<V> getAndSetAsync(V newValue) {
        Span span = this.tracingRedissonHelper.buildSpan("getAndSetAsync", (RObject)this.bucket);
        span.setTag("newValue", TracingHelper.nullable(newValue));
        return this.tracingRedissonHelper.prepareRFuture(span, () -> this.bucket.getAndSetAsync(newValue));
    }

    public RFuture<V> getAndSetAsync(V value, long timeToLive, TimeUnit timeUnit) {
        Span span = this.tracingRedissonHelper.buildSpan("getAndSetAsync", (RObject)this.bucket);
        span.setTag("value", TracingHelper.nullable(value));
        span.setTag("timeToLive", (Number)timeToLive);
        span.setTag("timeUnit", TracingHelper.nullable((Object)((Object)timeUnit)));
        return this.tracingRedissonHelper.prepareRFuture(span, () -> this.bucket.getAndSetAsync(value, timeToLive, timeUnit));
    }

    public RFuture<Void> setAsync(V value) {
        Span span = this.tracingRedissonHelper.buildSpan("setAsync", (RObject)this.bucket);
        span.setTag("value", TracingHelper.nullable(value));
        return this.tracingRedissonHelper.prepareRFuture(span, () -> this.bucket.setAsync(value));
    }

    public RFuture<Void> setAsync(V value, long timeToLive, TimeUnit timeUnit) {
        Span span = this.tracingRedissonHelper.buildSpan("setAsync", (RObject)this.bucket);
        span.setTag("value", TracingHelper.nullable(value));
        span.setTag("timeToLive", (Number)timeToLive);
        span.setTag("timeUnit", TracingHelper.nullable((Object)((Object)timeUnit)));
        return this.tracingRedissonHelper.prepareRFuture(span, () -> this.bucket.setAsync(value, timeToLive, timeUnit));
    }
}

