/*
 * Decompiled with CFR 0.152.
 */
package io.opentracing.contrib.redis.redisson;

import io.opentracing.Span;
import io.opentracing.contrib.redis.common.TracingHelper;
import io.opentracing.contrib.redis.redisson.TracingRedissonHelper;
import java.util.Arrays;
import java.util.Map;
import org.redisson.api.RBuckets;
import org.redisson.api.RFuture;

public class TracingRBuckets
implements RBuckets {
    private final RBuckets buckets;
    private final TracingRedissonHelper tracingRedissonHelper;

    public TracingRBuckets(RBuckets buckets, TracingRedissonHelper tracingRedissonHelper) {
        this.buckets = buckets;
        this.tracingRedissonHelper = tracingRedissonHelper;
    }

    public <V> Map<String, V> get(String ... keys) {
        Span span = this.tracingRedissonHelper.buildSpan("get");
        span.setTag("keys", Arrays.toString(keys));
        return (Map)this.tracingRedissonHelper.decorate(span, () -> this.buckets.get(keys));
    }

    public boolean trySet(Map<String, ?> buckets) {
        Span span = this.tracingRedissonHelper.buildSpan("trySet");
        span.setTag("buckets", TracingHelper.nullable(buckets));
        return (Boolean)this.tracingRedissonHelper.decorate(span, () -> this.buckets.trySet(buckets));
    }

    public void set(Map<String, ?> buckets) {
        Span span = this.tracingRedissonHelper.buildSpan("set");
        span.setTag("buckets", TracingHelper.nullable(buckets));
        this.tracingRedissonHelper.decorate(span, () -> this.buckets.set(buckets));
    }

    public long delete(String ... keys) {
        Span span = this.tracingRedissonHelper.buildSpan("delete");
        span.setTag("keys", Arrays.toString(keys));
        return (Long)this.tracingRedissonHelper.decorate(span, () -> this.buckets.delete(keys));
    }

    public <V> RFuture<Map<String, V>> getAsync(String ... keys) {
        Span span = this.tracingRedissonHelper.buildSpan("getAsync");
        span.setTag("keys", Arrays.toString(keys));
        return this.tracingRedissonHelper.prepareRFuture(span, () -> this.buckets.getAsync(keys));
    }

    public RFuture<Boolean> trySetAsync(Map<String, ?> buckets) {
        Span span = this.tracingRedissonHelper.buildSpan("trySetAsync");
        span.setTag("buckets", TracingHelper.nullable(buckets));
        return this.tracingRedissonHelper.prepareRFuture(span, () -> this.buckets.trySetAsync(buckets));
    }

    public RFuture<Void> setAsync(Map<String, ?> buckets) {
        Span span = this.tracingRedissonHelper.buildSpan("setAsync");
        span.setTag("buckets", TracingHelper.nullable(buckets));
        return this.tracingRedissonHelper.prepareRFuture(span, () -> this.buckets.setAsync(buckets));
    }

    public RFuture<Long> deleteAsync(String ... keys) {
        Span span = this.tracingRedissonHelper.buildSpan("deleteAsync");
        span.setTag("keys", TracingHelper.nullable((Object)keys));
        return this.tracingRedissonHelper.prepareRFuture(span, () -> this.buckets.deleteAsync(keys));
    }
}

